/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint.replace;

import com.mathworks.project.impl.table.AbstractComboBoxCellEditor;
import com.mathworks.project.impl.table.AbstractSimpleCellEditor;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableCellEditor;
import com.mathworks.toolbox.coder.fixedpoint.replace.DesignMinMaxCellEditor;
import com.mathworks.toolbox.coder.fixedpoint.replace.FunctionReplacementStrategy;
import com.mathworks.toolbox.coder.fixedpoint.replace.FunctionReplacementType;
import com.mathworks.toolbox.coder.fixedpoint.replace.ReplacementKey;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.util.ParameterRunnable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

final class FunctionReplacementStrategies {
    private static final String LEGACY_REPLACEMENT_NAME_ATTRIBUTE = "replacement";
    static final String USER_DEFINED_STRATEGY_KEY = "user-defined";
    static final String LOOKUP_TABLE_STRATEGY_KEY = "lookup-table";

    private FunctionReplacementStrategies() {
    }

    static class SimpleStringProperty
    extends MutableProperty {
        private SimpleStringProperty(String string, String string2) {
            super(string, string2, null);
        }

        @Override
        Object deserializeValue(String string) {
            return string;
        }

        @Override
        public PropertyTableCellEditor<ReplacementKey> createTableEditor(PropertyTable<ReplacementKey> propertyTable) {
            return new AbstractSimpleCellEditor<ReplacementKey>(propertyTable){

                public void loadData(Object object, String string) {
                    this.setData(object, (object = SimpleStringProperty.this.getValue()) != null ? object.toString() : "");
                }

                public void commitData() {
                    SimpleStringProperty.this.setValue(this.getData());
                }
            };
        }
    }

    private static class EnumProperty<T extends Enum<?>>
    extends MutableProperty {
        private final AbstractFunctionReplacementStrategy fBoundStrategy;
        private final Class<? extends Enum<?>> fValueType;
        private final Map<String, Object> fValueMappings;

        private EnumProperty(AbstractFunctionReplacementStrategy abstractFunctionReplacementStrategy, Class<T> clazz, String string, String string2, T t) {
            super(string, string2, t);
            this.fBoundStrategy = abstractFunctionReplacementStrategy;
            this.fValueType = clazz;
            this.fValueMappings = new HashMap<String, Object>();
            for (Enum<?> enum_ : this.fValueType.getEnumConstants()) {
                this.fValueMappings.put(enum_.name(), enum_);
            }
        }

        @Override
        public PropertyTableCellEditor<ReplacementKey> createTableEditor(PropertyTable<ReplacementKey> propertyTable) {
            return new AbstractComboBoxCellEditor<ReplacementKey>(propertyTable, this.fValueType){

                public void loadData(Object object, String string) {
                    this.setData(EnumProperty.this.fBoundStrategy.getPropertyValue(EnumProperty.this.getId()));
                }

                public void commitData() {
                    EnumProperty.this.fBoundStrategy.setPropertyValue(EnumProperty.this.getId(), this.getData());
                }
            };
        }

        @Override
        Object deserializeValue(String string) {
            return this.fValueMappings.get(string.toUpperCase(Locale.ENGLISH));
        }

        /* synthetic */ EnumProperty(AbstractFunctionReplacementStrategy abstractFunctionReplacementStrategy, Class clazz, String string, String string2, Enum enum_, 1 var6_6) {
            this(abstractFunctionReplacementStrategy, clazz, string, string2, enum_);
        }
    }

    private static class BooleanProperty
    extends MutableProperty {
        private final AbstractFunctionReplacementStrategy fBoundStrategy;

        BooleanProperty(AbstractFunctionReplacementStrategy abstractFunctionReplacementStrategy, String string, String string2, boolean bl) {
            super(string, string2, bl);
            this.fBoundStrategy = abstractFunctionReplacementStrategy;
        }

        @Override
        public PropertyTableCellEditor<ReplacementKey> createTableEditor(PropertyTable<ReplacementKey> propertyTable) {
            return new AbstractComboBoxCellEditor<ReplacementKey>(propertyTable){

                public void loadData(Object object, String string) {
                    Object object2 = BooleanProperty.this.fBoundStrategy.getPropertyValue(BooleanProperty.this.getId());
                    Boolean bl = object2 != null ? (Boolean)object2 : Boolean.FALSE;
                    this.setData(bl);
                }

                public void commitData() {
                    BooleanProperty.this.fBoundStrategy.setPropertyValue(BooleanProperty.this.getId(), this.getData());
                }
            };
        }

        @Override
        Object deserializeValue(String string) {
            return Boolean.valueOf(string);
        }
    }

    private static class IntegerProperty
    extends MutableProperty {
        private final AbstractFunctionReplacementStrategy fBoundStrategy;
        private final int fMin;
        private final int fMax;

        IntegerProperty(AbstractFunctionReplacementStrategy abstractFunctionReplacementStrategy, String string, String string2, int n, int n2, int n3) {
            super(string, string2, n);
            this.fBoundStrategy = abstractFunctionReplacementStrategy;
            this.fMin = n2;
            this.fMax = n3;
        }

        IntegerProperty(AbstractFunctionReplacementStrategy abstractFunctionReplacementStrategy, String string, String string2, int n) {
            this(abstractFunctionReplacementStrategy, string, string2, n, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }

        @Override
        public PropertyTableCellEditor<ReplacementKey> createTableEditor(PropertyTable<ReplacementKey> propertyTable) {
            return new AbstractSimpleCellEditor<ReplacementKey>(propertyTable, this.fMin, this.fMax){

                public void loadData(Object object, String string) {
                    Object object2 = IntegerProperty.this.fBoundStrategy.getPropertyValue(IntegerProperty.this.getId());
                    Integer n = object2 != null ? (Integer)object2 : Integer.valueOf(0);
                    this.setData(n, n.toString());
                }

                public void commitData() {
                    IntegerProperty.this.fBoundStrategy.setPropertyValue(IntegerProperty.this.getId(), this.getData());
                }
            };
        }

        @Override
        Object deserializeValue(String string) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    private static abstract class MutableProperty
    implements FunctionReplacementStrategy.Property {
        private final PropertyChangeSupport fChangeSupport;
        private final String fId;
        private final String fName;
        private final Object fDefaultValue;
        private Object fValue;

        MutableProperty(String string, String string2, Object object) {
            this.fId = string;
            this.fName = string2;
            this.fDefaultValue = object;
            this.fChangeSupport = new PropertyChangeSupport(this);
            this.setValue(object);
        }

        @Override
        public String getId() {
            return this.fId;
        }

        @Override
        public String getName() {
            return this.fName;
        }

        @Override
        public Object getValue() {
            return this.fValue;
        }

        @Override
        public String getStringValue() {
            return this.getValue() != null ? this.getValue().toString() : "";
        }

        private void fireChange(Object object) {
            this.fChangeSupport.firePropertyChange(this.getId(), object, this.getValue());
        }

        void setValue(Object object) {
            Object object2 = this.fValue;
            this.fValue = object;
            if (object == null && this.fDefaultValue != null) {
                this.fValue = this.fDefaultValue;
            }
            this.fireChange(object2);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.fChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.fChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }

        abstract Object deserializeValue(String var1);
    }

    static final class LookupTable
    extends AbstractFunctionReplacementStrategy {
        private static final String INTERP_ATTRIBUTE = "degreeOfInterpolation";
        private static final String MIN_ATTRIBUTE = "inputMin";
        private static final String MAX_ATTRIBUTE = "inputMax";
        private static final String RESOLUTION_ATTRIBUTE = "resolution";
        private static final String AUTO_VALUE = "Auto";

        LookupTable() {
            super(FunctionReplacementType.LOOKUP_TABLE);
        }

        @Override
        List<? extends MutableProperty> initProperties() {
            EnumProperty enumProperty = new EnumProperty(this, InterpolationDegree.class, INTERP_ATTRIBUTE, CoderResources.getString("f2f.functionReplacement.property.interp.label"), InterpolationDegree.LINEAR, null);
            IntegerProperty integerProperty = new IntegerProperty(this, RESOLUTION_ATTRIBUTE, CoderResources.getString("f2f.functionReplacement.property.resolution"), 1000);
            final MinMaxProperty minMaxProperty = new MinMaxProperty(MIN_ATTRIBUTE, CoderResources.getString("f2f.functionReplacement.property.min"));
            final MinMaxProperty minMaxProperty2 = new MinMaxProperty(MAX_ATTRIBUTE, CoderResources.getString("f2f.functionReplacement.property.max"));
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    MinMaxProperty minMaxProperty3;
                    MinMaxProperty minMaxProperty22;
                    if (propertyChangeEvent.getPropertyName().equals(minMaxProperty.getId())) {
                        minMaxProperty22 = minMaxProperty;
                        minMaxProperty3 = minMaxProperty2;
                    } else {
                        minMaxProperty22 = minMaxProperty2;
                        minMaxProperty3 = minMaxProperty;
                    }
                    minMaxProperty3.setAutoForced(minMaxProperty22.isAuto(), minMaxProperty22.getStringValue());
                }
            };
            minMaxProperty.addPropertyChangeListener(propertyChangeListener);
            minMaxProperty2.addPropertyChangeListener(propertyChangeListener);
            return Arrays.asList(enumProperty, minMaxProperty, minMaxProperty2, integerProperty);
        }

        @Override
        public boolean isValid() {
            return true;
        }

        public String getDegreeOfInterpolation() {
            return ((Enum)this.getProperty(INTERP_ATTRIBUTE).getValue()).name();
        }

        public String getInputMin() {
            return this.getProperty(MIN_ATTRIBUTE).getStringValue();
        }

        public String getInputMax() {
            return this.getProperty(MAX_ATTRIBUTE).getStringValue();
        }

        public int getResolutionAttribute() {
            return (Integer)this.getProperty(RESOLUTION_ATTRIBUTE).getValue();
        }

        private static class MinMaxProperty
        extends MutableProperty {
            private DesignMinMaxCellEditor fCellEditor;

            MinMaxProperty(String string, String string2) {
                super(string, string2, LookupTable.AUTO_VALUE);
            }

            boolean isAuto() {
                return this.getValue().equals(LookupTable.AUTO_VALUE);
            }

            void setAutoForced(boolean bl, String string) {
                if (bl && !this.getStringValue().equals(LookupTable.AUTO_VALUE)) {
                    this.setValue(LookupTable.AUTO_VALUE);
                } else if (!bl && this.getStringValue().equals(LookupTable.AUTO_VALUE)) {
                    this.setValue(string);
                }
            }

            @Override
            Object deserializeValue(String string) {
                if (string != null) {
                    if (LookupTable.AUTO_VALUE.equalsIgnoreCase(string)) {
                        return LookupTable.AUTO_VALUE;
                    }
                    try {
                        return Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        try {
                            return Double.parseDouble(string);
                        }
                        catch (NumberFormatException numberFormatException2) {
                            // empty catch block
                        }
                    }
                }
                return 0;
            }

            @Override
            public PropertyTableCellEditor<ReplacementKey> createTableEditor(PropertyTable<ReplacementKey> propertyTable) {
                this.fCellEditor = new DesignMinMaxCellEditor(propertyTable, LookupTable.AUTO_VALUE, this, new ParameterRunnable<Object>(){

                    public void run(Object object) {
                        MinMaxProperty.this.setValue(object);
                    }
                });
                return this.fCellEditor;
            }
        }

        static enum InterpolationDegree {
            NONE("f2f.functionReplacement.property.interp.None"),
            LINEAR("f2f.functionReplacement.property.interp.Linear"),
            QUADRATIC("f2f.functionReplacement.property.interp.Quadratic"),
            CUBIC("f2f.functionReplacement.property.interp.Cubic");

            private final String fDisplayText;

            private InterpolationDegree(String string2) {
                this.fDisplayText = CoderResources.getString(string2);
            }

            public String toString() {
                return this.fDisplayText;
            }
        }
    }

    static final class UserDefined
    extends AbstractFunctionReplacementStrategy {
        private static final String REPLACEMENT_ATTRIBUTE = "replacement";

        UserDefined() {
            super(FunctionReplacementType.USER_DEFINED);
        }

        UserDefined(String string) {
            this();
            this.setReplacement(string);
        }

        @Override
        List<? extends MutableProperty> initProperties() {
            return Arrays.asList(new SimpleStringProperty("replacement", CoderResources.getString("f2f.functionReplacement.property.functionName")));
        }

        public String getReplacement() {
            return this.getPropertyValue("replacement") != null ? this.getPropertyValue("replacement").toString() : null;
        }

        public void setReplacement(String string) {
            this.setPropertyValue("replacement", string);
        }

        @Override
        public boolean isValid() {
            return this.getReplacement() != null && !this.getReplacement().isEmpty();
        }
    }

    private static abstract class AbstractFunctionReplacementStrategy
    implements FunctionReplacementStrategy {
        private final Map<String, MutableProperty> fProperties;
        private final PropertyChangeSupport fChangeSupport;
        private final FunctionReplacementType fType;

        private AbstractFunctionReplacementStrategy(FunctionReplacementType functionReplacementType) {
            this.fType = functionReplacementType;
            this.fProperties = new LinkedHashMap<String, MutableProperty>();
            this.fChangeSupport = new PropertyChangeSupport(this);
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    AbstractFunctionReplacementStrategy.this.fChangeSupport.firePropertyChange(new PropertyChangeEvent(this, propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue()));
                }
            };
            for (MutableProperty mutableProperty : this.initProperties()) {
                MutableProperty mutableProperty2 = this.fProperties.put(mutableProperty.getId(), mutableProperty);
                assert (mutableProperty2 == null) : String.format("Duplicate property key: strategy=%s, property=%s", new Object[]{this.fType, mutableProperty.getId()});
                mutableProperty.addPropertyChangeListener(propertyChangeListener);
            }
        }

        @Override
        public FunctionReplacementType getFunctionReplacementType() {
            return this.fType;
        }

        @Override
        public Object getPropertyValue(String string) {
            return this.fProperties.containsKey(string) ? this.fProperties.get(string).getValue() : null;
        }

        @Override
        public FunctionReplacementStrategy.Property getProperty(String string) {
            return this.fProperties.containsKey(string) ? this.fProperties.get(string) : null;
        }

        @Override
        public String getPropertyDisplayValue(String string) {
            return this.fProperties.containsKey(string) ? this.fProperties.get(string).getStringValue() : "";
        }

        @Override
        public void loadProperties(Map<String, String> map) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (!this.fProperties.containsKey(entry.getKey())) continue;
                MutableProperty mutableProperty = this.fProperties.get(entry.getKey());
                mutableProperty.setValue(mutableProperty.deserializeValue(entry.getValue()));
            }
        }

        @Override
        public List<? extends FunctionReplacementStrategy.Property> getProperties() {
            return new LinkedList<MutableProperty>(this.fProperties.values());
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.fChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.fChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }

        void setPropertyValue(String string, Object object) {
            this.fProperties.get(string).setValue(object);
        }

        abstract List<? extends MutableProperty> initProperties();
    }
}

