/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint.replace;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.api.XmlWriter;
import com.mathworks.toolbox.coder.fixedpoint.ConversionModel;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import com.mathworks.toolbox.coder.fixedpoint.replace.FunctionReplacementKey;
import com.mathworks.toolbox.coder.fixedpoint.replace.FunctionReplacementStrategies;
import com.mathworks.toolbox.coder.fixedpoint.replace.FunctionReplacementStrategy;
import com.mathworks.toolbox.coder.fixedpoint.replace.ReplacementKey;
import com.mathworks.toolbox.coder.fixedpoint.replace.ReplacementSerializer;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.screener.ProjectScreenerModel;
import com.mathworks.toolbox.coder.screener.ScreenerTarget;
import com.mathworks.toolbox.coder.util.ProxyEventDispatcher;
import com.mathworks.util.MulticastChangeListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;

public final class FunctionReplacementsModel {
    private final Map<ReplacementKey, ModelEntry> fEntries;
    private final ProxyEventDispatcher<ModelObserver> fDispatcher;
    private final ModelObserver fProxyObserver;
    private final MulticastChangeListener fMulticastChangeListener;
    private final Set<String> fPrevRequiresReplacement;
    private final ConversionModel fConversionModel;
    private final ChangeListener fScreenerListener;
    private ScreenerBridge fScreenerBridge;
    private ReplacementSerializer fSerializer;
    private String fError;

    public FunctionReplacementsModel(FixedPointDataAdapter fixedPointDataAdapter, ConversionModel conversionModel, ProjectScreenerModel projectScreenerModel) {
        this(conversionModel, projectScreenerModel != null ? FunctionReplacementsModel.createRealScreenerBridge(projectScreenerModel) : FunctionReplacementsModel.createDummyScreenerBridge());
    }

    public FunctionReplacementsModel(FixedPointDataAdapter fixedPointDataAdapter, ConversionModel conversionModel) {
        this(conversionModel, FunctionReplacementsModel.createRealScreenerBridge(new ProjectScreenerModel(fixedPointDataAdapter.getConfiguration(), ScreenerTarget.FIXED_POINT)));
    }

    public FunctionReplacementsModel(ConversionModel conversionModel) {
        this(conversionModel, null);
    }

    private FunctionReplacementsModel(ConversionModel conversionModel, ScreenerBridge screenerBridge) {
        this.fConversionModel = conversionModel;
        this.fScreenerListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (FunctionReplacementsModel.this.screenerResultsHaveChanged()) {
                            FunctionReplacementsModel.this.updateModelForScreener();
                        }
                    }
                });
            }
        };
        this.setScreenerBridge(screenerBridge);
        this.fEntries = new LinkedHashMap<ReplacementKey, ModelEntry>();
        this.fPrevRequiresReplacement = new HashSet<String>();
        this.fDispatcher = new ProxyEventDispatcher<ModelObserver>(ModelObserver.class);
        this.fProxyObserver = this.fDispatcher.getProxyDispatcher();
        this.fMulticastChangeListener = new MulticastChangeListener();
        this.addModelObserver(this.createListenerAdapter());
        this.setSerializer(null);
    }

    public void setScreenerBridge(ScreenerBridge screenerBridge) {
        if (this.fScreenerBridge != null) {
            this.fScreenerBridge.removeChangeListener(this.fScreenerListener);
        }
        this.fScreenerBridge = screenerBridge;
        if (screenerBridge != null) {
            this.fScreenerBridge.addChangeListener(this.fScreenerListener);
        }
    }

    public void setScreener(FixedPointDataAdapter fixedPointDataAdapter) {
        this.setScreenerBridge(FunctionReplacementsModel.createRealScreenerBridge(new ProjectScreenerModel(fixedPointDataAdapter.getConfiguration(), ScreenerTarget.FIXED_POINT)));
    }

    public void setScreener(ProjectScreenerModel projectScreenerModel) {
        this.setScreenerBridge(FunctionReplacementsModel.createRealScreenerBridge(projectScreenerModel));
    }

    private static ScreenerBridge createDummyScreenerBridge() {
        return new ScreenerBridge(null){

            @Override
            Set<String> getUnsupportedFunctions() {
                return Collections.emptySet();
            }

            @Override
            boolean hasData() {
                return false;
            }

            @Override
            void addChangeListener(ChangeListener changeListener) {
            }

            @Override
            void removeChangeListener(ChangeListener changeListener) {
            }

            @Override
            void dispose() {
            }
        };
    }

    private static ScreenerBridge createRealScreenerBridge(ProjectScreenerModel projectScreenerModel) {
        return new ScreenerBridge(projectScreenerModel){

            @Override
            public Set<String> getUnsupportedFunctions() {
                return this.hasData() ? this.getModel().getReportModel().getFunctionsByImpact().keySet() : new HashSet<String>();
            }

            @Override
            boolean hasData() {
                return this.getModel().getReportModel() != null;
            }

            @Override
            public void addChangeListener(ChangeListener changeListener) {
                this.getModel().addChangeListener(changeListener);
            }

            @Override
            void removeChangeListener(ChangeListener changeListener) {
                this.getModel().removeChangeListener(changeListener);
            }

            @Override
            void dispose() {
                this.getModel().dispose();
            }
        };
    }

    public void dispose() {
        if (this.fScreenerBridge != null) {
            this.fScreenerBridge.dispose();
        }
    }

    public void addModelObserver(ModelObserver modelObserver) {
        this.fDispatcher.addObserver(modelObserver);
    }

    public void removeModelObserver(ModelObserver modelObserver) {
        this.fDispatcher.removeObserver(modelObserver);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fMulticastChangeListener.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fMulticastChangeListener.removeChangeListener(changeListener);
    }

    public Set<ReplacementKey> getAllReplacementKeys() {
        return new LinkedHashSet<ReplacementKey>(this.fEntries.keySet());
    }

    public FunctionReplacementStrategy getFunctionReplacement(ReplacementKey replacementKey) {
        return this.hasFunctionReplacement(replacementKey) ? this.fEntries.get(replacementKey).getReplacementStrategy() : null;
    }

    public FunctionReplacementStrategy getFunctionReplacement(String string) {
        ReplacementKey replacementKey = ReplacementKey.parse(string);
        return replacementKey != null && this.hasFunctionReplacement(replacementKey) ? this.fEntries.get(replacementKey).getReplacementStrategy() : null;
    }

    public boolean isUserAdded(ReplacementKey replacementKey) {
        return this.hasFunctionReplacement(replacementKey) && this.fEntries.get(replacementKey).isUserAdded();
    }

    private void clear() {
        this.fEntries.clear();
        this.fPrevRequiresReplacement.clear();
        this.invalidate(true);
    }

    public boolean hasFunctionReplacement(ReplacementKey replacementKey) {
        return replacementKey != null && this.fEntries.containsKey(replacementKey);
    }

    public boolean hasFunctionReplacement(String string) {
        ReplacementKey replacementKey = ReplacementKey.parse(string);
        return replacementKey != null && this.fEntries.containsKey(replacementKey);
    }

    public void load(XmlReader xmlReader) {
        this.setEventDispatchingEnabled(false);
        this.clear();
        Map<ReplacementKey, FunctionReplacementStrategy> map = this.fSerializer.deserialize(xmlReader);
        for (Map.Entry<ReplacementKey, FunctionReplacementStrategy> entry : map.entrySet()) {
            this.addFunctionReplacement(entry.getKey(), entry.getValue());
        }
        this.updateModelForScreener();
        this.setEventDispatchingEnabled(true);
        this.invalidate(true);
    }

    public void serialize(XmlWriter xmlWriter) {
        LinkedHashMap<ReplacementKey, FunctionReplacementStrategy> linkedHashMap = new LinkedHashMap<ReplacementKey, FunctionReplacementStrategy>();
        for (Map.Entry<ReplacementKey, ModelEntry> entry : this.fEntries.entrySet()) {
            linkedHashMap.put(entry.getKey(), entry.getValue().getReplacementStrategy());
        }
        this.fSerializer.serialize(linkedHashMap, xmlWriter);
    }

    boolean replaceExistingKey(ReplacementKey replacementKey, ReplacementKey replacementKey2) {
        boolean bl = true;
        if (this.fEntries.containsKey(replacementKey) && Utilities.areValuesDifferent(replacementKey, replacementKey2)) {
            if (replacementKey2 == null) {
                return this.removeFunctionReplacement(replacementKey);
            }
            if (this.fEntries.containsKey(replacementKey2)) {
                this.emitError("f2f.functionReplacement.error.functionAlreadyReplaced");
                bl = false;
            } else {
                ModelEntry modelEntry = this.fEntries.get(replacementKey);
                this.setEventDispatchingEnabled(false);
                bl = this.doRemoveFunctionReplacement(replacementKey, false);
                if (bl) {
                    this.addFunctionReplacement(replacementKey2, modelEntry.isUserAdded(), modelEntry.getReplacementStrategy());
                }
                this.setEventDispatchingEnabled(true);
                if (!bl) {
                    this.emitError("f2f.functionReplacement.error.functionReplacementRequired");
                }
            }
        }
        this.fProxyObserver.functionReplacementRemapped(replacementKey, replacementKey2, !bl);
        return bl;
    }

    boolean removeFunctionReplacement(ReplacementKey replacementKey) {
        return this.doRemoveFunctionReplacement(replacementKey, true);
    }

    private boolean doRemoveFunctionReplacement(ReplacementKey replacementKey, boolean bl) {
        boolean bl2 = true;
        if (this.fEntries.containsKey(replacementKey)) {
            ModelEntry modelEntry = this.fEntries.get(replacementKey);
            modelEntry.dispose();
            if (!modelEntry.isUserAdded() && bl) {
                this.emitError("f2f.functionReplacement.error.functionReplacementRequired");
                bl2 = false;
            } else {
                this.fEntries.remove(replacementKey);
            }
            this.fProxyObserver.functionReplacementRemoved(replacementKey, modelEntry.getReplacementStrategy(), !bl2);
        }
        return bl2;
    }

    boolean addFunctionReplacement(ReplacementKey replacementKey) {
        return this.addFunctionReplacement(replacementKey, FunctionReplacementKey.isFunctionReplacement(replacementKey) && this.isScreenerRequiredReplacement(replacementKey));
    }

    boolean addFunctionReplacement(ReplacementKey replacementKey, boolean bl) {
        return this.addFunctionReplacement(replacementKey, bl, new FunctionReplacementStrategies.UserDefined(""));
    }

    boolean addFunctionReplacement(ReplacementKey replacementKey, FunctionReplacementStrategy functionReplacementStrategy) {
        return this.addFunctionReplacement(replacementKey, !this.isScreenerRequiredReplacement(replacementKey), functionReplacementStrategy);
    }

    boolean addFunctionReplacement(ReplacementKey replacementKey, boolean bl, FunctionReplacementStrategy functionReplacementStrategy) {
        boolean bl2 = true;
        if (this.fEntries.containsKey(replacementKey)) {
            this.emitError("f2f.functionReplacement.error.functionAlreadyReplaced");
            bl2 = false;
        }
        this.fEntries.put(replacementKey, new ModelEntry(replacementKey, functionReplacementStrategy, bl));
        this.fProxyObserver.functionReplacementAdded(replacementKey, functionReplacementStrategy, !bl2);
        return bl2;
    }

    void setFunctionReplacementStrategy(ReplacementKey replacementKey, FunctionReplacementStrategy functionReplacementStrategy) {
        if (this.hasFunctionReplacement(replacementKey)) {
            ModelEntry modelEntry = this.fEntries.get(replacementKey);
            this.doRemoveFunctionReplacement(replacementKey, false);
            this.addFunctionReplacement(replacementKey, modelEntry.isUserAdded(), functionReplacementStrategy);
        }
    }

    String consumeError() {
        String string = this.fError;
        this.fError = null;
        return string != null ? CoderResources.getString(string) : null;
    }

    public void setSerializer(@Nullable ReplacementSerializer replacementSerializer) {
        if (replacementSerializer == null) {
            replacementSerializer = new ReplacementSerializer.DefaultSerializer();
        }
        this.fSerializer = replacementSerializer;
    }

    private boolean isScreenerRequiredReplacement(ReplacementKey replacementKey) {
        return this.fScreenerBridge != null && this.fScreenerBridge.isUnsupported(replacementKey.getDisplayString());
    }

    private void setEventDispatchingEnabled(boolean bl) {
        this.fDispatcher.setEnabled(bl);
    }

    private void emitError(String string) {
        this.fError = string;
    }

    private boolean screenerResultsHaveChanged() {
        return this.fScreenerBridge != null && this.fScreenerBridge.hasData() && !this.fScreenerBridge.getUnsupportedFunctions().equals(this.fPrevRequiresReplacement);
    }

    private void updateModelForScreener() {
        Set<Object> set = this.fScreenerBridge != null ? this.fScreenerBridge.getUnsupportedFunctions() : new HashSet();
        for (String object : this.fPrevRequiresReplacement) {
            Object object2 = new FunctionReplacementKey(object);
            if (!this.hasFunctionReplacement((ReplacementKey)object2) || this.getFunctionReplacement((ReplacementKey)object2).isValid() || this.isUserAdded((ReplacementKey)object2)) continue;
            this.doRemoveFunctionReplacement((ReplacementKey)object2, false);
        }
        this.fPrevRequiresReplacement.clear();
        this.fPrevRequiresReplacement.addAll(set);
        this.setEventDispatchingEnabled(false);
        boolean bl = false;
        for (Object object2 : set) {
            FunctionReplacementKey functionReplacementKey = new FunctionReplacementKey((String)object2);
            if (this.hasFunctionReplacement(functionReplacementKey) && this.fEntries.get(functionReplacementKey).isUserAdded()) {
                FunctionReplacementStrategy functionReplacementStrategy = this.fEntries.get(functionReplacementKey).getReplacementStrategy();
                this.removeFunctionReplacement(functionReplacementKey);
                this.addFunctionReplacement(functionReplacementKey, false, functionReplacementStrategy);
            } else {
                if (this.hasFunctionReplacement(functionReplacementKey)) continue;
                this.addFunctionReplacement((ReplacementKey)functionReplacementKey, false);
            }
            bl = true;
        }
        this.setEventDispatchingEnabled(true);
        if (bl) {
            this.invalidate(false);
        }
    }

    private void invalidate(boolean bl) {
        this.fProxyObserver.modelInvalidated();
        if (!bl) {
            this.fMulticastChangeListener.stateChanged(new ChangeEvent(this));
        }
    }

    private ModelObserver createListenerAdapter() {
        return new ModelObserver(){

            @Override
            public void functionReplacementRemapped(ReplacementKey replacementKey, ReplacementKey replacementKey2, boolean bl) {
                this.onChange(true);
            }

            @Override
            public void functionReplacementRemoved(ReplacementKey replacementKey, FunctionReplacementStrategy functionReplacementStrategy, boolean bl) {
                this.onChange(true);
            }

            @Override
            public void functionReplacementAdded(ReplacementKey replacementKey, FunctionReplacementStrategy functionReplacementStrategy, boolean bl) {
                this.onChange(true);
            }

            @Override
            public void functionReplacementUpdated(ReplacementKey replacementKey, FunctionReplacementStrategy functionReplacementStrategy, boolean bl) {
                this.onChange(true);
            }

            @Override
            public void modelInvalidated() {
            }

            private void onChange(boolean bl) {
                FunctionReplacementsModel.this.fMulticastChangeListener.stateChanged(new ChangeEvent(FunctionReplacementsModel.this));
            }
        };
    }

    public static ReplacementSerializer createDefaultSerializer() {
        return new ReplacementSerializer.DefaultSerializer();
    }

    private static abstract class ScreenerBridge {
        private ProjectScreenerModel fModel;

        ScreenerBridge(ProjectScreenerModel projectScreenerModel) {
            this.fModel = projectScreenerModel;
        }

        boolean isUnsupported(String string) {
            return this.getUnsupportedFunctions().contains(string);
        }

        abstract Set<String> getUnsupportedFunctions();

        abstract void addChangeListener(ChangeListener var1);

        abstract void removeChangeListener(ChangeListener var1);

        abstract boolean hasData();

        abstract void dispose();

        public ProjectScreenerModel getModel() {
            return this.fModel;
        }
    }

    public static interface ModelObserver {
        public void functionReplacementRemapped(ReplacementKey var1, ReplacementKey var2, boolean var3);

        public void functionReplacementRemoved(ReplacementKey var1, FunctionReplacementStrategy var2, boolean var3);

        public void functionReplacementAdded(ReplacementKey var1, FunctionReplacementStrategy var2, boolean var3);

        public void functionReplacementUpdated(ReplacementKey var1, FunctionReplacementStrategy var2, boolean var3);

        public void modelInvalidated();
    }

    private class ModelEntry
    implements PropertyChangeListener {
        private final boolean fUserAdded;
        private final ReplacementKey fKey;
        private FunctionReplacementStrategy fReplacementStrategy;

        private ModelEntry(ReplacementKey replacementKey, FunctionReplacementStrategy functionReplacementStrategy, boolean bl) {
            this.fKey = replacementKey;
            this.fUserAdded = bl;
            this.setReplacementStrategy(functionReplacementStrategy);
        }

        FunctionReplacementStrategy getReplacementStrategy() {
            return this.fReplacementStrategy;
        }

        void setReplacementStrategy(FunctionReplacementStrategy functionReplacementStrategy) {
            if (this.fReplacementStrategy != null) {
                this.dispose();
            }
            this.fReplacementStrategy = functionReplacementStrategy;
            this.fReplacementStrategy.addPropertyChangeListener(this);
        }

        boolean isUserAdded() {
            return this.fUserAdded;
        }

        void dispose() {
            this.fReplacementStrategy.removePropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FunctionReplacementsModel.this.fProxyObserver.functionReplacementUpdated(this.fKey, this.fReplacementStrategy, false);
        }
    }
}

