/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.graph;

import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.toolbox.coder.graph.CircuitComponent;
import com.mathworks.toolbox.coder.graph.CircuitGraphModel;
import com.mathworks.toolbox.coder.graph.ComponentKind;
import com.mathworks.toolbox.coder.graph.Network;
import com.mathworks.toolbox.coder.graph.PortedObject;
import com.mathworks.toolbox.coder.graph.Signal;
import java.io.File;
import java.io.IOException;

public class CircuitGraphReader {
    private static final String REF_NUM = "RefNum";
    private static final String USER_NAME = "UserName";

    public static CircuitGraphModel read(File file) throws IOException {
        PluginManager.init();
        CircuitGraphModel circuitGraphModel = new CircuitGraphModel();
        XmlReader xmlReader = XmlApi.getInstance().read(file);
        XmlReader xmlReader2 = xmlReader.getChild(new String[]{"Network"});
        while (xmlReader2.isPresent()) {
            circuitGraphModel.add(CircuitGraphReader.readNetwork(xmlReader2));
            xmlReader2 = xmlReader2.next();
        }
        return circuitGraphModel;
    }

    private static Network readNetwork(XmlReader xmlReader) {
        String string = xmlReader.readAttribute(REF_NUM);
        String string2 = xmlReader.readAttribute(USER_NAME);
        Network network = new Network(string, string2);
        XmlReader xmlReader2 = xmlReader.getChild(new String[]{"NetworkPorts"}).getChild(new String[0]);
        while (xmlReader2.isPresent()) {
            CircuitGraphReader.readPort(network, xmlReader2);
            xmlReader2 = xmlReader2.next();
        }
        XmlReader xmlReader3 = xmlReader.getChild(new String[]{"Signals"}).getChild(new String[0]);
        while (xmlReader3.isPresent()) {
            CircuitGraphReader.readSignal(network, xmlReader3);
            xmlReader3 = xmlReader3.next();
        }
        XmlReader xmlReader4 = xmlReader.getChild(new String[]{"Components"}).getChild(new String[0]);
        while (xmlReader4.isPresent()) {
            CircuitGraphReader.readComponent(network, xmlReader4);
            xmlReader4 = xmlReader4.next();
        }
        return network;
    }

    private static void readPort(PortedObject portedObject, XmlReader xmlReader) {
        String string = xmlReader.readAttribute("Signal");
        String string2 = xmlReader.readAttribute("Name");
        if (xmlReader.getCurrentElementName().equals("InPort")) {
            portedObject.addInput(string);
        } else {
            portedObject.addOutput(string);
        }
        if (portedObject instanceof Network) {
            CircuitComponent circuitComponent = new CircuitComponent(string2, string2, ComponentKind.PORT);
            if (xmlReader.getCurrentElementName().equals("InPort")) {
                circuitComponent.addOutput(string);
            } else {
                circuitComponent.addInput(string);
            }
            ((Network)portedObject).add(circuitComponent);
        }
    }

    private static void readSignal(Network network, XmlReader xmlReader) {
        String string = xmlReader.readAttribute(REF_NUM);
        String string2 = xmlReader.readAttribute(USER_NAME);
        Signal signal = new Signal(string, string2);
        network.add(signal);
    }

    private static void readComponent(Network network, XmlReader xmlReader) {
        ComponentKind componentKind = ComponentKind.fromString(xmlReader.getCurrentElementName());
        if (componentKind == ComponentKind.BLACK_BOX) {
            return;
        }
        String string = xmlReader.readAttribute(REF_NUM);
        String string2 = xmlReader.readAttribute(USER_NAME);
        CircuitComponent circuitComponent = new CircuitComponent(string, string2, componentKind);
        XmlReader xmlReader2 = xmlReader.getChild(new String[]{"CompPorts"}).getChild(new String[0]);
        while (xmlReader2.isPresent()) {
            CircuitGraphReader.readPort(circuitComponent, xmlReader2);
            xmlReader2 = xmlReader2.next();
        }
        network.add(circuitComponent);
    }
}

