/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.graph;

import com.mathworks.jmi.Matlab;
import com.mathworks.toolbox.coder.graph.CircuitComponent;
import com.mathworks.toolbox.coder.graph.Network;
import com.mathworks.toolbox.coder.graph.Signal;
import com.mathworks.toolbox.coder.graph.SignalMap;
import com.mathworks.util.PlatformInfo;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class GraphvizAPI {
    private static final double PPI = Toolkit.getDefaultToolkit().getScreenResolution();
    private static final String DOT_COMMAND = Matlab.isMatlabAvailable() ? GraphvizAPI.getMatlabDotCommand() : "dot";

    private GraphvizAPI() {
    }

    private static String getMatlabDotCommand() {
        return new File(new File(Matlab.matlabRoot()), "bin" + File.separator + GraphvizAPI.getArchitecture() + File.separator + "mwdot" + GraphvizAPI.getExecutableSuffix()).getAbsolutePath();
    }

    private static String getExecutableSuffix() {
        return PlatformInfo.isWindows() ? ".exe" : "";
    }

    private static String getArchitecture() {
        if (PlatformInfo.isWindows64()) {
            return "win64";
        }
        if (PlatformInfo.isLinux64()) {
            return "glnxa64";
        }
        if (PlatformInfo.isLinux()) {
            return "glnx86";
        }
        if (PlatformInfo.isMacintosh() && PlatformInfo.is64Bit()) {
            return "maci64";
        }
        return "win32";
    }

    public static Map<CircuitComponent, Rectangle> layout(Network network, Map<CircuitComponent, Dimension> map) {
        try {
            File file = File.createTempFile("graph", ".dot");
            GraphvizAPI.generateDotFile(network, map, file);
            return GraphvizAPI.translateDotFile(network, file);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    private static Map<CircuitComponent, Rectangle> translateDotFile(Network network, File file) throws IOException {
        String string;
        File file2 = File.createTempFile("graph", ".txt");
        HashMap<CircuitComponent, Rectangle> hashMap = new HashMap<CircuitComponent, Rectangle>();
        ProcessBuilder processBuilder = new ProcessBuilder(DOT_COMMAND, "-Tplain", file.getAbsolutePath(), "-o", file2.getAbsolutePath());
        Process process = processBuilder.start();
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.isEmpty()) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("node")) {
                String string3 = stringTokenizer.nextToken();
                double d4 = Double.parseDouble(stringTokenizer.nextToken()) * PPI / d3;
                double d5 = (d2 - Double.parseDouble(stringTokenizer.nextToken())) * PPI / d3;
                double d6 = Double.parseDouble(stringTokenizer.nextToken()) * PPI / d3;
                double d7 = Double.parseDouble(stringTokenizer.nextToken()) * PPI / d3;
                hashMap.put(network.getComponent(string3), new Rectangle((int)(d4 -= d6 / 2.0), (int)(d5 -= d7 / 2.0), (int)d6, (int)d7));
                continue;
            }
            if (!string2.equals("graph")) continue;
            d3 = Double.parseDouble(stringTokenizer.nextToken());
            d = Double.parseDouble(stringTokenizer.nextToken());
            d2 = Double.parseDouble(stringTokenizer.nextToken());
        }
        bufferedReader.close();
        return hashMap;
    }

    private static void generateDotFile(Network network, Map<CircuitComponent, Dimension> map, File file) throws IOException {
        SignalMap signalMap = new SignalMap(network);
        DecimalFormat decimalFormat = new DecimalFormat("###0.00");
        PrintWriter printWriter = new PrintWriter(new FileWriter(file));
        printWriter.println("digraph G {");
        printWriter.println("\trankdir = LR;");
        printWriter.println("\tordering = in;");
        printWriter.println();
        for (CircuitComponent circuitComponent : network.getComponents()) {
            Dimension dimension = map.get(circuitComponent);
            printWriter.println("\t" + circuitComponent.getId() + " [label=\"\", width=" + decimalFormat.format(dimension.getWidth() / PPI) + ", height = " + decimalFormat.format(dimension.getHeight() / PPI) + "];");
        }
        printWriter.println();
        for (CircuitComponent circuitComponent : network.getComponents()) {
            for (String string : circuitComponent.getOutputs()) {
                Signal signal = network.getSignal(string);
                if (signal == null) {
                    throw new IllegalStateException(string);
                }
                CircuitComponent circuitComponent2 = signalMap.getDestination(signal);
                if (circuitComponent2 == null) continue;
                printWriter.println("\t" + circuitComponent.getId() + " -> " + circuitComponent2.getId() + ";");
            }
        }
        printWriter.println("}");
        printWriter.close();
    }
}

