/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.mi;

import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public final class CodeCoverageMI {

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface CoverageByteOffset {
    }

    public static class StaticBasicBlock {
        @CoverageByteOffset
        public int charStartIdx;
        @CoverageByteOffset
        public int charEndIdx;
        public String code;
        public int maxHits;
    }

    public static class StaticAnalysisInfo {
        public File scriptPath;
        public StaticBasicBlock[] basicBlocks;
    }

    public static class WhileInfo
    implements Construct {
        @CoverageByteOffset
        public int charStartIdx;
        @CoverageByteOffset
        public int charExprEndIdx;
        @CoverageByteOffset
        public int charEndIdx;
        public int hitCount;

        @Override
        public int getLength() {
            return this.charEndIdx - this.charStartIdx + 1;
        }
    }

    public static class ForInfo
    implements Construct {
        @CoverageByteOffset
        public int charStartIdx;
        @CoverageByteOffset
        public int charExprEndIdx;
        @CoverageByteOffset
        public int charEndIdx;
        public int entryCount;
        public int exitCount;

        @Override
        public int getLength() {
            return this.charEndIdx - this.charStartIdx + 1;
        }
    }

    public static class Case {
        @CoverageByteOffset
        public int charStartIdx;
        @CoverageByteOffset
        public int charExprEndIdx;
        public int hitCount;
    }

    public static class SwitchInfo
    implements Construct {
        @CoverageByteOffset
        public int charStartIdx;
        @CoverageByteOffset
        public int charExprEndIdx;
        @CoverageByteOffset
        public int charEndIdx;
        public Case[] cases;

        @Override
        public int getLength() {
            return this.charEndIdx - this.charStartIdx + 1;
        }
    }

    public static class IfInfo
    implements Construct {
        @CoverageByteOffset
        public int charStartIdx;
        @CoverageByteOffset
        public int charExprEndIdx;
        @CoverageByteOffset
        public int charElseStartIdx;
        @CoverageByteOffset
        public int charEndIdx;
        public int trueCount;
        public int falseCount;

        @Override
        public int getLength() {
            return this.charEndIdx - this.charStartIdx + 1;
        }
    }

    public static class BasicBlockInfo
    implements Construct {
        @CoverageByteOffset
        public int charStartIdx;
        @CoverageByteOffset
        public int charExprEndIdx;
        @CoverageByteOffset
        public int charEndIdx;
        public int hits;

        @Override
        public int getLength() {
            return this.charEndIdx - this.charStartIdx + 1;
        }
    }

    public static class FcnInfo {
        @CoverageByteOffset
        public int charStartIdx;
        @CoverageByteOffset
        public int charExprEndIdx;
        @CoverageByteOffset
        public int charEndIdx;
        public String name;
        public int calls;
    }

    public static class CovInfo {
        public File path;
        public FcnInfo[] fcnInfos;
        public IfInfo[] ifInfos;
        public SwitchInfo[] switchInfos;
        public ForInfo[] forInfos;
        public WhileInfo[] whileInfos;
        public BasicBlockInfo[] basicBlockInfos;
    }

    public static interface Construct {
        public int getLength();
    }
}

