/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.mi;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.coder.mi.CodeCoverageMI;
import com.mathworks.toolbox.coder.mi.MatlabInterfaceLogger;
import com.mathworks.toolbox.coder.model.BuildError;
import com.mathworks.toolbox.coder.model.BuildErrorSeverity;
import com.mathworks.toolbox.coder.model.CallTree;
import com.mathworks.toolbox.coder.model.CoderFileSupport;
import com.mathworks.toolbox.coder.model.Expression;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.FunctionScopedKey;
import com.mathworks.toolbox.coder.model.MatlabType;
import com.mathworks.toolbox.coder.model.MetadataTree;
import com.mathworks.toolbox.coder.model.NumericType;
import com.mathworks.toolbox.coder.model.Range;
import com.mathworks.toolbox.coder.model.UnifiedModel;
import com.mathworks.toolbox.coder.model.Variable;
import com.mathworks.toolbox.coder.model.VariableKind;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPFimath;
import com.mathworks.toolbox.fixedpoint.FimathPanel;
import com.mathworks.toolbox.fixedpoint.SyntaxEnum;
import com.mathworks.util.MutableInt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConversionUtils {
    private static final String PROPOSED_TYPE_KEY = "ProposedType";
    private static final String INFERRED_TYPE_KEY = "inferred_Type";
    private static final String INTEGER_FLAG_KEY = "IsInteger";
    private static final String ROUNDING_METHOD_KEY = "RoundMode";
    private static final String OVERFLOW_ACTION_KEY = "OverflowMode";
    private static final String RATIO_OF_RANGE_KEY = "RatioOfRange";
    private static final String ERROR_FILE_KEY = "file";
    private static final String ERROR_FUNCTION_KEY = "functionName";
    private static final String ERROR_SPECIALIZATION_KEY = "specializationName";
    private static final String ERROR_SEVERITY_KEY = "type";
    private static final String ERROR_POSITION_KEY = "position";
    private static final String ERROR_LENGTH_KEY = "length";
    private static final String ERROR_MESSAGE_KEY = "text";
    public static final String SIM_MIN_KEY = "SimMin";
    public static final String SIM_MAX_KEY = "SimMax";
    public static final String DERIVED_MIN_KEY = "DerivedMin";
    public static final String DERIVED_MAX_KEY = "DerivedMax";
    public static final DoublyIndexedEnum<FimathPanel.RoundingMethod> ROUNDING_METHOD_RESOLVER = new DoublyIndexedEnum(FimathPanel.RoundingMethod.class);
    public static final DoublyIndexedEnum<FimathPanel.OverflowAction> OVERFLOW_ACTION_RESOLVER = new DoublyIndexedEnum(FimathPanel.OverflowAction.class);
    private static final boolean FORCE_INTERNAL_TYPE_FORMAT = true;
    private static CoverageOffsetConverter sCoverageOffsetConverter;

    private ConversionUtils() {
    }

    public static Set<String> getPopulatedFields(Object object) {
        Object[] objectArray;
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object2 : objectArray = (Object[])object) {
            Object[] objectArray2 = (Object[])object2;
            if (objectArray2.length <= 1) continue;
            for (int i = 1; i < objectArray2.length; ++i) {
                Object[] objectArray3 = (Object[])objectArray2[i];
                Object[] objectArray4 = (Object[])objectArray3[0];
                Object[] objectArray5 = (Object[])((Object[])objectArray3[1])[0];
                for (int j = 0; j < objectArray4.length; ++j) {
                    if (objectArray5[j] == null || objectArray5[j].equals("")) continue;
                    hashSet.add((String)objectArray4[j]);
                }
            }
        }
        return hashSet;
    }

    public static MetadataTree<VariableKind> convertPlainVariableList(Object object) {
        Object[] objectArray = (Object[])object;
        MetadataTree<VariableKind> metadataTree = new MetadataTree<VariableKind>();
        for (Object object2 : objectArray) {
            if (!(object2 instanceof Object[])) continue;
            Object[] objectArray2 = (Object[])object2;
            Function function = ConversionUtils.convertFunction(objectArray2);
            for (int i = 5; i < objectArray2.length; ++i) {
                Object[] objectArray3 = (Object[])objectArray2[i];
                Object[] objectArray4 = (Object[])((Object[])objectArray3[1])[0];
                String string = (String)objectArray4[0];
                metadataTree.put(new Variable(function, string), VariableKind.LOCAL);
            }
        }
        return metadataTree;
    }

    public static MetadataTree<MatlabType> convertMatlabTypes(Object object) {
        Object[] objectArray = (Object[])object;
        Map<String, Integer> map = null;
        MetadataTree<MatlabType> metadataTree = new MetadataTree<MatlabType>();
        for (Object object2 : objectArray) {
            Object[] objectArray2 = (Object[])object2;
            Function function = ConversionUtils.convertFunction(objectArray2);
            for (int i = 5; i < objectArray2.length; ++i) {
                Object[] objectArray3;
                Object[] objectArray4 = (Object[])objectArray2[i];
                if (map == null) {
                    objectArray3 = (Object[])objectArray4[0];
                    map = ConversionUtils.processHeader(objectArray3);
                }
                objectArray3 = (Object[])((Object[])objectArray4[1])[0];
                String string = (String)objectArray3[0];
                MatlabType matlabType = ConversionUtils.convertMatlabType(objectArray3[map.get(INFERRED_TYPE_KEY)]);
                metadataTree.put(new Variable(function, string), matlabType);
            }
        }
        return metadataTree;
    }

    private static MatlabType convertMatlabType(Object object) {
        Object[] objectArray = (Object[])object;
        Object[] objectArray2 = (Object[])objectArray[0];
        Object[] objectArray3 = (Object[])((Object[])objectArray[1])[0];
        String string = null;
        int[] nArray = null;
        boolean[] blArray = null;
        boolean bl = false;
        boolean bl2 = false;
        Object object2 = null;
        Object object3 = null;
        MatlabType.TypeFlag typeFlag = null;
        for (int i = 0; i < objectArray3.length; ++i) {
            if (objectArray2[i].equals("Class")) {
                string = (String)objectArray3[i];
                continue;
            }
            if (objectArray2[i].equals("Size")) {
                nArray = (int[])objectArray3[i];
                continue;
            }
            if (objectArray2[i].equals("Complex")) {
                bl = ((boolean[])objectArray3[i])[0];
                continue;
            }
            if (objectArray2[i].equals("SizeDynamic")) {
                blArray = (boolean[])objectArray3[i];
                continue;
            }
            if (objectArray2[i].equals("FiMath") && !(objectArray3[i] instanceof double[])) {
                object2 = objectArray3[i];
                continue;
            }
            if (objectArray2[i].equals("NumericType") && !(objectArray3[i] instanceof double[])) {
                object3 = objectArray3[i];
                continue;
            }
            if (objectArray2[i].equals("FiMathLocal") && objectArray3[i] instanceof boolean[]) {
                bl2 = ((boolean[])objectArray3[i])[0];
                continue;
            }
            if (!objectArray2[i].equals("SystemObj") && !objectArray2[i].equals("CppSystemObj") || !(objectArray3[i] instanceof boolean[]) || typeFlag != null) continue;
            typeFlag = ((boolean[])objectArray3[i])[0] ? MatlabType.TypeFlag.SYSTEM_OBJECT : null;
        }
        if (object3 != null) {
            NumericType numericType = ConversionUtils.convertNumericTypeProperties(object3);
            IDPFimath iDPFimath = ConversionUtils.convertFimathProperties(object2);
            return new MatlabType(string, nArray, blArray, bl, numericType, iDPFimath, bl2);
        }
        return new MatlabType(string, nArray, blArray, bl, typeFlag);
    }

    public static NumericType convertNumericTypeProperties(Object object) {
        Object[] objectArray = (Object[])object;
        Map<String, Integer> map = ConversionUtils.processHeader((Object[])objectArray[0]);
        Object[] objectArray2 = (Object[])((Object[])objectArray[1])[0];
        boolean bl = objectArray2[map.get("Signedness")].equals("Signed");
        int n = (int)((double[])objectArray2[map.get("WordLength")])[0];
        int n2 = (int)((double[])objectArray2[map.get("FractionLength")])[0];
        String string = (String)objectArray2[map.get("DataType")];
        return new NumericType(bl, n, n2, false, string.equals("ScaledDouble"));
    }

    public static IDPFimath convertFimathProperties(Object object) {
        Object[] objectArray = (Object[])object;
        Map<String, Integer> map = ConversionUtils.processHeader((Object[])objectArray[0]);
        Object[] objectArray2 = (Object[])((Object[])objectArray[1])[0];
        IDPFimath iDPFimath = new IDPFimath();
        iDPFimath.setOverflowAction(objectArray2[map.get("OverflowAction")].toString());
        iDPFimath.setRoundingMethod(objectArray2[map.get("RoundingMethod")].toString());
        return iDPFimath;
    }

    public static MetadataTree<VariableKind> convertVariableKinds(Function function, Object object, MetadataTree<VariableKind> metadataTree) {
        Object[] objectArray = (Object[])((Object[])object)[1];
        for (int i = 0; i < objectArray.length; ++i) {
            Object[] objectArray2 = (Object[])objectArray[i];
            if (!objectArray2[0].equals(function.getName())) continue;
            for (String string : (String[])objectArray2[1]) {
                metadataTree.put(new Variable(function, string), VariableKind.INPUT);
            }
            for (String string : (String[])objectArray2[2]) {
                Variable variable = new Variable(function, string);
                if (metadataTree.get(variable) == VariableKind.INPUT) {
                    metadataTree.put(variable, VariableKind.INPUT_OUTPUT);
                    continue;
                }
                metadataTree.put(variable, VariableKind.OUTPUT);
            }
            for (String string : (String[])objectArray2[3]) {
                metadataTree.put(new Variable(function, string), VariableKind.PERSISTENT);
            }
            HashSet hashSet = new HashSet();
            for (String string : (String[])objectArray2[4]) {
                metadataTree.put(new Variable(function, string), VariableKind.INDEX);
                hashSet.add(string);
            }
            for (String string : (String[])objectArray2[5]) {
                if (hashSet.contains(string)) continue;
                metadataTree.put(new Variable(function, string), VariableKind.LOCAL);
            }
        }
        return metadataTree;
    }

    public static void convertTypes(Object object, MetadataTree<String> metadataTree, MetadataTree<Boolean> metadataTree2) {
        VariableFunctionAccessor variableFunctionAccessor = new VariableFunctionAccessor();
        ConversionUtils.convertTypes(((Object[])object)[0], new VariableKeyGenerator(), variableFunctionAccessor, metadataTree, metadataTree2);
        ConversionUtils.convertTypes(((Object[])object)[1], new ExpressionKeyGenerator(new LinkedList<Expression>()), new ExpressionFunctionAccessor(variableFunctionAccessor), metadataTree, metadataTree2);
    }

    private static MetadataTree<String> convertTypes(Object object, KeyGenerator keyGenerator, FunctionAccessor functionAccessor, MetadataTree<String> metadataTree, MetadataTree<Boolean> metadataTree2) {
        Object[] objectArray = (Object[])object;
        Map<String, Integer> map = null;
        for (Object object2 : objectArray) {
            Object[] objectArray2 = (Object[])object2;
            Function function = functionAccessor.getFunction(objectArray2);
            for (int i = functionAccessor.getIndexAfterFunction(); i < objectArray2.length; ++i) {
                Object[] objectArray3;
                Object[] objectArray4 = (Object[])objectArray2[i];
                if (map == null) {
                    objectArray3 = (Object[])objectArray4[0];
                    map = ConversionUtils.processHeader(objectArray3);
                }
                objectArray3 = (Object[])((Object[])objectArray4[1])[0];
                String string = (String)objectArray3[map.get(PROPOSED_TYPE_KEY)];
                boolean bl = ConversionUtils.parseIntegerString((String)objectArray3[map.get(INTEGER_FLAG_KEY)]);
                FunctionScopedKey functionScopedKey = keyGenerator.generate(function, objectArray3);
                metadataTree.put(functionScopedKey, string);
                metadataTree2.put(functionScopedKey, bl);
            }
        }
        return metadataTree;
    }

    public static Map<String, Integer> processHeader(Object[] objectArray) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < objectArray.length; ++i) {
            hashMap.put((String)objectArray[i], i);
        }
        return hashMap;
    }

    public static void convertRangesAndTypes(Object object, String string, String string2, MetadataTree<Range> metadataTree, MetadataTree<MatlabType> metadataTree2, MetadataTree<String> metadataTree3, MetadataTree<Boolean> metadataTree4, MetadataTree<Boolean> metadataTree5, MetadataTree<FimathPanel.RoundingMethod> metadataTree6, MetadataTree<FimathPanel.OverflowAction> metadataTree7, Collection<Expression> collection) {
        VariableFunctionAccessor variableFunctionAccessor = new VariableFunctionAccessor();
        ConversionUtils.convertRangesAndTypes(((Object[])object)[0], new VariableKeyGenerator(), variableFunctionAccessor, string, string2, metadataTree, metadataTree2, metadataTree3, metadataTree4, metadataTree5, metadataTree6, metadataTree7);
        ConversionUtils.convertRangesAndTypes(((Object[])object)[1], new ExpressionKeyGenerator(collection), new ExpressionFunctionAccessor(variableFunctionAccessor), string, string2, metadataTree, metadataTree2, metadataTree3, metadataTree4, metadataTree5, metadataTree6, metadataTree7);
    }

    public static void convertRangesAndTypes(Object object, KeyGenerator keyGenerator, FunctionAccessor functionAccessor, String string, String string2, MetadataTree<Range> metadataTree, MetadataTree<MatlabType> metadataTree2, MetadataTree<String> metadataTree3, MetadataTree<Boolean> metadataTree4, MetadataTree<Boolean> metadataTree5, MetadataTree<FimathPanel.RoundingMethod> metadataTree6, MetadataTree<FimathPanel.OverflowAction> metadataTree7) {
        Object[] objectArray = (Object[])object;
        Map<String, Integer> map = null;
        for (Object object2 : objectArray) {
            Object[] objectArray2 = (Object[])object2;
            Function function = functionAccessor.getFunction(objectArray2);
            for (int i = functionAccessor.getIndexAfterFunction(); i < objectArray2.length; ++i) {
                Object object3;
                Object[] objectArray3;
                Object[] objectArray4 = (Object[])objectArray2[i];
                if (map == null) {
                    objectArray3 = (Object[])objectArray4[0];
                    map = ConversionUtils.processHeader(objectArray3);
                }
                objectArray3 = (Object[])((Object[])objectArray4[1])[0];
                Double d = ConversionUtils.parseDouble((String)objectArray3[map.get(string)]);
                Double d2 = ConversionUtils.parseDouble((String)objectArray3[map.get(string2)]);
                boolean bl = ConversionUtils.parseIntegerString((String)objectArray3[map.get(INTEGER_FLAG_KEY)]);
                FunctionScopedKey functionScopedKey = keyGenerator.generate(function, objectArray3);
                metadataTree.put(functionScopedKey, new Range(d, d2));
                metadataTree3.put(functionScopedKey, ConversionUtils.unpackType(objectArray3[map.get(PROPOSED_TYPE_KEY)]));
                metadataTree4.put(functionScopedKey, bl);
                if (map.containsKey(RATIO_OF_RANGE_KEY) && (object3 = objectArray3[map.get(RATIO_OF_RANGE_KEY)]) instanceof double[] && ((double[])object3).length == 1 && ((double[])object3)[0] > 100.0) {
                    metadataTree5.put(functionScopedKey, true);
                }
                if (map.containsKey(INFERRED_TYPE_KEY) && !objectArray3[map.get(INFERRED_TYPE_KEY)].equals("")) {
                    object3 = ConversionUtils.convertMatlabType(objectArray3[map.get(INFERRED_TYPE_KEY)]);
                    metadataTree2.put(functionScopedKey, (MatlabType)object3);
                }
                if (metadataTree2.get(functionScopedKey) != null && metadataTree2.get(functionScopedKey).getFimath() != null) continue;
                try {
                    object3 = ROUNDING_METHOD_RESOLVER.valueOf(((String)objectArray3[map.get(ROUNDING_METHOD_KEY)]).toUpperCase(Locale.ENGLISH));
                    metadataTree6.put(functionScopedKey, (FimathPanel.RoundingMethod)object3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                try {
                    object3 = OVERFLOW_ACTION_RESOLVER.valueOf(((String)objectArray3[map.get(OVERFLOW_ACTION_KEY)]).toUpperCase(Locale.ENGLISH));
                    metadataTree7.put(functionScopedKey, (FimathPanel.OverflowAction)object3);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    private static boolean parseIntegerString(@Nullable String string) {
        return string != null && (string.equalsIgnoreCase("Yes") || string.equalsIgnoreCase("true"));
    }

    public static String unpackType(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            NumericType numericType = NumericType.parse((String)object);
            return numericType != null ? numericType.toString() : (String)object;
        }
        if (!(object instanceof Object[])) {
            return null;
        }
        Map<String, Integer> map = ConversionUtils.processHeader((Object[])((Object[])object)[0]);
        Object[] objectArray = (Object[])((Object[])object)[1];
        if (map.size() >= 2 && objectArray.length >= 2) {
            String string = objectArray[map.get("Signedness")].toString();
            int n = Integer.parseInt(objectArray[map.get("WordLength")].toString());
            Integer n2 = null;
            if (map.containsKey("FractionLength")) {
                String string2;
                Object object2 = objectArray[map.get("FractionLength")];
                if (object2 != null && !(string2 = object2.toString()).isEmpty()) {
                    try {
                        n2 = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return NumericType.toNumericTypeString(string, n, n2);
            }
        }
        return null;
    }

    private static Double parseDouble(String string) {
        if (string.isEmpty()) {
            return Double.NaN;
        }
        if (string.equalsIgnoreCase("-Inf")) {
            return Double.NEGATIVE_INFINITY;
        }
        if (string.equalsIgnoreCase("Inf")) {
            return Double.POSITIVE_INFINITY;
        }
        if (string.equalsIgnoreCase("NaN")) {
            return Double.NaN;
        }
        return Double.parseDouble(string);
    }

    public static String expandFixedPointType(String string) {
        return ConversionUtils.expandFixedPointType(string, false);
    }

    public static String expandFixedPointType(String string, boolean bl) {
        try {
            NumericType numericType = new NumericType(string);
            return numericType.toString(bl);
        }
        catch (RuntimeException runtimeException) {
            return string;
        }
    }

    public static String contractFixedPointType(String string) {
        try {
            if (string.startsWith("uint")) {
                string = "ufix" + string.substring("uint".length());
            } else if (string.startsWith("int")) {
                string = "sfix" + string.substring("int".length());
            } else if (NumericType.isCanonicalNumericType(string)) {
                return new NumericType(string).toString();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "numerictype(, )");
            String string2 = stringTokenizer.nextToken();
            if (!string2.equals(NumericType.Signedness.AUTO.getUserRepresentation())) {
                boolean bl = stringTokenizer.nextToken().equals("1");
                int n = Integer.parseInt(stringTokenizer.nextToken());
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                String string3 = (bl ? "s" : "u") + "fix" + n;
                if (n2 > 0) {
                    return string3 + "_En" + n2;
                }
                if (n2 < 0) {
                    return string3 + "_E" + -n2;
                }
                return string3;
            }
        }
        catch (RuntimeException runtimeException) {
            return string;
        }
        return string;
    }

    private static Function convertFunction(Object[] objectArray) {
        Integer n = null;
        if (objectArray.length >= 5) {
            if (objectArray[4] instanceof Number) {
                n = ((Number)objectArray[4]).intValue();
            } else if (objectArray[4] instanceof double[]) {
                n = Double.valueOf(((double[])objectArray[4])[0]).intValue();
            }
        }
        return new Function(new File((String)objectArray[2]), (String)objectArray[0], (String)objectArray[1], (String)objectArray[3], n);
    }

    public static List<BuildError> convertErrors(Object object) {
        ArrayList<BuildError> arrayList = new ArrayList<BuildError>();
        if (!(object instanceof double[]) && !(object instanceof MLArrayRef)) {
            Map<String, Integer> map = ConversionUtils.processHeader((Object[])((Object[])object)[0]);
            Object[] objectArray = (Object[])((Object[])object)[1];
            LineMapper lineMapper = new LineMapper();
            OffsetConverterSource offsetConverterSource = new OffsetConverterSource();
            for (Object object2 : objectArray) {
                Object[] objectArray2 = (Object[])object2;
                String string = null;
                if (map.containsKey(ERROR_SPECIALIZATION_KEY) && (string = (String)objectArray2[map.get(ERROR_SPECIALIZATION_KEY)]).isEmpty()) {
                    string = null;
                }
                File file = new File((String)objectArray2[map.get(ERROR_FILE_KEY)]);
                String string2 = (String)objectArray2[map.get(ERROR_FUNCTION_KEY)];
                Function function = new Function(file, string2);
                CoderFileSupport.OffsetConverter offsetConverter = offsetConverterSource.getConverterForFile(file);
                String string3 = (String)objectArray2[map.get(ERROR_MESSAGE_KEY)];
                BuildErrorSeverity buildErrorSeverity = BuildErrorSeverity.valueOf(objectArray2[map.get(ERROR_SEVERITY_KEY)].toString().toUpperCase(Locale.ENGLISH));
                int n = ConversionUtils.readInt(objectArray2, map.get(ERROR_POSITION_KEY));
                int n2 = ConversionUtils.readInt(objectArray2, map.get(ERROR_LENGTH_KEY));
                if (offsetConverter != null) {
                    n2 = offsetConverter.byteToCharOffsetLength(n, n2);
                    n = offsetConverter.byteToCharOffset(n);
                }
                int n3 = lineMapper.map(function, n);
                if (n2 == 0) {
                    n2 = lineMapper.getLineLength(function, n3);
                }
                arrayList.add(new BuildError(function, n, n3, n2, buildErrorSeverity, string3));
            }
        }
        return arrayList;
    }

    public static CallTree convertCallTree(Object object, Collection<Function> collection) {
        HashMap<Function, Function> hashMap = new HashMap<Function, Function>();
        OffsetConverterSource offsetConverterSource = new OffsetConverterSource();
        CallTree callTree = new CallTree();
        Object[] objectArray = (Object[])object;
        for (int i = 0; i < objectArray.length; i += 7) {
            String string = (String)objectArray[i];
            String string2 = (String)objectArray[i + 1];
            String string3 = (String)objectArray[i + 2];
            String string4 = (String)objectArray[i + 3];
            String string5 = (String)objectArray[i + 4];
            String string6 = (String)objectArray[i + 5];
            int n = (int)((double[])objectArray[i + 6])[0];
            File file = new File(string3);
            Function function = new Function(file, string, string2);
            Function function2 = new Function(new File(string6), string4, string5);
            function = ConversionUtils.resolvePartialFunctionKey(function, hashMap, collection);
            function2 = ConversionUtils.resolvePartialFunctionKey(function2, hashMap, collection);
            if (function == null || function2 == null) continue;
            callTree.add(new CallTree.CallSite(offsetConverterSource.getConverterForFile(file).byteToCharOffset(n), function, function2));
        }
        return callTree;
    }

    private static Function resolvePartialFunctionKey(Function function, Map<Function, Function> map, Collection<Function> collection) {
        if (map.containsKey(function)) {
            return map.get(function);
        }
        for (Function function2 : collection) {
            if (!function2.equals(function)) continue;
            map.put(function, function2);
            return function2;
        }
        return null;
    }

    public static void loadAllVariableKinds(final UnifiedModel unifiedModel, final Runnable runnable) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                final Map<File, List<Function>> map = unifiedModel.getFunctionsByFile();
                final MetadataTree metadataTree = new MetadataTree();
                Matlab.whenMatlabReady((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (Map.Entry entry : map.entrySet()) {
                            Object[] objectArray = new Object[]{"fpGetVariableKinds", ((File)entry.getKey()).getAbsolutePath()};
                            try {
                                Object object = Matlab.mtFeval((String)"emlcprivate", (Object[])objectArray, (int)1);
                                MatlabInterfaceLogger.logReturn("emlcprivate", 1, objectArray, object);
                                for (Function function : (List)entry.getValue()) {
                                    ConversionUtils.convertVariableKinds(function, object, metadataTree);
                                }
                            }
                            catch (Exception exception) {
                                MatlabInterfaceLogger.logError("emlcprivate", 1, objectArray, exception);
                                throw new IllegalStateException(exception);
                            }
                        }
                        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                unifiedModel.setVariableKinds(metadataTree);
                                if (runnable != null) {
                                    runnable.run();
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    private static int readInt(Object[] objectArray, int n) {
        if (objectArray[n] instanceof double[]) {
            return (int)((double[])objectArray[n])[0];
        }
        return ((int[])objectArray[n])[0];
    }

    @Nullable
    public static Function getMostRepresentedFunction(List<Variable> list) {
        final HashMap<Function, MutableInt> hashMap = new HashMap<Function, MutableInt>();
        for (Variable variable : list) {
            if (variable.getFunction() == null) continue;
            MutableInt mutableInt = (MutableInt)hashMap.get(variable.getFunction());
            if (mutableInt == null) {
                hashMap.put(variable.getFunction(), new MutableInt(1));
                continue;
            }
            mutableInt.setValue(mutableInt.getValue() + 1);
        }
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        Collections.sort(arrayList, new Comparator<Function>(){

            @Override
            public int compare(Function function, Function function2) {
                int n = Integer.valueOf(((MutableInt)hashMap.get(function)).getValue()).compareTo(((MutableInt)hashMap.get(function2)).getValue());
                if (n == 0) {
                    n = Boolean.valueOf(function.isEntryPointFunction()).compareTo(function2.isEntryPointFunction());
                }
                return -n;
            }
        });
        return !arrayList.isEmpty() ? (Function)arrayList.get(0) : null;
    }

    public static void convertOffsets(List<CodeCoverageMI.CovInfo> list) {
        if (sCoverageOffsetConverter == null) {
            sCoverageOffsetConverter = new CoverageOffsetConverter();
        }
        OffsetConverterSource offsetConverterSource = new OffsetConverterSource();
        for (CodeCoverageMI.CovInfo covInfo : list) {
            sCoverageOffsetConverter.convert(covInfo, offsetConverterSource);
        }
    }

    private static class OffsetConverterSource {
        private final Map<File, CoderFileSupport.OffsetConverter> fConverters = new HashMap<File, CoderFileSupport.OffsetConverter>();

        OffsetConverterSource() {
        }

        @NotNull
        CoderFileSupport.OffsetConverter getConverterForFile(File file) {
            CoderFileSupport.OffsetConverter offsetConverter = this.fConverters.get(file);
            if (offsetConverter == null) {
                try {
                    offsetConverter = CoderFileSupport.getOffsetConverter(file);
                }
                catch (IOException iOException) {
                    offsetConverter = new CoderFileSupport.OffsetConverter(){

                        @Override
                        public int byteToCharOffset(int n) {
                            return n;
                        }
                    };
                }
                this.fConverters.put(file, offsetConverter);
            }
            return offsetConverter;
        }
    }

    public static class DoublyIndexedEnum<T extends Enum<T>> {
        private final Map<String, T> fMappedValues = new HashMap<String, T>();

        private DoublyIndexedEnum(Class<T> clazz) {
            for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                this.fMappedValues.put(enum_.name().toLowerCase(Locale.ENGLISH), enum_);
            }
            for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                this.fMappedValues.put(((SyntaxEnum)enum_).toSyntaxString().toLowerCase(Locale.ENGLISH), enum_);
            }
        }

        public T valueOf(String string) {
            return (T)((Enum)this.fMappedValues.get(string.toLowerCase(Locale.ENGLISH)));
        }
    }

    private static class CoverageOffsetConverter {
        private final Map<Class<?>, ReflectiveContext> fContexts = new HashMap();

        CoverageOffsetConverter() {
            for (Class<?> clazz : CodeCoverageMI.class.getDeclaredClasses()) {
                if (clazz.isInterface()) continue;
                this.processClassInto(clazz);
            }
            for (ReflectiveContext reflectiveContext : this.fContexts.values()) {
                reflectiveContext.initChildFields();
            }
        }

        void convert(CodeCoverageMI.CovInfo covInfo, OffsetConverterSource offsetConverterSource) {
            assert (covInfo.path != null && covInfo.path.exists());
            try {
                this.convert((Object)covInfo, offsetConverterSource.getConverterForFile(covInfo.path));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(illegalAccessException);
            }
        }

        private void convert(Object object, CoderFileSupport.OffsetConverter offsetConverter) throws IllegalAccessException {
            ReflectiveContext reflectiveContext = this.fContexts.get(object.getClass());
            if (reflectiveContext == null || reflectiveContext.getOffsetFields().isEmpty() && reflectiveContext.getChildFields().isEmpty()) {
                return;
            }
            for (Field field : reflectiveContext.getOffsetFields()) {
                field.setInt(object, offsetConverter.byteToCharOffset(field.getInt(object)));
            }
            for (Field field : reflectiveContext.getChildFields()) {
                Object object2 = field.get(object);
                if (object2 == null) continue;
                if (field.getType().isArray()) {
                    for (Object object3 : (Object[])object2) {
                        this.convert(object3, offsetConverter);
                    }
                    continue;
                }
                this.convert(object2, offsetConverter);
            }
        }

        private void processClassInto(Class<?> clazz) {
            ReflectiveContext reflectiveContext = this.parseClass(clazz);
            this.fContexts.put(clazz, reflectiveContext);
            this.fContexts.put(Array.newInstance(clazz, 0).getClass(), reflectiveContext);
        }

        private ReflectiveContext parseClass(Class<?> clazz) {
            HashSet<Field> hashSet = new HashSet<Field>();
            for (Field field : clazz.getFields()) {
                if (field.getAnnotation(CodeCoverageMI.CoverageByteOffset.class) == null) continue;
                hashSet.add(field);
            }
            return new ReflectiveContext(clazz, hashSet);
        }

        private class ReflectiveContext {
            private final Class<?> fClaxx;
            private final Set<Field> fChildFields;
            private final Set<Field> fOffsetFields;

            private ReflectiveContext(Class<?> clazz, Set<Field> set) {
                this.fClaxx = clazz;
                this.fOffsetFields = set;
                this.fChildFields = new HashSet<Field>();
            }

            void initChildFields() {
                for (Field field : this.fClaxx.getFields()) {
                    if (this.fOffsetFields.contains(field) || this.fClaxx.equals(field.getType()) || !CoverageOffsetConverter.this.fContexts.containsKey(field.getType())) continue;
                    this.fChildFields.add(field);
                }
            }

            Set<Field> getChildFields() {
                return this.fChildFields;
            }

            Set<Field> getOffsetFields() {
                return this.fOffsetFields;
            }
        }
    }

    private static class LineMapper {
        private final Map<File, int[]> fMap = new HashMap<File, int[]>();

        private LineMapper() {
        }

        public int getLineLength(Function function, int n) {
            int n2;
            this.map(function, 0);
            int[] nArray = this.fMap.get(function.getFile());
            int n3 = n2 = n - 1 >= 0 && n - 1 < nArray.length ? nArray[n - 1] : 0;
            if (n == nArray.length) {
                return (int)function.getFile().length() - n2;
            }
            if (n < nArray.length) {
                return nArray[n] - n2;
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int map(Function function, int n) {
            int[] nArray = this.fMap.get(function.getFile());
            if (nArray == null) {
                int n2;
                LinkedList<Integer> linkedList = new LinkedList<Integer>();
                BufferedReader bufferedReader = null;
                char[] cArray = new char[2048];
                try {
                    int n3 = 0;
                    bufferedReader = new BufferedReader(new FileReader(function.getFile()));
                    block11: while ((n2 = bufferedReader.read(cArray)) > 0) {
                        int n4 = 0;
                        while (true) {
                            if (n4 >= n2) continue block11;
                            if (cArray[n4] == '\n') {
                                linkedList.add(n3 + 1);
                            } else if (cArray[n4] == '\r') {
                                --n3;
                            }
                            ++n4;
                            ++n3;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    int n5 = 1;
                    return n5;
                }
                finally {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                nArray = new int[linkedList.size()];
                Iterator iterator = linkedList.iterator();
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    nArray[n2] = (Integer)iterator.next();
                }
                this.fMap.put(function.getFile(), nArray);
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (n >= nArray[i]) continue;
                return i + 1;
            }
            return nArray.length + 1;
        }
    }

    private static class ExpressionFunctionAccessor
    implements FunctionAccessor {
        private final VariableFunctionAccessor fCache;

        ExpressionFunctionAccessor(VariableFunctionAccessor variableFunctionAccessor) {
            this.fCache = variableFunctionAccessor;
        }

        @Override
        public Function getFunction(Object[] objectArray) {
            return this.fCache.get((String)objectArray[0]);
        }

        @Override
        public int getIndexAfterFunction() {
            return 1;
        }
    }

    private static class VariableFunctionAccessor
    implements FunctionAccessor {
        private final Map<String, Function> fMapBySpecialization = new HashMap<String, Function>();
        private final Map<String, Function> fMapByFunction = new HashMap<String, Function>();

        private VariableFunctionAccessor() {
        }

        @Override
        public Function getFunction(Object[] objectArray) {
            Function function = ConversionUtils.convertFunction(objectArray);
            this.fMapBySpecialization.put(function.getUniqueId(), function);
            this.fMapByFunction.put(function.getName(), function);
            return function;
        }

        @Override
        public int getIndexAfterFunction() {
            return 5;
        }

        Function get(String string) {
            Function function = this.fMapBySpecialization.get(string);
            return function == null ? this.fMapByFunction.get(string) : function;
        }
    }

    private static interface FunctionAccessor {
        public Function getFunction(Object[] var1);

        public int getIndexAfterFunction();
    }

    private static class VariableKeyGenerator
    implements KeyGenerator {
        private VariableKeyGenerator() {
        }

        @Override
        public FunctionScopedKey generate(Function function, Object[] objectArray) {
            return new Variable(function, objectArray[0].toString());
        }
    }

    private static class ExpressionKeyGenerator
    implements KeyGenerator {
        private final Collection<Expression> fExpressions;
        private final OffsetConverterSource fOffsetConverterSource;

        ExpressionKeyGenerator(Collection<Expression> collection) {
            this.fExpressions = collection;
            this.fOffsetConverterSource = new OffsetConverterSource();
        }

        @Override
        public FunctionScopedKey generate(Function function, Object[] objectArray) {
            CoderFileSupport.OffsetConverter offsetConverter = this.fOffsetConverterSource.getConverterForFile(function.getFile());
            try {
                int n = ((int[])objectArray[objectArray.length - 2])[0];
                Expression expression = new Expression(function, offsetConverter.byteToCharPosition(n), offsetConverter.byteToCharPositionLength(n, ((int[])objectArray[objectArray.length - 1])[0]), offsetConverter.byteToCharOffset(Integer.parseInt((String)objectArray[0])));
                this.fExpressions.add(expression);
                return expression;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    private static interface KeyGenerator {
        public FunctionScopedKey generate(Function var1, Object[] var2);
    }
}

