/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.model;

import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.FunctionScopedKey;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MetadataTree<V> {
    private final Node fRoot = new Node((Function)null);

    public final void reset() {
        this.fRoot.removeAllChildren();
    }

    public final void put(FunctionScopedKey<?> functionScopedKey, V v) {
        Node node = this.getNode(functionScopedKey, true);
        node.setValue(v);
    }

    public final void remove(FunctionScopedKey<?> functionScopedKey) {
        Node node = this.getFunctionNode(functionScopedKey.getFunction(), false);
        if (node != null) {
            node.removeChild(functionScopedKey.getKey());
        }
    }

    public final V get(FunctionScopedKey<?> functionScopedKey) {
        Node node = this.getNode(functionScopedKey, false);
        return node == null ? null : (V)node.getValue();
    }

    private final Node getNode(FunctionScopedKey<?> functionScopedKey, boolean bl) {
        Node node = this.getFunctionNode(functionScopedKey.getFunction(), bl);
        if (node == null) {
            return null;
        }
        Node node2 = node.getChild(functionScopedKey.getKey());
        if (node2 == null && bl) {
            node2 = new Node(functionScopedKey);
            node.addChild(node2);
        }
        return node2;
    }

    private final Node getFunctionNode(Function function, boolean bl) {
        for (Node node : this.fRoot.getChildren()) {
            if (!node.getFunction().equals(function)) continue;
            return node;
        }
        if (!bl) {
            return null;
        }
        Node node = new Node(function);
        this.fRoot.addChild(node);
        return node;
    }

    public final List<Function> getFunctions() {
        ArrayList<Function> arrayList = new ArrayList<Function>();
        for (Node node : this.fRoot.getChildren()) {
            arrayList.add(node.getFunction());
        }
        return arrayList;
    }

    public List<FunctionScopedKey<?>> getKeys(Function function) {
        ArrayList arrayList = new ArrayList();
        Node node = this.getFunctionNode(function, false);
        if (node != null) {
            for (Node node2 : node.getChildren()) {
                arrayList.add(node2.getScopedKey());
            }
        }
        return arrayList;
    }

    public <K> List<K> getKeys(Function function, Class<K> clazz) {
        List<FunctionScopedKey<?>> list = this.getKeys(function);
        ArrayList arrayList = new ArrayList();
        for (FunctionScopedKey<?> functionScopedKey : list) {
            if (!clazz.isInstance(functionScopedKey)) continue;
            arrayList.add(functionScopedKey);
        }
        return arrayList;
    }

    public final boolean hasAnyValues() {
        for (Function function : this.getFunctions()) {
            for (FunctionScopedKey<?> functionScopedKey : this.getKeys(function)) {
                if (this.get(functionScopedKey) == null) continue;
                return true;
            }
        }
        return false;
    }

    public class Node {
        private final Function fFunction;
        private final FunctionScopedKey<?> fScopedKey;
        private final List<Node> fChildren;
        private final Map<Object, Node> fChildrenByKey;
        private V fValue;

        Node(Function function) {
            this(function, null);
        }

        Node(FunctionScopedKey<?> functionScopedKey) {
            this(functionScopedKey.getFunction(), functionScopedKey);
        }

        private Node(Function function, FunctionScopedKey<?> functionScopedKey) {
            this.fFunction = function;
            this.fScopedKey = functionScopedKey;
            this.fChildren = new LinkedList<Node>();
            this.fChildrenByKey = new LinkedHashMap<Object, Node>();
        }

        public Function getFunction() {
            return this.fFunction;
        }

        public FunctionScopedKey<?> getKey() {
            return this.fScopedKey;
        }

        public void setValue(V v) {
            this.fValue = v;
        }

        public V getValue() {
            return this.fValue;
        }

        public FunctionScopedKey<?> getScopedKey() {
            return this.fScopedKey;
        }

        public void addChild(Node node) {
            this.fChildren.add(node);
            if (node.getKey() != null) {
                this.fChildrenByKey.put(node.getKey().getKey(), node);
            }
        }

        public void removeChild(Object object) {
            Node node = this.fChildrenByKey.remove(object);
            if (node != null) {
                this.fChildren.remove(node);
            }
        }

        public List<Node> getChildren() {
            return new ArrayList<Node>(this.fChildren);
        }

        public void removeAllChildren() {
            this.fChildren.clear();
        }

        public Node getChild(Object object) {
            return this.fChildrenByKey.get(object);
        }
    }
}

