/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJHelpButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.SectionComponentWithPropertySupport;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.project.impl.settingsui.ParamSetPanel;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.InstrumentationUtils;
import com.mathworks.toolbox.coder.plugin.MatlabResult;
import com.mathworks.toolbox.coder.plugin.TargetArtifact;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.BusyAffordance;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class BuildResultsSection
implements SectionComponentWithPropertySupport,
PropertyChangeListener {
    private final Configuration fConfig;
    private final MJPanel fPanel;
    private final PropertyChangeSupport fPropertySupport;
    private JPanel fButtonPanel;
    private MJButton fCodeGenReportSimpleButton;
    private MJLabel fDescription;
    private MJLabel fReportUnavailableMessage;
    private ParamSetPanel fInstrumentationSettingsPanel;
    private MJDialog fInstrumentationSettingsDialog;
    private BusyAffordance fBusyAffordance;
    private String fHeaderText;

    public BuildResultsSection(WritableConfiguration writableConfiguration) {
        this.fConfig = (Configuration)writableConfiguration;
        this.fPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        this.fPanel.setOpaque(false);
        this.fPropertySupport = new PropertyChangeSupport(this);
        this.rebuildPanel();
        this.updateHeaderText();
        this.fConfig.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void updateHeaderText() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string = BuildResultsSection.this.fHeaderText;
                String string2 = BuildResultsSection.this.fConfig.getParamAsString("param.artifact");
                BuildResultsSection.this.fHeaderText = string2.equals("option.target.artifact.mex.instrumented") ? CoderResources.getString("results.title.instrumented") : CoderResources.getString("results.title.normal");
                BuildResultsSection.this.fPropertySupport.firePropertyChange("header-text", string, BuildResultsSection.this.fHeaderText);
            }
        });
    }

    public Component getComponent() {
        return this.fPanel;
    }

    private void updateResultsDescription() {
        if (this.fConfig.getParamAsString("param.artifact").equals("option.target.artifact.mex.instrumented")) {
            this.fDescription.setText(CoderResources.getString("desc.buildResults.instrumented"));
        } else {
            this.fDescription.setText(CoderResources.getString("desc.buildResults"));
        }
    }

    private void createReportUnavailableMessage() {
        this.fReportUnavailableMessage = Utilities.createDescriptionComponent("desc.noBuildResults");
    }

    private boolean hasInstrumentationReport() {
        String string = this.fConfig.getParamAsString("param.artifact");
        return string.equals("option.target.artifact.mex.instrumented") && this.fConfig.getParamAsBoolean("param.BuiltInstrumentedMex") && this.fConfig.getParamAsBoolean("param.RanInstrumentedMex") && BuildResultsSection.isReportAvailable(this.getMainHtml()) && !BuildResultsSection.hasErrors(this.getMainHtml());
    }

    private void rebuildPanel() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Object object;
                BuildResultsSection.this.fDescription = Utilities.createDescriptionComponent(null);
                BuildResultsSection.this.updateResultsDescription();
                BuildResultsSection.this.createReportUnavailableMessage();
                BuildResultsSection.this.fBusyAffordance = new BusyAffordance(BusyAffordance.AffordanceSize.SIZE_16x16);
                BuildResultsSection.this.fBusyAffordance.getComponent().setVisible(false);
                BuildResultsSection.this.fButtonPanel = (JPanel)new MJPanel((LayoutManager)new FormLayout("fill:d, 3dlu, fill:d", "3dlu, fill:d, 3dlu"));
                BuildResultsSection.this.fButtonPanel.setOpaque(false);
                BuildResultsSection.this.fCodeGenReportSimpleButton = new MJButton(CoderResources.getString("button.report"));
                BuildResultsSection.this.fCodeGenReportSimpleButton.setName("view.report.button");
                BuildResultsSection.this.fCodeGenReportSimpleButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (BuildResultsSection.this.hasInstrumentationReport()) {
                            InstrumentationUtils.showReport(BuildResultsSection.this.fConfig, BuildResultsSection.this.fBusyAffordance, new String[0]);
                        } else {
                            BuildResultsSection.this.showRegularReport();
                        }
                    }
                });
                CellConstraints cellConstraints = new CellConstraints();
                BuildResultsSection.this.fButtonPanel.add((Component)BuildResultsSection.this.fCodeGenReportSimpleButton, cellConstraints.xy(1, 2));
                BuildResultsSection.this.fButtonPanel.add((Component)BuildResultsSection.this.fBusyAffordance.getComponent(), cellConstraints.xy(3, 2));
                BuildResultsSection.this.updateReportHyperLinkVisibility();
                boolean bl = BuildResultsSection.this.fConfig.getParamAsString("param.artifact").equals("option.target.artifact.mex.instrumented");
                String string = "p, default:grow";
                String string2 = "p, 3dlu, p, 1dlu, " + (bl ? "p, 3dlu, p" : "p") + ", p";
                FormLayout formLayout = new FormLayout(string, string2);
                PanelBuilder panelBuilder = new PanelBuilder(formLayout);
                CellConstraints cellConstraints2 = new CellConstraints();
                panelBuilder.add((Component)BuildResultsSection.this.fDescription, cellConstraints2.xyw(1, 1, 2));
                panelBuilder.add((Component)Utilities.createSeparator(), cellConstraints2.xyw(1, 3, 2));
                int n = 5;
                if (bl) {
                    object = Utilities.createLink(CoderResources.getString("results.instrumentation.report.settings"), "results.instrumentation.report.settings", new Runnable(){

                        @Override
                        public void run() {
                            BuildResultsSection.this.showInstrumentationReportSettings();
                        }
                    });
                    panelBuilder.add((Component)object.getComponent(), cellConstraints2.xyw(1, 5, 2));
                    n = 7;
                }
                panelBuilder.add((Component)BuildResultsSection.this.fButtonPanel, cellConstraints2.xy(1, n));
                panelBuilder.add((Component)BuildResultsSection.this.fReportUnavailableMessage, cellConstraints2.xyw(1, n + 1, 2));
                BuildResultsSection.this.fPanel.removeAll();
                object = panelBuilder.getPanel();
                ((JComponent)object).setOpaque(false);
                BuildResultsSection.this.fPanel.add((Component)object);
                BuildResultsSection.this.fPanel.revalidate();
                BuildResultsSection.this.fPanel.repaint();
            }
        });
    }

    private void updateReportHyperLinkVisibility() {
        Icon icon;
        boolean bl = BuildResultsSection.isReportAvailable(this.getMainHtml());
        this.fButtonPanel.setVisible(bl);
        this.fReportUnavailableMessage.setVisible(!bl);
        if (bl) {
            icon = BuildResultsSection.hasErrors(this.getMainHtml()) ? CoderResources.getIcon("table2_error.png") : CoderResources.getIcon("table2_check.png");
            this.fCodeGenReportSimpleButton.setIcon(icon);
        }
        this.fButtonPanel.removeAll();
        icon = new CellConstraints();
        this.fButtonPanel.add((Component)this.fCodeGenReportSimpleButton, icon.xy(1, 2));
        this.fButtonPanel.add((Component)this.fBusyAffordance.getComponent(), icon.xy(3, 2));
        this.fButtonPanel.revalidate();
        this.fButtonPanel.repaint();
    }

    private static boolean isReportAvailable(String string) {
        return string != null && !string.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasErrors(String string) {
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.indexOf("Number of errors:");
                if (n < 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "<>");
                while (stringTokenizer.hasMoreTokens()) {
                    try {
                        int n2 = Integer.parseInt(stringTokenizer.nextToken());
                        if (n2 <= 0) continue;
                        boolean bl = true;
                        return bl;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    private void showRegularReport() {
        this.fBusyAffordance.start();
        this.fBusyAffordance.getComponent().setVisible(true);
        final String string = this.getMainHtml();
        if (!BuildResultsSection.isReportAvailable(string)) {
            this.alertUser(CoderResources.getString("msg.noBuildResults"));
            return;
        }
        MatlabWorker<MatlabResult> matlabWorker = new MatlabWorker<MatlabResult>(){

            public MatlabResult runOnMatlabThread() throws Exception {
                Object[] objectArray = new Object[]{"emcOpenReport", string, "", BuildResultsSection.this.fConfig.getName()};
                return (MatlabResult)3.feval((String)"emlcprivate", (Object[])objectArray, (int)0);
            }

            public void runOnAWTEventDispatchThread(MatlabResult matlabResult) {
                BuildResultsSection.this.fBusyAffordance.stop();
                BuildResultsSection.this.fBusyAffordance.getComponent().setVisible(false);
            }
        };
        matlabWorker.start();
    }

    private void showInstrumentationReportSettings() {
        if (this.fInstrumentationSettingsDialog == null) {
            Object object;
            this.fInstrumentationSettingsPanel = new ParamSetPanel(this.fConfig.getProject(), this.fConfig.getTarget().getParamSet("paramset.instrumentation.report"), false, false);
            this.fInstrumentationSettingsDialog = new MJDialog((Frame)SwingUtilities.windowForComponent((Component)this.fPanel), CoderResources.getString("title.instrumentation.settings"), false);
            MJButton mJButton = null;
            MJHelpButton mJHelpButton = new MJHelpButton();
            mJHelpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Target target = BuildResultsSection.this.fConfig.getTarget();
                    String string = PluginManager.resolveHelpMapPath((String)target.getHelpMapPath());
                    MLHelpServices.cshDisplayTopic((Object)BuildResultsSection.this.fInstrumentationSettingsDialog, (String)string, (String)"help_button_instrumentation_report_settings");
                }
            });
            if (PlatformInfo.isMacintosh()) {
                object = new MJPanel();
                ((JComponent)object).setOpaque(false);
                ((Container)object).setLayout(new FlowLayout(2));
                ((Container)object).add((Component)mJHelpButton);
            } else {
                mJButton = new MJButton(BuiltInResources.getString((String)"button.close"));
                mJButton.setName("button.close");
                mJButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        BuildResultsSection.this.fInstrumentationSettingsDialog.setVisible(false);
                    }
                });
                object = ButtonBarFactory.buildCloseHelpBar((JButton)mJButton, (JButton)mJHelpButton);
                ((JComponent)object).setBorder(new EmptyBorder(6, 0, 6, 6));
            }
            this.fInstrumentationSettingsDialog.setLayout((LayoutManager)new BorderLayout(0, 0));
            this.fInstrumentationSettingsDialog.add(this.fInstrumentationSettingsPanel.getComponent(), (Object)"Center");
            this.fInstrumentationSettingsDialog.add((Component)object, (Object)"South");
            this.fInstrumentationSettingsDialog.setResizable(false);
            this.fInstrumentationSettingsDialog.pack();
            if (PlatformInfo.isMacintosh()) {
                this.fInstrumentationSettingsDialog.setSize(this.fInstrumentationSettingsDialog.getWidth() + 20, this.fInstrumentationSettingsDialog.getHeight());
            }
            this.fInstrumentationSettingsDialog.setLocationRelativeTo((Component)MLDesktop.getInstance().getMainFrame());
            if (!PlatformInfo.isMacintosh()) {
                this.fInstrumentationSettingsDialog.getRootPane().setDefaultButton((JButton)mJButton);
            }
        }
        this.fInstrumentationSettingsDialog.show();
    }

    private void alertUser(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MJOptionPane.showMessageDialog((Component)MJFrame.getFrame((Component)BuildResultsSection.this.fPanel), (Object)string, (String)CoderResources.getString("hdr.buildResults"), (int)1);
            }
        });
    }

    private String getMainHtml() {
        String string = this.fConfig.getParamAsString("param.artifact");
        String string2 = TargetArtifact.isMexTarget(string) ? "param.mex.mainhtml" : "param.grt.mainhtml";
        return this.fConfig.getParamAsString(string2);
    }

    public void dispose() {
        this.fConfig.removePropertyChangeListener((PropertyChangeListener)this);
        if (this.fInstrumentationSettingsPanel != null) {
            this.fInstrumentationSettingsPanel.dispose();
            this.fInstrumentationSettingsDialog.dispose();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("param.artifact".equals(string) || "param.mex.mainhtml".equals(string) || "param.grt.mainhtml".equals(string) || "param.BuiltInstrumentedMex".equals(string) || "param.RanInstrumentedMex".equals(string) || "build-time".equals(string)) {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    BuildResultsSection.this.updateReportHyperLinkVisibility();
                    BuildResultsSection.this.updateHeaderText();
                    BuildResultsSection.this.updateResultsDescription();
                    BuildResultsSection.this.rebuildPanel();
                }
            });
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public String getHeaderToolTipText() {
        return null;
    }
}

