/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.Profile;
import com.mathworks.util.Converter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class CoderSettingsHelp
implements Converter<ParamSet, String> {
    private final Configuration fConfiguration;
    private static final Set<String> sParamSetsAffectedByECoder = new HashSet<String>();

    public CoderSettingsHelp(Configuration configuration) {
        this.fConfiguration = configuration;
    }

    public String convert(ParamSet paramSet) {
        Profile profile = this.fConfiguration.getActiveProfile();
        String string = "help_button_" + (paramSet == null ? "all_settings" : paramSet.getKey().substring("paramset.".length()).replace(".", "_"));
        if (profile != null && profile.getKey().equals("profile.c")) {
            if ((paramSet == null || sParamSetsAffectedByECoder.contains(paramSet.getKey())) && this.fConfiguration.getParamAsBoolean("param.UseECoderFeatures")) {
                return string + "_ecoder";
            }
            return string + "_c";
        }
        return string + "_mex";
    }

    static {
        sParamSetsAffectedByECoder.addAll(Arrays.asList("paramset.code.appearance", "paramset.memory", "paramset.hardware"));
    }
}

