/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.DialogIcon;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ProjectComponent;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.api.XmlWriter;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.settingsui.ParamWidgetBinder;
import com.mathworks.project.impl.table.AbstractPropertyTableColumn;
import com.mathworks.project.impl.table.AbstractSimpleCellEditor;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableCellEditor;
import com.mathworks.project.impl.table.PropertyTableCellEditorFactory;
import com.mathworks.project.impl.table.PropertyTableContextMenuCustomizer;
import com.mathworks.project.impl.table.PropertyTableModel;
import com.mathworks.project.impl.table.PropertyTableNode;
import com.mathworks.project.impl.table.PropertyTableSearchPredicate;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import com.mathworks.util.RequestFilter;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class ToolchainSettingsPanel
implements ProjectComponent {
    private static final int MAX_TABLE_PREF_WIDTH = 500;
    private MJPanel fComponent;
    private final MJPanel fContent;
    private final Configuration fConfiguration;
    private final ParamWidgetBinder fBinder;
    private final Param fToolchainParam;
    private final Param fBuildConfigurationParam;
    private final PropertyChangeListener fConfigurationListener;
    private final RequestFilter fUpdateWarningLabels;
    private final MJLabel fToolchainDescriptionLabel;
    private final MJLabel fBuildConfigurationDescriptionLabel;
    private final MJLabel fToolchainWarningLabel;
    private final MJLabel fBuildConfigurationWarningLabel;
    private final MJButton fValidateButton;
    private final HyperlinkTextLabel fShowSettingsLink;
    private final HyperlinkTextLabel fHideSettingsLink;
    private final MJLabel fTableLabel;
    private final MJPanel fTableWrapper;
    private final MJPanel fPadding;
    private final MJPanel fLinkContainer;
    private final RequestFilter fUpdateBuildConfigurationInput;
    private final GridBagConstraints fConstraints;
    private final Map<String, String> fUserOptions;
    private Map<String, String> fDefaultOptions;
    private PropertyTable<String> fTable;
    private boolean fShowingReadOnlyTable;
    private static final String OPTIONS_PARAM_KEY = "param.CustomToolchainOptions";
    private static ToolchainSettingsPanel sInstance;

    public ToolchainSettingsPanel(WritableConfiguration writableConfiguration) {
        sInstance = this;
        this.fConfiguration = (Configuration)writableConfiguration;
        this.fContent = this.fComponent = new MJPanel();
        this.fUserOptions = new HashMap<String, String>();
        ToolchainSettingsPanel.loadOptions(this.fConfiguration, this.fUserOptions, true);
        this.fBinder = new ParamWidgetBinder(this.fConfiguration.getProject(), false);
        this.fToolchainParam = this.fConfiguration.getTarget().getParam("param.Toolchain");
        this.fBuildConfigurationParam = this.fConfiguration.getTarget().getParam("param.BuildConfiguration");
        this.fTableLabel = new MJLabel();
        this.fTableWrapper = PlatformInfo.isMacintosh() ? this.createConstrainingWrapper() : new MJPanel();
        this.fTableWrapper.setOpaque(false);
        Component component = this.fBinder.createAndRegister(this.fToolchainParam);
        Component component2 = this.fBinder.createAndRegister(this.fBuildConfigurationParam.stripMoreInfoCallback());
        this.fComponent.setLayout((LayoutManager)new GridBagLayout());
        this.fConstraints = new GridBagConstraints();
        this.fConstraints.gridx = 0;
        this.fConstraints.gridy = 0;
        this.fConstraints.fill = 0;
        this.fToolchainDescriptionLabel = new MJLabel();
        this.fUpdateBuildConfigurationInput = new RequestFilter(new Runnable(){

            @Override
            public void run() {
                Object[] objectArray = new String[]{"coder.make.internal.guicallback.buildConfigPulldown", ToolchainSettingsPanel.this.fConfiguration.getParamAsString(ToolchainSettingsPanel.this.fToolchainParam.getKey()), ToolchainSettingsPanel.this.fConfiguration.getParamAsString(ToolchainSettingsPanel.this.fBuildConfigurationParam.getKey())};
                new Matlab().fevalConsoleOutput("emlcprivate", objectArray, 3, new CompletionObserver(){

                    public void completed(int n, Object object) {
                        if (Matlab.getExecutionStatus((int)n) == 0) {
                            Object[] objectArray = (Object[])object;
                            ToolchainSettingsPanel.updateDropdownDecorations(objectArray, ToolchainSettingsPanel.this.fBuildConfigurationWarningLabel, ToolchainSettingsPanel.this.fBuildConfigurationDescriptionLabel);
                            boolean bl = ((boolean[])objectArray[2])[0];
                            ToolchainSettingsPanel.this.updateBuildConfigurationInput(bl);
                        }
                    }
                });
            }
        }, 100);
        this.fBuildConfigurationDescriptionLabel = new MJLabel();
        this.fToolchainWarningLabel = new MJLabel();
        this.fBuildConfigurationWarningLabel = new MJLabel();
        this.fValidateButton = new MJButton(CoderResources.getString("toolchain.validate"));
        this.fShowSettingsLink = new HyperlinkTextLabel("<a href=\"\">" + CoderResources.getString("toolchain.showSettings") + "</a>", new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                ToolchainSettingsPanel.this.prepareAndShowReadOnlyTable();
            }
        });
        this.fHideSettingsLink = new HyperlinkTextLabel("<a href=\"\">" + CoderResources.getString("toolchain.hideSettings") + "</a>", new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                ToolchainSettingsPanel.this.fShowingReadOnlyTable = false;
                ToolchainSettingsPanel.this.fLinkContainer.removeAll();
                ToolchainSettingsPanel.this.fLinkContainer.add((Component)ToolchainSettingsPanel.this.fShowSettingsLink.getComponent());
                ToolchainSettingsPanel.this.fLinkContainer.revalidate();
                ToolchainSettingsPanel.this.fLinkContainer.repaint();
                ToolchainSettingsPanel.this.removeTable();
            }
        });
        if (PlatformInfo.isMacintosh()) {
            this.fConstraints.anchor = 13;
            this.fConstraints.insets = new Insets(16, 3, 3, 3);
        } else {
            this.fConstraints.anchor = 17;
            this.fConstraints.insets = new Insets(3, 3, 3, 3);
        }
        this.fComponent.add((Component)new MJLabel(this.fToolchainParam.getName() + (PlatformInfo.isMacintosh() ? "" : ":")), (Object)this.fConstraints);
        this.fConstraints.anchor = 17;
        ++this.fConstraints.gridx;
        this.fConstraints.fill = 2;
        this.fConstraints.insets.bottom = 2;
        this.fComponent.add(component, (Object)this.fConstraints);
        this.fConstraints.insets.bottom = 3;
        this.fConstraints.fill = 0;
        ++this.fConstraints.gridx;
        this.fComponent.add((Component)this.fToolchainWarningLabel, (Object)this.fConstraints);
        ++this.fConstraints.gridx;
        if (PlatformInfo.isMacintosh()) {
            this.fConstraints.insets.left -= 3;
        }
        this.fConstraints.fill = 2;
        this.fComponent.add((Component)this.fValidateButton, (Object)this.fConstraints);
        this.fConstraints.fill = 0;
        if (PlatformInfo.isMacintosh()) {
            this.fConstraints.insets.left += 3;
        }
        ++this.fConstraints.gridy;
        this.fConstraints.gridx -= 2;
        this.fConstraints.insets.top = 0;
        if (PlatformInfo.isMacintosh()) {
            this.fConstraints.insets.left += 4;
        }
        this.fComponent.add((Component)this.fToolchainDescriptionLabel, (Object)this.fConstraints);
        if (PlatformInfo.isMacintosh()) {
            this.fConstraints.insets.left -= 4;
        }
        this.fConstraints.insets.top = 3;
        ++this.fConstraints.gridy;
        --this.fConstraints.gridx;
        if (PlatformInfo.isMacintosh()) {
            this.fConstraints.anchor = 13;
            this.fConstraints.insets.top = 3;
        }
        this.fLinkContainer = new MJPanel((LayoutManager)new FlowLayout(0, 0, 0));
        this.fLinkContainer.setOpaque(false);
        this.fComponent.add((Component)new MJLabel(this.fBuildConfigurationParam.getName() + (PlatformInfo.isMacintosh() ? "" : ":")), (Object)this.fConstraints);
        this.fConstraints.anchor = 17;
        ++this.fConstraints.gridx;
        this.fConstraints.fill = 2;
        this.fConstraints.insets.bottom = 2;
        this.fComponent.add(component2, (Object)this.fConstraints);
        this.fConstraints.insets.bottom = 3;
        this.fConstraints.fill = 0;
        ++this.fConstraints.gridx;
        this.fComponent.add((Component)this.fBuildConfigurationWarningLabel, (Object)this.fConstraints);
        ++this.fConstraints.gridx;
        this.fConstraints.fill = 2;
        this.fComponent.add((Component)this.fLinkContainer, (Object)this.fConstraints);
        this.fConstraints.fill = 0;
        ++this.fConstraints.gridy;
        this.fConstraints.gridx -= 2;
        this.fConstraints.insets.top = 0;
        if (PlatformInfo.isMacintosh()) {
            this.fConstraints.insets.left += 4;
        }
        this.fComponent.add((Component)this.fBuildConfigurationDescriptionLabel, (Object)this.fConstraints);
        if (PlatformInfo.isMacintosh()) {
            this.fConstraints.insets.left -= 4;
        }
        this.fConstraints.insets.top = 3;
        this.fPadding = new MJPanel();
        this.fPadding.setOpaque(false);
        this.addPadding();
        ++this.fConstraints.gridy;
        if (PlatformInfo.isMacintosh()) {
            this.fComponent = new MJPanel((LayoutManager)new FormLayout("0dlu:grow, fill:d, 0dlu:grow", "fill:d:grow"));
            this.fComponent.setOpaque(false);
            CellConstraints cellConstraints = new CellConstraints();
            this.fComponent.add((Component)this.fContent, (Object)cellConstraints.xy(2, 1));
        } else {
            this.fComponent.setBorder((Border)new EmptyBorder(9, 12, 9, 12));
        }
        this.fUpdateWarningLabels = new RequestFilter(new Runnable(){

            @Override
            public void run() {
                ToolchainSettingsPanel.this.doWarningLabelUpdate();
            }
        });
        this.fConfigurationListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals(ToolchainSettingsPanel.this.fToolchainParam.getKey()) || propertyChangeEvent.getPropertyName().equals(ToolchainSettingsPanel.this.fBuildConfigurationParam.getKey())) {
                    ToolchainSettingsPanel.this.fUpdateWarningLabels.request();
                }
            }
        };
        this.fConfiguration.addPropertyChangeListener(this.fConfigurationListener);
        this.fUpdateWarningLabels.request();
        this.fValidateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = new Object[]{"coder.make.internal.guicallback.validateToolchain", ToolchainSettingsPanel.this.fConfiguration.getParamAsString(ToolchainSettingsPanel.this.fToolchainParam.getKey()), ToolchainSettingsPanel.this.fConfiguration.getParamAsString(ToolchainSettingsPanel.this.fBuildConfigurationParam.getKey()), ToolchainSettingsPanel.convertOptionsToArray(ToolchainSettingsPanel.this.fConfiguration)};
                new Matlab().fevalConsoleOutput("emlcprivate", objectArray, 2, new CompletionObserver(){

                    public void completed(int n, Object object) {
                    }
                });
            }
        });
    }

    public static ToolchainSettingsPanel getInstance() {
        return sInstance;
    }

    public void viewSettings() {
        if (this.fTable == null && !this.fShowingReadOnlyTable) {
            this.getSettings("coder.make.internal.guicallback.viewBuildConfigSettings", new ParameterRunnable<Map<String, String>>(){

                public void run(Map<String, String> map) {
                    ToolchainSettingsPanel.this.fShowingReadOnlyTable = true;
                    ToolchainSettingsPanel.this.fLinkContainer.removeAll();
                    ToolchainSettingsPanel.this.fLinkContainer.add((Component)ToolchainSettingsPanel.this.fHideSettingsLink.getComponent());
                    ToolchainSettingsPanel.this.showTable(map, false);
                }
            });
        }
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public void dispose() {
        sInstance = null;
        this.fBinder.dispose();
        this.fConfiguration.removePropertyChangeListener(this.fConfigurationListener);
    }

    private void addPadding() {
        ++this.fConstraints.gridy;
        this.fConstraints.gridx = 0;
        this.fConstraints.gridwidth = 5;
        this.fConstraints.weightx = 1.0;
        this.fConstraints.weighty = 1.0;
        this.fConstraints.fill = 1;
        this.fContent.add((Component)this.fPadding, (Object)this.fConstraints);
        this.fConstraints.gridwidth = 1;
        this.fConstraints.gridx = 0;
        this.fConstraints.weightx = 0.0;
        this.fConstraints.weighty = 0.0;
        this.fConstraints.fill = 0;
    }

    private void doWarningLabelUpdate() {
        Object[] objectArray = new String[]{"coder.make.internal.guicallback.toolchainPulldown", this.fConfiguration.getParamAsString(this.fToolchainParam.getKey())};
        new Matlab().fevalConsoleOutput("emlcprivate", objectArray, 2, new CompletionObserver(){

            public void completed(int n, Object object) {
                if (Matlab.getExecutionStatus((int)n) == 0) {
                    Object[] objectArray = (Object[])object;
                    ToolchainSettingsPanel.updateDropdownDecorations(objectArray, ToolchainSettingsPanel.this.fToolchainWarningLabel, ToolchainSettingsPanel.this.fToolchainDescriptionLabel);
                }
            }
        });
        this.fUpdateBuildConfigurationInput.request();
    }

    private static void updateDropdownDecorations(Object[] objectArray, final MJLabel mJLabel, final MJLabel mJLabel2) {
        final boolean bl = ((boolean[])objectArray[0])[0];
        final String string = (String)objectArray[1];
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    mJLabel.setVisible(false);
                    mJLabel2.setText(string);
                } else {
                    mJLabel.setVisible(true);
                    mJLabel.setIcon((Icon)DialogIcon.ERROR_12x12.getIcon());
                    mJLabel.setToolTipText(string);
                    mJLabel2.setText("");
                }
            }
        });
    }

    private void removeTable() {
        if (this.fTable != null) {
            this.fTable.dispose();
            this.fContent.remove((Component)this.fTableWrapper);
            this.fContent.remove((Component)this.fTableLabel);
            this.fContent.remove((Component)this.fTable.getComponent());
            this.fContent.remove((Component)this.fPadding);
            this.fTable = null;
            this.addPadding();
            this.fContent.revalidate();
            this.fContent.repaint();
        }
    }

    private void updateBuildConfigurationInput(final boolean bl) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    if (ToolchainSettingsPanel.this.fShowingReadOnlyTable) {
                        ToolchainSettingsPanel.this.fLinkContainer.removeAll();
                        ToolchainSettingsPanel.this.fLinkContainer.add((Component)ToolchainSettingsPanel.this.fHideSettingsLink.getComponent());
                        ToolchainSettingsPanel.this.fLinkContainer.revalidate();
                        ToolchainSettingsPanel.this.fLinkContainer.repaint();
                        ToolchainSettingsPanel.this.prepareAndShowReadOnlyTable();
                    } else {
                        ToolchainSettingsPanel.this.removeTable();
                        ToolchainSettingsPanel.this.fLinkContainer.removeAll();
                        ToolchainSettingsPanel.this.fLinkContainer.add((Component)ToolchainSettingsPanel.this.fShowSettingsLink.getComponent());
                        ToolchainSettingsPanel.this.fLinkContainer.revalidate();
                        ToolchainSettingsPanel.this.fLinkContainer.repaint();
                    }
                } else {
                    ToolchainSettingsPanel.this.fLinkContainer.removeAll();
                    ToolchainSettingsPanel.this.fLinkContainer.revalidate();
                    ToolchainSettingsPanel.this.fLinkContainer.repaint();
                    ToolchainSettingsPanel.this.getSettings("coder.make.internal.guicallback.getBuildConfigOptionsAndValues", (ParameterRunnable<Map<String, String>>)((ParameterRunnable)new ParameterRunnable<Map<String, String>>(){

                        public void run(Map<String, String> map) {
                            ToolchainSettingsPanel.this.fDefaultOptions = map;
                            ToolchainSettingsPanel.this.saveOptions();
                            ToolchainSettingsPanel.this.showTable(map, true);
                        }
                    }));
                }
            }
        });
    }

    private void getSettings(String string, final ParameterRunnable<Map<String, String>> parameterRunnable) {
        Object[] objectArray = new String[]{string, this.fConfiguration.getParamAsString(this.fToolchainParam.getKey()), this.fConfiguration.getParamAsString(this.fBuildConfigurationParam.getKey())};
        new Matlab().fevalConsoleOutput("emlcprivate", objectArray, 1, new CompletionObserver(){

            public void completed(int n, Object object) {
                if (Matlab.getExecutionStatus((int)n) == 0) {
                    String[] stringArray = (String[])object;
                    final LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                    for (int i = 0; i < stringArray.length; i += 2) {
                        linkedHashMap.put(stringArray[i], stringArray[i + 1]);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            parameterRunnable.run((Object)linkedHashMap);
                        }
                    });
                }
            }
        });
    }

    public static void copyOptions(String[] stringArray, Configuration configuration) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        XmlWriter xmlWriter = XmlApi.getInstance().create("options");
        for (int i = 0; i < stringArray.length; i += 2) {
            XmlWriter xmlWriter2 = xmlWriter.createElement("option");
            xmlWriter2.writeAttribute("key", (Object)stringArray[i]);
            xmlWriter2.writeAttribute("value", (Object)stringArray[i + 1]);
            xmlWriter2.writeAttribute("modified", (Object)true);
        }
        try {
            configuration.setParamAsXml(OPTIONS_PARAM_KEY, XmlApi.getInstance().read(xmlWriter.getXML()));
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    private void prepareAndShowReadOnlyTable() {
        this.getSettings("coder.make.internal.guicallback.viewBuildConfigSettings", new ParameterRunnable<Map<String, String>>(){

            public void run(Map<String, String> map) {
                if (!map.isEmpty()) {
                    ToolchainSettingsPanel.this.fShowingReadOnlyTable = true;
                    ToolchainSettingsPanel.this.fLinkContainer.removeAll();
                    ToolchainSettingsPanel.this.fLinkContainer.add((Component)ToolchainSettingsPanel.this.fHideSettingsLink.getComponent());
                    ToolchainSettingsPanel.this.showTable(map, false);
                }
            }
        });
    }

    private MJPanel createConstrainingWrapper() {
        return new MJPanel(null){

            public void doLayout() {
                if (ToolchainSettingsPanel.this.fTable != null) {
                    ToolchainSettingsPanel.this.fTable.getComponent().setBounds(0, 0, this.getWidth(), this.getHeight());
                }
            }

            public Dimension getPreferredSize() {
                Dimension dimension = ToolchainSettingsPanel.this.fTable != null ? ToolchainSettingsPanel.this.fTable.getComponent().getPreferredSize() : super.getPreferredSize();
                return new Dimension(Math.min(dimension.width, 500), dimension.height);
            }

            public Dimension getMaximumSize() {
                return super.getPreferredSize();
            }

            public Dimension getMinimumSize() {
                Dimension dimension = this.getPreferredSize();
                return new Dimension(dimension.width / 2, dimension.height);
            }
        };
    }

    private void showTable(final Map<String, String> map, final boolean bl) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ToolchainSettingsPanel.this.removeTable();
                List<AbstractPropertyTableColumn> list = Arrays.asList(new AbstractPropertyTableColumn[]{new NameColumn(), bl ? new ValueColumn() : new ReadOnlyValueColumn(map)});
                ArrayList<PropertyTableNode> arrayList = new ArrayList<PropertyTableNode>();
                for (String string : map.keySet()) {
                    arrayList.add(new PropertyTableNode(null, false, Arrays.asList(string)));
                }
                final PropertyTableModel propertyTableModel = new PropertyTableModel(list, new Runnable(){

                    @Override
                    public void run() {
                    }
                }, (Predicate)new Predicate<String>(){

                    public boolean accept(String string) {
                        return bl;
                    }
                }, (PropertyTableSearchPredicate)new PropertyTableSearchPredicate<String>(){

                    public boolean accept(String string, String string2) {
                        return false;
                    }
                }, arrayList);
                ToolchainSettingsPanel.this.fTable = new PropertyTable(propertyTableModel, (PropertyTableCellEditorFactory)new PropertyTableCellEditorFactory<String>(){

                    public PropertyTableCellEditor<String> createWidget(PropertyTable<String> propertyTable, int n, int n2, final String string) {
                        return new AbstractSimpleCellEditor<String>(ToolchainSettingsPanel.this.fTable){

                            public void loadData(Object object, String string2) {
                                this.setData(object, string2);
                            }

                            public void commitData() {
                                ToolchainSettingsPanel.this.fUserOptions.put(string, (String)this.getData());
                                ToolchainSettingsPanel.this.saveOptions();
                            }
                        };
                    }
                });
                ToolchainSettingsPanel.this.fContent.remove((Component)ToolchainSettingsPanel.this.fPadding);
                ToolchainSettingsPanel.this.fTable.setContextMenuCustomizer(new PropertyTableContextMenuCustomizer(){

                    public void customize(MJPopupMenu mJPopupMenu, final int n, final int n2) {
                        if (n2 == 0) {
                            return;
                        }
                        if (!bl) {
                            mJPopupMenu.add((Action)new MJAbstractAction(BuiltInResources.getString((String)"action.copy")){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(propertyTableModel.getColumnText(n, n2)), null);
                                }
                            });
                        } else {
                            MJAbstractAction mJAbstractAction = new MJAbstractAction(CoderResources.getString("toolchain.restoreDefault")){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    ToolchainSettingsPanel.this.fUserOptions.remove(propertyTableModel.getColumnText(n, 0));
                                    propertyTableModel.fireChange();
                                    ToolchainSettingsPanel.this.saveOptions();
                                }
                            };
                            MJAbstractAction mJAbstractAction2 = new MJAbstractAction(CoderResources.getString("toolchain.restoreAllDefaults")){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    ToolchainSettingsPanel.this.fUserOptions.clear();
                                    propertyTableModel.fireChange();
                                    ToolchainSettingsPanel.this.saveOptions();
                                }
                            };
                            mJAbstractAction.setEnabled(!propertyTableModel.getColumnText(n, n2).equals(ToolchainSettingsPanel.this.fDefaultOptions.get(propertyTableModel.getColumnText(n, 0))));
                            mJAbstractAction2.setEnabled(!ToolchainSettingsPanel.this.fUserOptions.isEmpty());
                            mJPopupMenu.add((Action)mJAbstractAction);
                            mJPopupMenu.add((Action)mJAbstractAction2);
                        }
                    }
                });
                ToolchainSettingsPanel.this.fTableLabel.setText(bl ? CoderResources.getString("toolchain.projectSpecific") : CoderResources.getString("toolchain.readOnlyOptions"));
                if (PlatformInfo.isMacintosh()) {
                    ToolchainSettingsPanel.this.fTable.setPreferToShowAllRows(true);
                    ToolchainSettingsPanel.this.fComponent.remove((Component)ToolchainSettingsPanel.this.fPadding);
                    ((ToolchainSettingsPanel)ToolchainSettingsPanel.this).fConstraints.anchor = 18;
                    ((ToolchainSettingsPanel)ToolchainSettingsPanel.this).fConstraints.insets.top += 20;
                    ToolchainSettingsPanel.this.fContent.add((Component)ToolchainSettingsPanel.this.fTableLabel, (Object)ToolchainSettingsPanel.this.fConstraints);
                    ++((ToolchainSettingsPanel)ToolchainSettingsPanel.this).fConstraints.gridx;
                    ToolchainSettingsPanel.this.fTableWrapper.add((Component)ToolchainSettingsPanel.this.fTable.getComponent());
                    ((ToolchainSettingsPanel)ToolchainSettingsPanel.this).fConstraints.fill = 2;
                    ToolchainSettingsPanel.this.fContent.add((Component)ToolchainSettingsPanel.this.fTableWrapper, (Object)ToolchainSettingsPanel.this.fConstraints);
                    ((ToolchainSettingsPanel)ToolchainSettingsPanel.this).fConstraints.fill = 0;
                    --((ToolchainSettingsPanel)ToolchainSettingsPanel.this).fConstraints.gridx;
                    ((ToolchainSettingsPanel)ToolchainSettingsPanel.this).fConstraints.insets.top -= 20;
                    ToolchainSettingsPanel.this.addPadding();
                } else {
                    String string;
                    string = new CellConstraints();
                    ToolchainSettingsPanel.this.fTable.setColumnWeights(new double[]{0.25, 0.75});
                    ToolchainSettingsPanel.this.fTableWrapper.removeAll();
                    ToolchainSettingsPanel.this.fTableWrapper.setLayout((LayoutManager)new FormLayout("fill:d:grow", "3dlu, fill:d, 2dlu, fill:d:grow"));
                    ToolchainSettingsPanel.this.fTableWrapper.add((Component)ToolchainSettingsPanel.this.fTableLabel, (Object)string.xy(1, 2));
                    ToolchainSettingsPanel.this.fTableWrapper.add((Component)ToolchainSettingsPanel.this.fTable.getComponent(), (Object)string.xy(1, 4));
                    ((ToolchainSettingsPanel)ToolchainSettingsPanel.this).fConstraints.gridx = 0;
                    ((ToolchainSettingsPanel)ToolchainSettingsPanel.this).fConstraints.gridwidth = 5;
                    ((ToolchainSettingsPanel)ToolchainSettingsPanel.this).fConstraints.weightx = 1.0;
                    ((ToolchainSettingsPanel)ToolchainSettingsPanel.this).fConstraints.weighty = 1.0;
                    ((ToolchainSettingsPanel)ToolchainSettingsPanel.this).fConstraints.fill = 1;
                    ToolchainSettingsPanel.this.fContent.add((Component)ToolchainSettingsPanel.this.fTableWrapper, (Object)ToolchainSettingsPanel.this.fConstraints);
                }
                ToolchainSettingsPanel.this.fContent.revalidate();
                ToolchainSettingsPanel.this.fContent.repaint();
            }
        });
    }

    private void saveOptions() {
        XmlWriter xmlWriter = XmlApi.getInstance().create("options");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.putAll(this.fDefaultOptions);
        linkedHashMap.putAll(this.fUserOptions);
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            XmlWriter xmlWriter2 = xmlWriter.createElement("option");
            xmlWriter2.writeAttribute("key", entry.getKey());
            xmlWriter2.writeAttribute("value", entry.getValue());
            xmlWriter2.writeAttribute("modified", (Object)this.fUserOptions.containsKey(entry.getKey()));
        }
        try {
            this.fConfiguration.setParamAsXml(OPTIONS_PARAM_KEY, XmlApi.getInstance().read(xmlWriter.getXML()));
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    private static void loadOptions(Configuration configuration, Map<String, String> map, boolean bl) {
        XmlReader xmlReader = (XmlReader)configuration.getParamAsObject(OPTIONS_PARAM_KEY);
        if (xmlReader != null) {
            XmlReader xmlReader2 = xmlReader.getChild(new String[]{"option"});
            while (xmlReader2.isPresent()) {
                String string = xmlReader2.readAttribute("key");
                String string2 = xmlReader2.readAttribute("value");
                String string3 = xmlReader2.readAttribute("modified");
                if (string != null && string2 != null && (!bl || string3 != null && string3.equals("true"))) {
                    map.put(string, string2);
                }
                xmlReader2 = xmlReader2.next();
            }
        }
    }

    public static String[] convertOptionsToArray(Configuration configuration) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        ToolchainSettingsPanel.loadOptions(configuration, treeMap, false);
        for (Map.Entry entry : treeMap.entrySet()) {
            arrayList.add(entry.getKey());
            arrayList.add(entry.getValue());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private class ReadOnlyValueColumn
    extends AbstractPropertyTableColumn<String> {
        private final Map<String, String> fData;

        ReadOnlyValueColumn(Map<String, String> map) {
            super(CoderResources.getString("toolchain.options"));
            this.fData = map;
        }

        public String getText(String string) {
            return this.fData.get(string);
        }

        public boolean isEditable() {
            return true;
        }
    }

    private class ValueColumn
    extends AbstractPropertyTableColumn<String> {
        ValueColumn() {
            super(CoderResources.getString("toolchain.options"));
        }

        public String getText(String string) {
            if (ToolchainSettingsPanel.this.fUserOptions.containsKey(string)) {
                return (String)ToolchainSettingsPanel.this.fUserOptions.get(string);
            }
            return (String)ToolchainSettingsPanel.this.fDefaultOptions.get(string);
        }

        public boolean isEditable() {
            return true;
        }
    }

    private static class NameColumn
    extends AbstractPropertyTableColumn<String> {
        NameColumn() {
            super(CoderResources.getString("toolchain.toolName"));
        }

        public String getText(String string) {
            return string;
        }
    }
}

