/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.mathworks.common.icons.DocumentIcon;
import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.extensions.matlab.MFileType;
import com.mathworks.mlwidgets.explorer.extensions.matlab.MFileTypeFinder;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.project.api.ConfigurationValidator;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.ReadableFileSet;
import com.mathworks.project.api.Severity;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.api.XmlLooper;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.settingsui.ParamUtils;
import com.mathworks.toolbox.coder.fixedpoint.ConversionModel;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapterFactory;
import com.mathworks.toolbox.coder.model.CoderFileSupport;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.ParsedFunctionParameterNames;
import com.mathworks.toolbox.coder.plugin.TargetArtifact;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPAttributes;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputDataProperty;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.text.matlab.MatlabTokenInfo;
import com.mathworks.widgets.text.mcode.MLexer;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Validator
implements ConfigurationValidator {
    private static final String[] DATA_TYPES = new String[]{"Char", "Short", "Int", "Long", "LongLong", "Float", "Double", "Word", "Pointer"};
    private static final String[] DATA_TYPE_NAMES = new String[]{"char", "short", "int", "long", "long long", "float", "double", "word", "pointer"};
    private static final String[] HARDWARE_INSTANCES = new String[]{"Target", "Production"};

    public List<ValidationMessage> validate(ReadableConfiguration readableConfiguration) {
        String string;
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        Validator.validateEntryPoints(readableConfiguration, arrayList);
        Validator.validateGlobals(readableConfiguration, arrayList);
        Validator.validateTarget(readableConfiguration, arrayList);
        Validator.validateIdentifierFormats(readableConfiguration, arrayList);
        Validator.validateFixedPointState(readableConfiguration, arrayList);
        if (readableConfiguration.getParamAsBoolean("var.mex") && (string = readableConfiguration.getParamAsString("param.mex.outputfile")).length() > 63) {
            arrayList.add(new ValidationMessage(Severity.ERROR, CoderResources.getString("msg.tooLongOutputName")));
        }
        if (!readableConfiguration.getParamAsString("param.artifact").equals("option.target.artifact.mex")) {
            Validator.validateHardwareSettings(readableConfiguration, arrayList);
        }
        return arrayList;
    }

    private static void validateTarget(ReadableConfiguration readableConfiguration, List<ValidationMessage> list) {
        String string = readableConfiguration.getParamAsString("param.artifact");
        String string2 = TargetArtifact.isMexTarget(string) ? "param.mex.outputfile" : "param.grt.outputfile";
        String string3 = readableConfiguration.getParamAsString(string2);
        if (string3 == null || string3.isEmpty()) {
            String string4 = CoderResources.getString("msg.outputFilenameEmpty");
            list.add(new ValidationMessage(Severity.ERROR, string4));
        }
    }

    private static void validateFixedPointState(ReadableConfiguration readableConfiguration, List<ValidationMessage> list) {
        FixedPointDataAdapter fixedPointDataAdapter = FixedPointDataAdapterFactory.create((Configuration)readableConfiguration);
        if (fixedPointDataAdapter.isModeAutomatic()) {
            String string = readableConfiguration.getParamAsString("param.artifact");
            if (string != null && string.equals("option.target.artifact.mex.instrumented")) {
                list.add(new ValidationMessage(Severity.ERROR, CoderResources.getString("f2f.error.instrumentedMex")));
            }
            if (readableConfiguration.getFileSet("fileset.entrypoints").getFiles().size() > 1) {
                list.add(new ValidationMessage(Severity.ERROR, CoderResources.getString("f2f.error.multipleEntryPoints")));
            }
            ConversionModel conversionModel = new ConversionModel();
            conversionModel.deserialize(fixedPointDataAdapter, true);
            if (!conversionModel.hasAllProposedTypes()) {
                list.add(new ValidationMessage(Severity.ERROR, CoderResources.getString("msg.noFixedPointTypes")));
            }
            try {
                ConversionModel.convertTypesToArray((Configuration)readableConfiguration, false);
            }
            catch (Exception exception) {
                list.add(new ValidationMessage(Severity.ERROR, CoderResources.getString("msg.noFixedPointTypes")));
            }
        }
        fixedPointDataAdapter.dispose();
    }

    public static void validateGlobals(ReadableConfiguration readableConfiguration, List<ValidationMessage> list) {
        if (!readableConfiguration.isParamExplicitlySet("param.globals")) {
            return;
        }
        try {
            XmlReader xmlReader = readableConfiguration.getParamReader("param.globals");
            List<InputDataProperty> list2 = InputDataProperty.parse(xmlReader);
            HashSet<String> hashSet = new HashSet<String>(list2.size());
            for (InputDataProperty inputDataProperty : list2) {
                Validator.verifyDefined(inputDataProperty, list);
                String string = inputDataProperty.getName();
                if (hashSet.contains(string)) {
                    String string2 = MessageFormat.format(CoderResources.getString("msg.globalMultiplyUndefined"), inputDataProperty.getPath());
                    list.add(new ValidationMessage(Severity.ERROR, string2));
                    continue;
                }
                hashSet.add(string);
            }
        }
        catch (IOException iOException) {
            String string = CoderResources.getString("msg.errorReadingGlobalParams");
            list.add(new ValidationMessage(Severity.ERROR, string));
        }
    }

    private static void verifyDefined(InputDataProperty inputDataProperty, List<ValidationMessage> list) {
        Object object;
        if (inputDataProperty.isUndefined()) {
            object = MessageFormat.format(CoderResources.getString("msg.globalUndefined"), inputDataProperty.getPath());
            list.add(new ValidationMessage(Severity.ERROR, (String)object));
        } else if (inputDataProperty.isStruct() && inputDataProperty.isEmpty()) {
            object = MessageFormat.format(CoderResources.getString("msg.globalEmptyStruct"), inputDataProperty.getPath());
            list.add(new ValidationMessage(Severity.ERROR, (String)object));
        } else if (inputDataProperty.isFixedPoint() && !IDPAttributes.supportsFixedPoint()) {
            object = MessageFormat.format(CoderResources.getString("msg.globalFixedPointUnsupported"), inputDataProperty.getPath());
            list.add(new ValidationMessage(Severity.ERROR, (String)object));
        }
        for (InputDataProperty inputDataProperty2 : inputDataProperty.getChildren()) {
            Validator.verifyDefined(inputDataProperty2, list);
        }
    }

    private static void verifyDefined(File file, InputDataProperty inputDataProperty, List<ValidationMessage> list) {
        Object object;
        if (inputDataProperty.isUndefined()) {
            object = MessageFormat.format(CoderResources.getString("msg.inputUndefined"), file.getName(), inputDataProperty.getPath());
            list.add(new ValidationMessage(Severity.ERROR, (String)object, "fileset.entrypoints", file));
        } else if (inputDataProperty.isFixedPoint() && !IDPAttributes.supportsFixedPoint()) {
            object = MessageFormat.format(CoderResources.getString("msg.inputFixedPointUnsupported"), file.getName(), inputDataProperty.getPath());
            list.add(new ValidationMessage(Severity.ERROR, (String)object));
        }
        for (InputDataProperty inputDataProperty2 : inputDataProperty.getChildren()) {
            Validator.verifyDefined(file, inputDataProperty2, list);
        }
    }

    public static void validateEntryPoints(ReadableConfiguration readableConfiguration, List<ValidationMessage> list) {
        ReadableFileSet readableFileSet = readableConfiguration.getFileSet("fileset.entrypoints");
        Set set = readableFileSet.getFiles();
        Validator.validateEntryPointsAreFunctions(list, readableFileSet);
        Validator.validateEntryPointInputs(readableConfiguration, list, readableFileSet, set);
    }

    private static void validateEntryPointInputs(ReadableConfiguration readableConfiguration, List<ValidationMessage> list, ReadableFileSet readableFileSet, Set<File> set) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!readableConfiguration.getTargetKey().contains("hdl")) {
            String string;
            if (readableConfiguration.isParamExplicitlySet("param.BuildToolEnable")) {
                string = readableConfiguration.getParamAsString("param.BuildToolEnable");
                bl = string.equals("on");
            }
            if (readableConfiguration.isParamExplicitlySet("param.buildtool.GenerateMain")) {
                bl2 = readableConfiguration.getParamAsBoolean("param.buildtool.GenerateMain");
            }
            bl3 = TargetArtifact.isExeTarget(readableConfiguration.getParamAsString("param.artifact"));
            if (bl && bl3 && bl2 && readableFileSet.getCurrentCount() > 1) {
                string = CoderResources.getString("msg.projectHasMultipleEntryPoints");
                list.add(new ValidationMessage(Severity.ERROR, string));
                return;
            }
        }
        boolean bl4 = !readableConfiguration.getTargetKey().contains("hdl") && readableConfiguration.getParamAsBoolean("param.UsePreconditions");
        for (File file : set) {
            XmlReader xmlReader = readableFileSet.getCustomData(file);
            List<InputDataProperty> list2 = Validator.getProjectInputs(xmlReader);
            if (bl && bl3 && bl2 && !list2.isEmpty()) {
                String string = MessageFormat.format(CoderResources.getString("msg.entryPointHasInputs"), file.getName());
                list.add(new ValidationMessage(Severity.ERROR, string, "fileset.entrypoints", file));
                return;
            }
            if (bl4) continue;
            Validator.validateFileInputs(file, xmlReader, list);
        }
    }

    private static void validateEntryPointsAreFunctions(List<ValidationMessage> list, ReadableFileSet readableFileSet) {
        for (File file : readableFileSet.getFiles()) {
            try {
                FileSystemEntry fileSystemEntry = RealFileSystem.getInstance().getEntry(new FileLocation(file));
                MFileType mFileType = MFileTypeFinder.findMFileType((FileSystemEntry)fileSystemEntry);
                if (mFileType == MFileType.FUNCTION || Validator.hasFunction(fileSystemEntry)) continue;
                String string = mFileType == MFileType.SCRIPT ? CoderResources.getString("msg.projectHasNonFunctionEntryPoint.script") : CoderResources.getString("msg.projectHasNonFunctionEntryPoint.class");
                String string2 = MessageFormat.format(CoderResources.getString("msg.projectHasNonFunctionEntryPoint"), file.getName(), string);
                list.add(new ValidationMessage(Severity.ERROR, string2));
            }
            catch (IOException iOException) {}
        }
    }

    private static boolean hasFunction(FileSystemEntry fileSystemEntry) {
        try {
            char[] cArray = CoderFileSupport.readMatlabSource(fileSystemEntry.getLocation()).toCharArray();
            MatlabTokenInfo matlabTokenInfo = MLexer.getInstance().tokenizeLines(MLexer.getInstance().getInitialTokenizerState(), cArray, 0, cArray.length);
            for (int i = 0; i < matlabTokenInfo.getNumTokens(); ++i) {
                if (matlabTokenInfo.getToken(i) != 1) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static void validateFileInputs(File file, XmlReader xmlReader, List<ValidationMessage> list) {
        ParsedFunctionParameterNames parsedFunctionParameterNames = Utilities.getEntryPointInputNames(file);
        List<InputDataProperty> list2 = Validator.getProjectInputs(xmlReader);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (InputDataProperty inputDataProperty : list2) {
            arrayList.add(inputDataProperty.getName());
        }
        if (!parsedFunctionParameterNames.isValid()) {
            return;
        }
        if (!Validator.checkInputParamCount(file, list, parsedFunctionParameterNames.getInputNames(), arrayList)) {
            return;
        }
        for (int i = 0; i < list2.size(); ++i) {
            InputDataProperty inputDataProperty;
            inputDataProperty = list2.get(i);
            Validator.verifyDefined(file, inputDataProperty, list);
            if (parsedFunctionParameterNames.getInputNames().get(i).equals(inputDataProperty.getName())) continue;
            String string = MessageFormat.format(CoderResources.getString("msg.signatureChange"), file.getName(), Validator.nameListToSignature(parsedFunctionParameterNames.getInputNames()), Validator.nameListToSignature(arrayList));
            list.add(new ValidationMessage(Severity.ERROR, string, "fileset.entrypoints", file));
            return;
        }
    }

    private static boolean checkInputParamCount(File file, List<ValidationMessage> list, List<String> list2, List<String> list3) {
        if (list2.size() == list3.size()) {
            return true;
        }
        if (list3.isEmpty()) {
            if (list2.size() == 1 && IDPAttributes.isVarargin(list2.get(0))) {
                return true;
            }
            String string = "<img src=\"jar:file:";
            String string2 = Matlab.matlabRoot();
            if (PlatformInfo.isWindows() && !string2.startsWith("\\")) {
                string = string + "/";
            }
            string = string + string2.replace(File.separatorChar, '/') + "/java/jar/";
            String string3 = string + "common.jar!/com/mathworks/common/icons/resources/";
            String string4 = DocumentIcon.ACTIONS.getFileName();
            String string5 = string3 + string4 + "\">";
            String string6 = MessageFormat.format(CoderResources.getString("msg.undefinedInputs"), file.getName(), string5);
            list.add(new ValidationMessage(Severity.ERROR, string6, "fileset.entrypoints", file));
        } else {
            String string = MessageFormat.format(CoderResources.getString("msg.signatureMismatch"), file.getName(), Validator.nameListToSignature(list2), Validator.nameListToSignature(list3));
            list.add(new ValidationMessage(Severity.ERROR, string, "fileset.entrypoints", file));
        }
        return false;
    }

    private static String nameListToSignature(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private static List<InputDataProperty> getProjectInputs(XmlReader xmlReader) {
        final ArrayList<InputDataProperty> arrayList = new ArrayList<InputDataProperty>();
        if (xmlReader == null) {
            return arrayList;
        }
        xmlReader.loop(new XmlLooper(){

            public void iterate(XmlReader xmlReader) {
                InputDataProperty inputDataProperty = InputDataProperty.createInputDataProperty(xmlReader);
                arrayList.add(inputDataProperty);
            }
        }, new String[0]);
        return arrayList;
    }

    private static void validateIdentifierFormats(ReadableConfiguration readableConfiguration, List<ValidationMessage> list) {
        List<String> list2 = Arrays.asList("param.CustomSymbolStrGlobalVar", "param.CustomSymbolStrType", "param.CustomSymbolStrField", "param.CustomSymbolStrFcn", "param.CustomSymbolStrTmpVar", "param.CustomSymbolStrMacro", "param.CustomSymbolStrEMXArray");
        for (String string : list2) {
            String string2 = readableConfiguration.getParamAsString(string);
            if (string2 == null || string2.contains("$M")) continue;
            list.add(new ValidationMessage(Severity.ERROR, CoderResources.getString("msg.identifier.mangle.missing"), string));
        }
    }

    private static void validateHardwareSettings(ReadableConfiguration readableConfiguration, List<ValidationMessage> list) {
        Validator.validateHardwareSizesAreMultiplesOf8(readableConfiguration, list);
        Validator.validateHardwareSizeMinimums(readableConfiguration, list);
        for (String string : HARDWARE_INSTANCES) {
            Validator.validateHardwareInstanceSettings(readableConfiguration, list, string);
        }
    }

    private static void validateHardwareInstanceSettings(ReadableConfiguration readableConfiguration, List<ValidationMessage> list, String string) {
        Integer n = null;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = readableConfiguration.getParamAsInt(Validator.getHardwareSizeKey(string, "Word"));
        for (int i = 0; i < 5; ++i) {
            String string2 = Validator.getHardwareSizeKey(string, DATA_TYPES[i]);
            int n3 = readableConfiguration.getParamAsInt(string2);
            if (n != null && n3 < n) {
                list.add(new ValidationMessage(Severity.ERROR, MessageFormat.format(CoderResources.getString("msg.hardware.increasingCardinalSize"), DATA_TYPE_NAMES[i - 1], DATA_TYPE_NAMES[i]), string2));
            }
            bl |= n3 == 32;
            bl2 |= n3 == n2;
            n = n3;
        }
        String string3 = Validator.getHardwareSizeKey(string, "Int");
        if (!bl) {
            list.add(new ValidationMessage(Severity.ERROR, CoderResources.getString("msg.hardware.32bitTypeRequired"), string3));
        }
        if (!bl2) {
            list.add(new ValidationMessage(Severity.ERROR, CoderResources.getString("msg.hardware.wordSizedCardinalTypeRequired"), string3));
        }
    }

    private static void validateHardwareSizesAreMultiplesOf8(ReadableConfiguration readableConfiguration, List<ValidationMessage> list) {
        for (String string : HARDWARE_INSTANCES) {
            for (String string2 : DATA_TYPES) {
                String string3 = Validator.getHardwareSizeKey(string, string2);
                int n = readableConfiguration.getParamAsInt(string3);
                if (n % 8 == 0) continue;
                list.add(new ValidationMessage(Severity.ERROR, CoderResources.getString("msg.hardware.multiple"), string3));
                return;
            }
        }
    }

    private static void validateHardwareSizeMinimums(ReadableConfiguration readableConfiguration, List<ValidationMessage> list) {
        for (String string : HARDWARE_INSTANCES) {
            for (int i = 0; i < DATA_TYPES.length; ++i) {
                String string2 = DATA_TYPES[i];
                String string3 = Validator.getHardwareSizeKey(string, string2);
                Param param = ((Configuration)readableConfiguration).getTarget().getParam(string3);
                int n = ParamUtils.getIntParamMin((Param)param);
                int n2 = readableConfiguration.getParamAsInt(string3);
                if (n2 >= n) continue;
                list.add(new ValidationMessage(Severity.ERROR, MessageFormat.format(CoderResources.getString("msg.hardware.minimum"), DATA_TYPE_NAMES[i], n), string3));
            }
        }
    }

    private static String getHardwareSizeKey(String string, String string2) {
        return "param.HardwareSize" + string2 + "." + string;
    }
}

