/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.inputtypes;

import com.mathworks.toolbox.coder.plugin.inputtypes.DimensionSizeCategory;
import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;
import java.util.regex.Pattern;

public class InputDataPropertyDimSize
implements Serializable {
    private long fDim = 1L;
    private DimensionSizeCategory fSizeCategory = DimensionSizeCategory.FIXED;

    public InputDataPropertyDimSize() {
    }

    public InputDataPropertyDimSize(long l) {
        this.fDim = l;
    }

    public InputDataPropertyDimSize(long l, DimensionSizeCategory dimensionSizeCategory) {
        this.fDim = l;
        this.fSizeCategory = dimensionSizeCategory;
    }

    public long getDim() {
        return this.fDim;
    }

    public void setDim(long l) {
        this.fDim = l;
    }

    public boolean isDimDynamic() {
        return this.fSizeCategory != DimensionSizeCategory.FIXED;
    }

    public boolean isDimUnbounded() {
        return this.fSizeCategory == DimensionSizeCategory.UNBOUNDED;
    }

    public boolean isZero() {
        return !this.isDimUnbounded() && this.fDim == 0L;
    }

    public DimensionSizeCategory getSizeCategory() {
        return this.fSizeCategory;
    }

    public void setSizeCategory(DimensionSizeCategory dimensionSizeCategory) {
        this.fSizeCategory = dimensionSizeCategory;
    }

    public static Collection<InputDataPropertyDimSize> stringToDimensions(String string) {
        Vector<InputDataPropertyDimSize> vector = new Vector<InputDataPropertyDimSize>(1);
        InputDataPropertyDimSize.stringToDimensions(string, vector);
        return vector;
    }

    public static boolean stringToDimensions(String string, Vector<InputDataPropertyDimSize> vector) {
        Pattern pattern = Pattern.compile("[\\[\\]xX,\\s]+");
        String[] stringArray = pattern.split(string);
        boolean bl = true;
        for (String string2 : stringArray) {
            long l;
            String string3;
            if (string2.length() == 0) continue;
            boolean bl2 = false;
            if (string2.charAt(0) == ':') {
                bl2 = true;
                string3 = string2.substring(1);
            } else {
                string3 = string2;
            }
            boolean bl3 = false;
            if (string3.compareToIgnoreCase("inf") == 0) {
                bl2 = true;
                bl3 = true;
                l = 0L;
            } else {
                try {
                    l = Long.parseLong(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                    l = 0L;
                }
            }
            if (l < 0L) {
                bl = false;
                l = 0L;
            }
            if (l == 0L && bl2 && !bl3) {
                bl = false;
            }
            if (vector == null) continue;
            DimensionSizeCategory dimensionSizeCategory = bl2 ? (bl3 ? DimensionSizeCategory.UNBOUNDED : DimensionSizeCategory.BOUNDED) : DimensionSizeCategory.FIXED;
            vector.addElement(new InputDataPropertyDimSize(l, dimensionSizeCategory));
        }
        if (vector != null) {
            while (vector.size() < 2) {
                vector.addElement(new InputDataPropertyDimSize());
            }
        }
        return bl;
    }
}

