/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.inputtypes;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJHelpButton;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.ProjectKeyBindings;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.inputtypes.FormattedTypeField;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPAttributes;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPClassEnum;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputAttributesTable;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputDataProperty;
import com.mathworks.util.Converter;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.ReturnRunnable;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

final class InputTableActionMenu {
    private static MJDialog sPropertiesDialog;

    private InputTableActionMenu() {
    }

    static void bindKeyStrokes(final PropertyTable<InputDataProperty> propertyTable, final Runnable runnable, final ParameterRunnable<Integer> parameterRunnable) {
        ProjectKeyBindings.bind((String)"delete-next", (Runnable)new Runnable(){

            @Override
            public void run() {
                InputDataProperty inputDataProperty;
                int n;
                if (!propertyTable.isEditing() && (n = propertyTable.getSelectionModel().getSelectedRow()) > -1 && (inputDataProperty = (InputDataProperty)propertyTable.getModel().getValue(n, 0)) != null) {
                    if (inputDataProperty.getParent() != null) {
                        InputTableActionMenu.removeStructField((PropertyTable<InputDataProperty>)propertyTable, inputDataProperty, n, runnable);
                    } else if (parameterRunnable != null) {
                        parameterRunnable.run((Object)n);
                    }
                    propertyTable.requestFocus();
                }
            }
        }, (JComponent[])new JComponent[]{propertyTable.getComponent()});
    }

    static MJPopupMenu createAndShow(Component component, final Configuration configuration, final PropertyTable<InputDataProperty> propertyTable, final int n, final InputDataProperty inputDataProperty, final FormattedTypeField formattedTypeField, final JToggleButton jToggleButton, final Runnable runnable, final ParameterRunnable<Integer> parameterRunnable, final Converter<String, InputDataProperty> converter, final ReturnRunnable<String> returnRunnable) {
        boolean bl;
        MJPopupMenu mJPopupMenu = new MJPopupMenu();
        MJMenuItem mJMenuItem = new MJMenuItem(CoderResources.getString("typedef.addField"));
        mJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InputTableActionMenu.addStructField((PropertyTable<InputDataProperty>)propertyTable, inputDataProperty, n, (Converter<String, InputDataProperty>)converter, runnable);
            }
        });
        MJMenuItem mJMenuItem2 = new MJMenuItem(CoderResources.getString("typedef.insertField"));
        mJMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InputTableActionMenu.addStructFieldBelow((PropertyTable<InputDataProperty>)propertyTable, inputDataProperty.getParent(), n, (Converter<String, InputDataProperty>)converter, runnable);
            }
        });
        MJMenuItem mJMenuItem3 = new MJMenuItem(CoderResources.getString("typedef.removeField"));
        mJMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InputTableActionMenu.removeStructField((PropertyTable<InputDataProperty>)propertyTable, inputDataProperty, n, runnable);
            }
        });
        MJMenuItem mJMenuItem4 = new MJMenuItem(CoderResources.getString("typedef.addVarArg"));
        mJMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InputTableActionMenu.addVarArg((PropertyTable<InputDataProperty>)propertyTable, inputDataProperty, n, (Converter<String, InputDataProperty>)converter, runnable);
            }
        });
        MJMenuItem mJMenuItem5 = new MJMenuItem(CoderResources.getString("typedef.insertVarArg"));
        mJMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InputTableActionMenu.addVarArgBelow((PropertyTable<InputDataProperty>)propertyTable, inputDataProperty, n, (Converter<String, InputDataProperty>)converter, runnable);
            }
        });
        MJMenuItem mJMenuItem6 = new MJMenuItem(CoderResources.getString("typedef.removeVarArg"));
        mJMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InputTableActionMenu.removeVarArg((PropertyTable<InputDataProperty>)propertyTable, inputDataProperty, n, runnable);
            }
        });
        MJMenuItem mJMenuItem7 = new MJMenuItem(CoderResources.getString("typedef.removeVariable"));
        mJMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                parameterRunnable.run((Object)n);
            }
        });
        MJMenuItem mJMenuItem8 = new MJMenuItem(CoderResources.getString("typedef.properties"));
        mJMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (formattedTypeField.getTypeName() != null) {
                    inputDataProperty.setClass(formattedTypeField.getTypeName(), true);
                }
                InputTableActionMenu.showProperties(configuration, (PropertyTable<InputDataProperty>)propertyTable, inputDataProperty, (ReturnRunnable<String>)returnRunnable, null);
            }
        });
        mJPopupMenu.removeAll();
        boolean bl2 = inputDataProperty.getParent() != null && inputDataProperty.getParent().isStruct();
        boolean bl3 = formattedTypeField.getTypeName() == null && inputDataProperty.isStruct() || formattedTypeField.getTypeName() != null && formattedTypeField.getTypeName().equals("struct");
        boolean bl4 = bl = inputDataProperty.getParent() == null && parameterRunnable != null;
        if (bl) {
            mJPopupMenu.add((JMenuItem)mJMenuItem7);
        }
        if (bl2) {
            mJPopupMenu.add((JMenuItem)mJMenuItem2);
            mJPopupMenu.add((JMenuItem)mJMenuItem3);
        }
        if (inputDataProperty.isVarargin()) {
            mJPopupMenu.add((JMenuItem)mJMenuItem4);
        }
        if (inputDataProperty.getParent() != null && inputDataProperty.getParent().isVarargin()) {
            mJPopupMenu.add((JMenuItem)mJMenuItem5);
            mJPopupMenu.add((JMenuItem)mJMenuItem6);
        }
        if (bl3) {
            mJPopupMenu.add((JMenuItem)mJMenuItem);
            mJPopupMenu.add((JMenuItem)mJMenuItem8);
        }
        formattedTypeField.closeFormatTip();
        formattedTypeField.lockFormatTip();
        mJPopupMenu.show(component, (int)((double)component.getWidth() - mJPopupMenu.getPreferredSize().getWidth()), component.getHeight());
        mJPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                formattedTypeField.getComponent().requestFocus();
                formattedTypeField.unlockFormatTip();
                Timer timer = new Timer(20, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        propertyTable.setKeepEditorAlive(false);
                        jToggleButton.setSelected(false);
                    }
                });
                timer.setRepeats(false);
                timer.start();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        return mJPopupMenu;
    }

    private static boolean isNumeric(InputDataProperty inputDataProperty, FormattedTypeField formattedTypeField) {
        IDPClassEnum iDPClassEnum = inputDataProperty.getAttributes().getClassID();
        if (formattedTypeField.getTypeName() != null) {
            try {
                iDPClassEnum = IDPClassEnum.valueOf(formattedTypeField.getTypeName().toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                iDPClassEnum = null;
            }
        }
        if (iDPClassEnum == null) {
            return false;
        }
        switch (iDPClassEnum) {
            case DOUBLE: 
            case SINGLE: 
            case INT8: 
            case INT16: 
            case INT32: 
            case UINT8: 
            case UINT16: 
            case UINT32: {
                return true;
            }
        }
        return false;
    }

    private static void addVarArg(PropertyTable<InputDataProperty> propertyTable, InputDataProperty inputDataProperty, int n, Converter<String, InputDataProperty> converter, Runnable runnable) {
        propertyTable.stopEditing(false);
        InputDataProperty inputDataProperty2 = (InputDataProperty)converter.convert((Object)inputDataProperty.nextVararginName());
        inputDataProperty.addVararg(inputDataProperty2);
        int n2 = propertyTable.getModel().addChild(n, (Object)inputDataProperty2);
        runnable.run();
        propertyTable.getSelectionModel().select(n2);
        propertyTable.startEditing(n2, 0, false);
        propertyTable.getComponent().revalidate();
        propertyTable.getComponent().repaint();
    }

    private static void addVarArgBelow(PropertyTable<InputDataProperty> propertyTable, InputDataProperty inputDataProperty, int n, Converter<String, InputDataProperty> converter, Runnable runnable) {
        propertyTable.stopEditing(false);
        InputDataProperty inputDataProperty2 = inputDataProperty.getParent();
        InputDataProperty inputDataProperty3 = (InputDataProperty)converter.convert((Object)inputDataProperty2.nextVararginName(inputDataProperty));
        inputDataProperty2.addVararg(inputDataProperty, inputDataProperty3);
        runnable.run();
        int n2 = propertyTable.getModel().addChildBelow(n, (Object)inputDataProperty3);
        propertyTable.getSelectionModel().select(n2);
        propertyTable.startEditing(n2, 0, false);
        propertyTable.getComponent().revalidate();
        propertyTable.getComponent().repaint();
    }

    private static void removeVarArg(PropertyTable<InputDataProperty> propertyTable, InputDataProperty inputDataProperty, int n, Runnable runnable) {
        propertyTable.stopEditing(false);
        InputDataProperty inputDataProperty2 = inputDataProperty.getParent();
        inputDataProperty2.delVararg(inputDataProperty);
        runnable.run();
        propertyTable.getModel().remove(n);
        propertyTable.getSelectionModel().select(n - 1);
        propertyTable.getComponent().revalidate();
        propertyTable.getComponent().repaint();
    }

    private static void addStructField(PropertyTable<InputDataProperty> propertyTable, InputDataProperty inputDataProperty, int n, Converter<String, InputDataProperty> converter, Runnable runnable) {
        propertyTable.stopEditing(false);
        inputDataProperty = (InputDataProperty)propertyTable.getModel().getValue(n, 0);
        InputDataProperty inputDataProperty2 = (InputDataProperty)converter.convert((Object)("field" + (inputDataProperty.getChildren().size() + 1)));
        inputDataProperty.addField(inputDataProperty2);
        runnable.run();
        int n2 = propertyTable.getModel().addChild(n, (Object)inputDataProperty2);
        propertyTable.getSelectionModel().select(n2);
        propertyTable.startEditing(n2, 0, false);
        propertyTable.getComponent().revalidate();
        propertyTable.getComponent().repaint();
    }

    private static void addStructFieldBelow(PropertyTable<InputDataProperty> propertyTable, InputDataProperty inputDataProperty, int n, Converter<String, InputDataProperty> converter, Runnable runnable) {
        propertyTable.stopEditing(false);
        InputDataProperty inputDataProperty2 = (InputDataProperty)converter.convert((Object)("field" + (inputDataProperty.getChildren().size() + 1)));
        InputDataProperty inputDataProperty3 = (InputDataProperty)propertyTable.getModel().getValue(n, 0);
        inputDataProperty.insertField(inputDataProperty3, inputDataProperty2);
        runnable.run();
        int n2 = propertyTable.getModel().addChildBelow(n, (Object)inputDataProperty2);
        propertyTable.getSelectionModel().select(n2);
        propertyTable.startEditing(n2, 0, false);
        propertyTable.getComponent().revalidate();
        propertyTable.getComponent().repaint();
    }

    private static void removeStructField(PropertyTable<InputDataProperty> propertyTable, InputDataProperty inputDataProperty, int n, Runnable runnable) {
        propertyTable.stopEditing(false);
        InputDataProperty inputDataProperty2 = inputDataProperty.getParent();
        inputDataProperty2.delField(inputDataProperty);
        runnable.run();
        propertyTable.getModel().remove(n);
        propertyTable.getSelectionModel().select(n - 1);
        propertyTable.getComponent().revalidate();
        propertyTable.getComponent().repaint();
    }

    public static void showProperties(Configuration configuration, PropertyTable<InputDataProperty> propertyTable, final InputDataProperty inputDataProperty, final ReturnRunnable<String> returnRunnable, final Runnable runnable) {
        InputTableActionMenu.disposePropertiesDialog();
        final IDPAttributes iDPAttributes = inputDataProperty.getAttributes();
        final InputAttributesTable inputAttributesTable = new InputAttributesTable(inputDataProperty, iDPAttributes);
        JFrame jFrame = (JFrame)SwingUtilities.windowForComponent(propertyTable.getComponent());
        sPropertiesDialog = new MJDialog((Frame)jFrame, MessageFormat.format(CoderResources.getString("typedef.properties.title"), inputDataProperty.getName()));
        sPropertiesDialog.setName("typedef.properties.dialog");
        ((JComponent)sPropertiesDialog.getContentPane()).putClientProperty("PropertyTable-cell-editor-dialog", propertyTable);
        sPropertiesDialog.addWindowListener((WindowListener)new FinishListener(new Runnable(){

            @Override
            public void run() {
                inputDataProperty.setAttributesDirect(iDPAttributes);
                if (runnable != null) {
                    runnable.run();
                }
            }
        }));
        sPropertiesDialog.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                inputAttributesTable.dispose();
                sPropertiesDialog = null;
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                inputAttributesTable.dispose();
                sPropertiesDialog = null;
            }
        });
        sPropertiesDialog.setLayout((LayoutManager)new FormLayout("3dlu, fill:d:grow, 3dlu", "3dlu, fill:d, 3dlu:grow, fill:d, 3dlu"));
        CellConstraints cellConstraints = new CellConstraints();
        MJButton mJButton = new MJButton(BuiltInResources.getString((String)"button.close"));
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                sPropertiesDialog.dispose();
            }
        });
        MJHelpButton mJHelpButton = new MJHelpButton();
        mJHelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)returnRunnable.run();
                String string2 = inputDataProperty.isStruct() ? "help_button_struct_properties" : "help_button_fixed_point_properties";
                MLHelpServices.cshDisplayTopic((Object)sPropertiesDialog, (String)string, (String)string2);
            }
        });
        MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("3dlu:grow, fill:d, 3dlu, fill:d", "fill:d"));
        mJPanel.add((Component)mJHelpButton, (Object)cellConstraints.xy(2, 1));
        mJPanel.add((Component)mJButton, (Object)cellConstraints.xy(4, 1));
        sPropertiesDialog.add((Component)inputAttributesTable.getComponent(), (Object)cellConstraints.xy(2, 2));
        sPropertiesDialog.add((Component)mJPanel, (Object)cellConstraints.xy(2, 4));
        sPropertiesDialog.pack();
        sPropertiesDialog.setLocationRelativeTo((Component)sPropertiesDialog.getParent());
        sPropertiesDialog.setVisible(true);
        sPropertiesDialog.getRootPane().setDefaultButton((JButton)mJButton);
    }

    public static void disposePropertiesDialog() {
        if (sPropertiesDialog != null) {
            sPropertiesDialog.setVisible(false);
        }
    }

    private static class FinishListener
    extends WindowAdapter {
        private Runnable fFinish;

        FinishListener(Runnable runnable) {
            this.fFinish = runnable;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.run();
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            this.run();
        }

        private void run() {
            Runnable runnable = this.fFinish;
            this.fFinish = null;
            if (runnable != null) {
                runnable.run();
            }
        }
    }
}

