/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.screener.ScoreWidget;
import com.mathworks.toolbox.coder.screener.ScreenerReportModel;
import com.mathworks.util.PlatformInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JComponent;

public final class CodeBasePieChart {
    private final ScreenerReportModel fModel;
    private final MJPanel fComponent;
    private final Map<File, Double> fFilePercentages;
    private BufferedImage fImage;
    private static final double PIE_SIZE = 150.0;

    public CodeBasePieChart(ScreenerReportModel screenerReportModel) {
        this.fModel = screenerReportModel;
        this.fFilePercentages = screenerReportModel.getFilePercentages();
        this.fComponent = new MJPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(CodeBasePieChart.this.fImage.getWidth(), CodeBasePieChart.this.fImage.getHeight());
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                graphics.drawImage(CodeBasePieChart.this.fImage, this.getWidth() / 2 - CodeBasePieChart.this.fImage.getWidth() / 2, this.getHeight() / 2 - CodeBasePieChart.this.fImage.getHeight() / 2, (ImageObserver)((Object)this));
            }
        };
        if (!PlatformInfo.isMacintosh()) {
            this.fComponent.setOpaque(false);
        }
        this.generateImage();
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    private void generateImage() {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        ChartMetrics chartMetrics = this.paintImage(graphics2D, this.fComponent.getFont(), new ChartMetrics());
        graphics2D.dispose();
        this.fImage = new BufferedImage((int)chartMetrics.getBounds().getWidth(), (int)chartMetrics.getBounds().getHeight(), 2);
        Graphics2D graphics2D2 = this.fImage.createGraphics();
        this.paintImage(graphics2D2, this.fComponent.getFont(), chartMetrics);
        graphics2D2.dispose();
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    private ChartMetrics paintImage(Graphics graphics, Font font, ChartMetrics chartMetrics) {
        double d;
        Object object;
        Cloneable cloneable;
        Cloneable cloneable2;
        double d2 = chartMetrics.getBounds().getWidth();
        double d3 = chartMetrics.getCenterPoint().getX();
        double d4 = chartMetrics.getCenterPoint().getY();
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 2.147483647E9;
        double d8 = d4 + 75.0;
        double d9 = d4 - 75.0;
        double d10 = d2 / 2.0 + 75.0;
        double d11 = d2 / 2.0 - 75.0;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double d12 = 90.0;
        double d13 = (double)graphics2D.getFontMetrics(font).getHeight() * 1.4;
        ArrayList<String> arrayList = new ArrayList<String>();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (Map.Entry<File, Double> entry : this.fFilePercentages.entrySet()) {
            double d14;
            double d15;
            double d16;
            String string = entry.getKey().getName();
            double d17 = entry.getValue() * 360.0;
            cloneable2 = new Arc2D.Double(d3 - 75.0, d4 - 75.0, 150.0, 150.0, d12, d17, 2);
            cloneable = new Arc2D.Double(d3 - 75.0, d4 - 75.0, 150.0, 150.0, d12, d17 / 2.0, 2);
            d12 += d17;
            graphics2D.setStroke(new BasicStroke(0.7f));
            int n = this.fModel.getFileScore(entry.getKey());
            treeSet.add(n);
            graphics2D.setColor(ScoreWidget.getScoreColor(n));
            graphics2D.fill((Shape)((Object)cloneable2));
            graphics2D.setColor(new Color(250, 250, 250));
            graphics2D.draw((Shape)((Object)cloneable2));
            if (d17 < 10.0) {
                if (d5 == 0.0) {
                    d5 = d12 - d17;
                }
                if (arrayList.size() < 3) {
                    arrayList.add(entry.getKey().getName());
                    continue;
                }
                if (arrayList.size() != 3) continue;
                arrayList.add("etc.");
                continue;
            }
            object = ((Arc2D)cloneable).getEndPoint();
            if (((Point2D)object).getX() >= d3) {
                d16 = d3 + 112.5;
                d15 = Math.min(d7 - d13, ((Point2D)object).getY());
                d14 = d16 + 3.0;
                d7 = d15;
                d9 = Math.min(d9, d7 - d13);
                d10 = Math.max(d10, d14 + graphics2D.getFontMetrics().getStringBounds(string, graphics2D).getWidth());
            } else {
                d16 = d3 - 112.5;
                d6 = d15 = Math.max(d6 + d13, ((Point2D)object).getY());
                d8 = Math.max(d8, d6 + d13);
                d14 = d16 - 3.0 - graphics2D.getFontMetrics().getStringBounds(string, graphics2D).getWidth();
                d11 = Math.min(d11, d14);
            }
            Line2D.Double double_ = new Line2D.Double((Point2D)object, new Point2D.Double(d16, d15));
            graphics2D.setColor(new Color(180, 180, 180));
            graphics2D.draw(double_);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString(string, (float)d14, (float)(d15 + (double)(graphics2D.getFontMetrics(font).getAscent() / 2)));
        }
        if (d5 > 0.0) {
            double d18;
            double d19;
            Object object2;
            if (arrayList.size() == 1) {
                object2 = new Arc2D.Double(d3 - 75.0, d4 - 75.0, 150.0, 150.0, d5, (450.0 - d5) / 2.0, 2);
                cloneable2 = ((Arc2D)object2).getEndPoint();
                d19 = Math.min(d7 - d13, ((Point2D)cloneable2).getY());
                d18 = d3 + 112.5;
                cloneable = new Line2D.Double((Point2D)cloneable2, new Point2D.Double(d18, d19));
                graphics2D.setColor(new Color(180, 180, 180));
                graphics2D.draw((Shape)((Object)cloneable));
            } else {
                object2 = new Arc2D.Double(d3 - 75.0, d4 - 75.0, 150.0, 150.0, d5, 450.0 - d5, 2);
                cloneable2 = ((Arc2D)object2).getStartPoint();
                cloneable = ((Arc2D)object2).getEndPoint();
                d19 = Math.min(d7 - d13, ((Point2D)cloneable).getY());
                d18 = d3 + 112.5;
                Line2D.Double double_ = new Line2D.Double((Point2D)cloneable2, new Point2D.Double(d18, d19));
                object = new Line2D.Double((Point2D)cloneable, new Point2D.Double(d18, d19));
                graphics2D.setColor(new Color(180, 180, 180));
                graphics2D.draw(double_);
                graphics2D.draw((Shape)object);
            }
            if (arrayList.size() > 1) {
                graphics2D.setColor(new Color(0x444444));
            } else {
                graphics2D.setColor(Color.BLACK);
            }
            object2 = StringUtils.listToDelimitedString(arrayList, (String)", ");
            if (((String)object2).trim().endsWith(",")) {
                object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
            }
            graphics2D.drawString((String)object2, (float)(d18 + 3.0), (float)(d19 + (double)(graphics2D.getFontMetrics(graphics2D.getFont()).getAscent() / 2)));
            d9 = Math.min(d9, d19 - d13);
            d10 = Math.max(d10, d18 + 3.0 + graphics2D.getFontMetrics().getStringBounds((String)object2, graphics2D).getWidth());
        }
        double d20 = d4 + 75.0 + 10.0;
        double d21 = d3 - 75.0;
        if (PlatformInfo.isMacintosh()) {
            graphics2D.setFont(font.deriveFont(11.0f));
        }
        d13 = (double)graphics2D.getFontMetrics(graphics2D.getFont()).getHeight() * 1.4;
        for (Integer n : treeSet) {
            d = d13 / 2.0;
            Rectangle2D.Double double_ = new Rectangle2D.Double(d21, d20 + d13 / 2.0 - d / 2.0, d, d);
            graphics2D.setColor(ScoreWidget.getScoreColor(n));
            graphics2D.fill(double_);
            graphics2D.setColor(graphics2D.getColor().darker());
            graphics2D.draw(double_);
            graphics2D.setColor(Color.BLACK);
            String string = CoderResources.getString("screener.score." + n);
            graphics2D.drawString(string, (float)(d21 + d + 5.0), (float)(d20 + d13 - (double)(graphics2D.getFontMetrics(graphics2D.getFont()).getAscent() / 2)));
            d10 = Math.max(d10, d21 + d + 5.0 + graphics2D.getFontMetrics().getStringBounds(string, graphics2D).getWidth());
            d8 = Math.max(d8, d20 += d13);
        }
        graphics2D.dispose();
        double d22 = Math.max(d10 - d3, d3 - d11) * 2.0;
        d = d8 - d9 + 1.0;
        return new ChartMetrics(new Rectangle((int)d22, (int)d), new Point((int)(d22 / 2.0), (int)(d4 - d9)));
    }

    private static class ChartMetrics {
        private final Rectangle fBounds;
        private final Point fCenterPoint;

        ChartMetrics() {
            this.fBounds = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.fCenterPoint = new Point((int)(this.fBounds.getWidth() / 2.0), (int)(this.fBounds.getHeight() / 2.0));
        }

        ChartMetrics(Rectangle rectangle, Point point) {
            this.fBounds = new Rectangle(rectangle);
            this.fCenterPoint = new Point(point);
        }

        public Rectangle getBounds() {
            return new Rectangle(this.fBounds);
        }

        public Point getCenterPoint() {
            return new Point(this.fCenterPoint);
        }
    }
}

