/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.toolbox.coder.screener.FunctionInfo;
import com.mathworks.toolbox.coder.screener.ScreenerTarget;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public final class MatlabFunctionSupport {
    private static final FileLocation TOOLBOX_ROOT = new FileLocation(new FileLocation(Matlab.matlabRoot()), "toolbox");
    private static final Set<String> PRIMITIVE_BASE_CLASSES = new HashSet<String>();

    private MatlabFunctionSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean isSupported(FileLocation fileLocation, String string, ScreenerTarget screenerTarget) {
        if (fileLocation.hasPrefix(TOOLBOX_ROOT)) {
            if (screenerTarget == ScreenerTarget.FIXED_POINT) {
                return FunctionInfo.isFixedPointBuiltin(string) || FunctionInfo.hasFixedPointSupport(fileLocation.getNameBeforeDot()) || FunctionInfo.isSystemObjectWithFixedPointSupport(string);
            }
            if (FunctionInfo.isBuiltin(string) || MatlabFunctionSupport.hasEmlImpl(string) || FunctionInfo.isAutoExtrinsic(string) || FunctionInfo.isSystemObjectClass(string)) {
                return true;
            }
        }
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(fileLocation.toFile()));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!string2.contains("%#codegen")) continue;
                Boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    private static boolean hasEmlImpl(String string) {
        return FunctionInfo.hasEmlImpl(string);
    }

    public static boolean isPrimitiveBaseClass(String string) {
        return PRIMITIVE_BASE_CLASSES.contains(string.toLowerCase(Locale.ENGLISH));
    }

    static {
        PRIMITIVE_BASE_CLASSES.add("handle");
        PRIMITIVE_BASE_CLASSES.add("int8");
        PRIMITIVE_BASE_CLASSES.add("int16");
        PRIMITIVE_BASE_CLASSES.add("int32");
        PRIMITIVE_BASE_CLASSES.add("int64");
        PRIMITIVE_BASE_CLASSES.add("uint8");
        PRIMITIVE_BASE_CLASSES.add("uint16");
        PRIMITIVE_BASE_CLASSES.add("uint32");
        PRIMITIVE_BASE_CLASSES.add("uint64");
        PRIMITIVE_BASE_CLASSES.add("single");
        PRIMITIVE_BASE_CLASSES.add("double");
        PRIMITIVE_BASE_CLASSES.add("logical");
    }
}

