/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.explorer.ActionDefinition;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.matlab.api.explorer.StatusRunnable;
import com.mathworks.mlwidgets.explorer.model.actions.CoreMenuSection;
import com.mathworks.toolbox.coder.model.CoderFileSupport;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.screener.ScreenerReportDialog;
import java.io.File;

public final class ScreenerActionProvider
implements ActionProvider {
    private static final ActionDefinition SCREENER = new ActionDefinition("action.screener", false, CoreMenuSection.MISC.getSection(), CoderResources.getString("screener.report.action"));
    private static volatile Boolean fHasMatlabCoder;

    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return fileSystemEntry != null && CoderFileSupport.isMatlabSourceFile(fileSystemEntry.getLocation());
    }

    private static boolean hasMatlabCoder() {
        if (fHasMatlabCoder == null) {
            fHasMatlabCoder = Matlab.matlabRoot() != null && new File(Matlab.matlabRoot(), "toolbox/coder/matlabcoder").exists();
        }
        return fHasMatlabCoder;
    }

    public void configureActions(ActionRegistry actionRegistry) {
        if (!ScreenerActionProvider.hasMatlabCoder()) {
            return;
        }
        actionRegistry.defineAction(SCREENER).setCode(SelectionMode.EXPLICIT_SINGLE_FILE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                File file = ((FileSystemEntry)actionInput.getSelection().get(0)).getLocation().toFile();
                return ScreenerReportDialog.show(file);
            }
        });
    }
}

