/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.util;

import com.mathworks.project.impl.util.Matlab;
import com.mathworks.services.Prefs;
import com.mathworks.util.event.GlobalEventListener;
import com.mathworks.util.event.GlobalEventManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

public final class CoderLogger {
    public static final String CODER_LOGGING_ENV_KEY = "CODER_UI_LOGGING";
    public static final String CODER_LOGGING_PREF_KEY = "MatlabCoderUILoggingEnabled";
    public static final File DEFAULT_LOGGING_FILE = new File(Matlab.matlabRoot(), "coder_ui_debug.txt");
    private static final MultiLogTarget LOGGER = new MultiLogTarget(new LinkedList<LogTarget>());
    private static final CoderLogger DEFAULT_LOGGER_SINGLETON = new CoderLogger();
    private final Object fSource;

    public CoderLogger(@NotNull Object object) {
        assert (object != null) : "If an unscoped logger is desired, use the static logging methods instead.";
        this.fSource = object;
    }

    private CoderLogger() {
        this.fSource = null;
    }

    public static void logToFile() {
        CoderLogger.logToFile((File)null);
    }

    public static void logToFile(String string) {
        CoderLogger.logToFile(new File(string));
    }

    public static void logToFile(File file) {
        LOGGER.addLogTarget(file != null ? new FileLogger(file) : new FileLogger());
        CoderLogger.setEnabled(true);
    }

    public static void logToConsole() {
        LOGGER.addLogTarget(new ConsoleLogger());
        CoderLogger.setEnabled(true);
    }

    public static void setEnabled(boolean bl) {
        LOGGER.setEnabled(bl);
    }

    public static void setAlwaysEnabled(boolean bl) {
        Prefs.setBooleanPref((String)CODER_LOGGING_PREF_KEY, (boolean)bl);
    }

    public static void setVerbosity(Severity severity) {
        LOGGER.setVerbosity(severity);
    }

    public static void logInfo(String string, Object ... objectArray) {
        DEFAULT_LOGGER_SINGLETON.info(string, objectArray);
    }

    public static void logDebug(String string, Object ... objectArray) {
        DEFAULT_LOGGER_SINGLETON.debug(string, objectArray);
    }

    public static void logWarning(String string, Object ... objectArray) {
        DEFAULT_LOGGER_SINGLETON.warning(string, objectArray);
    }

    public static void logError(String string, Object ... objectArray) {
        DEFAULT_LOGGER_SINGLETON.error(string, objectArray);
    }

    public static void logAlert(String string, Object ... objectArray) {
        DEFAULT_LOGGER_SINGLETON.alert(string, objectArray);
    }

    public void info(String string, Object ... objectArray) {
        LOGGER.log(this.fSource, string, objectArray, Severity.INFO);
    }

    public void debug(String string, Object ... objectArray) {
        LOGGER.log(this.fSource, string, objectArray, Severity.DEBUG);
    }

    public void warning(String string, Object ... objectArray) {
        LOGGER.log(this.fSource, string, objectArray, Severity.WARNING);
    }

    public void error(String string, Object ... objectArray) {
        LOGGER.log(this.fSource, string, objectArray, Severity.ERROR);
    }

    public void alert(String string, Object ... objectArray) {
        LOGGER.log(this.fSource, string, objectArray, Severity.ALERT);
    }

    static {
        GlobalEventManager.addListener((String)"shutdown", (GlobalEventListener)new GlobalEventListener(){

            public void actionPerformed(String string) {
                if (string.equals("shutdown")) {
                    LOGGER.shutdown();
                }
            }
        });
        if (Prefs.exists((String)CODER_LOGGING_PREF_KEY)) {
            CoderLogger.setEnabled(Prefs.getBooleanPref((String)CODER_LOGGING_PREF_KEY, (boolean)false));
        } else {
            String string = System.getenv(CODER_LOGGING_ENV_KEY);
            if (string != null) {
                if (string.equals("1") || string.equals("0")) {
                    CoderLogger.setEnabled(string.equals("1"));
                } else {
                    CoderLogger.setEnabled(Boolean.parseBoolean(string));
                }
            }
        }
        LOGGER.addLogTarget(new FileLogger());
    }

    public static abstract class LogTarget {
        protected void initialize() throws Exception {
        }

        protected void shutdown() throws Exception {
        }

        protected abstract void log(Object var1, String var2, Object[] var3, Severity var4);
    }

    public static abstract class PrintStreamLogger
    extends LogTarget {
        private static final DateFormat DATE_FORMAT = new SimpleDateFormat("M/d/yyyy hh:mm:ss a");

        @Override
        protected final void log(Object object, String string, Object[] objectArray, Severity severity) {
            PrintStream printStream = this.getPrintStream();
            if (printStream == null) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (object != null) {
                Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
                stringBuilder.append("[class=").append(clazz.getName()).append(']');
                stringBuilder.append('[').append(Integer.toHexString(object.hashCode())).append(']');
            }
            stringBuilder.append("[thread=").append(Thread.currentThread().getName()).append(']');
            stringBuilder.append("[time=").append(DATE_FORMAT.format(new Date())).append(']');
            stringBuilder.append('\t').append(String.format(string, objectArray));
            printStream.println(stringBuilder.toString());
            printStream.flush();
        }

        protected abstract PrintStream getPrintStream();
    }

    private static class ConsoleLogger
    extends PrintStreamLogger {
        private ConsoleLogger() {
        }

        @Override
        protected PrintStream getPrintStream() {
            return System.err;
        }
    }

    private static class FileLogger
    extends PrintStreamLogger {
        private final File fLogFile;
        private PrintStream fPrintStream;

        FileLogger(@NotNull File file) {
            this.fLogFile = file;
        }

        FileLogger() {
            this(DEFAULT_LOGGING_FILE);
        }

        @Override
        protected void initialize() throws FileNotFoundException {
            this.fPrintStream = new PrintStream(new FileOutputStream(this.fLogFile));
        }

        @Override
        protected void shutdown() {
            this.fPrintStream.flush();
            this.fPrintStream.close();
        }

        @Override
        protected PrintStream getPrintStream() {
            return this.fPrintStream;
        }
    }

    private static class MultiLogTarget
    extends LogTarget {
        private final Collection<LogTarget> fLogTargets;
        private Severity fVerbosity;
        private boolean fInitialized;
        private boolean fShutdown;
        private boolean fEnabled;

        MultiLogTarget(@NotNull Collection<LogTarget> collection) {
            this.fLogTargets = new LinkedList<LogTarget>(collection);
        }

        synchronized void setVerbosity(Severity severity) {
            this.fVerbosity = severity;
        }

        synchronized void setEnabled(boolean bl) {
            if (this.fEnabled && !bl) {
                this.shutdown();
            } else if (!this.fEnabled && bl) {
                this.initialize();
            }
            this.fEnabled = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void addLogTarget(LogTarget logTarget) {
            Iterator<LogTarget> iterator = this.fLogTargets.iterator();
            while (iterator.hasNext()) {
                LogTarget logTarget2 = iterator.next();
                if (!logTarget2.getClass().equals(logTarget.getClass()) || !this.fInitialized || this.fShutdown) continue;
                try {
                    logTarget2.shutdown();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    iterator.remove();
                }
            }
            if (this.fInitialized && !this.fShutdown) {
                try {
                    logTarget.initialize();
                    this.fLogTargets.add(logTarget);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.fLogTargets.add(logTarget);
            }
        }

        @Override
        protected synchronized void initialize() {
            if (this.fInitialized) {
                return;
            }
            Iterator<LogTarget> iterator = this.fLogTargets.iterator();
            while (iterator.hasNext()) {
                try {
                    iterator.next().initialize();
                }
                catch (Exception exception) {
                    iterator.remove();
                    exception.printStackTrace();
                }
            }
            this.fInitialized = true;
            this.fShutdown = false;
        }

        @Override
        protected synchronized void shutdown() {
            if (!this.fInitialized || this.fShutdown) {
                return;
            }
            for (LogTarget logTarget : this.fLogTargets) {
                try {
                    logTarget.shutdown();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.fShutdown = true;
            this.fInitialized = false;
        }

        @Override
        protected synchronized void log(Object object, String string, Object[] objectArray, Severity severity) {
            if (this.fEnabled && (this.fVerbosity == null || severity.compareTo(this.fVerbosity) >= 0)) {
                for (LogTarget logTarget : this.fLogTargets) {
                    logTarget.log(object, string, objectArray, severity);
                }
            }
        }
    }

    public static enum Severity {
        INFO,
        DEBUG,
        WARNING,
        ERROR,
        ALERT;

    }
}

