/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.util;

import com.mathworks.toolbox.coder.plugin.Utilities;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LRUMap<K, V>
implements Map<K, V> {
    private final Map<K, V> fPrimaryMap;
    private final Map<K, V> fSecondaryMap;
    private final Map<K, V> fImmutableView;

    public LRUMap(final @NotNull LRUPredicate<K, V> lRUPredicate, final @Nullable Map<K, V> hashMap) {
        this.fSecondaryMap = hashMap != null ? hashMap : new HashMap();
        this.fImmutableView = Collections.unmodifiableMap(this);
        this.fPrimaryMap = new LinkedHashMap<K, V>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
                boolean bl = lRUPredicate.evictEldestEntry(entry, LRUMap.this.fImmutableView);
                if (bl && hashMap != null) {
                    hashMap.put(entry.getKey(), entry.getValue());
                }
                if (bl) {
                    LRUMap.this.onPendingRemoval(entry.getKey(), entry.getValue());
                }
                return bl;
            }
        };
    }

    public LRUMap(@NotNull LRUPredicate<K, V> lRUPredicate) {
        this(lRUPredicate, new SoftReferenceMap());
    }

    @Override
    public final int size() {
        return this.fPrimaryMap.size() + this.fSecondaryMap.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.fPrimaryMap.isEmpty() && this.fSecondaryMap.isEmpty();
    }

    @Override
    public final boolean containsKey(Object object) {
        return this.fPrimaryMap.containsKey(object) || this.fSecondaryMap.containsKey(object);
    }

    @Override
    public final boolean containsValue(Object object) {
        return this.fPrimaryMap.containsValue(object) || this.fSecondaryMap.containsValue(object);
    }

    @Override
    public final V get(Object object) {
        if (this.fPrimaryMap.containsKey(object)) {
            return this.fPrimaryMap.put(object, this.fPrimaryMap.get(object));
        }
        return this.fSecondaryMap.get(object);
    }

    @Override
    public final V put(K k, V v) {
        this.onPendingAddition(k, v);
        return this.fPrimaryMap.put(k, v);
    }

    @Override
    public final V remove(Object object) {
        V v = this.fPrimaryMap.get(object);
        if (v != null) {
            this.onPendingRemoval(object, v);
            this.fPrimaryMap.remove(object);
        } else {
            v = this.fSecondaryMap.remove(object);
        }
        return v;
    }

    @Override
    public final void putAll(@NotNull Map<? extends K, ? extends V> map) {
        this.fPrimaryMap.putAll(map);
    }

    @Override
    public final void clear() {
        this.fPrimaryMap.clear();
        this.fSecondaryMap.clear();
    }

    @Override
    @NotNull
    public final Set<K> keySet() {
        HashSet<K> hashSet = new HashSet<K>(this.fPrimaryMap.keySet());
        hashSet.addAll(this.fSecondaryMap.keySet());
        return hashSet;
    }

    @Override
    @NotNull
    public final Collection<V> values() {
        LinkedList<V> linkedList = new LinkedList<V>(this.fPrimaryMap.values());
        linkedList.addAll(this.fSecondaryMap.values());
        return linkedList;
    }

    @Override
    @NotNull
    public final Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet<Map.Entry<K, V>> linkedHashSet = new LinkedHashSet<Map.Entry<K, V>>(this.fPrimaryMap.entrySet());
        linkedHashSet.addAll(this.fSecondaryMap.entrySet());
        return linkedHashSet;
    }

    protected void onPendingAddition(K k, V v) {
    }

    protected void onPendingRemoval(K k, V v) {
    }

    private static void forceGarbageCollection() {
        long l;
        LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
        for (long i = Runtime.getRuntime().maxMemory(); i > 0L; i -= l) {
            try {
                l = Math.min(i, 0x7FFFFFF7L);
                linkedList.add(new Object[(int)l]);
                continue;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                return;
            }
        }
    }

    private static class SoftReferenceMap<K, V>
    implements Map<K, V> {
        private final Map<K, SoftWrapper> fMap = new HashMap<K, SoftWrapper>();
        private final ReferenceQueue<V> fDisposalQueue = new ReferenceQueue();

        private SoftReferenceMap() {
        }

        private void purge() {
            SoftWrapper softWrapper;
            while ((softWrapper = (SoftWrapper)this.fDisposalQueue.poll()) != null) {
                this.fMap.remove(softWrapper.getKey());
            }
        }

        @Override
        public int size() {
            this.purge();
            return this.fMap.size();
        }

        @Override
        public boolean isEmpty() {
            this.purge();
            return this.fMap.isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            this.purge();
            return this.fMap.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            this.purge();
            for (SoftWrapper softWrapper : this.fMap.values()) {
                Object t = softWrapper.get();
                if (Utilities.areValuesDifferent(object, t)) continue;
                return true;
            }
            return false;
        }

        @Override
        public V get(Object object) {
            this.purge();
            return this.containsKey(object) ? (V)this.fMap.get(object).get() : null;
        }

        @Override
        public V put(K k, V v) {
            this.purge();
            V v2 = this.get(k);
            this.fMap.put(k, new SoftWrapper(k, v));
            return v2;
        }

        @Override
        public V remove(Object object) {
            this.purge();
            return this.containsKey(object) ? (V)this.fMap.remove(object).get() : null;
        }

        @Override
        public void putAll(@NotNull Map<? extends K, ? extends V> map) {
            this.purge();
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.fMap.put(entry.getKey(), new SoftWrapper(entry.getKey(), entry.getValue()));
            }
        }

        @Override
        public void clear() {
            this.fMap.clear();
        }

        @Override
        @NotNull
        public Set<K> keySet() {
            this.purge();
            return this.fMap.keySet();
        }

        @Override
        @NotNull
        public Collection<V> values() {
            this.purge();
            LinkedList linkedList = new LinkedList();
            for (SoftWrapper softWrapper : this.fMap.values()) {
                Object t = softWrapper.get();
                if (t == null) continue;
                linkedList.add(t);
            }
            return linkedList;
        }

        @Override
        @NotNull
        public Set<Map.Entry<K, V>> entrySet() {
            this.purge();
            LinkedHashSet<Map.Entry<K, V>> linkedHashSet = new LinkedHashSet<Map.Entry<K, V>>();
            for (Map.Entry<K, SoftWrapper> entry : this.fMap.entrySet()) {
                Object t = entry.getValue().get();
                if (t == null) continue;
                linkedHashSet.add(new SoftEntry(entry.getKey(), t));
            }
            return linkedHashSet;
        }

        private class SoftEntry
        implements Map.Entry<K, V> {
            private final K fKey;
            private final V fValue;

            SoftEntry(K k, V v) {
                this.fKey = k;
                this.fValue = v;
            }

            @Override
            public K getKey() {
                return this.fKey;
            }

            @Override
            public V getValue() {
                return this.fValue;
            }

            @Override
            public V setValue(V v) {
                throw new UnsupportedOperationException();
            }
        }

        private class SoftWrapper
        extends SoftReference<V> {
            private final K fKey;

            private SoftWrapper(K k, V v) {
                super(v, SoftReferenceMap.this.fDisposalQueue);
                this.fKey = k;
            }

            K getKey() {
                return this.fKey;
            }
        }
    }

    public static interface LRUPredicate<K, V> {
        public boolean evictEldestEntry(Map.Entry<K, V> var1, Map<K, V> var2);
    }
}

