/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.GenericArtifact;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.core.Step;
import com.mathworks.toolbox.coder.wfa.core.StepModel;
import com.mathworks.toolbox.coder.wfa.core.StepModelAdapter;
import com.mathworks.toolbox.coder.wfa.core.StepSummaryView;
import com.mathworks.toolbox.coder.wfa.core.StepView;
import com.mathworks.toolbox.coder.wfa.core.StepViewFactory;
import com.mathworks.toolbox.coder.wfa.toolbar.OpenButton;
import com.mathworks.toolbox.coder.wfa.toolbar.ToolbarContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class OverviewPanel
implements StepView {
    private final CoderApp fApp;
    private final StepModel fModel;
    private final MJPanel fComponent;
    private final StepList fStepList;
    private final MJComboBox fArtifactBox;
    private final StepViewFactory fViewFactory;
    private final OpenButton fOpenButton;
    private static final Color LINE_COLOR = new Color(190, 190, 190);
    private static final int STEP_SPACING = 25;

    public OverviewPanel(CoderApp coderApp, StepModel stepModel, StepViewFactory stepViewFactory) {
        GenericArtifact genericArtifact2;
        this.fApp = coderApp;
        this.fModel = stepModel;
        this.fViewFactory = stepViewFactory;
        this.fComponent = new MJPanel((LayoutManager)new BorderLayout(0, 10));
        this.fArtifactBox = new MJComboBox();
        this.fArtifactBox.setFont(CoderApp.getFont().deriveFont(16.0f));
        this.fArtifactBox.setConstrainPopupWidth(false);
        this.fArtifactBox.setName("wfa.objective");
        for (GenericArtifact genericArtifact2 : this.fApp.getModel().getSupportedGenericArtifacts()) {
            this.fArtifactBox.addItem((Object)genericArtifact2);
        }
        this.fArtifactBox.setSelectedItem((Object)coderApp.getModel().getGenericArtifact());
        Object object = new GenericArtifactSelector();
        if (this.fApp.getModel().getSupportedGenericArtifacts().size() > 1) {
            this.fComponent.add(object, (Object)"North");
        }
        this.fStepList = new StepList();
        this.fComponent.add((Component)((Object)this.fStepList), (Object)"Center");
        genericArtifact2 = new MJPanel((GenericArtifactSelector)((Object)object)){
            final /* synthetic */ GenericArtifactSelector val$artifactSelector;
            {
                this.val$artifactSelector = genericArtifactSelector;
            }

            public Dimension getPreferredSize() {
                return this.val$artifactSelector.getPreferredSize();
            }
        };
        this.fComponent.add((Component)((Object)genericArtifact2), (Object)"South");
        stepModel.addStepModelListener(new StepModelAdapter(){

            @Override
            public void stepsChanged() {
                OverviewPanel.this.fStepList.rebuild();
            }

            @Override
            public void stepCompletionChanged(Step step, boolean bl) {
                OverviewPanel.this.fStepList.updateState();
            }
        });
        this.fArtifactBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (OverviewPanel.this.fArtifactBox.getSelectedItem() == itemEvent.getItem()) {
                    OverviewPanel.this.fApp.getModel().setGenericArtifact((GenericArtifact)((Object)OverviewPanel.this.fArtifactBox.getSelectedItem()));
                }
            }
        });
        this.fOpenButton = new OpenButton(coderApp);
    }

    @Override
    public JComponent getComponent() {
        return this.fComponent;
    }

    @Override
    public void activate(ToolbarContext toolbarContext, boolean bl) {
        toolbarContext.setStepComponents(Arrays.asList(this.fOpenButton));
    }

    @Override
    public void deactivate() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean shouldStretch() {
        return false;
    }

    @Override
    public boolean needsNarrowNavigationBars() {
        return false;
    }

    @Override
    public void displaySheet(Component component, int n, boolean bl, boolean bl2, Runnable runnable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void displaySheet(Component component, Component component2, boolean bl, boolean bl2, Runnable runnable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSheetSize(Component component) {
    }

    @Override
    public void closeSheet(Component component) {
    }

    @Override
    public void showHelp() {
        String string = "help_button_fixed_point_converter_app";
        if (this.fApp.getModel().getGenericArtifact() != GenericArtifact.FIXED_POINT) {
            string = "help_button_coder_app";
        }
        MLHelpServices.cshDisplayTopic((Object)this.fComponent, (String)CoderApp.getHelpMapPath(this.fApp), (String)string);
    }

    private static GeneralPath createArrowPath(Component component, int n) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.append(new Line2D.Double(component.getX() + component.getWidth() + 4, component.getY(), component.getX() + component.getWidth() + 7 - n, component.getY()), true);
        generalPath.append(new Line2D.Double(component.getX() + component.getWidth() + 7 - n, component.getY(), component.getX() + component.getWidth() + 25 - 6 - n, component.getY() + component.getHeight() / 2), true);
        generalPath.append(new Line2D.Double(component.getX() + component.getWidth() + 25 - 6 - n, component.getY() + component.getHeight() / 2, component.getX() + component.getWidth() + 7 - n, component.getY() + component.getHeight() - 1), true);
        generalPath.append(new Line2D.Double(component.getX() + component.getWidth() + 7 - n, component.getY() + component.getHeight() - 1, component.getX() + component.getWidth() + 4, component.getY() + component.getHeight() - 1), true);
        generalPath.append(new Line2D.Double(component.getX() + component.getWidth() + 4, component.getY() + component.getHeight() - 1, component.getX() + component.getWidth() + 4, component.getY()), true);
        return generalPath;
    }

    private class StepList
    extends MJPanel {
        StepList() {
            this.rebuild();
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(new Color(0, 0, 0, 0));
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length - 1; ++i) {
                Component component = componentArray[i];
                graphics2D.setPaint(new GradientPaint(component.getX(), component.getY() - 10, UIManager.getColor("control"), component.getX(), component.getY() + component.getHeight() / 2, LINE_COLOR, true));
                Area area = new Area(OverviewPanel.createArrowPath(component, 0));
                area.subtract(new Area(OverviewPanel.createArrowPath(component, 1)));
                graphics2D.fill(area);
            }
        }

        private void rebuild() {
            this.removeAll();
            List<Step> list = OverviewPanel.this.fModel.getSteps();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("3dlu");
            for (Step step : list) {
                stringBuilder.append(", fill:d, 25px");
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append("3dlu");
            int n = list.size() / 5 + (list.size() % 5 == 0 ? 0 : 1);
            for (int i = 0; i < n; ++i) {
                stringBuilder2.append(", fill:d, 25px");
            }
            this.setLayout((LayoutManager)new FormLayout(stringBuilder.toString(), stringBuilder2.toString()));
            CellConstraints cellConstraints = new CellConstraints();
            int n2 = 2;
            int n3 = 2;
            for (int i = 0; i < list.size(); ++i) {
                Step step = list.get(i);
                StepSummaryView stepSummaryView = OverviewPanel.this.fViewFactory.getSummaryView(step, OverviewPanel.this.fModel);
                this.add(stepSummaryView.getComponent(), cellConstraints.xy(n3, n2));
                if ((n3 += 2) <= 10) continue;
                n3 = 2;
                n2 += 2;
            }
            this.updateState();
            this.revalidate();
            this.repaint();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OverviewPanel.this.fComponent.revalidate();
                    OverviewPanel.this.fComponent.repaint();
                    Container container = OverviewPanel.this.fComponent.getParent();
                    if (container != null) {
                        container.revalidate();
                        container.repaint();
                    }
                }
            });
        }

        private void updateState() {
            boolean bl = true;
            for (Step step : OverviewPanel.this.fModel.getSteps()) {
                StepSummaryView stepSummaryView = OverviewPanel.this.fViewFactory.getSummaryView(step, OverviewPanel.this.fModel);
                stepSummaryView.setEnabled(bl);
                if (OverviewPanel.this.fModel.isCompleted(step)) continue;
                bl = false;
            }
        }
    }

    private class GenericArtifactSelector
    extends MJPanel {
        private final MJLabel fLabel;

        GenericArtifactSelector() {
            this.setLayout(null);
            this.fLabel = new MJLabel(CoderResources.getString("wfa.objective"));
            this.fLabel.setFont(CoderApp.getFont().deriveFont(16.0f));
            this.add((Component)this.fLabel);
            this.add((Component)OverviewPanel.this.fArtifactBox);
            this.setBorder(new Border(){

                @Override
                public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    n2 = component.getHeight() - 2;
                    Graphics2D graphics2D = (Graphics2D)graphics.create();
                    graphics2D.setColor(UIManager.getColor("control"));
                    graphics2D.fillRect(n, n2, n3, n4);
                    graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, UIManager.getColor("control"), n3 / 2, 0.0f, LINE_COLOR, true));
                    graphics2D.draw(new Line2D.Double(n, n2, n + n3, n2));
                    graphics2D.dispose();
                }

                @Override
                public Insets getBorderInsets(Component component) {
                    return new Insets(0, 0, 22, 0);
                }

                @Override
                public boolean isBorderOpaque() {
                    return true;
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GenericArtifactSelector.this.revalidate();
                    GenericArtifactSelector.this.repaint();
                }
            });
        }

        public void doLayout() {
            super.doLayout();
            Dimension dimension = this.fLabel.getPreferredSize();
            Dimension dimension2 = OverviewPanel.this.fArtifactBox.getPreferredSize();
            int n = dimension.width + 6 + dimension2.width;
            this.fLabel.setBounds(this.getWidth() / 2 - n / 2, this.getHeight() / 2 - dimension.height / 2, dimension.width, dimension.height);
            OverviewPanel.this.fArtifactBox.setBounds(this.fLabel.getX() + this.fLabel.getWidth() + 6, this.getHeight() / 2 - dimension2.height / 2, dimension2.width, dimension2.height);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = this.fLabel.getPreferredSize();
            Dimension dimension2 = OverviewPanel.this.fArtifactBox.getPreferredSize();
            return new Dimension(dimension.width + 6 + dimension2.width, Math.max(dimension.height, dimension2.height) + this.getBorder().getBorderInsets((Component)((Object)this)).bottom);
        }
    }
}

