/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.build;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJSplitPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.coder.fixedpoint.HDLExtendedModel;
import com.mathworks.toolbox.coder.wfa.core.Animation;
import com.mathworks.toolbox.coder.wfa.core.AnimationTrack;
import com.mathworks.toolbox.coder.wfa.core.Animator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class HDLDrillDownTable<T> {
    private static final double DEFAULT_SPLIT_PANE_PROPORTION = 0.6;
    private final HDLParameterContext<T> fParameterContext;
    private final DrillDownSourceView<T> fSourceView;
    private final DrillDownView<T> fDrillDownView;
    private final SelectionModel fSelectionModel;
    private final MJPanel fComponent;
    private final ToggleAction fStateToggler;
    private final ParameterSourcingPolicy<T> fSourcingPolicy;
    private final VisiblityPolicy<T> fVisiblityPolicy;
    private double fFinalLocation;
    private boolean fShowUniqueOnly;
    private boolean fLastVisible;

    HDLDrillDownTable(HDLParameterContext<T> hDLParameterContext, DrillDownSourceView<T> drillDownSourceView, DrillDownView<T> drillDownView, ParameterSourcingPolicy<T> parameterSourcingPolicy, VisiblityPolicy<T> visiblityPolicy, boolean bl) {
        this.fParameterContext = hDLParameterContext;
        this.fDrillDownView = drillDownView;
        this.fSourceView = drillDownSourceView;
        this.fShowUniqueOnly = true;
        this.fFinalLocation = 0.6;
        this.fLastVisible = false;
        this.fSelectionModel = bl ? new MultiSelectionModel() : new SelectionModel();
        this.fSourceView.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                HDLDrillDownTable.this.update();
            }
        });
        this.fComponent = new MJPanel((LayoutManager)new BorderLayout());
        this.fStateToggler = new AnimatedBaitAndSwitchToggleAction(0.7, this.fSourceView.getComponent(), this.fDrillDownView.getComponent());
        this.fSourcingPolicy = parameterSourcingPolicy != null ? parameterSourcingPolicy : this.createSharedOnlyPolicy();
        this.fVisiblityPolicy = visiblityPolicy != null ? visiblityPolicy : this.createMultiSelectNonEmptyVisibilityPolicy();
    }

    HDLDrillDownTable(HDLParameterContext<T> hDLParameterContext, DrillDownSourceView<T> drillDownSourceView, DrillDownView<T> drillDownView, boolean bl) {
        this(hDLParameterContext, drillDownSourceView, drillDownView, null, null, bl);
    }

    private ParameterSourcingPolicy<T> createSharedOnlyPolicy() {
        return new ParameterSourcingPolicy<T>(){

            @Override
            public Collection<HDLExtendedModel.HDLParameter<?>> sourceParameters(HDLParameterContext<T> hDLParameterContext, Collection<T> collection) {
                return hDLParameterContext.getSharedHDLParameters(collection);
            }
        };
    }

    private VisiblityPolicy<T> createMultiSelectNonEmptyVisibilityPolicy() {
        return new VisiblityPolicy<T>(){

            @Override
            public boolean isShowDrillDownView(Collection<T> collection, Collection<HDLExtendedModel.HDLParameter<?>> collection2) {
                return !collection2.isEmpty() && collection.size() > 1;
            }
        };
    }

    private Runnable createExpandAction() {
        return new Runnable(){

            @Override
            public void run() {
            }
        };
    }

    public void init() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                HDLDrillDownTable.this.fComponent.removeAll();
                HDLDrillDownTable.this.fStateToggler.deactivate();
                HDLDrillDownTable.this.update();
            }
        });
    }

    public void update() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Collection collection = HDLDrillDownTable.this.fSourceView.getSelectedEntries();
                if (collection == null) {
                    collection = new LinkedList();
                }
                HDLDrillDownTable.this.fSelectionModel.setSelectedEntries(new ArrayList(collection));
                Collection<HDLExtendedModel.HDLParameter<?>> collection2 = HDLDrillDownTable.this.fSourcingPolicy.sourceParameters(HDLDrillDownTable.this.fParameterContext, collection);
                HDLDrillDownTable.this.fDrillDownView.setCurrentEntries(collection2, collection);
                HDLDrillDownTable.this.fComponent.revalidate();
                HDLDrillDownTable.this.fComponent.repaint();
                HDLDrillDownTable.this.setDrillDownVisible(HDLDrillDownTable.this.fVisiblityPolicy.isShowDrillDownView(collection, collection2));
            }
        });
    }

    private void setDrillDownVisible(boolean bl) {
        if (bl == this.fLastVisible) {
            return;
        }
        if (bl) {
            this.fStateToggler.activate();
        } else {
            this.fStateToggler.deactivate();
        }
        this.fLastVisible = bl;
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public boolean isShowUniqueOnly() {
        return this.fShowUniqueOnly;
    }

    public void setShowUniqueOnly(boolean bl) {
        this.fShowUniqueOnly = bl;
    }

    static interface VisiblityPolicy<T> {
        public boolean isShowDrillDownView(Collection<T> var1, Collection<HDLExtendedModel.HDLParameter<?>> var2);
    }

    static interface ParameterSourcingPolicy<T> {
        public Collection<HDLExtendedModel.HDLParameter<?>> sourceParameters(HDLParameterContext<T> var1, Collection<T> var2);
    }

    static interface HDLParameterContext<T> {
        public Set<HDLExtendedModel.HDLParameter<?>> getApplicableHDLParameters(T var1);

        public Set<HDLExtendedModel.HDLParameter<?>> getSharedHDLParameters(Collection<T> var1);

        public Set<HDLExtendedModel.HDLParameter<?>> getCommonViewHDLParameters(Collection<T> var1);
    }

    static interface DrillDownView<T> {
        public void setCurrentEntries(Collection<HDLExtendedModel.HDLParameter<?>> var1, Collection<T> var2);

        public JComponent getComponent();
    }

    static interface DrillDownSourceView<T> {
        public void addChangeListener(ChangeListener var1);

        public Collection<T> getSelectedEntries();

        public JComponent getComponent();
    }

    private class AnimatedBaitAndSwitchToggleAction
    implements ToggleAction {
        private final Animator fAnimator;
        private final MJPanel fPanel;
        private final MJSplitPane fSplitPane;
        private final JComponent fLeftWidget;
        private final JComponent fRightWidget;
        private final PropertyChangeListener fDividerListener;
        private final double fExpandedProportion;
        private double fLastProportion;

        AnimatedBaitAndSwitchToggleAction(double d, JComponent jComponent, JComponent jComponent2) {
            this.fExpandedProportion = d;
            this.fLeftWidget = jComponent;
            this.fRightWidget = jComponent2;
            this.fPanel = new MJPanel((LayoutManager)new BorderLayout());
            this.fSplitPane = new MJSplitPane(1);
            this.fAnimator = new Animator();
            this.fLastProportion = this.fExpandedProportion;
            this.fDividerListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    AnimatedBaitAndSwitchToggleAction.this.fLastProportion = AnimatedBaitAndSwitchToggleAction.this.fSplitPane.getDividerLocation();
                }
            };
        }

        @Override
        public void activate() {
            HDLDrillDownTable.this.fComponent.remove((Component)this.fPanel);
            this.fSplitPane.setLeftComponent((Component)this.fLeftWidget);
            this.fSplitPane.setRightComponent((Component)this.fRightWidget);
            this.fSplitPane.setOneTouchExpandable(false);
            this.fSplitPane.setEnabled(false);
            HDLDrillDownTable.this.fComponent.add((Component)this.fSplitPane, (Object)"Center");
            double d = this.fLastProportion < this.fExpandedProportion ? this.fLastProportion : this.fExpandedProportion;
            this.doDividerAnimation(1.0, d, new Runnable(){

                @Override
                public void run() {
                    AnimatedBaitAndSwitchToggleAction.this.fSplitPane.addPropertyChangeListener("dividerLocation", AnimatedBaitAndSwitchToggleAction.this.fDividerListener);
                    AnimatedBaitAndSwitchToggleAction.this.fSplitPane.setEnabled(true);
                    AnimatedBaitAndSwitchToggleAction.this.fSplitPane.setOneTouchExpandable(true);
                    HDLDrillDownTable.this.fComponent.revalidate();
                    HDLDrillDownTable.this.fComponent.repaint();
                }
            });
        }

        @Override
        public void deactivate() {
            this.fSplitPane.removePropertyChangeListener("dividerLocation", this.fDividerListener);
            double d = (double)this.fSplitPane.getDividerLocation() / (double)this.fSplitPane.getMaximumDividerLocation();
            this.doDividerAnimation(d, 1.0, new Runnable(){

                @Override
                public void run() {
                    HDLDrillDownTable.this.fComponent.remove((Component)AnimatedBaitAndSwitchToggleAction.this.fSplitPane);
                    AnimatedBaitAndSwitchToggleAction.this.fPanel.add((Component)AnimatedBaitAndSwitchToggleAction.this.fLeftWidget, (Object)"Center");
                    HDLDrillDownTable.this.fComponent.add((Component)AnimatedBaitAndSwitchToggleAction.this.fPanel, (Object)"Center");
                    HDLDrillDownTable.this.fComponent.revalidate();
                    HDLDrillDownTable.this.fComponent.repaint();
                }
            });
        }

        private void doDividerAnimation(final double d, final double d2, final Runnable runnable) {
            this.fAnimator.animate(AnimationTrack.ACCELERATING, new Animation(){

                @Override
                public void step(double d3) {
                    AnimatedBaitAndSwitchToggleAction.this.fSplitPane.setDividerLocation(d + (d2 - d) * d3);
                    if (d3 >= 1.0 && runnable != null) {
                        runnable.run();
                    }
                }
            });
        }
    }

    private static interface ToggleAction {
        public void activate();

        public void deactivate();
    }

    private class MultiSelectionModel
    extends SelectionModel {
        private Collection<T> fSelected;

        private MultiSelectionModel() {
        }

        @Override
        public void setSelectedEntries(List<T> list) {
            this.fSelected = list;
        }

        @Override
        public Collection<T> getSelectedEntries() {
            return this.fSelected;
        }

        @Override
        public Set<HDLExtendedModel.HDLParameter<?>> getDrillableParameters(boolean bl) {
            if (this.fSelected == null || this.fSelected.isEmpty()) {
                return null;
            }
            LinkedHashSet linkedHashSet = new LinkedHashSet(HDLDrillDownTable.this.fParameterContext.getSharedHDLParameters(this.fSelected));
            if (bl) {
                linkedHashSet.removeAll(HDLDrillDownTable.this.fParameterContext.getCommonViewHDLParameters(this.fSelected));
            }
            return linkedHashSet;
        }

        @Override
        public boolean isMultiSelectEnabled() {
            return true;
        }
    }

    private class SelectionModel {
        private T fCurrentEntry;

        private SelectionModel() {
        }

        public void setSelectedEntries(List<T> list) {
            this.fCurrentEntry = list.size() > 0 ? list.get(0) : null;
        }

        public Collection<T> getSelectedEntries() {
            return this.fCurrentEntry != null ? Arrays.asList(this.fCurrentEntry) : new LinkedList();
        }

        public Set<HDLExtendedModel.HDLParameter<?>> getDrillableParameters(boolean bl) {
            if (this.fCurrentEntry == null) {
                return null;
            }
            LinkedHashSet linkedHashSet = new LinkedHashSet(HDLDrillDownTable.this.fParameterContext.getApplicableHDLParameters(this.fCurrentEntry));
            if (bl) {
                linkedHashSet.removeAll(HDLDrillDownTable.this.fParameterContext.getCommonViewHDLParameters(Arrays.asList(this.fCurrentEntry)));
            }
            return linkedHashSet;
        }

        public boolean isMultiSelectEnabled() {
            return false;
        }
    }
}

