/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.build;

import com.mathworks.project.impl.table.PropertyTableCellEditorFactory;
import com.mathworks.project.impl.table.PropertyTableColumn;
import com.mathworks.toolbox.coder.fixedpoint.HDLExtendedModel;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.InferenceModel;
import com.mathworks.toolbox.coder.model.Variable;
import com.mathworks.toolbox.coder.model.VariableKind;
import com.mathworks.toolbox.coder.wfa.build.HDLParameterCellEditorFactory;
import com.mathworks.toolbox.coder.wfa.build.HDLPropertyGroupDecorator;
import com.mathworks.toolbox.coder.wfa.build.HDLTableUtils;
import com.mathworks.toolbox.coder.wfa.build.InferenceTable;
import com.mathworks.util.Converter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class HDLInferenceTableContext
implements InferenceTable.InferenceTableContext {
    private final PropertyTableCellEditorFactory<Variable> fEditorFactory;
    private final HDLExtendedModel fHdlModel;
    private List<HDLExtendedModel.HDLParameter<?>> fCommonParams;
    private Map<Integer, VariableKind> fGroupLocations;
    private InferenceTable fTable;
    private int fLeftoverIndex;

    public HDLInferenceTableContext(HDLExtendedModel hDLExtendedModel) {
        this.fHdlModel = hDLExtendedModel;
        this.fEditorFactory = HDLParameterCellEditorFactory.createEditorFactory(new HDLParameterCellEditorFactory.CellEditorValueContext<Variable>(){

            @Override
            public Collection<Variable> getKeys() {
                return HDLInferenceTableContext.this.fTable.getSelectedVariables();
            }

            @Override
            public List<HDLExtendedModel.HDLParameter<?>> getHDLParameters(Variable variable, int n) {
                return --n < HDLInferenceTableContext.this.fCommonParams.size() ? Arrays.asList((HDLExtendedModel.HDLParameter)HDLInferenceTableContext.this.fCommonParams.get(n)) : HDLInferenceTableContext.this.getLeftoverParameters(variable);
            }
        });
    }

    private List<HDLExtendedModel.HDLParameter<?>> getLeftoverParameters(Variable variable) {
        ArrayList arrayList = new ArrayList();
        for (HDLExtendedModel.HDLParameter<?> hDLParameter : this.fHdlModel.getHDLParameters(variable)) {
            if (this.fCommonParams.contains(hDLParameter)) continue;
            arrayList.add(hDLParameter);
        }
        return arrayList;
    }

    private HDLExtendedModel.HDLParameter<?> getNthUniqueParameter(Variable variable, int n) {
        int n2 = 0;
        for (HDLExtendedModel.HDLParameter<?> hDLParameter : this.fHdlModel.getHDLParameters(variable)) {
            if (this.fCommonParams.contains(hDLParameter)) continue;
            if (n2 == n) {
                return hDLParameter;
            }
            ++n2;
        }
        return null;
    }

    public InferenceTable getInferenceTable() {
        return this.fTable;
    }

    @Override
    public InferenceModel getInferenceModel() {
        return this.fHdlModel.getCoreModel();
    }

    @Override
    public List<PropertyTableColumn<Variable>> getColumnsForFunction(Function function) {
        ArrayList<PropertyTableColumn<Variable>> arrayList = new ArrayList<PropertyTableColumn<Variable>>();
        List<Variable> list = this.getInferenceModel().getVariables(function);
        this.fCommonParams = new ArrayList(HDLTableUtils.intersectParameters(list, this.fHdlModel));
        for (HDLExtendedModel.HDLParameter<?> hDLParameter : this.fCommonParams) {
            arrayList.add((PropertyTableColumn<Variable>)new HDLTableUtils.HDLParameterColumn(hDLParameter));
        }
        final Set<HDLExtendedModel.HDLParameter<?>> set = HDLTableUtils.findUniqueParameters(list, this.fHdlModel);
        this.fLeftoverIndex = -1;
        if (!set.isEmpty()) {
            this.fLeftoverIndex = arrayList.size();
            arrayList.add((PropertyTableColumn<Variable>)new HDLTableUtils.LeftoverParameterColumn(this.fHdlModel, set, new HDLPropertyGroupDecorator.GroupColumnResolver(){

                @Override
                public List<HDLExtendedModel.HDLParameter<?>> getLeftoverParametersForGroup(int n) {
                    if (HDLInferenceTableContext.this.fGroupLocations == null || !HDLInferenceTableContext.this.fGroupLocations.containsKey(n)) {
                        return new ArrayList(set);
                    }
                    ArrayList arrayList = new ArrayList(HDLInferenceTableContext.this.fHdlModel.getHDLParameters((VariableKind)((Object)HDLInferenceTableContext.this.fGroupLocations.get(n))));
                    arrayList.retainAll(set);
                    return arrayList;
                }
            }, new Converter<Variable, List<HDLExtendedModel.HDLParameter<?>>>(){

                public List<HDLExtendedModel.HDLParameter<?>> convert(Variable variable) {
                    return new ArrayList(HDLInferenceTableContext.this.fHdlModel.getHDLParameters(variable));
                }
            }));
        }
        return arrayList;
    }

    @Override
    public void setCurrentGroups(Map<Integer, VariableKind> map) {
        this.fGroupLocations = map;
    }

    @Override
    public PropertyTableCellEditorFactory<Variable> getCellEditorFactory() {
        return this.fEditorFactory;
    }

    @Override
    public void setInferenceTable(InferenceTable inferenceTable) {
        this.fTable = inferenceTable;
    }

    @Override
    public boolean allowGroupSelection() {
        return true;
    }

    @Override
    public boolean allowMultipleSelection() {
        return true;
    }
}

