/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.core;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.coder.wfa.core.Step;
import com.mathworks.toolbox.coder.wfa.core.StepModel;
import com.mathworks.toolbox.coder.wfa.core.StepModelListener;
import com.mathworks.toolbox.coder.wfa.core.StepViewFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class AbstractStepModel
implements StepModel {
    private final Set<Step> fCompleted;
    private final Set<Step> fAutoSkip;
    private final List<StepModelListener> fListeners;
    private final StepViewFactory fViewFactory;
    private Step fCurrentStep;

    protected AbstractStepModel(StepViewFactory stepViewFactory) {
        this.fViewFactory = stepViewFactory;
        this.fCompleted = new HashSet<Step>();
        this.fAutoSkip = new HashSet<Step>();
        this.fListeners = new LinkedList<StepModelListener>();
    }

    @Override
    public final void addStepModelListener(StepModelListener stepModelListener) {
        this.fListeners.add(stepModelListener);
    }

    @Override
    public final void removeStepModelListener(StepModelListener stepModelListener) {
        this.fListeners.remove(stepModelListener);
    }

    protected final void fireStepsChanged() {
        for (StepModelListener stepModelListener : new ArrayList<StepModelListener>(this.fListeners)) {
            stepModelListener.stepsChanged();
        }
    }

    @Override
    public final Step getCurrentStep() {
        return this.fCurrentStep;
    }

    @Override
    public Step getNextSuggestedStep() {
        for (Step step : this.getSteps()) {
            if (this.isCompleted(step) || this.fAutoSkip.contains(step)) continue;
            return step;
        }
        return null;
    }

    @Override
    public final void setCurrentStep(Step step, boolean bl) {
        this.fCurrentStep = step;
        for (StepModelListener stepModelListener : new ArrayList<StepModelListener>(this.fListeners)) {
            stepModelListener.stepSelected(step, bl);
        }
    }

    @Override
    public void goToPreviousStep() {
        Step step = this.getPreviousStep();
        if (step != null) {
            this.setCurrentStep(step, false);
        }
    }

    @Override
    public void goToNextStep() {
        Step step = this.getNextStep();
        if (step != null) {
            this.setCurrentStep(step, false);
        }
    }

    public Step getPreviousStep() {
        List<Step> list = this.getSteps();
        if (this.fCurrentStep == null) {
            return OVERVIEW;
        }
        int n = list.indexOf(this.fCurrentStep);
        --n;
        while (n >= 0) {
            Step step = list.get(n);
            if (!this.fAutoSkip.contains(step)) {
                return step;
            }
            --n;
        }
        return OVERVIEW;
    }

    @Override
    public Step getNextStep() {
        List<Step> list = this.getSteps();
        if (this.fCurrentStep == null || this.fCurrentStep.equals(OVERVIEW)) {
            return list.get(0);
        }
        int n = list.indexOf(this.fCurrentStep);
        ++n;
        while (n < list.size()) {
            Step step = list.get(n);
            this.fViewFactory.getView(step, this);
            if (!this.fAutoSkip.contains(step)) {
                return step;
            }
            ++n;
        }
        return null;
    }

    @Override
    public final void refreshCompletion(final Step step) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractStepModel.this.setCompleted(step, AbstractStepModel.this.determineIfCompleted(step));
            }
        });
    }

    protected abstract boolean determineIfCompleted(Step var1);

    private void setCompleted(Step step, boolean bl) {
        if (bl) {
            this.fCompleted.add(step);
        } else {
            this.fCompleted.remove(step);
        }
        for (StepModelListener stepModelListener : new ArrayList<StepModelListener>(this.fListeners)) {
            stepModelListener.stepCompletionChanged(step, bl);
        }
    }

    @Override
    public boolean isCompleted(Step step) {
        return this.fCompleted.contains(step);
    }

    @Override
    public void setAutoSkip(Step step, boolean bl) {
        if (bl) {
            this.fAutoSkip.add(step);
        } else {
            this.fAutoSkip.remove(step);
        }
    }

    @Override
    public final boolean isAfter(Step step, Step step2) {
        if (step.equals(OVERVIEW) && !step2.equals(OVERVIEW)) {
            return false;
        }
        if (step2.equals(OVERVIEW) && !step.equals(OVERVIEW)) {
            return true;
        }
        List<Step> list = this.getAllPossibleSteps();
        int n = list.indexOf(step);
        int n2 = list.indexOf(step2);
        return n2 >= 0 && n > n2;
    }
}

