/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.core;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.Timer;

public abstract class ActionLink {
    private final MJPanel fComponent = new MJPanel((LayoutManager)new BorderLayout(0, 0));
    private final MJLabel fLabel;
    private boolean fEnabled;
    private Timer fEnableTimer;
    private static final float ENABLED_SATURATION;
    private static final float DISABLED_SATURATION = 0.041f;
    private static final Color ENABLED_COLOR;
    private static final Color DISABLED_COLOR;

    public ActionLink(String string) {
        this.fComponent.setOpaque(false);
        this.fLabel = new MJLabel(string);
        this.fLabel.setFont(new Font("Segoe UI", 0, 14));
        this.fLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ActionLink.this.invoke();
            }
        });
        this.fComponent.add((Component)this.fLabel);
        this.setEnabled(true);
    }

    protected abstract void invoke();

    public JComponent getComponent() {
        return this.fComponent;
    }

    public void setEnabled(final boolean bl) {
        if (bl == this.fEnabled && this.fEnableTimer == null) {
            return;
        }
        if (this.fComponent.isShowing()) {
            if (this.fEnableTimer != null) {
                this.fEnableTimer.stop();
            }
            this.fEnableTimer = new Timer(10, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = ActionLink.this.fLabel.getForeground();
                    float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                    if (bl) {
                        fArray[1] = fArray[1] + 0.02f;
                        if (fArray[1] > ENABLED_SATURATION) {
                            ActionLink.this.finishEnabledChange(bl);
                            return;
                        }
                    } else {
                        fArray[1] = fArray[1] - 0.02f;
                        if (fArray[1] < 0.041f) {
                            ActionLink.this.finishEnabledChange(bl);
                            return;
                        }
                    }
                    ActionLink.this.fLabel.setForeground(Color.getHSBColor(fArray[0], fArray[1], fArray[2]));
                }
            });
            this.fEnableTimer.start();
        } else {
            this.finishEnabledChange(bl);
        }
    }

    private void finishEnabledChange(boolean bl) {
        if (this.fEnableTimer != null) {
            this.fEnableTimer.stop();
            this.fEnableTimer = null;
        }
        this.fEnabled = bl;
        this.fLabel.setForeground(this.fEnabled ? ENABLED_COLOR : DISABLED_COLOR);
        this.fLabel.setCursor(Cursor.getPredefinedCursor(this.fEnabled ? 12 : 0));
    }

    static {
        ENABLED_COLOR = new Color(0, 0, 190);
        float[] fArray = Color.RGBtoHSB(ENABLED_COLOR.getRed(), ENABLED_COLOR.getGreen(), ENABLED_COLOR.getBlue(), null);
        ENABLED_SATURATION = fArray[1];
        fArray[1] = 0.041f;
        DISABLED_COLOR = Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
    }
}

