/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.files;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJTree;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.files.AbstractFileSetView;
import com.mathworks.toolbox.coder.wfa.files.FileScopedNode;
import com.mathworks.toolbox.coder.wfa.files.FileScopedTreeModel;
import com.mathworks.toolbox.coder.wfa.files.FileSetIntegrationContext;
import com.mathworks.toolbox.coder.wfa.files.MultiViewUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class FileScopedTree
extends AbstractFileSetView {
    private final JComponent fComponent;
    private final String fLabel;
    private final FileScopedTreeModel fTreeModel;
    private final JTree fTree;
    private final FileScopedContextMenu fContextMenu;

    public FileScopedTree(FileSetIntegrationContext fileSetIntegrationContext, FileScopedTreeModel fileScopedTreeModel, String string) {
        this.fTreeModel = fileScopedTreeModel;
        this.fLabel = string;
        this.fComponent = new MJPanel((LayoutManager)new BorderLayout());
        this.fTree = new MJTree((TreeModel)fileScopedTreeModel);
        TreeExpansionStateManager treeExpansionStateManager = new TreeExpansionStateManager(this.fTree);
        this.fTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (FileScopedTree.this.getSelectedFunction() != null) {
                    FileScopedTree.this.fireSelectionEvent(FileScopedTree.this.getSelectedFunction());
                } else {
                    FileScopedTree.this.fireSelectionEvent(FileScopedTree.this.getSelectedFile());
                }
            }
        });
        this.fTree.setRootVisible(false);
        this.fTree.setShowsRootHandles(true);
        this.fComponent.add((Component)MultiViewUtils.createBorderedScrollPane(this.fTree));
        this.fContextMenu = new FileScopedContextMenu();
        RowSpanningTreeUI rowSpanningTreeUI = this.createTreeUI();
        if (rowSpanningTreeUI != null) {
            this.fTree.setUI(rowSpanningTreeUI);
        }
        this.setTreeCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                FileScopedNode fileScopedNode = (FileScopedNode)object;
                this.setText(fileScopedNode.getNodeType().toString());
                return this;
            }
        });
        this.fTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    FileScopedTree.this.fContextMenu.tryShow(mouseEvent.getComponent(), mouseEvent.getPoint());
                }
            }
        });
        this.fTree.setSelectionModel(new DefaultTreeSelectionModel(){

            @Override
            protected void fireValueChanged(TreeSelectionEvent treeSelectionEvent) {
                super.fireValueChanged(treeSelectionEvent);
            }
        });
        this.installDefaultContextMenuActions();
        if (this.getViewName() != null) {
            this.fTree.setName(this.getViewName());
        }
    }

    public FileScopedTree(FileSetIntegrationContext fileSetIntegrationContext, FileScopedTreeModel fileScopedTreeModel) {
        this(fileSetIntegrationContext, fileScopedTreeModel, null);
    }

    @Nullable
    protected RowSpanningTreeUI createTreeUI() {
        return new RowSpanningTreeUI();
    }

    public FileScopedNode getSelectedNode() {
        return this.fTree.getSelectionPath() != null ? (FileScopedNode)this.fTree.getSelectionPath().getLastPathComponent() : null;
    }

    public FileScopedTreeModel getTreeModel() {
        return this.fTreeModel;
    }

    public void setListLike(boolean bl) {
        this.fTree.setShowsRootHandles(!bl);
    }

    public void expandRoot() {
        if (this.fTreeModel.getRoot() != null) {
            this.fTree.expandPath(new TreePath(this.fTreeModel.getRoot()));
        }
    }

    public void expandAll(final @Nullable FileScopedNode fileScopedNode) {
        this.runAndRestoreSelection(new Runnable(){

            @Override
            public void run() {
                for (TreePath treePath : FileScopedTree.this.fTreeModel.getExpandablePaths(fileScopedNode)) {
                    FileScopedTree.this.fTree.expandPath(treePath);
                }
            }
        });
    }

    public void collapseAll(final FileScopedNode fileScopedNode) {
        this.runAndRestoreSelection(new Runnable(){

            @Override
            public void run() {
                for (TreePath treePath : FileScopedTree.this.fTreeModel.getExpandablePaths(fileScopedNode)) {
                    FileScopedTree.this.fTree.collapsePath(treePath);
                }
                FileScopedTree.this.expandRoot();
            }
        });
    }

    private void runAndRestoreSelection(final Runnable runnable) {
        this.runSilently(new Runnable(){

            @Override
            public void run() {
                File file = FileScopedTree.this.getSelectedFile();
                runnable.run();
                if (file != null) {
                    FileScopedTree.this.select(file);
                }
            }
        });
    }

    protected JTree getTree() {
        return this.fTree;
    }

    protected void installDefaultContextMenuActions() {
        this.registerContextMenuAction(new ScopedAction(CoderResources.getString("wfa.sidebar.fileScopedTree.expandAll")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileScopedTree.this.expandAll(null);
            }

            @Override
            public boolean isVisibleForNode(FileScopedNode fileScopedNode) {
                return fileScopedNode == null;
            }
        });
        this.registerContextMenuAction(new ScopedAction(CoderResources.getString("wfa.sidebar.fileScopedTree.collapseAll")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileScopedTree.this.collapseAll(null);
            }

            @Override
            public boolean isVisibleForNode(FileScopedNode fileScopedNode) {
                return fileScopedNode == null;
            }
        });
        this.registerContextMenuAction(new ScopedAction(CoderResources.getString("wfa.sidebar.fileScopedTree.expandNode")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileScopedTree.this.expandAll(this.getCurrentNode());
            }

            @Override
            public boolean isVisibleForNode(FileScopedNode fileScopedNode) {
                return fileScopedNode != null && !FileScopedTree.this.fTree.isExpanded(FileScopedTree.getPath(fileScopedNode));
            }
        });
        this.registerContextMenuAction(new ScopedAction(CoderResources.getString("wfa.sidebar.fileScopedTree.collapseNode")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileScopedTree.this.collapseAll(this.getCurrentNode());
            }

            @Override
            public boolean isVisibleForNode(FileScopedNode fileScopedNode) {
                return fileScopedNode != null && FileScopedTree.this.fTree.isExpanded(FileScopedTree.getPath(fileScopedNode));
            }
        });
    }

    public void registerContextMenuAction(ScopedAction scopedAction) {
        this.fContextMenu.addScopedAction(scopedAction);
    }

    public void setTreeCellRenderer(TreeCellRenderer treeCellRenderer) {
        this.fTree.setCellRenderer(treeCellRenderer);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.fTree.addMouseListener(mouseListener);
    }

    private static TreePath getPath(FileScopedNode fileScopedNode) {
        return new TreePath(FileScopedTreeModel.getPath(fileScopedNode, true));
    }

    @Override
    public void update() {
        this.runSilently(new Runnable(){

            @Override
            public void run() {
                FileScopedTree.this.fTreeModel.populate();
                FileScopedTree.this.expandRoot();
            }
        });
    }

    @Override
    public boolean select(File file) {
        return this.fTreeModel.containsFile(file) && this.select(this.fTreeModel.getFileRoot(file));
    }

    @Override
    public boolean select(Function function) {
        boolean bl = this.select(function.getFile());
        return bl && function.isEntryPointFunction();
    }

    public boolean select(final FileScopedNode fileScopedNode) {
        this.runSilently(new Runnable(){

            @Override
            public void run() {
                FileScopedTree.this.fTree.setSelectionPath(FileScopedTree.getPath(fileScopedNode));
            }
        });
        return true;
    }

    @Override
    public JComponent getComponent() {
        return this.fComponent;
    }

    @Override
    public File getSelectedFile() {
        TreePath treePath = this.fTree.getSelectionPath();
        return treePath != null ? ((FileScopedNode)treePath.getLastPathComponent()).getAssociatedFile() : null;
    }

    @Override
    public Function getSelectedFunction() {
        FileScopedNode fileScopedNode;
        TreePath treePath = this.fTree.getSelectionPath();
        if (treePath != null && (fileScopedNode = (FileScopedNode)treePath.getLastPathComponent()).getNodeType() == FileScopedNode.NodeType.VALUE_NODE && fileScopedNode.getValueType().equals(Function.class)) {
            return (Function)fileScopedNode.getValue();
        }
        return null;
    }

    @Override
    public void clearSelection() {
        this.runSilently(new Runnable(){

            @Override
            public void run() {
                FileScopedTree.this.fTree.setSelectionPath(null);
            }
        });
    }

    @Override
    public String getViewName() {
        return this.fLabel;
    }

    @Override
    public boolean isEnabled() {
        return this.fTree.isEnabled();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.fTree.setEnabled(bl);
    }

    private static boolean isPathValid(TreePath treePath) {
        FileScopedNode fileScopedNode = null;
        for (Object object : treePath.getPath()) {
            if (fileScopedNode != null && !fileScopedNode.getChildren().contains(object)) {
                return false;
            }
            fileScopedNode = (FileScopedNode)object;
        }
        return true;
    }

    public static abstract class ScopedAction
    extends AbstractAction {
        private FileScopedNode fCurrentNode;

        public ScopedAction(String string) {
            super(string);
        }

        public ScopedAction(String string, Icon icon) {
            super(string, icon);
        }

        public FileScopedNode getCurrentNode() {
            return this.fCurrentNode;
        }

        public void setCurrentNode(FileScopedNode fileScopedNode) {
            this.fCurrentNode = fileScopedNode;
        }

        public boolean isVisibleForNode(FileScopedNode fileScopedNode) {
            return true;
        }

        public String getGroupKey() {
            return null;
        }
    }

    static class RowSpanningTreeUI
    extends BasicTreeUI {
        RowSpanningTreeUI() {
        }

        @Override
        protected CellRendererPane createCellRendererPane() {
            return new CellRendererPane(){

                @Override
                public void paintComponent(Graphics graphics, Component component, Container container, int n, int n2, int n3, int n4, boolean bl) {
                    super.paintComponent(graphics, component, container, n, n2, container.getWidth() - n, n4, bl);
                }
            };
        }

        @Override
        protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
            graphics.drawLine(n2, n, n3, n);
        }

        @Override
        protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
            graphics.drawLine(n, n2, n, n3);
        }

        public static ComponentUI createUI(JComponent jComponent) {
            return new RowSpanningTreeUI();
        }
    }

    private class TreeExpansionStateManager {
        private final Set<TreePath> fExpanded;
        private final Set<TreePath> fRestorePoint = new HashSet<TreePath>();
        private boolean fEnabled;

        TreeExpansionStateManager(JTree jTree) {
            this.fExpanded = new HashSet<TreePath>();
            final TreeModelListener treeModelListener = new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                }

                @Override
                public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                }

                @Override
                public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                    TreeExpansionStateManager.this.save();
                    TreeExpansionStateManager.this.restore();
                }
            };
            if (jTree.getModel() != null) {
                jTree.getModel().addTreeModelListener(treeModelListener);
            }
            jTree.addPropertyChangeListener("model", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    TreeModel treeModel = (TreeModel)propertyChangeEvent.getOldValue();
                    if (treeModel != null) {
                        treeModel.removeTreeModelListener(treeModelListener);
                    }
                    FileScopedTree.this.fTree.getModel().addTreeModelListener(treeModelListener);
                    TreeExpansionStateManager.this.reset();
                }
            });
            jTree.addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                    TreeExpansionStateManager.this.addPath(treeExpansionEvent.getPath());
                    FileScopedTree.this.getComponent().revalidate();
                    FileScopedTree.this.getComponent().repaint();
                }

                @Override
                public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                    TreeExpansionStateManager.this.removePath(treeExpansionEvent.getPath());
                    FileScopedTree.this.getComponent().revalidate();
                    FileScopedTree.this.getComponent().repaint();
                }
            });
            this.setEnabled(true);
            this.reset();
        }

        void setEnabled(boolean bl) {
            this.fEnabled = bl;
        }

        void reset() {
            this.fExpanded.clear();
            Enumeration<TreePath> enumeration = FileScopedTree.this.fTree.getExpandedDescendants(new TreePath(FileScopedTree.this.fTree.getModel().getRoot()));
            if (enumeration != null) {
                for (TreePath treePath : Collections.list(enumeration)) {
                    this.addPath(treePath);
                }
            }
        }

        void addPath(TreePath treePath) {
            if (this.fEnabled) {
                this.fExpanded.add(treePath);
            }
        }

        void removePath(TreePath treePath) {
            if (this.fEnabled) {
                this.fExpanded.remove(treePath);
            }
        }

        void save() {
            this.fRestorePoint.clear();
            this.fRestorePoint.addAll(this.fExpanded);
        }

        void restore() {
            Serializable serializable;
            this.fExpanded.clear();
            this.fExpanded.addAll(this.fRestorePoint);
            final HashSet<TreePath> hashSet = new HashSet<TreePath>(this.fRestorePoint);
            final HashSet<Serializable> hashSet2 = new HashSet<Serializable>();
            Enumeration<TreePath> enumeration = FileScopedTree.this.fTree.getExpandedDescendants(new TreePath(FileScopedTree.this.fTree.getModel().getRoot()));
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    serializable = enumeration.nextElement();
                    if (!hashSet.contains(serializable)) {
                        hashSet2.add(serializable);
                        continue;
                    }
                    hashSet.remove(serializable);
                }
            }
            serializable = new HashSet();
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                TreePath treePath = (TreePath)iterator.next();
                if (!FileScopedTree.isPathValid(treePath)) {
                    iterator.remove();
                    continue;
                }
                do {
                    if ((treePath = treePath.getParentPath()) == null) continue;
                    serializable.add(treePath);
                } while (treePath != null);
            }
            hashSet.removeAll((Collection<?>)((Object)serializable));
            MJUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (TreePath treePath : hashSet2) {
                        FileScopedTree.this.fTree.collapsePath(treePath);
                    }
                    for (TreePath treePath : hashSet) {
                        if (FileScopedTree.this.fTree.getModel().isLeaf(treePath.getLastPathComponent())) {
                            FileScopedTree.this.fTree.expandPath(treePath.getParentPath());
                            continue;
                        }
                        FileScopedTree.this.fTree.expandPath(treePath);
                    }
                }
            });
        }
    }

    private class FileScopedContextMenu {
        private final JPopupMenu fPopupMenu = new MJPopupMenu();
        private final Collection<ScopedAction> fActions = new LinkedList<ScopedAction>();

        FileScopedContextMenu() {
        }

        void addScopedAction(ScopedAction scopedAction) {
            this.fActions.add(scopedAction);
        }

        void tryShow(Component component, Point point) {
            FileScopedNode fileScopedNode = null;
            TreePath treePath = FileScopedTree.this.fTree.getPathForLocation(point.x, point.y);
            if (treePath != null) {
                fileScopedNode = (FileScopedNode)treePath.getLastPathComponent();
            }
            this.fPopupMenu.removeAll();
            LinkedHashMap<String, Collection<ScopedAction>> linkedHashMap = new LinkedHashMap<String, Collection<ScopedAction>>();
            for (ScopedAction scopedAction : this.fActions) {
                if (!scopedAction.isVisibleForNode(fileScopedNode)) continue;
                String string = scopedAction.getGroupKey();
                LinkedList<ScopedAction> linkedList = (LinkedList<ScopedAction>)linkedHashMap.get(string);
                if (linkedList == null) {
                    linkedList = new LinkedList<ScopedAction>();
                    linkedHashMap.put(string, linkedList);
                }
                scopedAction.setCurrentNode(fileScopedNode);
                linkedList.add(scopedAction);
            }
            if (!linkedHashMap.isEmpty()) {
                this.populateMenu(linkedHashMap);
                this.fPopupMenu.show(component, point.x, point.y);
            }
        }

        private void populateMenu(Map<String, Collection<ScopedAction>> map) {
            this.fPopupMenu.removeAll();
            boolean bl = false;
            for (Collection<ScopedAction> collection : map.values()) {
                if (bl) {
                    this.fPopupMenu.addSeparator();
                }
                for (ScopedAction scopedAction : collection) {
                    this.fPopupMenu.add(scopedAction);
                }
                bl = true;
            }
        }
    }
}

