/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.files;

import com.mathworks.toolbox.coder.model.CallTree;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.Variable;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.wfa.files.AbstractExpansionContext;
import com.mathworks.toolbox.coder.wfa.files.CallTreeFileSetView;
import com.mathworks.toolbox.coder.wfa.files.FileScopedNode;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.widgets.grouptable.ExpansionContext;
import com.mathworks.widgets.grouptable.ExpansionProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileSetExpansionProviders {
    private FileSetExpansionProviders() {
    }

    static ExpansionProvider<FileScopedNode> createMStructureExpansionProvider() {
        return new ExpansionProvider<FileScopedNode>(){

            public ExpansionContext<FileScopedNode> openContext(FileScopedNode fileScopedNode) {
                switch (fileScopedNode.getNodeType()) {
                    case INTERNAL_ROOT: {
                        return new RootExpansionContext(fileScopedNode, null);
                    }
                    case FILE_NODE: {
                        return new MFileExpansionContext(fileScopedNode);
                    }
                    case VALUE_NODE: {
                        if (fileScopedNode.getValue() == null) break;
                        if (fileScopedNode.getValueType().equals(Function.class)) {
                            return new FunctionExpansionContext(fileScopedNode);
                        }
                        if (!fileScopedNode.getValueType().equals(Variable.class)) break;
                        return new VariableExpansionContext(fileScopedNode);
                    }
                }
                return null;
            }
        };
    }

    static ExpansionProvider<FileScopedNode> createCallTreeExpansionProvider(final @Nullable CallTree callTree, final @NotNull CallTreeFileSetView.CallTreeDisplayMode callTreeDisplayMode) {
        return new ExpansionProvider<FileScopedNode>(){

            public ExpansionContext<FileScopedNode> openContext(FileScopedNode fileScopedNode) {
                switch (fileScopedNode.getNodeType()) {
                    case INTERNAL_ROOT: {
                        return new RootExpansionContext(fileScopedNode, callTreeDisplayMode.createRootOverrideNodes(fileScopedNode));
                    }
                    case FILE_NODE: {
                        return new CallTreeFileExpansionContext(fileScopedNode, callTree, callTreeDisplayMode);
                    }
                    case VALUE_NODE: {
                        if (fileScopedNode.getValueType().equals(CallTree.CallSite.class)) {
                            return new ConcreteCallSiteExpansionContext(fileScopedNode, callTree, callTreeDisplayMode);
                        }
                        if (!fileScopedNode.getValueType().equals(Function.class)) break;
                        return new FunctionCallSiteExpansionContext(fileScopedNode, callTree, callTreeDisplayMode);
                    }
                }
                return null;
            }
        };
    }

    private static class FunctionCallSiteExpansionContext
    extends AbstractCallSiteExpansionContext {
        private FunctionCallSiteExpansionContext(FileScopedNode fileScopedNode, CallTree callTree, CallTreeFileSetView.CallTreeDisplayMode callTreeDisplayMode) {
            super(fileScopedNode, callTree, callTreeDisplayMode);
        }

        @Override
        Function getNodeFunction() {
            assert (this.getItem().getValueType().equals(Function.class));
            return (Function)this.getItem().getValue();
        }
    }

    private static class ConcreteCallSiteExpansionContext
    extends AbstractCallSiteExpansionContext {
        ConcreteCallSiteExpansionContext(FileScopedNode fileScopedNode, CallTree callTree, CallTreeFileSetView.CallTreeDisplayMode callTreeDisplayMode) {
            super(fileScopedNode, callTree, callTreeDisplayMode, CallTree.CallSite.class);
        }

        @Override
        Function getNodeFunction() {
            return this.getMode().extractFunction((CallTree.CallSite)this.getItem().getValue());
        }
    }

    private static class CallTreeFileExpansionContext
    extends AbstractCallSiteExpansionContext {
        CallTreeFileExpansionContext(FileScopedNode fileScopedNode, CallTree callTree, CallTreeFileSetView.CallTreeDisplayMode callTreeDisplayMode) {
            super(fileScopedNode, callTree, callTreeDisplayMode);
        }

        @Override
        Function getNodeFunction() {
            return this.getMode().getRootFunction(this.getItem());
        }
    }

    private static abstract class AbstractCallSiteExpansionContext
    extends AbstractExpansionContext {
        private final Collection<FileScopedNode> fChildren;
        private final CallTreeFileSetView.CallTreeDisplayMode fMode;
        private final CallTree fCallTree;

        AbstractCallSiteExpansionContext(FileScopedNode fileScopedNode, CallTree callTree, CallTreeFileSetView.CallTreeDisplayMode callTreeDisplayMode) {
            this(fileScopedNode, callTree, callTreeDisplayMode, null);
        }

        AbstractCallSiteExpansionContext(FileScopedNode fileScopedNode, CallTree callTree, CallTreeFileSetView.CallTreeDisplayMode callTreeDisplayMode, Class<?> clazz) {
            super(fileScopedNode, clazz);
            this.fMode = callTreeDisplayMode;
            this.fCallTree = callTree;
            this.fChildren = new LinkedList<FileScopedNode>();
            Set<File> set = this.getItem().getInternalRootContext().getFiles();
            if (this.getCallTree() != null) {
                Function function = this.getNodeFunction();
                if (function == null || !callTreeDisplayMode.isIgnoreSpecializations() || function.isSpecialized()) {
                    // empty if block
                }
                if (function != null) {
                    Object object;
                    List<CallTree.CallSite> list;
                    if (this.getItem().getNodeType() == FileScopedNode.NodeType.VALUE_NODE && this.getItem().getValueType().equals(CallTree.CallSite.class) && ((CallTree.CallSite)((Object)(list = (CallTree.CallSite)this.getItem().getValue()))).getEnclosingFunction().equals(((CallTree.CallSite)((Object)list)).getTarget())) {
                        return;
                    }
                    list = this.getCallTree().getCallSites(function);
                    if (!list.isEmpty() || (object = callTreeDisplayMode.createLeafValueAppendages(this.getItem())) != null) {
                        // empty if block
                    }
                    for (CallTree.CallSite callSite : list) {
                        Function function2 = callTreeDisplayMode.extractFunction(callSite);
                        if (function2 == null || !set.contains(function2.getFile()) || !Utilities.areValuesDifferent(this.getItem().getValue(), callSite)) continue;
                        this.fChildren.add(new FileScopedNode(this.getItem(), callSite, function.getFile()));
                    }
                }
            }
        }

        abstract Function getNodeFunction();

        CallTree getCallTree() {
            return this.fCallTree;
        }

        CallTreeFileSetView.CallTreeDisplayMode getMode() {
            return this.fMode;
        }

        public boolean hasChildren() {
            Function function = this.getNodeFunction();
            if (function == null || this.getCallTree() == null) {
                return false;
            }
            return !this.getCallTree().getCallSites(function).isEmpty();
        }

        public void getChildrenAsynchronously(AsyncReceiver<FileScopedNode> asyncReceiver) {
            for (FileScopedNode fileScopedNode : this.fChildren) {
                asyncReceiver.receive((Object)fileScopedNode);
            }
            asyncReceiver.finished();
        }
    }

    private static class VariableExpansionContext
    extends AbstractExpansionContext {
        VariableExpansionContext(FileScopedNode fileScopedNode) {
            super(fileScopedNode, Variable.class);
        }

        public boolean hasChildren() {
            return false;
        }

        public void getChildrenAsynchronously(AsyncReceiver<FileScopedNode> asyncReceiver) {
            asyncReceiver.finished();
        }
    }

    private static class FunctionExpansionContext
    extends AbstractExpansionContext {
        private final List<FileScopedNode> fChildren = new LinkedList<FileScopedNode>();

        FunctionExpansionContext(FileScopedNode fileScopedNode) {
            super(fileScopedNode, Function.class);
            for (Variable variable : this.getItem().getInternalRootContext().getSourceModel().getVariables((Function)fileScopedNode.getValue())) {
                this.fChildren.add(new FileScopedNode(fileScopedNode, variable));
            }
        }

        @Override
        public FileScopedNode createChildPlaceholder() {
            return new FileScopedNode(this.getItem(), new Variable((Function)this.getItem().getValue(), "..."));
        }

        public boolean hasChildren() {
            return !this.fChildren.isEmpty();
        }

        public void getChildrenAsynchronously(AsyncReceiver<FileScopedNode> asyncReceiver) {
            for (FileScopedNode fileScopedNode : this.fChildren) {
                asyncReceiver.receive((Object)fileScopedNode);
            }
            asyncReceiver.finished();
        }
    }

    private static class MFileExpansionContext
    extends AbstractExpansionContext {
        private final List<FileScopedNode> fChildren = new LinkedList<FileScopedNode>();

        MFileExpansionContext(FileScopedNode fileScopedNode) {
            super(fileScopedNode);
            Map<File, List<Function>> map = this.getItem().getInternalRootContext().getSourceModel().getFunctionsByFile();
            if (map.containsKey(fileScopedNode.getAssociatedFile())) {
                for (Function function : map.get(fileScopedNode.getAssociatedFile())) {
                    this.fChildren.add(new FileScopedNode(fileScopedNode, function));
                }
            }
        }

        @Override
        public FileScopedNode createChildPlaceholder() {
            return new FileScopedNode(this.getItem().getParent(), new Function(this.getItem().getAssociatedFile(), "..."));
        }

        public boolean hasChildren() {
            return !this.fChildren.isEmpty();
        }

        public void getChildrenAsynchronously(AsyncReceiver<FileScopedNode> asyncReceiver) {
            for (FileScopedNode fileScopedNode : this.fChildren) {
                asyncReceiver.receive((Object)fileScopedNode);
            }
            asyncReceiver.finished();
        }
    }

    static class RootExpansionContext
    extends AbstractExpansionContext {
        private final List<FileScopedNode> fChildren;

        RootExpansionContext(FileScopedNode fileScopedNode, @Nullable Collection<FileScopedNode> collection) {
            super(fileScopedNode);
            if (!fileScopedNode.getNodeType().equals((Object)FileScopedNode.NodeType.INTERNAL_ROOT)) {
                throw new IllegalArgumentException("Incompatible node type for RootExpansionContext");
            }
            this.fChildren = new ArrayList<FileScopedNode>();
            if (collection != null) {
                this.fChildren.addAll(collection);
            } else {
                for (File file : this.getItem().getInternalRootContext().getFiles()) {
                    this.fChildren.add(new FileScopedNode(this.getItem(), file));
                }
            }
        }

        @Override
        public FileScopedNode createChildPlaceholder() {
            return new FileScopedNode(this.getItem(), new File("."));
        }

        public boolean hasChildren() {
            return !this.fChildren.isEmpty();
        }

        public void getChildrenAsynchronously(AsyncReceiver<FileScopedNode> asyncReceiver) {
            for (FileScopedNode fileScopedNode : this.fChildren) {
                asyncReceiver.receive((Object)fileScopedNode);
            }
            asyncReceiver.finished();
        }
    }
}

