/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.files;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.project.impl.DocumentCellRenderer;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.files.AbstractFileSetView;
import com.mathworks.toolbox.coder.wfa.files.FileSetIntegrationContext;
import com.mathworks.toolbox.coder.wfa.files.MultiViewUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FileSetPanel
extends AbstractFileSetView {
    private static final Comparator<File> FILE_COMPARATOR = new SubjectiveFileTypeComparator();
    private final MJPanel fComponent;
    private final MJList fList;
    private final MJScrollPane fScroller;
    private final FileSetIntegrationContext fContext;

    public FileSetPanel(FileSetIntegrationContext fileSetIntegrationContext, String string) {
        this.fContext = fileSetIntegrationContext;
        this.fComponent = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        this.fList = new MJList();
        this.fList.setName(string);
        this.fComponent.add((Component)this.fList);
        this.fList.setBorder(null);
        this.fList.setCellRenderer((ListCellRenderer)new DocumentCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
                if (FileSetPanel.this.fContext.getApp().getEditManager().isDirty((File)object)) {
                    this.setText(this.getText() + "*");
                }
                return component;
            }
        });
        this.fScroller = MultiViewUtils.createBorderedScrollPane((JComponent)this.fList);
        this.fList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FileSetPanel.this.fireSelectionEvent(FileSetPanel.this.getSelectedFile());
            }
        });
        this.fContext.getApp().getEditManager().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FileSetPanel.this.fList.revalidate();
                FileSetPanel.this.fList.repaint();
            }
        });
        this.fComponent.putClientProperty((Object)"mwjavaguitest.instance", (Object)this);
    }

    @Override
    public void update() {
        final DefaultListModel<File> defaultListModel = new DefaultListModel<File>();
        ArrayList<File> arrayList = new ArrayList<File>(this.fContext.getFiles());
        Collections.sort(arrayList, FILE_COMPARATOR);
        for (File file : arrayList) {
            defaultListModel.addElement(file);
        }
        this.runSilently(new Runnable(){

            @Override
            public void run() {
                File file = FileSetPanel.this.fList.getSelectedValue() != null ? (File)FileSetPanel.this.fList.getSelectedValue() : null;
                FileSetPanel.this.fList.setModel((ListModel)defaultListModel);
                FileSetPanel.this.fList.setVisibleRowCount(FileSetPanel.this.fList.getModel().getSize());
                FileSetPanel.this.fList.setSelectedValue((Object)file, true);
            }
        });
    }

    @Override
    public boolean select(File file) {
        for (int i = 0; i < this.fList.getModel().getSize(); ++i) {
            if (!this.fList.getModel().getElementAt(i).equals(file)) continue;
            this.fList.setSelectedIndex(i);
            return true;
        }
        this.fList.clearSelection();
        return false;
    }

    @Override
    public boolean select(Function function) {
        if (function != null && function.isEntryPointFunction()) {
            return this.select(function.getFile());
        }
        this.select(function != null ? function.getFile() : null);
        return false;
    }

    @Override
    public JComponent getComponent() {
        return this.fScroller;
    }

    @Override
    public File getSelectedFile() {
        return (File)this.fList.getSelectedValue();
    }

    @Override
    public void clearSelection() {
        this.runSilently(new Runnable(){

            @Override
            public void run() {
                FileSetPanel.this.fList.clearSelection();
            }
        });
    }

    @Override
    public String getViewName() {
        return CoderResources.getString("wfa.sidebar.outputDefaultView");
    }

    @Override
    public boolean isEnabled() {
        return this.fComponent.isEnabled();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.fComponent.setEnabled(bl);
    }

    private static class SubjectiveFileTypeComparator
    implements Comparator<File> {
        private static final Collator SORTER = Collator.getInstance();
        private static final String[] EXPLICIT_PRIORITIZED_TYPES = new String[]{"mlx", "m", "c", "h", "htm", "html"};

        private SubjectiveFileTypeComparator() {
        }

        @Override
        public int compare(File file, File file2) {
            String string = new FileLocation(file).getExtension();
            String string2 = new FileLocation(file2).getExtension();
            if (string == null && string2 == null || string != null && string2 != null && string.equals(string2)) {
                return SORTER.compare(file.getName(), file2.getName());
            }
            for (String string3 : EXPLICIT_PRIORITIZED_TYPES) {
                int n = SubjectiveFileTypeComparator.matchExtension(string, string2, string3);
                if (n == 0) continue;
                return n;
            }
            if (string != null && string2 != null) {
                int n = string.compareTo(string2);
                return n != 0 ? n : file.getName().compareTo(file2.getName());
            }
            return 0;
        }

        private static int matchExtension(String string, String string2, String string3) {
            boolean bl;
            boolean bl2 = string != null && string.equalsIgnoreCase(string3);
            boolean bl3 = bl = string2 != null && string2.equalsIgnoreCase(string3);
            if (bl2 == bl) {
                return 0;
            }
            if (bl2 && !bl) {
                return -1;
            }
            return 1;
        }
    }
}

