/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.files;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.toolbox.coder.app.ide.SelectionEvent;
import com.mathworks.toolbox.coder.app.ide.SelectionListener;
import com.mathworks.toolbox.coder.model.BuildError;
import com.mathworks.toolbox.coder.model.BuildErrorSeverity;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.files.AbstractFileSetView;
import com.mathworks.toolbox.coder.wfa.files.CallTreeFileSetView;
import com.mathworks.toolbox.coder.wfa.files.FileScopedNode;
import com.mathworks.toolbox.coder.wfa.files.FileScopedTree;
import com.mathworks.toolbox.coder.wfa.files.FileScopedTreeModel;
import com.mathworks.toolbox.coder.wfa.files.FileSetIntegrationContext;
import com.mathworks.util.Converter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import org.jetbrains.annotations.Nullable;

public class FunctionTreeView
extends AbstractFileSetView {
    private final FileScopedTree fTree;
    private final CallTreeFileSetView.FileScopedCellRendererPanel fRenderer;
    private final FileSetIntegrationContext fContext;
    private final Converter<FileScopedNode, Collection<FileScopedNode>> fCollapseProvider;
    private final Converter<FileScopedNode, Collection<FileScopedNode>> fDumpProvider;
    private final Converter<FileScopedNode, File> fCollapseBinder;
    private final Converter<FileScopedNode, File> fDumpBinder;
    private final Map<Function, Collection<Function>> fSpecializations;
    private final FileScopedTree.ScopedAction fDumpAction;
    private final FileScopedTree.ScopedAction fCollapseAction;
    private final Map<File, List<Function>> fFunctions;
    private boolean fCollapsed;

    public FunctionTreeView(FileSetIntegrationContext fileSetIntegrationContext) {
        this.fContext = fileSetIntegrationContext;
        this.fSpecializations = new HashMap<Function, Collection<Function>>();
        this.fFunctions = new HashMap<File, List<Function>>();
        FileScopedTreeModel fileScopedTreeModel = new FileScopedTreeModel(fileSetIntegrationContext);
        this.fTree = new FileScopedTree(fileSetIntegrationContext, fileScopedTreeModel){

            @Override
            public String getViewName() {
                return "wfa.sidebar.functionListView";
            }
        };
        this.fTree.addSelectionListener(new SelectionListener(){

            @Override
            public void selectionChanged(SelectionEvent selectionEvent) {
                FunctionTreeView.this.fireSelectionEvent(selectionEvent.derive(FunctionTreeView.this));
            }
        });
        this.fDumpProvider = this.createDumpedConverter();
        this.fCollapseProvider = this.createCollapsedConverter();
        this.fDumpAction = this.createDumpAction();
        this.fCollapseAction = this.createCollapseAction();
        this.setCollapseSpecializations(false);
        this.fTree.registerContextMenuAction(this.fDumpAction);
        this.fTree.registerContextMenuAction(this.fCollapseAction);
        this.fRenderer = this.createRenderer(fileSetIntegrationContext, new Converter<Function, Collection<Function>>(){

            public Collection<Function> convert(Function function) {
                return FunctionTreeView.this.fCollapsed && FunctionTreeView.this.fSpecializations.containsKey(function) ? (Collection)FunctionTreeView.this.fSpecializations.get(function) : new LinkedList<Function>();
            }
        });
        this.fTree.setTreeCellRenderer(this.fRenderer);
        this.fContext.getApp().getEditManager().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FunctionTreeView.this.fTree.getComponent().repaint();
            }
        });
        this.fDumpBinder = FunctionTreeView.createDumpedFileConverter();
        this.fCollapseBinder = FunctionTreeView.createCollapsedFileConverter();
    }

    public void setErrors(Collection<BuildError> collection) {
        this.fRenderer.setBuildErrors(collection);
    }

    public void setFunctions(@Nullable Map<File, List<Function>> map) {
        this.fFunctions.clear();
        if (map != null) {
            this.fFunctions.putAll(map);
        }
        this.update();
    }

    private Converter<FileScopedNode, Collection<FileScopedNode>> createCollapsedConverter() {
        return new Converter<FileScopedNode, Collection<FileScopedNode>>(){

            public Collection<FileScopedNode> convert(FileScopedNode fileScopedNode) {
                Function function;
                LinkedList<FileScopedNode> linkedList = new LinkedList<FileScopedNode>();
                if (fileScopedNode.getNodeType() == FileScopedNode.NodeType.INTERNAL_ROOT) {
                    HashSet hashSet = new HashSet(FunctionTreeView.this.fSpecializations.keySet());
                    for (File file : fileScopedNode.getInternalRootContext().getFiles()) {
                        Map map = FunctionTreeView.this.fFunctions;
                        if (!map.containsKey(file)) continue;
                        for (Function function2 : (List)map.get(file)) {
                            if (function2.isSpecialized()) continue;
                            linkedList.add(new FileScopedNode(fileScopedNode, function2, file));
                        }
                        Iterator iterator = hashSet.iterator();
                        while (iterator.hasNext()) {
                            Function function2;
                            function2 = (Function)iterator.next();
                            if (!function2.getFile().equals(file)) continue;
                            linkedList.add(new FileScopedNode(fileScopedNode, function2, file));
                            iterator.remove();
                        }
                    }
                } else if (fileScopedNode.getNodeType() == FileScopedNode.NodeType.VALUE_NODE && !(function = (Function)fileScopedNode.getValue()).isSpecialized() && FunctionTreeView.this.fSpecializations.containsKey(function)) {
                    for (Function function3 : (Collection)FunctionTreeView.this.fSpecializations.get(function)) {
                        linkedList.add(new FileScopedNode(fileScopedNode, function3, function3.getFile()));
                    }
                }
                Collections.sort(linkedList, FunctionTreeView.this.createDefaultComparator());
                return linkedList;
            }
        };
    }

    private Converter<FileScopedNode, Collection<FileScopedNode>> createDumpedConverter() {
        return new Converter<FileScopedNode, Collection<FileScopedNode>>(){

            public Collection<FileScopedNode> convert(FileScopedNode fileScopedNode) {
                LinkedList<FileScopedNode> linkedList = new LinkedList<FileScopedNode>();
                if (fileScopedNode.getNodeType() == FileScopedNode.NodeType.INTERNAL_ROOT) {
                    for (File file : fileScopedNode.getInternalRootContext().getFiles()) {
                        Map map = FunctionTreeView.this.fFunctions;
                        if (!map.containsKey(file)) continue;
                        for (Function function : (List)map.get(file)) {
                            linkedList.add(new FileScopedNode(fileScopedNode, function, file));
                        }
                    }
                }
                Collections.sort(linkedList, FunctionTreeView.this.createDefaultComparator());
                return linkedList;
            }
        };
    }

    private static Converter<FileScopedNode, File> createCollapsedFileConverter() {
        return FunctionTreeView.createDumpedFileConverter();
    }

    private static Converter<FileScopedNode, File> createDumpedFileConverter() {
        return new Converter<FileScopedNode, File>(){

            public File convert(FileScopedNode fileScopedNode) {
                Function function;
                if (fileScopedNode.getValueType() != null && fileScopedNode.getValueType().equals(Function.class) && ((function = (Function)fileScopedNode.getValue()).isEntryPointFunction() || !function.isSpecialized())) {
                    return function.getFile();
                }
                return null;
            }
        };
    }

    private FileScopedTree.ScopedAction createCollapseAction() {
        return new FileScopedTree.ScopedAction(CoderResources.getString("wfa.sidebar.functionTree.showCollapsed")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FunctionTreeView.this.setCollapseSpecializations(true);
            }

            @Override
            public String getGroupKey() {
                return "functionTree";
            }
        };
    }

    private FileScopedTree.ScopedAction createDumpAction() {
        return new FileScopedTree.ScopedAction(CoderResources.getString("wfa.sidebar.functionTree.showFlat")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FunctionTreeView.this.setCollapseSpecializations(false);
            }

            @Override
            public String getGroupKey() {
                return "functionTree";
            }
        };
    }

    private void regenerateSpecializationMap() {
        this.fSpecializations.clear();
        Map<File, List<Function>> map = this.fFunctions;
        for (File file : this.fContext.getFiles()) {
            if (!map.containsKey(file)) continue;
            for (Function function : map.get(file)) {
                if (!function.isSpecialized()) continue;
                Function function2 = new Function(function.getFile(), function.getName());
                Collection<Function> collection = this.fSpecializations.get(function2);
                if (collection == null) {
                    collection = new LinkedList<Function>();
                    this.fSpecializations.put(function2, collection);
                }
                collection.add(function);
            }
        }
    }

    public void setCollapseSpecializations(final boolean bl) {
        this.runSilently(new Runnable(){

            @Override
            public void run() {
                File file = FunctionTreeView.this.getSelectedFile();
                FunctionTreeView.this.fCollapsed = bl;
                FunctionTreeView.this.fTree.getTreeModel().setNodeProvider((Converter<FileScopedNode, Collection<FileScopedNode>>)(bl ? FunctionTreeView.this.fCollapseProvider : FunctionTreeView.this.fDumpProvider));
                FunctionTreeView.this.fTree.getTreeModel().setNodeToFileBinder((Converter<FileScopedNode, File>)(bl ? FunctionTreeView.this.fCollapseBinder : FunctionTreeView.this.fDumpBinder));
                FunctionTreeView.this.fTree.setListLike(!bl);
                FunctionTreeView.this.fDumpAction.setEnabled(bl);
                FunctionTreeView.this.fCollapseAction.setEnabled(!bl);
                FunctionTreeView.this.fTree.update();
                if (file != null) {
                    FunctionTreeView.this.select(file);
                }
            }
        });
    }

    @Override
    public Function getSelectedFunction() {
        FileScopedNode fileScopedNode = this.fTree.getSelectedNode();
        if (this.fTree.getSelectedNode() != null) {
            return fileScopedNode.getNodeType() == FileScopedNode.NodeType.VALUE_NODE ? (Function)fileScopedNode.getValue() : null;
        }
        return null;
    }

    @Override
    public void clearSelection() {
        this.fTree.clearSelection();
    }

    @Override
    public void update() {
        final Function function = this.getSelectedFunction();
        final File file = this.getSelectedFile();
        this.regenerateSpecializationMap();
        this.fTree.update();
        if (function != null) {
            this.runSilently(new Runnable(){

                @Override
                public void run() {
                    if (function != null) {
                        FunctionTreeView.this.select(function);
                    } else if (file != null) {
                        FunctionTreeView.this.select(file);
                    }
                }
            });
        }
    }

    @Override
    public boolean select(File file) {
        return this.fTree.select(file);
    }

    @Override
    public boolean select(Function function) {
        Collection<FileScopedNode> collection = this.fTree.getTreeModel().getNodeChildren(null);
        for (FileScopedNode fileScopedNode : collection) {
            if (fileScopedNode.getNodeType() != FileScopedNode.NodeType.VALUE_NODE || !fileScopedNode.getValue().equals(function)) continue;
            return this.fTree.select(fileScopedNode);
        }
        return false;
    }

    @Override
    public JComponent getComponent() {
        return this.fTree.getComponent();
    }

    @Override
    public File getSelectedFile() {
        return this.fTree.getSelectedFile();
    }

    @Override
    public boolean isEnabled() {
        return this.fTree.isEnabled();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.fTree.setEnabled(bl);
    }

    private CallTreeFileSetView.FileScopedCellRendererPanel createRenderer(FileSetIntegrationContext fileSetIntegrationContext, Converter<Function, Collection<Function>> converter) {
        MJLabel mJLabel = new MJLabel();
        Icon icon = CoderResources.getIcon("project_function.png");
        CallTreeFileSetView.FileScopedCellRendererPanel fileScopedCellRendererPanel = new CallTreeFileSetView.FileScopedCellRendererPanel(fileSetIntegrationContext, converter, (JLabel)mJLabel, icon){
            final /* synthetic */ JLabel val$label;
            final /* synthetic */ Icon val$allPassedIcon;
            {
                this.val$label = jLabel;
                this.val$allPassedIcon = icon;
                super(fileSetIntegrationContext, (Converter<Function, Collection<Function>>)converter);
            }

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                FileScopedNode fileScopedNode = (FileScopedNode)object;
                if (fileScopedNode.getNodeType() != FileScopedNode.NodeType.VALUE_NODE) {
                    return this;
                }
                Function function = (Function)fileScopedNode.getValue();
                String string = FunctionTreeView.this.fContext.getApp().getEditManager().isDirty(function.getFile()) ? "*" : null;
                String string2 = CallTreeFileSetView.createSpecializationDisplayString(function, this.getForeground(), FunctionTreeView.this.fContext.getSourceModel(), bl, true, string);
                this.val$label.setText(string2);
                this.val$label.setForeground(this.getForeground());
                BuildErrorSeverity buildErrorSeverity = this.getSeverity(function);
                if (bl3) {
                    if (this.getNumberOfFunctionsWithErrors() == 0) {
                        this.val$label.setIcon(this.val$allPassedIcon);
                    } else {
                        this.val$label.setIcon(buildErrorSeverity != null ? buildErrorSeverity.getIcon() : this.getPassedIcon());
                    }
                } else {
                    this.val$label.setIcon(buildErrorSeverity != null && buildErrorSeverity.isError() ? this.getFolderFailedIcon() : this.getFolderPassedIcon());
                }
                return this;
            }
        };
        fileScopedCellRendererPanel.add((Component)mJLabel, "Center");
        return fileScopedCellRendererPanel;
    }

    private Comparator<FileScopedNode> createDefaultComparator() {
        final Collator collator = Collator.getInstance();
        return new Comparator<FileScopedNode>(){

            @Override
            public int compare(FileScopedNode fileScopedNode, FileScopedNode fileScopedNode2) {
                if (fileScopedNode.getNodeType() == FileScopedNode.NodeType.INTERNAL_ROOT) {
                    return -1;
                }
                if (fileScopedNode2.getNodeType() == FileScopedNode.NodeType.INTERNAL_ROOT) {
                    return -1;
                }
                int n = 0;
                if (fileScopedNode.getNodeType() == FileScopedNode.NodeType.FILE_NODE || fileScopedNode2.getNodeType() == FileScopedNode.NodeType.FILE_NODE) {
                    n = collator.compare(fileScopedNode.getAssociatedFile().getName(), fileScopedNode2.getAssociatedFile().getName());
                } else if (fileScopedNode.getNodeType() == FileScopedNode.NodeType.VALUE_NODE && fileScopedNode2.getNodeType() == FileScopedNode.NodeType.VALUE_NODE) {
                    assert (fileScopedNode.getValueType().equals(fileScopedNode2.getValueType()) && fileScopedNode.getValueType().equals(Function.class)) : "Only Function value nodes are supported by this comparator";
                    Function function = (Function)fileScopedNode.getValue();
                    Function function2 = (Function)fileScopedNode2.getValue();
                    Function function3 = FunctionTreeView.this.fContext.getSourceModel().getEntryPointFunction(function.getFile());
                    Function function4 = FunctionTreeView.this.fContext.getSourceModel().getEntryPointFunction(function2.getFile());
                    n = function3 != null && function4 != null && !function3.equals(function4) ? collator.compare(function3.getName(), function4.getName()) : (function.equals(function3) || function2.equals(function4) ? -Boolean.valueOf(function.isEntryPointFunction()).compareTo(function2.isEntryPointFunction()) : (!function.getName().equals(function2.getName()) ? (function.getName().startsWith(function2.getName()) ? 1 : (function2.getName().startsWith(function.getName()) ? -1 : collator.compare(function.getName(), function2.getName()))) : Integer.valueOf(function.getSpecializationId()).compareTo(function2.getSpecializationId())));
                }
                return n;
            }
        };
    }
}

