/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.files;

import com.mathworks.mwswing.MJButtonGroup;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.coder.app.ide.SelectionEvent;
import com.mathworks.toolbox.coder.app.ide.SelectionListener;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.wfa.core.AnimationTrack;
import com.mathworks.toolbox.coder.wfa.files.AbstractFileSetView;
import com.mathworks.toolbox.coder.wfa.files.FileSetIntegrationContext;
import com.mathworks.toolbox.coder.wfa.files.FileSetView;
import com.mathworks.toolbox.coder.wfa.files.MultiViewUtils;
import com.mathworks.toolbox.coder.wfa.files.SlidingPanel;
import com.mathworks.toolbox.coder.widgets.TransitionPanel;
import com.mathworks.toolbox.coder.widgets.Transitions;
import com.mathworks.util.MulticastChangeListener;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MultiFileSetView
extends AbstractFileSetView {
    private static final String RES_INPUT_M_STRUCTURE_LABEL = "wfa.sidebar.inputMStructureViewLabel";
    private static final String RES_OUTPUT_VIEW = "wfa.sidebar.outputDefaultView";
    private static final String RES_VIEW_MENU_LABEL = "wfa.sidebar.viewSwitchLabel";
    private final FileSetIntegrationContext fContext;
    private final Map<FileSetView, SubViewContext> fSubViews;
    private final CardPanel fCardManager;
    private final MulticastChangeListener fUpdateListener;
    private final JComponent fPanel;
    private final JComponent fSlidingPanel;
    private final String fViewName;
    private ButtonGroup fActivateGroup;
    private FileSetView fActiveView;
    private boolean fIsInitialized;
    private boolean fDecorate;

    public MultiFileSetView(FileSetIntegrationContext fileSetIntegrationContext, FileSetView ... fileSetViewArray) {
        this(fileSetIntegrationContext, (String)null, fileSetViewArray);
    }

    public MultiFileSetView(FileSetIntegrationContext fileSetIntegrationContext, String string, FileSetView ... fileSetViewArray) {
        this.fContext = fileSetIntegrationContext;
        this.fViewName = string;
        this.fSubViews = new LinkedHashMap<FileSetView, SubViewContext>();
        this.fCardManager = new CardPanel();
        this.fUpdateListener = new MulticastChangeListener();
        this.fPanel = new MJPanel((LayoutManager)new BorderLayout());
        this.fSlidingPanel = new SlidingPanel();
        this.fActivateGroup = new MJButtonGroup();
        this.fDecorate = true;
        for (FileSetView fileSetView : fileSetViewArray) {
            this.addSubView(fileSetView);
        }
        this.fPanel.add((Component)this.fCardManager.getComponent(), "Center");
        this.fPanel.putClientProperty("mwjavaguitest.instance", this);
    }

    public void addSubView(FileSetView fileSetView) {
        this.fCardManager.add(fileSetView.getComponent(), fileSetView);
        SubViewContext subViewContext = new SubViewContext(fileSetView);
        this.fSubViews.put(fileSetView, subViewContext);
        this.fIsInitialized = false;
        this.update();
    }

    public void removeSubView(FileSetView fileSetView) {
        this.fCardManager.remove(fileSetView.getComponent());
        this.fSubViews.remove(fileSetView).dispose();
        this.fIsInitialized = false;
        this.update();
    }

    public void removeAll() {
        for (FileSetView fileSetView : new LinkedList<FileSetView>(this.fSubViews.keySet())) {
            this.removeSubView(fileSetView);
        }
    }

    public void setSubViewIcon(FileSetView fileSetView, Icon icon) {
        if (this.fSubViews.containsKey(fileSetView)) {
            this.fSubViews.get(fileSetView).setIcon(icon);
        }
    }

    public void setSubViewTooltip(FileSetView fileSetView, String string) {
        if (this.fSubViews.containsKey(fileSetView)) {
            this.fSubViews.get(fileSetView).setTooltip(string);
        }
    }

    public void setSubViewEnabled(FileSetView fileSetView, boolean bl) {
        if (this.fSubViews.containsKey(fileSetView)) {
            this.fSubViews.get(fileSetView).setEnabled(bl);
            if (this.fActiveView != null && this.fActiveView.equals(fileSetView)) {
                this.setNextEnabledView();
            }
        }
    }

    public void setDecorateSidebar(boolean bl) {
        this.fDecorate = bl;
        this.fIsInitialized = false;
        this.update();
    }

    private void initDecorations() {
        this.fSlidingPanel.removeAll();
        this.fActivateGroup = new MJButtonGroup();
        if (this.fDecorate) {
            for (SubViewContext subViewContext : this.fSubViews.values()) {
                this.fSlidingPanel.add(subViewContext.getActivateItem());
                this.fActivateGroup.add(subViewContext.getActivateItem());
            }
            this.setNextEnabledView();
        }
        this.fContext.getSidebarIntegrationContext().setHeadingWidget(this.fSlidingPanel);
        this.fSlidingPanel.revalidate();
        this.fSlidingPanel.repaint();
    }

    public void setNextEnabledView() {
        for (SubViewContext subViewContext : this.fSubViews.values()) {
            if (!subViewContext.isEnabled()) continue;
            this.setActiveView(subViewContext.fView);
            return;
        }
    }

    public int getEnabledViewCount() {
        int n = 0;
        for (SubViewContext subViewContext : this.fSubViews.values()) {
            if (!subViewContext.isEnabled()) continue;
            ++n;
        }
        return n;
    }

    private void refresh() {
        for (SubViewContext subViewContext : this.fSubViews.values()) {
            subViewContext.refresh();
        }
    }

    public void addUpdateListener(ChangeListener changeListener) {
        this.fUpdateListener.addChangeListener(changeListener);
    }

    public void setActiveView(FileSetView fileSetView) {
        if (fileSetView == null) {
            fileSetView = this.fSubViews.keySet().iterator().next();
        }
        if (this.fSubViews.containsKey(fileSetView) && this.fSubViews.get(fileSetView).isEnabled()) {
            SubViewContext subViewContext = this.fSubViews.get(fileSetView);
            subViewContext.show();
            this.fActiveView = fileSetView;
        }
    }

    public void setViewEnabled(FileSetView fileSetView, boolean bl) {
        if (this.fSubViews.containsKey(fileSetView)) {
            this.fSubViews.get(fileSetView).setEnabled(bl);
            if (this.fActiveView != null && this.fActiveView.equals(fileSetView)) {
                this.setNextEnabledView();
            }
        }
    }

    @Override
    public Function getSelectedFunction() {
        return this.fActiveView != null ? this.fActiveView.getSelectedFunction() : null;
    }

    @Override
    public void update() {
        if (!this.fIsInitialized) {
            this.initDecorations();
            this.fIsInitialized = true;
        }
        this.runSilently(new Runnable(){

            @Override
            public void run() {
                for (FileSetView fileSetView : MultiFileSetView.this.fSubViews.keySet()) {
                    fileSetView.update();
                }
            }
        });
        this.fUpdateListener.stateChanged(new ChangeEvent(this));
    }

    @Override
    public boolean select(File file) {
        return this.select(file, new MultiViewUtils.FileSelectionPolicy());
    }

    @Override
    public boolean select(Function function) {
        return this.select(function, new MultiViewUtils.FunctionSelectionPolicy());
    }

    @Override
    public void select(final SelectionEvent selectionEvent) {
        this.runSilently(new Runnable(){

            @Override
            public void run() {
                MultiFileSetView.this.select(selectionEvent, new MultiViewUtils.SelectionPolicy<SelectionEvent>(){

                    @Override
                    public boolean select(FileSetView fileSetView, SelectionEvent selectionEvent) {
                        fileSetView.select(selectionEvent);
                        return selectionEvent.isConsumed();
                    }
                });
            }
        });
    }

    public FileSetView getViewByType(Class<? extends FileSetView> clazz) {
        LinkedList<MultiFileSetView> linkedList = new LinkedList<MultiFileSetView>();
        linkedList.add(this);
        while (!linkedList.isEmpty()) {
            for (FileSetView fileSetView : ((MultiFileSetView)linkedList.poll()).fSubViews.keySet()) {
                if (clazz.equals(fileSetView)) {
                    return fileSetView;
                }
                if (!(fileSetView instanceof MultiFileSetView)) continue;
                linkedList.offer((MultiFileSetView)fileSetView);
            }
        }
        return null;
    }

    private <T> boolean select(T t, MultiViewUtils.SelectionPolicy<T> selectionPolicy) {
        boolean bl = false;
        if (this.fActiveView != null) {
            for (FileSetView fileSetView : this.fSubViews.keySet()) {
                if (fileSetView.equals(this.fActiveView)) continue;
                selectionPolicy.select(fileSetView, t);
            }
            bl = selectionPolicy.select(this.fActiveView, t);
        }
        if (!bl) {
            for (FileSetView fileSetView : this.fSubViews.keySet()) {
                if (!bl) {
                    bl = selectionPolicy.select(fileSetView, t);
                    continue;
                }
                selectionPolicy.select(fileSetView, t);
            }
        }
        return bl;
    }

    @Override
    public void setEnabled(boolean bl) {
        for (FileSetView fileSetView : this.fSubViews.keySet()) {
            fileSetView.setEnabled(bl);
        }
    }

    @Override
    public JComponent getComponent() {
        return this.fPanel;
    }

    @Override
    public File getSelectedFile() {
        return this.fActiveView != null ? this.fActiveView.getSelectedFile() : null;
    }

    @Override
    public void clearSelection() {
        this.runSilently(new Runnable(){

            @Override
            public void run() {
                for (FileSetView fileSetView : MultiFileSetView.this.fSubViews.keySet()) {
                    fileSetView.clearSelection();
                }
            }
        });
    }

    @Override
    public String getViewName() {
        return this.fViewName;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    private static class CardPanel {
        private final TransitionPanel fComponent = new TransitionPanel(Transitions.createFadeTransitionFactory(AnimationTrack.ACCELERATING));
        private final CardLayout fCardLayout;
        private final Map<Object, JComponent> fComponentMap;
        private final Map<Object, String> fKeys = new HashMap<Object, String>();
        private JComponent fCurrent;
        private int idCounter = 0;

        CardPanel() {
            this.fComponentMap = new HashMap<Object, JComponent>();
            this.fCardLayout = new CardLayout();
            this.fComponent.setLayout(this.fCardLayout);
        }

        void add(JComponent jComponent, Object object) {
            String string = Integer.valueOf(this.idCounter++).toString();
            this.fKeys.put(object, string);
            this.fComponentMap.put(object, jComponent);
            this.fComponent.add(jComponent, string);
        }

        void remove(JComponent jComponent) {
            this.fComponent.remove(jComponent);
            this.fComponentMap.remove(this.fKeys.remove(jComponent));
        }

        void show(Object object) {
            if (!this.fKeys.containsKey(object)) {
                return;
            }
            JComponent jComponent = this.fComponentMap.get(object);
            if (this.fCurrent != null && this.fCurrent == jComponent) {
                this.fComponent.repaint();
                return;
            }
            this.fCardLayout.show((Container)((Object)this.fComponent), this.fKeys.get(object));
            this.fCurrent = jComponent;
        }

        JComponent getComponent() {
            return this.fComponent;
        }
    }

    private class SubViewContext
    implements SelectionListener {
        private final FileSetView fView;
        private final AbstractButton fActivateItem;
        private boolean fEnabled;

        SubViewContext(FileSetView fileSetView) {
            this.fView = fileSetView;
            this.fActivateItem = new SlidingPanel.MonochromeToggleButton(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MultiFileSetView.this.setActiveView(SubViewContext.this.fView);
                }
            });
            if (fileSetView.getViewName() != null) {
                this.fActivateItem.setName(fileSetView.getViewName() + ".button");
            }
            fileSetView.addSelectionListener(this);
        }

        @Override
        public void selectionChanged(SelectionEvent selectionEvent) {
            MultiFileSetView.this.fireSelectionEvent(selectionEvent);
        }

        void dispose() {
            this.fView.removeSelectionListener(this);
            MultiFileSetView.this.fSlidingPanel.remove(this.fActivateItem);
            MultiFileSetView.this.fActivateGroup.remove(this.fActivateItem);
        }

        AbstractButton getActivateItem() {
            return this.fActivateItem;
        }

        void setIcon(Icon icon) {
            this.fActivateItem.setIcon(icon);
            this.fActivateItem.revalidate();
            this.fActivateItem.repaint();
        }

        void setEnabled(boolean bl) {
            this.getActivateItem().setEnabled(bl);
            this.fView.setEnabled(bl);
        }

        void refresh() {
            if (this.fActivateItem.isSelected()) {
                this.show();
            }
        }

        void show() {
            this.fActivateItem.setSelected(true);
            MultiFileSetView.this.fCardManager.show(this.fView);
        }

        void setTooltip(String string) {
            this.fActivateItem.setToolTipText(string);
        }

        boolean isEnabled() {
            return this.getActivateItem().isEnabled();
        }
    }
}

