/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.inputtypes;

import com.mathworks.common.icons.DialogIcon;
import com.mathworks.common.icons.FileTypeIcon;
import com.mathworks.mwswing.IconUtils;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTree;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.toolbox.coder.app.CoderAppModel;
import com.mathworks.toolbox.coder.plugin.EntryPoint;
import com.mathworks.toolbox.coder.plugin.EntryPointFileDataWidget;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPChangeListener;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputTable;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.ReturnRunnable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;

public final class InputTypesTree {
    private final CoderAppModel fModel;
    private final MJPanel fComponent;
    private final Map<File, EntryPointFileDataWidget> fWidgets;
    private final MulticastChangeListener fChangeListeners;
    private final ChangeListener fChangeListenerAdapter;
    private final ReturnRunnable<String> fHelpPathResolver;
    private double fExpansionRatio;
    private boolean fSettingData;

    public InputTypesTree(CoderAppModel coderAppModel, @Nullable ReturnRunnable<String> returnRunnable) {
        this.fModel = coderAppModel;
        this.fHelpPathResolver = returnRunnable;
        this.fChangeListeners = new MulticastChangeListener();
        this.fComponent = new Wrapper();
        this.fComponent.setBackground(Color.WHITE);
        this.fComponent.setLayout((LayoutManager)new GridBagLayout());
        this.fWidgets = new HashMap<File, EntryPointFileDataWidget>();
        this.fExpansionRatio = 1.0;
        this.fChangeListenerAdapter = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                InputTypesTree.this.fChangeListeners.stateChanged(new ChangeEvent(this));
            }
        };
        this.refresh(true);
    }

    public void setExpansionRatio(double d) {
        this.fExpansionRatio = d;
    }

    public double getExpansionRatio() {
        return this.fExpansionRatio;
    }

    public void update(File file, XmlReader xmlReader) {
        EntryPointFileDataWidget entryPointFileDataWidget;
        if (!this.fSettingData && (entryPointFileDataWidget = this.fWidgets.get(file)) != null) {
            entryPointFileDataWidget.setData(xmlReader);
        }
    }

    public void fileChanged(final File file) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                EntryPointFileDataWidget entryPointFileDataWidget = (EntryPointFileDataWidget)InputTypesTree.this.fWidgets.get(file);
                if (entryPointFileDataWidget != null) {
                    entryPointFileDataWidget.fileChanged();
                }
            }
        });
    }

    public void refresh(final boolean bl) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Icon icon;
                InputTypesTree.this.fComponent.removeAll();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(3, 3, 3, 3);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.anchor = 17;
                Set set = InputTypesTree.this.fModel.getEntryPointFileSet().getFiles();
                for (Object object : set) {
                    icon = ((File)object).exists() ? FileTypeIcon.M_FUNCTION.getIcon() : IconUtils.createBadgedIcon((ImageIcon)FileTypeIcon.M_FUNCTION.getIcon(), (ImageIcon)DialogIcon.ERROR_10x10.getIcon(), (int)8, (int)8, (int)7, (int)7);
                    MJLabel mJLabel = new MJLabel(((File)object).getName());
                    mJLabel.setIcon(icon);
                    InputTypesTree.this.fComponent.add((Component)mJLabel, (Object)gridBagConstraints);
                    ++gridBagConstraints.gridy;
                    if (((File)object).exists()) {
                        EntryPointFileDataWidget entryPointFileDataWidget = InputTypesTree.this.getOrCreateWidget((File)object);
                        InputTypesTree.this.fComponent.add(entryPointFileDataWidget.getComponent(), (Object)gridBagConstraints);
                    }
                    ++gridBagConstraints.gridy;
                }
                Iterator<Object> iterator = InputTypesTree.this.fWidgets.entrySet().iterator();
                while (iterator.hasNext()) {
                    Object object;
                    object = (Map.Entry)iterator.next();
                    if (!set.contains(object.getKey())) {
                        ((EntryPointFileDataWidget)object.getValue()).removeChangeListener(InputTypesTree.this.fChangeListenerAdapter);
                        ((EntryPointFileDataWidget)object.getValue()).dispose();
                        iterator.remove();
                        continue;
                    }
                    if (!bl || (icon = InputTypesTree.this.fModel.getInputTypeData((File)object.getKey())) == null) continue;
                    ((EntryPointFileDataWidget)object.getValue()).setData((XmlReader)icon);
                }
                InputTypesTree.this.fComponent.revalidate();
                InputTypesTree.this.fComponent.repaint();
            }
        });
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }

    private EntryPointFileDataWidget getOrCreateWidget(File file) {
        EntryPointFileDataWidget entryPointFileDataWidget = this.fWidgets.get(file);
        return entryPointFileDataWidget == null ? this.createWidget(file) : entryPointFileDataWidget;
    }

    private EntryPointFileDataWidget createWidget(final File file) {
        final EntryPointFileDataWidget entryPointFileDataWidget = new EntryPointFileDataWidget(this.fModel.getConfiguration(), file, this.fHelpPathResolver, true){

            @Override
            protected InputTable createInputTable(Configuration configuration, EntryPoint entryPoint, boolean bl, IDPChangeListener iDPChangeListener, Runnable runnable, ReturnRunnable<String> returnRunnable) {
                return new InputTable(configuration, entryPoint, bl, iDPChangeListener, runnable, returnRunnable){

                    @Override
                    public JComponent getComponent() {
                        return (JComponent)this.getTable().getTableComponent();
                    }
                };
            }
        };
        entryPointFileDataWidget.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                InputTypesTree.this.fSettingData = true;
                InputTypesTree.this.fModel.getEntryPointFileSet().setCustomData(file, entryPointFileDataWidget.getData().getXML());
                InputTypesTree.this.fSettingData = false;
            }
        });
        entryPointFileDataWidget.addChangeListener(this.fChangeListenerAdapter);
        this.fWidgets.put(file, entryPointFileDataWidget);
        return entryPointFileDataWidget;
    }

    private class Wrapper
    extends MJPanel
    implements Scrollable {
        private final MJTree fTree = new MJTree();

        private Wrapper() {
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(dimension.width, (int)((double)dimension.height * InputTypesTree.this.fExpansionRatio));
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            Dimension dimension = this.getPreferredSize();
            dimension.height = Math.min(dimension.height, 200);
            return dimension;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return this.fTree.getScrollableUnitIncrement(rectangle, n, n2);
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return this.fTree.getScrollableBlockIncrement(rectangle, n, n2);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return this.getParent() != null && this.getParent() instanceof JViewport && (double)this.getParent().getWidth() > this.getPreferredSize().getWidth();
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return this.getParent() != null && this.getParent() instanceof JViewport && (double)this.getParent().getHeight() > this.getPreferredSize().getHeight();
        }
    }
}

