/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.verification;

import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.core.DropDownButton;
import com.mathworks.toolbox.coder.wfa.toolbar.ToolbarUtils;
import com.mathworks.util.ReturnRunnable;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

public class TestDropDownButton
extends DropDownButton {
    private final CoderApp fApp;
    private final String fText;
    private final int fTextWidth;

    public TestDropDownButton(CoderApp coderApp, Runnable runnable, ReturnRunnable<Boolean> returnRunnable) {
        this.fApp = coderApp;
        this.setName("wfa.button.test");
        this.fText = CoderResources.getString("wfa.test");
        this.fTextWidth = ToolbarUtils.getTextWidth(this.fText);
        this.setShortcutAction(runnable);
        this.setReady(returnRunnable);
    }

    @Override
    public void paintMainContent(Graphics2D graphics2D) {
        graphics2D.setStroke(new BasicStroke(1.7f));
        GeneralPath generalPath = new GeneralPath();
        int n = 22;
        generalPath.append(new Line2D.Double(8.0, 6.0, n - 7, this.getHeight() / 2), true);
        generalPath.append(new Line2D.Double(n - 7, this.getHeight() / 2, 7.0, this.getHeight() - 6), true);
        generalPath.append(new Line2D.Double(7.0, this.getHeight() - 7, 7.0, 6.0), true);
        ToolbarUtils.drawString((Component)((Object)this), graphics2D, this.fText, 22.0);
        graphics2D.fill(generalPath);
    }

    @Override
    public Dimension getMainPreferredSize() {
        return new Dimension(30 + this.fTextWidth, 22);
    }

    public String getToolTipText() {
        return ToolbarUtils.getTestButtonToolTip(this.fApp);
    }
}

