/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.widgets;

import com.mathworks.toolbox.coder.app.GlassPaneManager;
import com.mathworks.toolbox.coder.app.GlassPaneWidget;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jetbrains.annotations.Nullable;

public final class GlassPaneCloseButton
implements GlassPaneWidget {
    private final GlassPaneManager fGlassPane;
    private final Runnable fCloseRunnable;
    private final Component fHostComponent;
    private final ComponentListener fComponentListener;
    private final Timer fHoverTimer;
    private final Dimension fOffset;
    private final String fTooltip;
    private boolean fHidden;
    private RoundRectangle2D.Double fButton;

    public GlassPaneCloseButton(GlassPaneManager glassPaneManager, Component component, Runnable runnable, @Nullable String string, @Nullable Dimension dimension) {
        this.fGlassPane = glassPaneManager;
        this.fCloseRunnable = runnable;
        this.fHostComponent = component;
        this.fTooltip = string;
        this.fOffset = dimension != null ? dimension : new Dimension(-48, 6);
        this.fGlassPane.add(this);
        this.fComponentListener = this.createComponentListener();
        this.fHostComponent.addComponentListener(this.fComponentListener);
        this.regenerateShape();
        this.fHoverTimer = new Timer(20, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GlassPaneCloseButton.this.fGlassPane.repaint();
            }
        });
        this.fHoverTimer.setRepeats(true);
        this.fHoverTimer.start();
    }

    public GlassPaneCloseButton(GlassPaneManager glassPaneManager, Component component, Runnable runnable, @Nullable String string) {
        this(glassPaneManager, component, runnable, string, null);
    }

    private ComponentListener createComponentListener() {
        return new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                GlassPaneCloseButton.this.regenerateShape();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                GlassPaneCloseButton.this.regenerateShape();
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                GlassPaneCloseButton.this.fHidden = false;
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                GlassPaneCloseButton.this.fHidden = true;
            }
        };
    }

    private void regenerateShape() {
        Point point = SwingUtilities.convertPoint(this.fHostComponent.getParent(), this.fHostComponent.getLocation(), this.fGlassPane.getPane());
        Point2D.Double double_ = new Point2D.Double(point.getX() + (double)this.fHostComponent.getWidth() + this.fOffset.getWidth(), point.getY() + this.fOffset.getHeight());
        this.fButton = new RoundRectangle2D.Double(((Point2D)double_).getX(), ((Point2D)double_).getY(), 24.0, 24.0, 24.0, 24.0);
    }

    public void close() {
        if (this.fCloseRunnable != null) {
            this.fCloseRunnable.run();
        }
        this.dispose();
    }

    public void dispose() {
        this.fHoverTimer.stop();
        this.fGlassPane.remove(this);
        this.fHostComponent.removeComponentListener(this.fComponentListener);
    }

    @Override
    @Nullable
    public String getTooltip(Point point) {
        return this.fTooltip;
    }

    @Override
    public void paint(Component component, Graphics2D graphics2D) {
        Object object;
        if (this.fHidden) {
            return;
        }
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        double d = 0.6;
        if (pointerInfo != null && (object = pointerInfo.getLocation()) != null) {
            SwingUtilities.convertPointFromScreen((Point)object, component);
            double d2 = ((Point2D)object).distance(new Point((int)this.fButton.getBounds().getCenterX(), (int)this.fButton.getBounds().getCenterY()));
            d = Math.max(0.6, 1.0 - d2 / 500.0);
        }
        object = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, (float)d));
        Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double d3 = 0.5;
        double d4 = d;
        for (int i = 1; i < 3; ++i) {
            Area area = new Area(new RoundRectangle2D.Double(this.fButton.getX() + (double)i / 2.0, this.fButton.getY() + (double)i / 2.0, this.fButton.getWidth(), this.fButton.getHeight(), this.fButton.getWidth(), this.fButton.getHeight()));
            area.subtract(new Area(this.fButton));
            d -= d3 * d;
            graphics2D.setComposite(AlphaComposite.getInstance(3, (float)Math.max(0.01, d)));
            graphics2D.draw(area);
        }
        graphics2D.setComposite(AlphaComposite.getInstance(3, (float)d4));
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(this.fButton);
        graphics2D.setColor(Color.BLACK);
        Rectangle rectangle = this.fButton.getBounds();
        graphics2D.fill(new RoundRectangle2D.Double(((RectangularShape)rectangle).getX() + 3.0, ((RectangularShape)rectangle).getY() + 3.0, ((RectangularShape)rectangle).getWidth() - 6.0, ((RectangularShape)rectangle).getHeight() - 6.0, ((RectangularShape)rectangle).getWidth() - 6.0, ((RectangularShape)rectangle).getHeight() - 6.0));
        graphics2D.setColor(Color.WHITE);
        graphics2D.setStroke(new BasicStroke(2.0f, 1, 1));
        graphics2D.draw(new Line2D.Double(((RectangularShape)rectangle).getX() + 8.0, ((RectangularShape)rectangle).getY() + 8.0, ((RectangularShape)rectangle).getX() + ((RectangularShape)rectangle).getWidth() - 9.0, ((RectangularShape)rectangle).getY() + ((RectangularShape)rectangle).getHeight() - 9.0));
        graphics2D.draw(new Line2D.Double(((RectangularShape)rectangle).getX() + 8.0, ((RectangularShape)rectangle).getY() + ((RectangularShape)rectangle).getHeight() - 9.0, ((RectangularShape)rectangle).getX() + ((RectangularShape)rectangle).getWidth() - 9.0, ((RectangularShape)rectangle).getY() + 8.0));
        graphics2D.setComposite((Composite)object);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object2);
    }

    @Override
    public boolean contains(int n, int n2) {
        return this.fButton != null && this.fButton.contains(n, n2);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.close();
    }

    @Override
    @Nullable
    public Rectangle getBounds() {
        return this.fButton != null ? this.fButton.getBounds() : new Rectangle(0, 0, 0, 0);
    }
}

