/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.widgets;

import com.mathworks.mwswing.MJButton;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.util.ReturnRunnable;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class Widgets {
    private static Map<Component, Runnable> sFocusComponents;
    private static AWTEventListener sGlobalListener;

    private Widgets() {
    }

    public static void makeComponentLoseFocusOnClicks(final Component component, final @NotNull Runnable runnable) {
        if (sFocusComponents == null) {
            sFocusComponents = new HashMap<Component, Runnable>();
        }
        if (sGlobalListener == null) {
            sGlobalListener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent aWTEvent) {
                    if ((aWTEvent.getID() == 502 || aWTEvent.getID() == 500) && aWTEvent instanceof MouseEvent) {
                        Window window;
                        Component component = ((MouseEvent)aWTEvent).getComponent();
                        Window window2 = window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
                        if (sFocusComponents != null) {
                            Iterator iterator = sFocusComponents.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry entry = iterator.next();
                                Component component2 = (Component)entry.getKey();
                                Window window3 = SwingUtilities.getWindowAncestor(component2);
                                if (Utilities.areValuesDifferent(window3, window) || SwingUtilities.isDescendingFrom(component, component2)) continue;
                                ((Runnable)entry.getValue()).run();
                                iterator.remove();
                            }
                            if (sFocusComponents.isEmpty()) {
                                Toolkit.getDefaultToolkit().removeAWTEventListener(sGlobalListener);
                            }
                        }
                    }
                }
            };
            Toolkit.getDefaultToolkit().addAWTEventListener(sGlobalListener, 16L);
        }
        component.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (sFocusComponents.isEmpty()) {
                    Toolkit.getDefaultToolkit().addAWTEventListener(sGlobalListener, 16L);
                }
                sFocusComponents.put(component, runnable);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                sFocusComponents.remove(component);
                if (sFocusComponents.isEmpty()) {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(sGlobalListener);
                }
            }
        });
    }

    public static class MinimalDropDownButton
    extends MJButton {
        private static final int ARROW_WIDTH = 9;
        private static final int ARROW_HEIGHT = 6;
        private final Component fHost;
        private final ReturnRunnable<Boolean> fPaintApprover;

        public MinimalDropDownButton(Component component, ReturnRunnable<Boolean> returnRunnable) {
            this.fHost = component;
            this.fPaintApprover = returnRunnable;
            this.setBorder(null);
        }

        public MinimalDropDownButton(Component component) {
            this(component, new ReturnRunnable<Boolean>(){

                public Boolean run() {
                    return true;
                }
            });
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(this.fHost.getBackground());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (!((Boolean)this.fPaintApprover.run()).booleanValue()) {
                return;
            }
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(new Line2D.Double(this.getWidth() / 2 - 4, this.getHeight() / 2 - 3, this.getWidth() / 2 + 4, this.getHeight() / 2 - 3), true);
            generalPath.append(new Line2D.Double(this.getWidth() / 2 + 4, this.getHeight() / 2 - 3, this.getWidth() / 2, this.getHeight() / 2 + 3), true);
            generalPath.append(new Line2D.Double(this.getWidth() / 2, this.getHeight() / 2 + 3, this.getWidth() / 2 - 4, this.getHeight() / 2 - 3), true);
            graphics2D.setColor(Color.BLACK);
            graphics2D.fill(generalPath);
            graphics2D.draw(generalPath);
            graphics2D.dispose();
        }

        public Dimension getPreferredSize() {
            return new Dimension(18, 9);
        }
    }
}

