/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl;

import com.mathworks.mlwidgets.util.UIFileUtils;
import com.mathworks.mwswing.validation.Validity;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.ValidatableWithHelp;
import com.mathworks.widgets.ValidityWithHelp;
import java.io.File;

final class ProjectLocationValidator
implements ValidatableWithHelp {
    ProjectLocationValidator() {
    }

    private static boolean hasExistingWritableParent(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists() || !file.isDirectory()) {
            return ProjectLocationValidator.hasExistingWritableParent(file.getParentFile());
        }
        return NativeJava.canWrite((File)file);
    }

    private static boolean hasNonExistentInvalidNamedParent(File file) {
        return file != null && !file.exists() && (UIFileUtils.validateNameChars((String)file.getName()) != null || ProjectLocationValidator.hasNonExistentInvalidNamedParent(file.getParentFile()));
    }

    public ValidityWithHelp getValidity(String string) {
        File file = new File(string.trim());
        if (!file.exists()) {
            if (ProjectLocationValidator.hasExistingWritableParent(file)) {
                if (ProjectLocationValidator.hasNonExistentInvalidNamedParent(file)) {
                    if (PlatformInfo.isWindows()) {
                        return new ValidityWithHelp(Validity.INVALID, BuiltInResources.getString("errortip.name.invalidchar.win"));
                    }
                    return new ValidityWithHelp(Validity.INVALID, BuiltInResources.getString("errortip.name.invalidchar.unix"));
                }
                return new ValidityWithHelp(Validity.WARNING, BuiltInResources.getString("warningtip.location.create"));
            }
            return new ValidityWithHelp(Validity.INVALID, BuiltInResources.getString("errortip.location.nonexistent"));
        }
        return new ValidityWithHelp(Validity.VALID);
    }

    public ValidityWithHelp getValidityWhenBlank() {
        return new ValidityWithHelp(Validity.INVALID, BuiltInResources.getString("errortip.location.blank"));
    }
}

