/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl;

import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.tree.TreeUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.LineBorder;
import javax.swing.text.JTextComponent;

public final class TooltipWindow
extends MJDialog {
    private static final double SQUARE_ROOT_OF_TWO = Math.sqrt(2.0);
    private final AnchorSide fAnchorSide;
    private final TooltipWindowStyle fStyle;
    private final boolean fContainWithinParent;
    private final int fPaddingBelow;
    private final Component fParent;
    private final boolean fAllowFocus;
    private Component fContent;
    private Point fScreenAnchorPoint;
    private Point fAnchorPoint;
    private double fRatio = 1.0;
    private boolean fTransparent;
    private TooltipArrangement fArrangement;
    private Rectangle fEffectiveBounds;
    private Rectangle fOriginalBounds;
    private Rectangle fPopupRect;
    private Component fPopupOwner;
    private BufferedImage fChildBuffer;

    public TooltipWindow(Window window, Component component, boolean bl, boolean bl2, boolean bl3, int n, Color color, Color color2) {
        this(window, component, bl ? AnchorSide.POPUP_ABOVE : AnchorSide.POPUP_BELOW, new BasicTooltipWindowStyle(color2, color), bl2, bl3, n);
    }

    public TooltipWindow(Window window, Component component, AnchorSide anchorSide, boolean bl, boolean bl2, int n) {
        this(window, component, anchorSide, new BasicTooltipWindowStyle(), bl, bl2, n);
    }

    public TooltipWindow(Window window, Component component, AnchorSide anchorSide, TooltipWindowStyle tooltipWindowStyle, boolean bl, boolean bl2, int n) {
        super(window instanceof Frame ? (Frame)window : (Frame)null);
        this.fParent = component;
        this.fStyle = tooltipWindowStyle;
        this.fAnchorSide = anchorSide;
        this.fPaddingBelow = n;
        this.fContainWithinParent = bl;
        this.fAllowFocus = bl2;
        this.fTransparent = true;
        if (!this.fAllowFocus) {
            this.setFocusableWindowState(false);
        }
        this.setUndecorated(true);
        if (PlatformInfo.isLinux()) {
            this.setBackground(this.getStyleBackground());
        } else {
            this.setBackground(new Color(0, 0, 0, 0));
        }
        if (PlatformInfo.isMacintosh()) {
            this.getRootPane().putClientProperty("apple.awt.draggableWindowBackground", Boolean.FALSE);
        }
        this.setContentPane(new JComponent(){

            @Override
            public Dimension getPreferredSize() {
                return TooltipWindow.this.fArrangement != null ? new Dimension(((TooltipWindow)TooltipWindow.this).fArrangement.getWindowSize().width + 1, ((TooltipWindow)TooltipWindow.this).fArrangement.getWindowSize().height) : super.getPreferredSize();
            }
        });
        this.setLayout(null);
    }

    private Color getStyleBackground() {
        return this.fStyle.getBackgroundColor() != null ? this.fStyle.getBackgroundColor() : Color.WHITE;
    }

    private Color getStyleBorderColor() {
        return this.fStyle.getBorderColor() != null ? this.fStyle.getBorderColor() : Color.BLACK;
    }

    public boolean isAbove() {
        return this.fAnchorSide == AnchorSide.POPUP_ABOVE;
    }

    public Shape getVisualBounds() {
        return this.fArrangement != null ? this.fArrangement.getVisualShape() : this.getBounds();
    }

    public void setTransparent(boolean bl) {
        this.fTransparent = bl;
    }

    public void showWithAnimation(Component component, int n, int n2) {
        Timer[] timerArray;
        this.fRatio = 0.15;
        this.setFocusableWindowState(false);
        this.update(component, n, n2);
        this.show();
        timerArray = new Timer[]{new Timer(5, new ActionListener(){
            private double fIncrement = 0.3;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TooltipWindow.this.fRatio += this.fIncrement;
                this.fIncrement *= 0.8;
                if (TooltipWindow.this.fRatio >= 1.0) {
                    TooltipWindow.this.fRatio = 1.0;
                    timerArray[0].stop();
                    TooltipWindow.this.repaint();
                    TooltipWindow.this.setFocusableWindowState(TooltipWindow.this.fAllowFocus);
                    TooltipWindow.this.repaint();
                } else {
                    TooltipWindow.this.repaint();
                }
            }
        })};
        timerArray[0].setRepeats(true);
        timerArray[0].start();
    }

    public void close() {
        if (PlatformInfo.isMacintosh()) {
            this.closeWithAnimation();
        } else {
            this.dispose();
        }
    }

    private void closeWithAnimation() {
        Timer[] timerArray;
        timerArray = new Timer[]{new Timer(5, new ActionListener(){
            private double fIncrement = -0.04;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TooltipWindow.this.fRatio += this.fIncrement;
                TooltipWindow.this.fRatio = Math.max(0.0, TooltipWindow.this.fRatio);
                this.fIncrement *= 1.2;
                if (TooltipWindow.this.fRatio <= 0.15) {
                    timerArray[0].stop();
                    TooltipWindow.this.dispose();
                } else {
                    TooltipWindow.this.repaint();
                }
            }
        })};
        timerArray[0].setRepeats(true);
        timerArray[0].start();
    }

    public void update(Component component, int n, int n2) {
        if (component.getParent() != null) {
            component.getParent().remove(component);
        }
        if (PlatformInfo.isLinux()) {
            MJPanel mJPanel = new MJPanel();
            mJPanel.setBackground(this.getStyleBackground());
            mJPanel.add(component);
            ((JComponent)this.getContentPane()).setBorder(new LineBorder(this.getStyleBorderColor()));
            this.fContent = mJPanel;
        } else {
            this.fContent = component;
        }
        this.getContentPane().removeAll();
        this.getContentPane().add(this.fContent);
        this.setSizeAndLocation(n, n2);
    }

    public void doLayout() {
        super.doLayout();
        this.fContent.setBounds(this.fArrangement.getContentRect());
    }

    public Point getScreenAnchorPoint() {
        return this.fScreenAnchorPoint;
    }

    private TooltipArrangement calculateBounds() {
        int n;
        Dimension dimension = this.fContent.getPreferredSize();
        Insets insets = this.fStyle.getMargins(this.fAnchorSide, dimension);
        Rectangle rectangle = new Rectangle(insets.left, insets.top, dimension.width, dimension.height);
        Rectangle rectangle2 = new Rectangle(0, 0, (int)(rectangle.getMaxX() + (double)insets.right), (int)rectangle.getMaxY() + insets.bottom);
        if (this.fStyle.getFilletRadius() > 0) {
            n = this.fStyle.getFilletRadius();
            int n2 = (int)((double)n - (double)n / SQUARE_ROOT_OF_TWO + (double)Math.max(0, this.fStyle.getInscribedPadding()) / SQUARE_ROOT_OF_TWO);
            rectangle2.setSize(rectangle2.width + n2 * 2, rectangle2.height + n2 * 2);
            rectangle.setLocation(rectangle.x + n2, rectangle.y + n2);
        }
        n = this.fStyle.getLocationToAnchor(this.fAnchorSide, this.fAnchorSide == AnchorSide.POPUP_ABOVE || this.fAnchorSide == AnchorSide.POPUP_BELOW ? rectangle2.width : rectangle2.height);
        Dimension dimension2 = rectangle2.getSize();
        dimension2.setSize(dimension2.width + 2, dimension2.height + 2);
        Dimension dimension3 = this.fStyle.getArrowSize();
        if (dimension3 == null) {
            dimension3 = new Dimension();
        }
        Arrow arrow = this.fAnchorSide.arrowify(rectangle2, rectangle, dimension2, dimension3, n);
        return new TooltipArrangement(rectangle2, arrow, rectangle, dimension2);
    }

    public void setSizeAndLocation(int n, int n2) {
        this.fArrangement = this.calculateBounds();
        this.pack();
        this.setLocation(this.fAnchorSide.locate(new Point(n, n2), this.fArrangement.getArrow().getTipPoint(), this.fArrangement.getWindowSize(), this.fPaddingBelow));
        Point point = this.fParent.getLocation();
        SwingUtilities.convertPointToScreen(point, this.fParent);
        if (this.fContainWithinParent && (double)this.getX() < point.getX()) {
            this.setLocation((int)point.getX() + 14, this.getY());
        }
        this.fAnchorPoint = this.fScreenAnchorPoint = new Point(n, n2);
        Rectangle rectangle = WindowUtils.getScreenBoundsWithOrNearestToPoint((Point)this.fScreenAnchorPoint);
        if (rectangle != null) {
            if ((double)this.getX() < rectangle.getX()) {
                this.setLocation((int)rectangle.getX(), this.getY());
            }
            if ((double)(this.getX() + this.getWidth()) > rectangle.getX() + rectangle.getWidth()) {
                this.setLocation((int)(rectangle.getX() + rectangle.getWidth() - (double)this.getWidth()), this.getY());
            }
        }
        this.updateEffectiveBounds();
        SwingUtilities.convertPointFromScreen(this.fAnchorPoint, (Component)((Object)this));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TooltipWindow.this.updateEffectiveBounds();
                TooltipWindow.this.revalidate();
                TooltipWindow.this.repaint();
            }
        });
    }

    private void updateEffectiveBounds() {
        this.fOriginalBounds = this.getBounds();
        this.fEffectiveBounds = this.getBounds();
        this.fEffectiveBounds.x = 0;
        this.fEffectiveBounds.y = 0;
    }

    private Rectangle effectiveBounds() {
        if (this.fEffectiveBounds == null) {
            this.updateEffectiveBounds();
        }
        return this.fEffectiveBounds;
    }

    public void setPopupRect(Component component, Rectangle rectangle) {
        if (rectangle == null && component != this.fPopupOwner) {
            return;
        }
        if (this.fPopupRect != null) {
            this.setBounds(this.fOriginalBounds);
        }
        this.fPopupRect = rectangle;
        this.fPopupOwner = component;
        if (rectangle != null) {
            this.setLocation(Math.min(this.getX(), rectangle.x), Math.min(this.getY(), rectangle.y));
            this.setSize((int)Math.max((double)this.getWidth(), rectangle.getX() + rectangle.getWidth() - (double)this.getX()), (int)Math.max((double)this.getHeight(), rectangle.getY() + rectangle.getHeight() - (double)this.getY()));
        }
    }

    private int constrainToWidth(int n) {
        return Math.max(0, Math.min(n, this.getWidth()));
    }

    public void paint(Graphics graphics) {
        Object object;
        Object object2;
        if (PlatformInfo.isLinux()) {
            super.paint(graphics);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setColor(new Color(0, 0, 0, 0));
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(1.0, 1.0);
        Area area = this.fArrangement.getVisualShape().createTransformedArea(affineTransform);
        area.subtract(this.fArrangement.getVisualShape());
        float f = 0.2f;
        int n = this.fStyle.getShadowLength();
        for (int i = 0; i < n; ++i) {
            graphics2D.setColor(new Color(0.0f, 0.0f, 0.0f, f));
            graphics2D.fill(area);
            area.transform(affineTransform);
            if (PlatformInfo.isMacintosh()) {
                f = (float)((double)f * 0.6);
                continue;
            }
            f /= 2.0f;
        }
        Color color = this.getStyleBackground();
        assert (color != null);
        if (!PlatformInfo.isLinux() && this.fTransparent) {
            if (color.getAlpha() == 255) {
                color = new Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, this.fStyle.getOpacity());
            }
        } else if (color.getAlpha() != 255) {
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255);
        }
        graphics2D.setColor(color);
        graphics2D.fill(this.fArrangement.getVisualShape());
        graphics2D.setColor(this.getStyleBorderColor());
        graphics2D.draw(this.fArrangement.getVisualShape());
        if (!PlatformInfo.isMacintosh() && this.fTransparent) {
            object2 = new ArrayList();
            object2.addAll(TreeUtils.findComponents((Component)((Object)this), JTextComponent.class));
            object2.addAll(TreeUtils.findComponents((Component)((Object)this), JLabel.class));
            object2.addAll(TreeUtils.findComponents((Component)((Object)this), JCheckBox.class));
            object = object2.iterator();
            while (object.hasNext()) {
                Component component = (Component)object.next();
                Rectangle rectangle = SwingUtilities.convertRectangle(component.getParent(), component.getBounds(), (Component)((Object)this));
                int n2 = (int)(10.0 - 10.0 / SQUARE_ROOT_OF_TWO);
                rectangle.grow(n2, n2);
                for (int i = 0; i < 8; ++i) {
                    graphics2D.setColor(new Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)((double)this.fStyle.getOpacity() * 0.92 + (double)i * 0.01)));
                    graphics2D.fill(new RoundRectangle2D.Double(rectangle.x + i, rectangle.y + i, rectangle.width - i * 2, rectangle.height - i * 2, 10.0, 10.0));
                }
            }
        }
        if (this.fRatio >= 1.0) {
            assert (!PlatformInfo.isLinux()) : "The following logic assumes a transparent background, which we only set on a non-Linux machine";
            object2 = this.cleanAndGetBuffer();
            object = ((BufferedImage)object2).createGraphics();
            ((Graphics2D)object).setRenderingHints(graphics2D.getRenderingHints());
            this.paintComponents((Graphics)object);
            ((Graphics)object).dispose();
            graphics.drawImage((Image)object2, 0, 0, null);
        }
        graphics2D.dispose();
    }

    private BufferedImage cleanAndGetBuffer() {
        if (this.fChildBuffer == null || this.fChildBuffer.getWidth() != this.getWidth() || this.fChildBuffer.getHeight() != this.getHeight()) {
            this.fChildBuffer = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(this.getWidth(), this.getHeight(), 3);
        } else {
            Graphics2D graphics2D = this.fChildBuffer.createGraphics();
            graphics2D.setComposite(AlphaComposite.getInstance(1));
            graphics2D.setColor(Color.BLACK);
            graphics2D.fillRect(0, 0, this.fChildBuffer.getWidth(), this.fChildBuffer.getHeight());
            graphics2D.dispose();
        }
        return this.fChildBuffer;
    }

    private static Arrow createArrow(Point point, Dimension dimension, int n, int n2, int n3, int n4) {
        GeneralPath generalPath = null;
        if (dimension.height * dimension.width > 0) {
            generalPath = new GeneralPath();
            int n5 = dimension.width / 2;
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(-n5 * n, -n5 * n2);
            generalPath.lineTo(n3 * dimension.height, n4 * dimension.height);
            generalPath.lineTo(n5 * n, n5 * n2);
            generalPath.closePath();
            generalPath.transform(AffineTransform.getTranslateInstance(point.x, point.y));
        }
        return new Arrow(generalPath, point, new Point(point.x + n3 * dimension.width, point.y + n4 * dimension.height));
    }

    public static interface TooltipWindowStyle {
        public Insets getMargins(AnchorSide var1, Dimension var2);

        public int getLocationToAnchor(AnchorSide var1, int var2);

        public int getFilletRadius();

        public float getOpacity();

        public Color getBorderColor();

        public Color getBackgroundColor();

        public Dimension getArrowSize();

        public int getInscribedPadding();

        public int getShadowLength();
    }

    private static class Arrow {
        private final Shape fShape;
        private final Point fBasePoint;
        private final Point fTipPoint;

        Arrow(Shape shape, Point point, Point point2) {
            this.fShape = shape;
            this.fBasePoint = point;
            this.fTipPoint = point2;
        }

        boolean isRenderable() {
            return this.fShape != null;
        }

        Shape getShape() {
            return this.fShape;
        }

        Point getTipPoint() {
            return this.fTipPoint;
        }
    }

    public static enum AnchorSide {
        POPUP_ABOVE{

            @Override
            int constrainToRect(Rectangle rectangle, int n) {
                return Math.max(0, Math.min(n, rectangle.width));
            }

            @Override
            Arrow arrowify(Rectangle rectangle, Rectangle rectangle2, Dimension dimension, Dimension dimension2, int n) {
                dimension.setSize(dimension.width, dimension.height + dimension2.height);
                return TooltipWindow.createArrow(new Point(n + rectangle.x, (int)rectangle.getMaxY()), dimension2, 1, 0, 0, 1);
            }

            @Override
            Point locate(Point point, Point point2, Dimension dimension, int n) {
                return new Point(point.x - point2.x, point.y - dimension.height - n);
            }
        }
        ,
        POPUP_BELOW{

            @Override
            int constrainToRect(Rectangle rectangle, int n) {
                return POPUP_ABOVE.constrainToRect(rectangle, n);
            }

            @Override
            Arrow arrowify(Rectangle rectangle, Rectangle rectangle2, Dimension dimension, Dimension dimension2, int n) {
                POPUP_ABOVE.arrowify(rectangle, rectangle2, dimension, dimension2, n);
                rectangle.setLocation(rectangle.x, rectangle.y + dimension2.height);
                rectangle2.setLocation(rectangle2.x, rectangle2.y + dimension2.height);
                return TooltipWindow.createArrow(new Point(n + rectangle.x, rectangle.y), dimension2, 1, 0, 0, -1);
            }

            @Override
            Point locate(Point point, Point point2, Dimension dimension, int n) {
                return new Point(point.x - point2.x, point.y + n);
            }
        }
        ,
        POPUP_ON_LEFT{

            @Override
            int constrainToRect(Rectangle rectangle, int n) {
                return Math.max(0, Math.min(n, rectangle.height));
            }

            @Override
            Arrow arrowify(Rectangle rectangle, Rectangle rectangle2, Dimension dimension, Dimension dimension2, int n) {
                dimension.setSize(dimension.width + dimension2.width, dimension.height);
                return TooltipWindow.createArrow(new Point((int)rectangle.getMaxX(), n + rectangle.y), dimension2, 0, 1, 1, 0);
            }

            @Override
            Point locate(Point point, Point point2, Dimension dimension, int n) {
                return new Point(point.x - n - dimension.width, point.y - point2.y);
            }
        }
        ,
        POPUP_ON_RIGHT{

            @Override
            int constrainToRect(Rectangle rectangle, int n) {
                return POPUP_ON_LEFT.constrainToRect(rectangle, n);
            }

            @Override
            Arrow arrowify(Rectangle rectangle, Rectangle rectangle2, Dimension dimension, Dimension dimension2, int n) {
                POPUP_ON_LEFT.arrowify(rectangle, rectangle2, dimension, dimension2, n);
                rectangle2.setLocation(rectangle2.x + dimension2.width, rectangle2.y);
                rectangle.setLocation(rectangle.x + dimension2.height, rectangle.y);
                return TooltipWindow.createArrow(new Point(rectangle.x, rectangle.y + n), dimension2, 0, 1, -1, 0);
            }

            @Override
            Point locate(Point point, Point point2, Dimension dimension, int n) {
                return new Point(point.x + n, point.y - point2.y);
            }
        };


        abstract int constrainToRect(Rectangle var1, int var2);

        abstract Arrow arrowify(Rectangle var1, Rectangle var2, Dimension var3, Dimension var4, int var5);

        abstract Point locate(Point var1, Point var2, Dimension var3, int var4);
    }

    private class TooltipArrangement {
        private final Rectangle fBalloon;
        private final Arrow fArrow;
        private final Rectangle fContentRect;
        private final Dimension fWindowSize;
        private final Area fVisualShape;

        TooltipArrangement(Rectangle rectangle, Arrow arrow, Rectangle rectangle2, Dimension dimension) {
            this.fBalloon = rectangle;
            this.fArrow = arrow;
            this.fContentRect = rectangle2;
            this.fWindowSize = dimension;
            this.fVisualShape = new Area(new RoundRectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height, TooltipWindow.this.fStyle.getFilletRadius(), TooltipWindow.this.fStyle.getFilletRadius()));
            if (this.fArrow.isRenderable()) {
                this.fVisualShape.add(new Area(this.getArrow().getShape()));
            }
        }

        public Rectangle getBalloon() {
            return this.fBalloon;
        }

        public Arrow getArrow() {
            return this.fArrow;
        }

        public Rectangle getContentRect() {
            return this.fContentRect;
        }

        public Dimension getWindowSize() {
            return this.fWindowSize;
        }

        public Area getVisualShape() {
            return this.fVisualShape;
        }
    }

    public static class BasicTooltipWindowStyle
    implements TooltipWindowStyle {
        private Color fBorderColor;
        private Color fBackgroundColor;
        private Dimension fArrowSize;
        private float fOpacity = PlatformInfo.isMacintosh() ? 0.93f : 0.85f;
        private int fAnchorSidePadding = 8;
        private int fGeneralPadding = 6;
        private int fInscribedPadding;
        private int fFilletRadius = PlatformInfo.isMacintosh() ? 6 : 0;
        private int fShadowLength = 5;

        public BasicTooltipWindowStyle() {
            this.fArrowSize = new Dimension(8, 8);
        }

        public BasicTooltipWindowStyle(Color color, Color color2) {
            this();
            this.fBorderColor = color;
            this.fBackgroundColor = color2;
        }

        @Override
        public Insets getMargins(AnchorSide anchorSide, Dimension dimension) {
            Insets insets = new Insets(this.fGeneralPadding, this.fGeneralPadding, this.fGeneralPadding, this.fGeneralPadding);
            if (this.fAnchorSidePadding != 0) {
                switch (anchorSide) {
                    case POPUP_ABOVE: {
                        insets.bottom = this.fAnchorSidePadding;
                        break;
                    }
                    case POPUP_BELOW: {
                        insets.top = this.fAnchorSidePadding;
                        break;
                    }
                    case POPUP_ON_LEFT: {
                        insets.right = this.fAnchorSidePadding;
                        break;
                    }
                    case POPUP_ON_RIGHT: {
                        insets.left = this.fAnchorSidePadding;
                    }
                }
            }
            return insets;
        }

        @Override
        public int getLocationToAnchor(AnchorSide anchorSide, int n) {
            return n / 2;
        }

        @Override
        public int getFilletRadius() {
            return this.fFilletRadius;
        }

        @Override
        public float getOpacity() {
            return this.fOpacity;
        }

        @Override
        public Color getBorderColor() {
            return this.fBorderColor;
        }

        @Override
        public Color getBackgroundColor() {
            return this.fBackgroundColor;
        }

        @Override
        public Dimension getArrowSize() {
            return this.fArrowSize != null ? new Dimension(this.fArrowSize) : null;
        }

        @Override
        public int getInscribedPadding() {
            return this.fInscribedPadding;
        }

        @Override
        public int getShadowLength() {
            return this.fShadowLength;
        }

        public void setShadowLength(int n) {
            this.fShadowLength = n;
        }

        public void setBorderColor(Color color) {
            this.fBorderColor = color;
        }

        public void setBackgroundColor(Color color) {
            this.fBackgroundColor = color;
        }

        public void setArrowSize(Dimension dimension) {
            this.fArrowSize = dimension;
        }

        public void setOpacity(float f) {
            this.fOpacity = f;
        }

        public void setFilletRadius(int n) {
            this.fFilletRadius = n;
        }

        public void setAnchorSidePadding(int n) {
            this.fAnchorSidePadding = n;
        }

        public void setGeneralPadding(int n) {
            this.fGeneralPadding = n;
        }

        public void setInscribedPadding(int n) {
            this.fInscribedPadding = n;
        }
    }
}

