/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.desktop;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mvm.context.MvmContext;
import com.mathworks.mvm.exec.MatlabExecutor;
import com.mathworks.mvm.exec.MatlabFevalRequest;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.api.DeploymentProcessMonitor;
import com.mathworks.project.api.SubProcessType;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.ResourceUtils;
import com.mathworks.project.impl.desktop.ToolstripProjectClient;
import com.mathworks.project.impl.logui.BufferedLogSource;
import com.mathworks.project.impl.logui.LogFileDisplay;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.BusyAffordance;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public abstract class AbstractPackageDialog
extends MJDialog {
    private final DeploymentProcess fProcess;
    private final File fLogFile;
    private final Configuration fConfiguration;
    private boolean fFinished;
    private boolean fWasThereAnError = false;
    private BufferedLogSource fLogSource;
    private LogFileDisplay fLogFileDisplay;
    private MJLabel fStatusLabel;
    private MJPanel fStatusPanel;
    private MJButton fCancelButton;
    private MJCheckBox fCheckBox;
    private HyperlinkTextLabel fArtifactHyperlink;
    private HyperlinkTextLabel fErrorHyperlink;
    private static final boolean sIsDesktopSupported = Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE) && Desktop.getDesktop().isSupported(Desktop.Action.OPEN);

    public AbstractPackageDialog(ToolstripProjectClient toolstripProjectClient, DeploymentProcess deploymentProcess) {
        super(toolstripProjectClient == null ? null : (Frame)SwingUtilities.windowForComponent(toolstripProjectClient.getComponent()), BuiltInResources.getString("progress.package.title"), false);
        this.fProcess = deploymentProcess;
        this.fConfiguration = (Configuration)this.fProcess.getConfiguration();
        this.fLogFile = this.getPackagingLogLocation(this.fConfiguration);
        this.setup(this.createContent());
    }

    public static boolean isDesktopSupported() {
        return sIsDesktopSupported;
    }

    protected abstract File getPackagingLogLocation(Configuration var1);

    public AbstractPackageDialog(DeploymentProcess deploymentProcess) {
        this(null, deploymentProcess);
    }

    public void setup(MJPanel mJPanel) {
        this.setName("progress.dialog");
        this.add((Component)mJPanel);
        this.finishInitializing();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (!AbstractPackageDialog.this.isFinished()) {
                    AbstractPackageDialog.this.fProcess.cancel();
                }
            }
        });
        WindowUtils.centerWindowOnParent((Window)((Object)this));
        this.pack();
        this.setResizable(false);
    }

    protected abstract BufferedLogSource getLogSource();

    protected abstract MJPanel createProcessPanel();

    protected abstract String getPreference();

    private MJPanel createBottomPanel() {
        this.fCheckBox = new MJCheckBox(BuiltInResources.getString("details.build.checkbox"));
        this.fCheckBox.setName("output.dir.checkbox");
        this.fCheckBox.setSelected(Prefs.getPref((String)this.getPreference()) == null || Prefs.getBooleanPref((String)this.getPreference()));
        this.fCheckBox.setOpaque(false);
        this.fCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Prefs.setBooleanPref((String)AbstractPackageDialog.this.getPreference(), (boolean)AbstractPackageDialog.this.fCheckBox.isSelected());
            }
        });
        this.fArtifactHyperlink = new HyperlinkTextLabel(BuiltInResources.getString("details.build.hyperlink"), new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                AbstractPackageDialog.this.openFileBrowser();
            }
        });
        this.fArtifactHyperlink.setHyperlinkColor(new Color(93, 134, 178));
        this.fArtifactHyperlink.setFontColor(new Color(93, 134, 178));
        this.fArtifactHyperlink.getComponent().setVisible(false);
        this.fArtifactHyperlink.getComponent().setBorder(BorderFactory.createEmptyBorder());
        this.fArtifactHyperlink.getComponent().setName("package.dialog.hyperlink");
        this.fErrorHyperlink = new HyperlinkTextLabel(BuiltInResources.getString("details.error.hyperlink"), new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                MatlabFevalRequest matlabFevalRequest = new MatlabFevalRequest("edit", Integer.valueOf(1), new Object[]{AbstractPackageDialog.this.fLogFile.getAbsolutePath()});
                MatlabExecutor matlabExecutor = MvmContext.get().getExecutor();
                matlabExecutor.submit(matlabFevalRequest);
            }
        });
        this.fErrorHyperlink.setHyperlinkColor(new Color(93, 134, 178));
        this.fErrorHyperlink.getComponent().setVisible(false);
        this.fErrorHyperlink.getComponent().setBorder(BorderFactory.createEmptyBorder());
        this.fErrorHyperlink.getComponent().setName("package.dialog.hyperlink");
        this.fCancelButton = new MJButton(BuiltInResources.getString("button.cancel"));
        this.fCancelButton.setName("progress.button.close");
        this.fCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractPackageDialog.this.fProcess.cancel();
                if (!AbstractPackageDialog.this.fFinished) {
                    AbstractPackageDialog.this.fCancelButton.setEnabled(false);
                } else {
                    AbstractPackageDialog.this.setVisible(false);
                }
            }
        });
        MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("8dlu:none, left:d:grow, 5dlu:none, fill:d:none, 8dlu:none", "4dlu:grow, center:d:none, 10dlu:none"));
        CellConstraints cellConstraints = new CellConstraints();
        if (sIsDesktopSupported) {
            mJPanel.add((Component)this.fCheckBox, (Object)cellConstraints.xy(2, 2));
        }
        mJPanel.add((Component)this.fCancelButton, (Object)cellConstraints.xy(4, 2));
        mJPanel.setOpaque(false);
        return mJPanel;
    }

    private MJPanel createContent() {
        MJPanel mJPanel = new MJPanel();
        this.setBackground(new Color(248, 248, 246));
        mJPanel.setOpaque(true);
        this.fLogSource = this.getLogSource();
        this.fLogSource.setProcess(this.fProcess);
        try {
            this.fLogFileDisplay = new LogFileDisplay(this.fLogFile);
            this.fLogSource.bind(this.fLogFileDisplay);
        }
        catch (IOException iOException) {
            MJOptionPane.showMessageDialog((Component)((Object)this), (Object)BuiltInResources.getString("savelog.error.nonwritable"), (String)BuiltInResources.getString("savelog.error.nonwritable.title"), (int)0);
        }
        MJPanel mJPanel2 = this.createProcessPanel();
        MJPanel mJPanel3 = this.createBottomPanel();
        mJPanel.setLayout((LayoutManager)new FormLayout("4dlu:none, fill:d:grow, center:d:grow, fill:d:grow, 4dlu:none", "4dlu:none, fill:d:none, fill:d:none, fill:d:none, 8dlu:none"));
        this.fStatusLabel = new MJLabel();
        this.fStatusPanel = new MJPanel((LayoutManager)new FlowLayout());
        this.fStatusPanel.add((Component)this.fStatusLabel);
        CellConstraints cellConstraints = new CellConstraints();
        mJPanel.add((Component)mJPanel2, (Object)cellConstraints.xyw(2, 2, 3));
        mJPanel.add((Component)this.fStatusPanel, (Object)cellConstraints.xyw(2, 3, 3));
        mJPanel.add((Component)mJPanel3, (Object)cellConstraints.xyw(2, 4, 3));
        this.fProcess.addMonitor(new DeploymentProcessMonitor(){

            public void subProcessStarted(SubProcessType subProcessType) {
                AbstractPackageDialog.this.initializeProcess(subProcessType);
            }

            public void commandStarted(String string) {
            }

            public void commandOutput(String string) {
            }

            public void commandError(String string) {
                if (string == null || !string.isEmpty() && !string.contains("operation completed successfully")) {
                    AbstractPackageDialog.this.fWasThereAnError = true;
                }
            }

            public void finished() {
                AbstractPackageDialog.this.finished(false);
            }

            public void failed() {
                AbstractPackageDialog.this.finished(true);
            }

            public void canceled() {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AbstractPackageDialog.this.setVisible(false);
                    }
                });
                AbstractPackageDialog.this.finished(true);
            }
        });
        return mJPanel;
    }

    protected abstract void initializeProcess(SubProcessType var1);

    protected abstract void updateProcessPanelForCompletion(boolean var1);

    protected abstract void updateProcessPanelForFailure();

    private void doFinishedActions(boolean bl) {
        if (this.fLogFileDisplay != null) {
            this.fLogFileDisplay.close();
        }
        if (bl) {
            HyperlinkTextLabel hyperlinkTextLabel;
            this.updateProcessPanelForCompletion(this.fWasThereAnError);
            this.fStatusPanel.removeAll();
            if (this.fWasThereAnError) {
                hyperlinkTextLabel = new HyperlinkTextLabel(BuiltInResources.getString("details.warning.hyperlink"), new HyperlinkTextLabel.HyperlinkHandler(){

                    public void processHyperlink(String string) {
                        MatlabFevalRequest matlabFevalRequest = new MatlabFevalRequest("edit", Integer.valueOf(1), new Object[]{AbstractPackageDialog.this.fLogFile.getAbsolutePath()});
                        MatlabExecutor matlabExecutor = MvmContext.get().getExecutor();
                        matlabExecutor.submit(matlabFevalRequest);
                    }
                });
                hyperlinkTextLabel.setHyperlinkColor(new Color(93, 134, 178));
                hyperlinkTextLabel.setFontColor(new Color(93, 134, 178));
                hyperlinkTextLabel.getComponent().setBorder(BorderFactory.createEmptyBorder());
                hyperlinkTextLabel.getComponent().setName("package.dialog.warning.hyperlink");
                hyperlinkTextLabel.getComponent().setVisible(true);
                this.fStatusPanel.add((Component)hyperlinkTextLabel.getComponent());
                this.fArtifactHyperlink.setText(BuiltInResources.getString("details.build.hyperlink.partial"));
            } else {
                this.fArtifactHyperlink.setText(BuiltInResources.getString("details.build.hyperlink"));
            }
            if (sIsDesktopSupported) {
                this.fStatusPanel.add((Component)this.fArtifactHyperlink.getComponent());
                this.fArtifactHyperlink.getComponent().setVisible(true);
                if (this.fCheckBox.isSelected()) {
                    this.openFileBrowser();
                }
            } else {
                hyperlinkTextLabel = new MJLabel(BuiltInResources.getString("details.build.complete"));
                this.fStatusPanel.add((Component)hyperlinkTextLabel);
            }
        } else {
            if (this.fLogFile.exists()) {
                this.fErrorHyperlink.setText(BuiltInResources.getString("details.error.hyperlink"));
            } else {
                this.fErrorHyperlink.setText(BuiltInResources.getString("details.error.hyperlink.partial"));
            }
            this.fStatusLabel.setVisible(false);
            this.fStatusPanel.add((Component)this.fErrorHyperlink.getComponent());
            this.fErrorHyperlink.getComponent().setVisible(true);
            this.updateProcessPanelForFailure();
        }
    }

    protected void openFileBrowser() {
        File file = this.fConfiguration.getParamKeys().contains("param.output") ? this.fConfiguration.getParamAsFile("param.output").getParentFile() : this.fConfiguration.getFile().getParentFile();
        if (PlatformInfo.isWindows()) {
            try {
                Runtime.getRuntime().exec("explorer.exe /select,\"" + this.fConfiguration.getParamAsFile("param.output") + "\"");
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            String string = file.getCanonicalPath();
            if (string.startsWith("\\\\")) {
                String string2 = "file:///" + new File(string).toURI().getRawPath();
                URI uRI = URI.create(string2);
                Desktop.getDesktop().browse(uRI);
            } else {
                Desktop.getDesktop().open(new File(string));
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog((Component)((Object)this), BuiltInResources.getString("error.open.browser"), BuiltInResources.getString("error.open.browser.title"), 0);
        }
    }

    private void finishInitializing() {
        this.setSize(this.getPreferredSize());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractPackageDialog.this.fCancelButton.requestFocus();
            }
        });
    }

    boolean isFinished() {
        return this.fFinished;
    }

    protected void setStatusLabel(String string) {
        this.fStatusLabel.setText(string);
    }

    private void finished(final boolean bl) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (AbstractPackageDialog.this.fFinished) {
                    return;
                }
                AbstractPackageDialog.this.doFinishedActions(!bl);
                AbstractPackageDialog.this.fCancelButton.setText(BuiltInResources.getString("button.close"));
                AbstractPackageDialog.this.fCancelButton.setEnabled(true);
                AbstractPackageDialog.this.fFinished = true;
            }
        });
    }

    protected static class ProcessStepPanel
    extends MJPanel {
        private MJLabel fIconLabel;
        private MJLabel fCompleteLabel;
        private MJLabel fCompleteWithWarningLabel;
        private MJLabel fFailedLabel;
        private BusyAffordance fBusyAffordance;
        private ImageIcon fActiveIcon;
        private ImageIcon fInactiveIcon;
        private String fActiveLabel;
        private boolean fIsComplete;

        public ProcessStepPanel(ImageIcon imageIcon, ImageIcon imageIcon2, String string) {
            this.fActiveIcon = imageIcon;
            this.fInactiveIcon = imageIcon2;
            this.fActiveLabel = string;
            this.fBusyAffordance = new BusyAffordance();
            this.fIconLabel = new MJLabel((Icon)this.fInactiveIcon);
            this.fCompleteLabel = new MJLabel((Icon)ResourceUtils.STEP_PASSED);
            this.fFailedLabel = new MJLabel((Icon)ResourceUtils.STEP_FAILED);
            this.fCompleteWithWarningLabel = new MJLabel((Icon)ResourceUtils.WARNING_ICO_24);
            this.setLayout((LayoutManager)new FormLayout("center:d:none", "center:d:none, 4dlu:none, 15dlu:none"));
            CellConstraints cellConstraints = new CellConstraints();
            this.add((Component)this.fIconLabel, cellConstraints.xy(1, 1));
            this.add(this.fBusyAffordance.getComponent(), cellConstraints.xy(1, 3));
            this.setOpaque(false);
        }

        public String getActiveLabel() {
            return this.fActiveLabel;
        }

        public void setActive() {
            this.fBusyAffordance.start();
            this.fIconLabel.setIcon((Icon)this.fActiveIcon);
        }

        public void setComplete() {
            this.setComplete(false);
        }

        public void setComplete(boolean bl) {
            this.fBusyAffordance.stop();
            this.fIconLabel.setIcon((Icon)this.fActiveIcon);
            this.remove(this.fBusyAffordance.getComponent());
            this.add((Component)(bl ? this.fCompleteWithWarningLabel : this.fCompleteLabel), new CellConstraints().xy(1, 3));
            this.fIsComplete = true;
        }

        public void setFailed() {
            this.fBusyAffordance.stop();
            this.fIconLabel.setIcon((Icon)this.fActiveIcon);
            this.remove(this.fBusyAffordance.getComponent());
            this.add((Component)this.fFailedLabel, new CellConstraints().xy(1, 3));
        }

        public boolean isComplete() {
            return this.fIsComplete;
        }
    }
}

