/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.desktop;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.ResourceUtils;
import com.mathworks.project.impl.desktop.DocumentHeaderPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.border.Border;

public class TwistOpenPanel
extends MJPanel {
    private ImageIcon fCloseIcon;
    private ImageIcon fOpenIcon;
    private DocumentHeaderPanel fHeaderPanel;
    private MJPanel fContent;
    private boolean fIsOpen;
    private boolean fCanTwist;
    private CellConstraints fCellConstraints;
    private boolean fShowHelpButton;
    private static final Color PANEL_BORDER = new Color(223, 224, 222);
    private static final Color PANEL_BACKGROUND = new Color(248, 248, 246);

    public TwistOpenPanel(String string, String string2, MJPanel mJPanel, boolean bl) {
        this(string, string2, mJPanel, bl, false, "", "");
    }

    public TwistOpenPanel(String string, String string2, MJPanel mJPanel, boolean bl, boolean bl2, String string3, String string4) {
        this.fShowHelpButton = bl2;
        this.fHeaderPanel = this.fShowHelpButton ? new DocumentHeaderPanel(string, true, string3, string4) : new DocumentHeaderPanel(string);
        FormLayout formLayout = new FormLayout("fill:pref:grow", "center:d:none, center:d:grow");
        this.fCellConstraints = new CellConstraints();
        this.setLayout((LayoutManager)formLayout);
        this.add((Component)((Object)this.fHeaderPanel), this.fCellConstraints.xy(1, 1));
        this.fShowHelpButton = bl2;
        this.fIsOpen = !bl;
        this.fCanTwist = bl;
        if (mJPanel != null) {
            this.setContent(mJPanel, string2 + ".panel");
        }
        if (this.fCanTwist) {
            this.fCloseIcon = ResourceUtils.TWIST_CLOSED;
            this.fOpenIcon = ResourceUtils.TWIST_OPEN;
            this.fHeaderPanel.getLabel().setIcon((Icon)this.fCloseIcon);
            this.fHeaderPanel.getLabel().setName(string2 + ".twist");
            this.fHeaderPanel.getLabel().addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    TwistOpenPanel.this.toggle(!TwistOpenPanel.this.fIsOpen);
                }
            });
            if (this.fContent != null) {
                this.fContent.setVisible(false);
            }
        }
    }

    private void setContent(MJPanel mJPanel, String string) {
        this.fContent = mJPanel;
        this.fContent.setName(string);
        this.fContent.setBackground(PANEL_BACKGROUND);
        this.fContent.setOpaque(true);
        this.fContent.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(PANEL_BORDER, 1), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.add((Component)this.fContent, this.fCellConstraints.xy(1, 2));
        if (!this.fIsOpen) {
            this.fContent.setVisible(false);
        }
    }

    public void setCustomBackground(Color color) {
        this.fContent.setBackground(color);
    }

    public void setCustomHeaderLabel(String string) {
        this.fHeaderPanel.setLabel(string);
    }

    public void setLineBorder() {
        this.fContent.setBorder(BorderFactory.createLineBorder(PANEL_BORDER, 1));
    }

    public void toggle(boolean bl) {
        if (this.fCanTwist) {
            if (bl) {
                this.fContent.setVisible(true);
                this.fHeaderPanel.getLabel().setIcon((Icon)this.fOpenIcon);
            } else {
                this.fContent.setVisible(false);
                this.fHeaderPanel.getLabel().setIcon((Icon)this.fCloseIcon);
            }
            this.fIsOpen = bl;
        }
    }

    public void flattenPanel() {
        this.fHeaderPanel.setBackground(PANEL_BACKGROUND);
        this.fContent.setBackground(PANEL_BACKGROUND);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.fContent.setBorder(BorderFactory.createEmptyBorder());
        this.fHeaderPanel.setTextColor(Color.BLACK);
        this.fCloseIcon = ResourceUtils.TWIST_CLOSED_BLACK;
        this.fOpenIcon = ResourceUtils.TWIST_OPEN_BLACK;
        this.fHeaderPanel.getLabel().setIcon((Icon)this.fCloseIcon);
    }
}

