/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.filesetui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.IconEnumerationUtils;
import com.mathworks.matlab.api.explorer.ExtensionRegistry;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.mlwidgets.explorer.model.ExplorerExtensionRegistry;
import com.mathworks.mlwidgets.explorer.model.MatlabPathModel;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.util.UiFileSystemUtils;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ProjectComponent;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.FileChooser;
import com.mathworks.project.impl.SectionPanel;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.FileSetFilter;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.project.impl.plugin.DepfunAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;

public class DefaultFileSetEditor
implements ProjectComponent {
    private MJPanel fFileSetPanel;
    private MJList fUserFilesList;
    private MJPanel fFilesListPanel = new MJPanel();
    private SortedFileModel fModel;
    private FileSetInstance fFileSet;
    private MJScrollPane fListScroller;
    private List<FileSetFilter> fFilters = null;
    private MJPopupMenu fPopupMenu;
    private static final String DELETE = "Delete";
    private Set<File> fDepfunFileList = null;
    private Configuration fConfiguration;
    private DepfunAction fDepfunAction;
    private static final int PREFERRED_CELL_WIDTH = 150;

    public DefaultFileSetEditor(FileSetInstance fileSetInstance, FileSetFilter fileSetFilter, Configuration configuration, DepfunAction depfunAction) {
        this(fileSetInstance, fileSetFilter, configuration, depfunAction, true);
    }

    public DefaultFileSetEditor(FileSetInstance fileSetInstance, FileSetFilter fileSetFilter, Configuration configuration, DepfunAction depfunAction, boolean bl) {
        this.fFileSet = fileSetInstance;
        this.fConfiguration = configuration;
        this.fDepfunAction = depfunAction;
        this.fFilters = new ArrayList<FileSetFilter>();
        this.fFilters.add(fileSetFilter);
        this.initializeComponents(bl);
        this.fUserFilesList.setName(this.fFileSet.getDefinition().getKey().toString());
    }

    private void initializeComponents(final boolean bl) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                MJButton mJButton;
                DefaultFileSetEditor.this.fFileSetPanel = new MJPanel();
                DefaultFileSetEditor.this.fModel = new SortedFileModel();
                DefaultFileSetEditor.this.fUserFilesList = new MJList((ListModel)DefaultFileSetEditor.this.fModel);
                DefaultFileSetEditor.this.fUserFilesList.setCellRenderer((ListCellRenderer)new NewTableCellRenderer(bl));
                DefaultFileSetEditor.this.fFileSetPanel.setLayout((LayoutManager)new FormLayout("fill:d:grow, 25px", "fill:d:grow, 15dlu"));
                CellConstraints cellConstraints = new CellConstraints();
                int n = bl ? 1 : 2;
                DefaultFileSetEditor.this.fFileSetPanel.add((Component)DefaultFileSetEditor.this.fFilesListPanel, (Object)cellConstraints.xywh(1, 1, n, n));
                DefaultFileSetEditor.this.fFileSetPanel.setOpaque(true);
                DefaultFileSetEditor.this.fFileSetPanel.setBackground(Color.WHITE);
                if (bl) {
                    mJButton = new MJButton();
                    mJButton.setIcon(BuiltInResources.getIcon("plus.png"));
                    mJButton.setOpaque(false);
                    mJButton.setBackground(SectionPanel.APP_INNER_BACKGROUND);
                    mJButton.setContentAreaFilled(false);
                    DefaultFileSetEditor.this.fPopupMenu = new MJPopupMenu();
                    MJMenuItem mJMenuItem = new MJMenuItem(DefaultFileSetEditor.DELETE);
                    mJMenuItem.setMnemonic(80);
                    mJMenuItem.getAccessibleContext().setAccessibleDescription(DefaultFileSetEditor.DELETE);
                    mJMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            DefaultFileSetEditor.this.deleteSelectedFiles();
                        }
                    });
                    DefaultFileSetEditor.this.fPopupMenu.add((JMenuItem)mJMenuItem);
                    mJButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            File file = MatlabPathModel.getInstance().getCurrentFolder().toFile();
                            FileChooser fileChooser = FileChooser.create((Component)DefaultFileSetEditor.this.fFileSetPanel, BuiltInResources.getString("dialog.title.addfiles"), file, true, DefaultFileSetEditor.this.fFileSet.getDefinition().getFilters());
                            File[] fileArray = fileChooser.showOpenDialog();
                            HashSet<File> hashSet = new HashSet();
                            if (fileArray != null) {
                                hashSet = DefaultFileSetEditor.this.recursiveFileAdd(hashSet, fileArray);
                                DefaultFileSetEditor.this.setData(hashSet);
                            }
                            if (DefaultFileSetEditor.this.fConfiguration != null) {
                                DefaultFileSetEditor.this.fDepfunAction.doDepfun();
                            }
                        }
                    });
                    DefaultFileSetEditor.this.fFileSetPanel.add((Component)mJButton, (Object)cellConstraints.xy(2, 2));
                    DefaultFileSetEditor.this.fUserFilesList.addMouseListener((MouseListener)new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent mouseEvent) {
                            if (SwingUtilities.isRightMouseButton(mouseEvent) && DefaultFileSetEditor.this.fUserFilesList.getSelectedIndex() >= 0 && DefaultFileSetEditor.this.fUserFilesList.getSelectedIndex() < DefaultFileSetEditor.this.fModel.getSize()) {
                                DefaultFileSetEditor.this.fPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                            }
                        }
                    });
                    KeyStroke keyStroke = KeyStroke.getKeyStroke("DELETE");
                    DefaultFileSetEditor.this.fUserFilesList.getInputMap().put(keyStroke, "deletefile");
                    DefaultFileSetEditor.this.fUserFilesList.getActionMap().put("deletefile", new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            DefaultFileSetEditor.this.deleteSelectedFiles();
                        }
                    });
                    mJButton.setName(DefaultFileSetEditor.this.fFileSet.getDefinition().getKey() + ".addfile");
                }
                DefaultFileSetEditor.this.fListScroller = new MJScrollPane(21, 31);
                DefaultFileSetEditor.this.fListScroller.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
                DefaultFileSetEditor.this.fListScroller.setOpaque(true);
                DefaultFileSetEditor.this.fListScroller.setBackground(Color.WHITE);
                DefaultFileSetEditor.this.fFilesListPanel.setLayout((LayoutManager)new FormLayout("left:pref:grow", "top:pref:grow"));
                DefaultFileSetEditor.this.fUserFilesList.setSelectionMode(2);
                DefaultFileSetEditor.this.fUserFilesList.setFixedCellHeight(25);
                DefaultFileSetEditor.this.fUserFilesList.setFixedCellWidth(150);
                DefaultFileSetEditor.this.fUserFilesList.setLayoutOrientation(1);
                DefaultFileSetEditor.this.fListScroller.getViewport().add((Component)DefaultFileSetEditor.this.fUserFilesList);
                mJButton = new CellConstraints();
                DefaultFileSetEditor.this.fFilesListPanel.add((Component)DefaultFileSetEditor.this.fListScroller, (Object)mJButton.xy(1, 1));
                DefaultFileSetEditor.this.fFilesListPanel.setOpaque(true);
                DefaultFileSetEditor.this.fFilesListPanel.setBackground(Color.WHITE);
                DefaultFileSetEditor.this.fUserFilesList.setOpaque(true);
                DefaultFileSetEditor.this.fUserFilesList.setBackground(Color.WHITE);
                DefaultFileSetEditor.this.refreshAll();
            }
        });
    }

    private void deleteSelectedFiles() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (DefaultFileSetEditor.this.fUserFilesList.getSelectedIndex() != -1 && DefaultFileSetEditor.this.fUserFilesList.getSelectedIndex() < DefaultFileSetEditor.this.fUserFilesList.getModel().getSize()) {
                    try {
                        List list = DefaultFileSetEditor.this.fUserFilesList.getSelectedValuesList();
                        DefaultFileSetEditor.this.removeFromFileSet(list);
                        for (File file : list) {
                            DefaultFileSetEditor.this.fModel.removeElement(file);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        return;
                    }
                    if (DefaultFileSetEditor.this.fUserFilesList.getSelectedIndex() >= DefaultFileSetEditor.this.fUserFilesList.getModel().getSize()) {
                        DefaultFileSetEditor.this.fUserFilesList.setSelectedIndex(DefaultFileSetEditor.this.fUserFilesList.getModel().getSize() - 1);
                    }
                    if (DefaultFileSetEditor.this.fUserFilesList.getSelectedIndices().length > 1) {
                        DefaultFileSetEditor.this.fUserFilesList.getSelectionModel().setSelectionInterval(DefaultFileSetEditor.this.fUserFilesList.getSelectedIndex(), DefaultFileSetEditor.this.fUserFilesList.getSelectedIndex());
                    }
                    DefaultFileSetEditor.this.fDepfunAction.doDepfun();
                    DefaultFileSetEditor.this.refreshAll();
                }
            }
        });
    }

    private Set<File> recursiveFileAdd(Set<File> set, File[] fileArray) {
        for (File file : fileArray) {
            if (file.isDirectory()) {
                File[] fileArray2 = file.listFiles();
                this.recursiveFileAdd(set, fileArray2);
                continue;
            }
            set.add(file);
        }
        return set;
    }

    public MJPanel getComponent() {
        return this.fFileSetPanel;
    }

    public void dispose() {
    }

    public void setEnabled(boolean bl) {
        this.fFileSetPanel.setEnabled(bl);
    }

    public void setDepfunFileList(Set<File> set) {
        this.fDepfunFileList = set;
        if (!set.isEmpty()) {
            this.setData(this.fDepfunFileList);
        }
    }

    public void removeDepfunFileList() {
        if (this.fDepfunFileList != null) {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (File file : DefaultFileSetEditor.this.fDepfunFileList) {
                        DefaultFileSetEditor.this.fModel.removeElement(file);
                    }
                }
            });
            this.fDepfunFileList.clear();
        }
    }

    public void setData(final Set<File> set) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                int n = DefaultFileSetEditor.this.fUserFilesList.getSelectedIndex();
                DefaultFileSetEditor.this.fFileSet.add(set);
                DefaultFileSetEditor.this.fModel.removeAllElements();
                Set<File> set2 = DefaultFileSetEditor.this.getData();
                for (File file : set2) {
                    if (DefaultFileSetEditor.this.fModel.contains(file) || file.toString().equals(".exe") || file.getName().equals("for_testing")) continue;
                    DefaultFileSetEditor.this.fModel.addElement(file);
                }
                DefaultFileSetEditor.this.refreshAll();
                DefaultFileSetEditor.this.fUserFilesList.setSelectedIndex(n < DefaultFileSetEditor.this.fUserFilesList.getModel().getSize() ? n : DefaultFileSetEditor.this.fUserFilesList.getModel().getSize() - 1);
            }
        });
    }

    public void removeData(final Collection<File> collection) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (File file : collection) {
                    DefaultFileSetEditor.this.fModel.removeElement(file);
                }
            }
        });
        this.removeFromFileSet(new ArrayList<File>(collection));
    }

    private void removeFromFileSet(List<File> list) {
        this.fFileSet.remove(list);
        this.refreshAll();
    }

    public void refreshAll() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                DefaultFileSetEditor.this.fUserFilesList.setVisibleRowCount(DefaultFileSetEditor.this.fModel.getSize() / 5 + (DefaultFileSetEditor.this.fModel.getSize() % 5 == 0 ? 0 : 1));
                DefaultFileSetEditor.this.fFileSetPanel.revalidate();
                DefaultFileSetEditor.this.fFileSetPanel.repaint();
                DefaultFileSetEditor.this.fListScroller.revalidate();
                DefaultFileSetEditor.this.fListScroller.repaint();
                DefaultFileSetEditor.this.fUserFilesList.revalidate();
                DefaultFileSetEditor.this.fUserFilesList.repaint();
            }
        });
    }

    public Set<File> getData() {
        return this.fFileSet.getFiles();
    }

    public void setToolTip(String string) {
        this.fFileSetPanel.setToolTipText(string);
    }

    private class FileByName
    extends File {
        public FileByName(String string) {
            super(string);
        }

        @Override
        public int compareTo(File file) {
            if (file instanceof FileByName) {
                int n = this.getName().toLowerCase(Locale.ENGLISH).compareTo(file.getName().toLowerCase(Locale.ENGLISH));
                if (n == 0) {
                    n = this.getAbsolutePath().compareTo(file.getAbsolutePath());
                }
                return n;
            }
            return super.compareTo(file);
        }
    }

    private class SortedFileModel
    extends DefaultListModel {
        private Set<FileByName> fFolders = new TreeSet<FileByName>();
        private Set<FileByName> fFiles = new TreeSet<FileByName>();

        public void addElement(Object object) {
            if (object instanceof File) {
                File file = (File)object;
                if (file.isDirectory()) {
                    this.fFolders.add(new FileByName(file.getAbsolutePath()));
                } else {
                    this.fFiles.add(new FileByName(file.getAbsolutePath()));
                }
                int n = this.fFolders.size() + this.fFiles.size();
                this.fireIntervalAdded(this, n, n);
            }
        }

        @Override
        public boolean removeElement(Object object) {
            if (this.fFolders.contains(object)) {
                this.fFolders.remove(object);
            } else if (this.fFiles.contains(object)) {
                this.fFiles.remove(object);
            } else {
                return false;
            }
            return true;
        }

        @Override
        public int getSize() {
            return this.fFolders.size() + this.fFiles.size();
        }

        @Override
        public Object getElementAt(int n) {
            if (n >= this.fFolders.size()) {
                return this.fFiles.toArray()[n - this.fFolders.size()];
            }
            return this.fFolders.toArray()[n];
        }

        @Override
        public void clear() {
            this.removeAllElements();
        }

        @Override
        public void removeAllElements() {
            this.fFiles.clear();
            this.fFolders.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.getSize() == 0;
        }

        @Override
        public int indexOf(Object object) {
            Iterator<FileByName> iterator = null;
            int n = 0;
            if (this.fFolders.contains(object)) {
                iterator = this.fFolders.iterator();
            } else if (this.fFiles.contains(object)) {
                iterator = this.fFiles.iterator();
                n = this.fFolders.size();
            }
            if (iterator != null) {
                while (iterator.hasNext()) {
                    File file = iterator.next();
                    if (file.equals(object)) {
                        return n;
                    }
                    ++n;
                }
            }
            return -1;
        }
    }

    protected class NewTableCellRenderer
    extends DefaultListCellRenderer {
        private final Map<File, Icon> fCache;
        private final boolean fAllowSelection;

        NewTableCellRenderer(boolean bl) {
            this.fAllowSelection = bl;
            this.fCache = new HashMap<File, Icon>();
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, this.fAllowSelection ? bl : false, this.fAllowSelection ? bl2 : false);
            if (object != null && object instanceof File) {
                String string;
                File file = (File)object;
                String string2 = file.getName();
                if (this.isWide()) {
                    string2 = file.getAbsolutePath();
                }
                this.setText(string2);
                Icon icon = this.fCache.get(file);
                if (icon == null) {
                    icon = UiFileSystemUtils.getIconEvenIfNonExistent((FileSystem)RealFileSystem.getInstance(), (FileLocation)new FileLocation(file), (ExtensionRegistry)ExplorerExtensionRegistry.getInstance());
                    this.fCache.put(file, icon);
                }
                this.setIcon(icon);
                this.setToolTipText(file.getAbsolutePath());
                if (!this.fAllowSelection) {
                    this.setBorder(null);
                }
                if ((string = ((File)object).getName()).endsWith(".p")) {
                    MJPanel mJPanel = new MJPanel();
                    mJPanel.setLayout((LayoutManager)new GridLayout(1, 2));
                    mJPanel.add(component);
                    mJPanel.setBackground(Color.WHITE);
                    MJLabel mJLabel = new MJLabel();
                    mJLabel.setIcon((Icon)IconEnumerationUtils.getIcon((String)"step_warning"));
                    mJLabel.setToolTipText(BuiltInResources.getString("pfile.warning"));
                    mJLabel.setBackground(Color.WHITE);
                    mJLabel.setOpaque(true);
                    mJPanel.setToolTipText(BuiltInResources.getString("pfile.warning"));
                    mJPanel.add((Component)mJLabel);
                    return mJPanel;
                }
            }
            return component;
        }

        public boolean isWide() {
            return false;
        }
    }
}

