/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.filesetui;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.model.table.UiFileList;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.RequestQueue;
import com.mathworks.widgets.grouptable.ExpansionChangeListener;
import com.mathworks.widgets.grouptable.GroupingTableTransaction;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public final class FileChangeNotifier {
    private final FileSetInstance fFileSet;
    private final ParameterRunnable<File> fNotify;
    private final Map<FileLocation, UiFileList> fLists;
    private final ExpansionChangeListener<FileSystemEntry> fListener;
    private final PropertyChangeListener fPropertyChangeListener;
    private final RequestQueue fRequestQueue;

    public FileChangeNotifier(FileSetInstance fileSetInstance, ParameterRunnable<File> parameterRunnable) {
        this.fFileSet = fileSetInstance;
        this.fNotify = parameterRunnable;
        this.fLists = new HashMap<FileLocation, UiFileList>();
        this.fRequestQueue = new RequestQueue("Deploy Tool File system monitoring request queue for " + this.fFileSet.getDefinition().getKey());
        this.fListener = new ExpansionChangeListener<FileSystemEntry>(){

            public void childrenChanged(GroupingTableTransaction<FileSystemEntry> groupingTableTransaction) {
                for (GroupingTableTransaction.Element element : groupingTableTransaction) {
                    FileChangeNotifier.this.fNotify.run((Object)((FileSystemEntry)element.getData()).getLocation().toFile());
                }
            }

            public void hasChildrenChanged() {
            }
        };
        this.fPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FileChangeNotifier.this.updateLists();
            }
        };
        this.fFileSet.addPropertyChangeListener(this.fPropertyChangeListener);
        this.updateLists();
    }

    public synchronized void dispose() {
        for (UiFileList uiFileList : this.fLists.values()) {
            uiFileList.close();
        }
        this.fFileSet.removePropertyChangeListener(this.fPropertyChangeListener);
    }

    private synchronized void updateLists() {
        HashSet<FileLocation> hashSet = new HashSet<FileLocation>();
        for (File object : this.fFileSet.getFiles()) {
            if (object.getParentFile() == null) continue;
            hashSet.add(new FileLocation(object.getParentFile()));
        }
        Iterator<Object> iterator = this.fLists.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (hashSet.contains(entry.getKey())) continue;
            iterator.remove();
            ((UiFileList)entry.getValue()).removeListener(this.fListener);
            ((UiFileList)entry.getValue()).close();
        }
        for (FileLocation fileLocation : hashSet) {
            if (this.fLists.containsKey(fileLocation)) continue;
            UiFileList uiFileList = new UiFileList(this.fRequestQueue, FileSystemUtils.getNonStrictList((FileSystem)RealFileSystem.getInstance(), (FileLocation)fileLocation), true);
            uiFileList.addListener(this.fListener);
            this.fLists.put(fileLocation, uiFileList);
        }
    }
}

