/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.filesetui;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ReadableEntityInstance;
import com.mathworks.project.impl.filesetui.EntityControls;
import com.mathworks.project.impl.filesetui.FileSetEditor;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.EntityInstance;
import com.mathworks.project.impl.model.FileSetInstance;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

final class FileSetTreeModel
implements TreeModel {
    private final FileSetEditor fEditor;
    private final FileSetInstance fSet;
    private final List<TreeModelListener> fListeners;
    private final PropertyChangeListener fChangeListener;
    private final Map<EntityInstance, EntityControls> fEntityControls;
    private FileSetInstance fCurrentSnapshot;

    FileSetTreeModel(FileSetEditor fileSetEditor) {
        this.fSet = fileSetEditor.getFileSet();
        this.fEditor = fileSetEditor;
        this.fCurrentSnapshot = this.fSet.getSnapshot();
        this.fListeners = new ArrayList<TreeModelListener>();
        this.fEntityControls = new HashMap<EntityInstance, EntityControls>();
        this.fChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                if (FileSetTreeModel.this.isEventRelevant(propertyChangeEvent)) {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            FileSetInstance fileSetInstance = FileSetTreeModel.this.fCurrentSnapshot;
                            FileSetTreeModel.this.fCurrentSnapshot = FileSetTreeModel.this.fSet.getSnapshot();
                            FileSetTreeModel.this.fireEvents(propertyChangeEvent, fileSetInstance, FileSetTreeModel.this.fCurrentSnapshot);
                        }
                    });
                }
            }
        };
        this.fEditor.getProject().addPropertyChangeListener(this.fChangeListener);
    }

    private boolean isEventRelevant(PropertyChangeEvent propertyChangeEvent) {
        boolean bl;
        block1: {
            Object object = propertyChangeEvent.getSource();
            boolean bl2 = bl = object.equals(this.fSet) || Configuration.isBuildDeliverableChange(propertyChangeEvent);
            if (bl || !(object instanceof EntityInstance)) break block1;
            Set<EntityInstance> set = this.fEntityControls.keySet();
            Iterator<EntityInstance> iterator = set.iterator();
            while (iterator.hasNext() && !(bl = object.equals(iterator.next()))) {
            }
        }
        return bl;
    }

    public void dispose() {
        this.fEditor.getProject().removePropertyChangeListener(this.fChangeListener);
    }

    @Override
    public Object getRoot() {
        return this.fCurrentSnapshot;
    }

    @Override
    public Object getChild(Object object, int n) {
        return this.getChildren(object).get(n);
    }

    @Override
    public int getChildCount(Object object) {
        return this.getChildren(object).size();
    }

    private List getChildren(Object object) {
        if (object instanceof FileSetInstance) {
            if (this.fCurrentSnapshot.getDefinition().getHierarchyLevels() == 2) {
                return this.fCurrentSnapshot.getRootEntities().isEmpty() ? new ArrayList(0) : this.fCurrentSnapshot.getChildren((ReadableEntityInstance)this.fCurrentSnapshot.getRootEntities().get(0));
            }
            return new ArrayList<File>(this.fCurrentSnapshot.getFiles());
        }
        if (object instanceof EntityInstance) {
            EntityInstance entityInstance = (EntityInstance)object;
            ArrayList<File> arrayList = new ArrayList<File>(this.fCurrentSnapshot.getFilesForEntity((ReadableEntityInstance)entityInstance));
            EntityControls entityControls = this.fEntityControls.get(entityInstance);
            if (entityControls == null) {
                entityControls = new EntityControls(this.fEditor, entityInstance);
                this.fEntityControls.put(entityInstance, entityControls);
            }
            arrayList.add((File)((Object)entityControls));
            return arrayList;
        }
        if (object instanceof File || object instanceof EntityControls) {
            return new ArrayList(0);
        }
        throw new IllegalArgumentException("Unknown parent: " + object);
    }

    @Override
    public boolean isLeaf(Object object) {
        return this.getChildren(object).isEmpty();
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        Object object2 = treePath.getLastPathComponent();
        assert (object2 != null && object2 instanceof EntityInstance);
        EntityInstance entityInstance = (EntityInstance)object2;
        entityInstance.setName(object.toString());
        for (TreeModelListener treeModelListener : this.fListeners) {
            TreePath treePath2 = treePath.getParentPath();
            Object object3 = treePath2.getLastPathComponent();
            int n = this.getIndexOfChild(object3, entityInstance);
            treeModelListener.treeNodesChanged(new TreeModelEvent((Object)this, treePath2, new int[]{n}, new Object[]{entityInstance}));
        }
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return this.getChildren(object).indexOf(object2);
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.fListeners.add(treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.fListeners.remove(treeModelListener);
    }

    private void fireEvents(PropertyChangeEvent propertyChangeEvent, FileSetInstance fileSetInstance, FileSetInstance fileSetInstance2) {
        assert (fileSetInstance.getDefinition().getHierarchyLevels() == fileSetInstance2.getDefinition().getHierarchyLevels());
        assert (fileSetInstance.getDefinition().getHierarchyLevels() == 1 || fileSetInstance.getDefinition().getHierarchyLevels() == 2);
        if (fileSetInstance.getDefinition().getHierarchyLevels() == 2) {
            this.fireListChanges(propertyChangeEvent, fileSetInstance.getRootEntities(), fileSetInstance2.getRootEntities(), fileSetInstance);
            for (EntityInstance entityInstance : fileSetInstance.getRootEntities()) {
                if (!fileSetInstance2.getRootEntities().contains(entityInstance)) continue;
                this.fireListChanges(propertyChangeEvent, fileSetInstance.getChildren((ReadableEntityInstance)entityInstance), fileSetInstance2.getChildren((ReadableEntityInstance)entityInstance), fileSetInstance);
                for (EntityInstance entityInstance2 : fileSetInstance.getChildren((ReadableEntityInstance)entityInstance)) {
                    this.fireListChanges(propertyChangeEvent, fileSetInstance.getFilesForEntity((ReadableEntityInstance)entityInstance2), fileSetInstance2.getFilesForEntity((ReadableEntityInstance)entityInstance2), fileSetInstance, entityInstance2);
                }
            }
        } else {
            this.fireListChanges(propertyChangeEvent, fileSetInstance.getFiles(), fileSetInstance2.getFiles(), fileSetInstance);
        }
    }

    private <T> void fireListChanges(PropertyChangeEvent propertyChangeEvent, Collection<T> collection, Collection<T> collection2, Object ... objectArray) {
        MutableTreeModelEvent mutableTreeModelEvent = new MutableTreeModelEvent(objectArray);
        MutableTreeModelEvent mutableTreeModelEvent2 = new MutableTreeModelEvent(objectArray);
        MutableTreeModelEvent mutableTreeModelEvent3 = new MutableTreeModelEvent(objectArray);
        Iterator<T> iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!collection2.contains(t)) {
                mutableTreeModelEvent2.add(n, t);
            }
            ++n;
        }
        Iterator<T> iterator2 = collection2.iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            T t = iterator2.next();
            if (!collection.contains(t)) {
                mutableTreeModelEvent.add(n2, t);
            }
            ++n2;
        }
        Object object = propertyChangeEvent.getSource();
        iterator2 = collection2.iterator();
        int n3 = 0;
        while (iterator2.hasNext()) {
            T object2 = iterator2.next();
            if (object.equals(object2) && !mutableTreeModelEvent2.contains(object) && !mutableTreeModelEvent.contains(object)) {
                mutableTreeModelEvent3.add(n3, object2);
            }
            ++n3;
        }
        if (mutableTreeModelEvent2.size() > 0) {
            for (TreeModelListener treeModelListener : this.fListeners) {
                treeModelListener.treeNodesRemoved(mutableTreeModelEvent2.createEvent());
            }
        }
        if (mutableTreeModelEvent.size() > 0) {
            for (TreeModelListener treeModelListener : this.fListeners) {
                treeModelListener.treeNodesInserted(mutableTreeModelEvent.createEvent());
            }
        }
        if (mutableTreeModelEvent3.size() > 0) {
            for (TreeModelListener treeModelListener : this.fListeners) {
                treeModelListener.treeNodesChanged(mutableTreeModelEvent3.createEvent());
            }
        }
    }

    private class MutableTreeModelEvent {
        private final Object[] fPath;
        private final List<Integer> fChildIndices;
        private final List<Object> fChildren;

        MutableTreeModelEvent(Object[] objectArray) {
            this.fPath = (Object[])objectArray.clone();
            this.fChildIndices = new ArrayList<Integer>();
            this.fChildren = new ArrayList<Object>();
        }

        public void add(int n, Object object) {
            this.fChildIndices.add(n);
            this.fChildren.add(object);
        }

        TreeModelEvent createEvent() {
            int[] nArray = new int[this.fChildIndices.size()];
            Iterator<Integer> iterator = this.fChildIndices.iterator();
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = iterator.next();
            }
            return new TreeModelEvent((Object)FileSetTreeModel.this, this.fPath, nArray, this.fChildren.toArray());
        }

        public int size() {
            return this.fChildren.size();
        }

        public boolean contains(Object object) {
            return this.fChildren.contains(object);
        }
    }
}

