/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.filesetui;

import com.mathworks.util.Converter;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

class SelectionModelAdapter
implements TreeSelectionModel {
    private final ListSelectionModel fListSelectionModel;
    private final Converter<TreePath, Integer> fPathToRowConverter;
    private final Converter<Integer, TreePath> fRowToPathConverter;

    SelectionModelAdapter(ListSelectionModel listSelectionModel, Converter<TreePath, Integer> converter, Converter<Integer, TreePath> converter2) {
        this.fListSelectionModel = listSelectionModel;
        this.fPathToRowConverter = converter;
        this.fRowToPathConverter = converter2;
    }

    @Override
    public void setSelectionMode(int n) {
        this.fListSelectionModel.setSelectionMode(n);
    }

    @Override
    public int getSelectionMode() {
        return this.fListSelectionModel.getSelectionMode();
    }

    @Override
    public void setSelectionPath(TreePath treePath) {
        this.clearSelection();
        if (treePath != null) {
            this.addSelectionPath(treePath);
        }
    }

    @Override
    public void setSelectionPaths(TreePath[] treePathArray) {
        this.clearSelection();
        if (treePathArray != null) {
            this.addSelectionPaths(treePathArray);
        }
    }

    @Override
    public void addSelectionPath(TreePath treePath) {
        int n = (Integer)this.fPathToRowConverter.convert((Object)treePath);
        if (n != -1) {
            this.fListSelectionModel.addSelectionInterval(n, n);
        }
    }

    @Override
    public void addSelectionPaths(TreePath[] treePathArray) {
        for (TreePath treePath : treePathArray) {
            this.addSelectionPath(treePath);
        }
    }

    @Override
    public void removeSelectionPath(TreePath treePath) {
        int n = (Integer)this.fPathToRowConverter.convert((Object)treePath);
        if (n != -1) {
            this.fListSelectionModel.removeSelectionInterval(n, n);
        }
    }

    @Override
    public void removeSelectionPaths(TreePath[] treePathArray) {
        for (TreePath treePath : treePathArray) {
            this.removeSelectionPath(treePath);
        }
    }

    @Override
    public TreePath getSelectionPath() {
        int n = this.fListSelectionModel.getLeadSelectionIndex();
        return n != -1 ? (TreePath)this.fRowToPathConverter.convert((Object)n) : null;
    }

    @Override
    public TreePath[] getSelectionPaths() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = this.fListSelectionModel.getMinSelectionIndex(); i <= this.fListSelectionModel.getMaxSelectionIndex(); ++i) {
            if (!this.fListSelectionModel.isSelectedIndex(i)) continue;
            arrayList.add(this.fRowToPathConverter.convert((Object)i));
        }
        return arrayList.toArray(new TreePath[arrayList.size()]);
    }

    @Override
    public int getSelectionCount() {
        return this.getSelectionPaths().length;
    }

    @Override
    public boolean isPathSelected(TreePath treePath) {
        int n = (Integer)this.fPathToRowConverter.convert((Object)treePath);
        return n > -1 && this.fListSelectionModel.isSelectedIndex(n);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.fListSelectionModel.isSelectionEmpty();
    }

    @Override
    public void clearSelection() {
        this.fListSelectionModel.clearSelection();
    }

    @Override
    public void setRowMapper(RowMapper rowMapper) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowMapper getRowMapper() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getSelectionRows() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = this.fListSelectionModel.getMinSelectionIndex(); i <= this.fListSelectionModel.getMaxSelectionIndex(); ++i) {
            if (!this.fListSelectionModel.isSelectedIndex(i)) continue;
            arrayList.add(i);
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return nArray;
    }

    @Override
    public int getMinSelectionRow() {
        return this.fListSelectionModel.getMinSelectionIndex();
    }

    @Override
    public int getMaxSelectionRow() {
        return this.fListSelectionModel.getMaxSelectionIndex();
    }

    @Override
    public boolean isRowSelected(int n) {
        return this.fListSelectionModel.isSelectedIndex(n);
    }

    @Override
    public void resetRowSelection() {
    }

    @Override
    public int getLeadSelectionRow() {
        return this.fListSelectionModel.getLeadSelectionIndex();
    }

    @Override
    public TreePath getLeadSelectionPath() {
        return (TreePath)this.fRowToPathConverter.convert((Object)this.getLeadSelectionRow());
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.fListSelectionModel.addListSelectionListener(new ListenerAdapter(treeSelectionListener));
    }

    @Override
    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.fListSelectionModel.removeListSelectionListener(new ListenerAdapter(treeSelectionListener));
    }

    private class ListenerAdapter
    implements ListSelectionListener {
        private final TreeSelectionListener iListener;

        ListenerAdapter(TreeSelectionListener treeSelectionListener) {
            this.iListener = treeSelectionListener;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            TreePath treePath = (TreePath)SelectionModelAdapter.this.fRowToPathConverter.convert((Object)SelectionModelAdapter.this.fListSelectionModel.getLeadSelectionIndex());
            TreePath[] treePathArray = new TreePath[listSelectionEvent.getLastIndex() - listSelectionEvent.getFirstIndex() + 1];
            boolean[] blArray = new boolean[treePathArray.length];
            for (int i = listSelectionEvent.getFirstIndex(); i <= listSelectionEvent.getLastIndex(); ++i) {
                treePathArray[i - listSelectionEvent.getFirstIndex()] = (TreePath)SelectionModelAdapter.this.fRowToPathConverter.convert((Object)i);
                blArray[i - listSelectionEvent.getFirstIndex()] = SelectionModelAdapter.this.fListSelectionModel.isSelectedIndex(i);
            }
            this.iListener.valueChanged(new TreeSelectionEvent((Object)SelectionModelAdapter.this, treePathArray, blArray, null, treePath));
        }

        public int hashCode() {
            return this.iListener.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof ListenerAdapter && this.iListener.equals(((ListenerAdapter)object).iListener);
        }
    }
}

