/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.logui;

import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJTextPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.api.DeploymentProcessMonitor;
import com.mathworks.project.api.SubProcessType;
import com.mathworks.project.impl.InterruptibleQueue;
import com.mathworks.project.impl.logui.LogDisplay;
import com.mathworks.project.impl.logui.LogMessage;
import com.mathworks.project.impl.logui.LogMessageType;
import com.mathworks.services.FontPrefs;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.EditorKit;
import javax.swing.text.Position;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.commons.lang.StringEscapeUtils;

public final class BuildProgressTextArea {
    private MJTextPane fTextPane;
    private StringWriter fPlainText;
    private DeploymentProcessMonitor fMonitor;
    private InterruptibleQueue<PrintlnRequest> fPrinter;
    private boolean fEcho = true;
    private DocumentListener fDocumentListener;
    private final MulticastChangeListener fChangeListeners = new MulticastChangeListener();
    private DeploymentProcess fProcess;
    private HTMLEditorKit fEditorKit;
    private static final String HTML_PREFIX = "<html><body>";
    private static final String HTML_SUFFIX = "</body></html>";
    private static final String MATLAB_LINK_PREFIX = "matlab:";
    private HyperlinkListener fHyperlinkListener;

    public void dispose() {
        this.clear();
        if (this.fDocumentListener != null) {
            this.fTextPane.getDocument().removeDocumentListener(this.fDocumentListener);
            this.fDocumentListener = null;
        }
        if (this.fTextPane != null) {
            this.fTextPane.removeContextMenu();
            try {
                if (this.fTextPane.getUI() != null) {
                    this.fTextPane.getUI().uninstallUI((JComponent)this.fTextPane);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.fHyperlinkListener != null) {
                this.fTextPane.removeHyperlinkListener(this.fHyperlinkListener);
            }
            if (this.fEditorKit != null) {
                this.fEditorKit.deinstall((JEditorPane)this.fTextPane);
            }
            if (this.fTextPane.getParent() != null) {
                this.fTextPane.getParent().remove((Component)this.fTextPane);
            }
        }
        if (this.fPrinter != null) {
            this.fPrinter.dispose();
        }
        try {
            if (this.fPlainText != null) {
                this.fPlainText.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public BuildProgressTextArea() {
        this.fPrinter = new InterruptibleQueue<PrintlnRequest>(1000L, new ParameterRunnable<List<PrintlnRequest>>(){

            public void run(List<PrintlnRequest> list) {
                BuildProgressTextArea.this.run(list);
            }
        });
        this.fPlainText = new StringWriter();
        this.fEditorKit = new HTMLEditorKit();
        this.fTextPane = new MJTextPane(){

            public String getSelectedText() {
                String string = super.getSelectedText();
                try {
                    Position position = this.getDocument().createPosition(this.getSelectionStart());
                    Position position2 = this.getDocument().createPosition(this.getSelectionEnd());
                    StringWriter stringWriter = new StringWriter(position2.getOffset() - position.getOffset());
                    BuildProgressTextArea.this.fEditorKit.write(stringWriter, this.getDocument(), position.getOffset(), position2.getOffset() - position.getOffset());
                    string = BuildProgressTextArea.htmlToPlainText(stringWriter.toString());
                }
                catch (IOException | BadLocationException exception) {
                    // empty catch block
                }
                return string;
            }
        };
        this.fTextPane.registerWithKeyBindingManager(MatlabKeyBindings.getManager(), "MATLABDesktop");
        ((DefaultCaret)this.fTextPane.getCaret()).setUpdatePolicy(1);
        this.fHyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                String string;
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (string = ((AttributeSet)hyperlinkEvent.getSourceElement().getAttributes().getAttribute(HTML.Tag.A)).getAttribute(HTML.Attribute.HREF).toString()).startsWith(BuildProgressTextArea.MATLAB_LINK_PREFIX)) {
                    new Matlab().evalConsoleOutput(string.substring(BuildProgressTextArea.MATLAB_LINK_PREFIX.length()));
                }
            }
        };
        this.fTextPane.addHyperlinkListener(this.fHyperlinkListener);
        this.fTextPane.setContentType("text/html");
        this.fTextPane.setText("<html><body></body></html>");
        this.fTextPane.setEditorKit((EditorKit)this.fEditorKit);
        this.fTextPane.setName("progress.details.text");
        this.fTextPane.setEditable(false);
        this.fTextPane.setWrapping(false);
        this.fMonitor = new DeploymentProcessMonitor(){

            public void subProcessStarted(SubProcessType subProcessType) {
            }

            public void commandStarted(String string) {
                if (!string.isEmpty() && BuildProgressTextArea.this.fEcho) {
                    BuildProgressTextArea.this.println(string, MessageType.COMMAND);
                }
            }

            public void commandOutput(String string) {
                BuildProgressTextArea.this.println(string, MessageType.OUTPUT);
            }

            public void commandError(String string) {
                BuildProgressTextArea.this.println(string, MessageType.ERROR);
            }

            public void finished() {
                BuildProgressTextArea.this.fPrinter.force();
            }

            public void failed() {
                BuildProgressTextArea.this.fPrinter.force();
            }

            public void canceled() {
            }
        };
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
        if (this.fDocumentListener == null) {
            this.fDocumentListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    BuildProgressTextArea.this.fChangeListeners.stateChanged(new ChangeEvent(BuildProgressTextArea.this));
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    BuildProgressTextArea.this.fChangeListeners.stateChanged(new ChangeEvent(BuildProgressTextArea.this));
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                }
            };
            this.fTextPane.getDocument().addDocumentListener(this.fDocumentListener);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }

    public void setEcho(boolean bl) {
        this.fEcho = bl;
    }

    public LogDisplay getDisplay() {
        return new LogDisplay(){

            @Override
            public void setLive(boolean bl) {
                BuildProgressTextArea.this.fTextPane.setOpaque(bl);
            }

            @Override
            public void clear() {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        BuildProgressTextArea.this.clear();
                    }
                });
            }

            @Override
            public void write(LogMessage logMessage) {
                if (!BuildProgressTextArea.this.fEcho && logMessage.getType() == LogMessageType.COMMAND) {
                    return;
                }
                BuildProgressTextArea.this.println(logMessage.getLine(), MessageType.valueOf(logMessage.getType().toString()));
            }

            @Override
            public void flush() {
                BuildProgressTextArea.this.fPrinter.force();
            }
        };
    }

    public void setProcess(DeploymentProcess deploymentProcess) {
        if (this.fProcess != null) {
            this.fProcess.removeMonitor(this.fMonitor);
        }
        this.fEditorKit = new HTMLEditorKit();
        this.fTextPane.setText("<html><body></body></html>");
        this.fTextPane.setEditorKit((EditorKit)this.fEditorKit);
        this.fProcess = deploymentProcess;
        this.fProcess.addMonitor(this.fMonitor);
    }

    private void run(final List<PrintlnRequest> list) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                HTMLDocument hTMLDocument = (HTMLDocument)BuildProgressTextArea.this.fTextPane.getDocument();
                StringBuilder stringBuilder = new StringBuilder();
                MessageType messageType = null;
                int n = 0;
                for (PrintlnRequest printlnRequest : list) {
                    if (printlnRequest.isClear()) {
                        BuildProgressTextArea.this.fTextPane.setText("");
                        continue;
                    }
                    String string = "<nobr>" + BuildProgressTextArea.clean(printlnRequest.getLine()) + "</nobr>";
                    MessageType messageType2 = printlnRequest.getType();
                    if (string.trim().length() <= 0) continue;
                    if (messageType == null || messageType != messageType2 || n > 500) {
                        if (messageType != null) {
                            stringBuilder.append("</font></span>");
                        }
                        stringBuilder.append(messageType2.getFontTag());
                        n = 0;
                    } else {
                        ++n;
                    }
                    stringBuilder.append(string);
                    if (printlnRequest.getLine().endsWith("\n")) {
                        stringBuilder.append("<br>");
                    }
                    messageType = messageType2;
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("</font></span>");
                }
                try {
                    String string = stringBuilder.toString();
                    BuildProgressTextArea.this.fEditorKit.insertHTML(hTMLDocument, hTMLDocument.getLength(), string, 0, 0, null);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BuildProgressTextArea.this.fTextPane.scrollRectToVisible(new Rectangle(0, BuildProgressTextArea.this.fTextPane.getHeight() - 1, 1, 1));
                        }
                    });
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception);
                }
            }
        });
    }

    private void println(String string, MessageType messageType) {
        this.fPrinter.request(new PrintlnRequest(string, messageType));
    }

    private static String htmlToPlainText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c != '\r' && c != '\n') {
                if (Character.isWhitespace(c)) {
                    if (bl) {
                        ++n;
                        continue;
                    }
                    stringBuilder.append(' ');
                    bl = true;
                } else if (c == '<') {
                    StringBuilder stringBuilder2 = new StringBuilder();
                    ++n;
                    while (n < string.length() && string.charAt(n) != '>') {
                        stringBuilder2.append(string.charAt(n));
                        ++n;
                    }
                    if (stringBuilder2.toString().trim().equalsIgnoreCase("br")) {
                        stringBuilder.append("\n");
                    }
                } else {
                    bl = false;
                    stringBuilder.append(c);
                }
            }
            ++n;
        }
        return StringEscapeUtils.unescapeHtml((String)stringBuilder.toString().trim());
    }

    private static String clean(String string) {
        String string2 = string;
        Pattern pattern = Pattern.compile("[^\b]\b");
        Matcher matcher = pattern.matcher(string2);
        while (matcher.find()) {
            string2 = matcher.replaceAll("");
            matcher = pattern.matcher(string2);
        }
        if (string2 != null && string2.endsWith("\n")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string2 != null) {
            string2 = string2.replaceAll("[^\b]\b", "").replaceAll("\r", "").replaceAll("\\Q<\\E([^a/])", "&lt;$1").replaceAll("([^a\"])\\Q>\\E", "$1&gt;").replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;").replaceAll("\n", "<br>");
        }
        return string2;
    }

    public JComponent getComponent() {
        return this.fTextPane;
    }

    public String getPlainText() {
        return BuildProgressTextArea.htmlToPlainText(this.fTextPane.getText());
    }

    public void clear() {
        this.fPrinter.cancelPendingRequests();
        this.fPrinter.request(new PrintlnRequest(true));
        this.fPrinter.force();
    }

    private static class PrintlnRequest {
        private final String fLine;
        private final MessageType fMessageType;
        private final boolean fClear;

        PrintlnRequest(boolean bl) {
            this.fClear = bl;
            this.fLine = null;
            this.fMessageType = null;
        }

        PrintlnRequest(String string, MessageType messageType) {
            this.fLine = string;
            this.fClear = false;
            this.fMessageType = messageType;
        }

        public String getLine() {
            return this.fLine;
        }

        public MessageType getType() {
            return this.fMessageType;
        }

        public boolean isClear() {
            return this.fClear;
        }
    }

    private static enum MessageType {
        COMMAND(Color.BLACK, FontPrefs.getCodeFont().deriveFont(12.0f)),
        OUTPUT(null, FontPrefs.getCodeFont().deriveFont(12.0f)),
        ERROR(Color.RED, FontPrefs.getCodeFont().deriveFont(12.0f));

        private final Font fFont;
        private final Color fColor;

        private MessageType(Color color, Font font) {
            this.fFont = font;
            this.fColor = color;
        }

        public String getFontTag() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<span style=\"font-size: ");
            stringBuilder.append(this.fFont.getSize());
            stringBuilder.append("pt; font-family: ");
            stringBuilder.append(PlatformInfo.isMacintosh() ? "Menlo" : "Courier New");
            stringBuilder.append("\"><font");
            if (this.fColor != null) {
                stringBuilder.append(" color=\"");
                stringBuilder.append(this.getColorString());
                stringBuilder.append("\"");
            }
            stringBuilder.append(">");
            return stringBuilder.toString();
        }

        public String getColorString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("#");
            stringBuilder.append(MessageType.getTwoDigitHex(this.fColor.getRed()));
            stringBuilder.append(MessageType.getTwoDigitHex(this.fColor.getGreen()));
            stringBuilder.append(MessageType.getTwoDigitHex(this.fColor.getBlue()));
            return stringBuilder.toString();
        }

        private static String getTwoDigitHex(int n) {
            String string = Integer.toHexString(n);
            return string.length() < 2 ? "0" + string : string;
        }
    }
}

