/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.project.api.ConfigurationValidator;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.Severity;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.DynamicFileReference;
import com.mathworks.project.impl.model.FileSetDefinition;
import com.mathworks.project.impl.model.FileSetInstance;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

final class BasicValidator
implements ConfigurationValidator {
    private final boolean fForPackaging;

    BasicValidator(boolean bl) {
        this.fForPackaging = bl;
    }

    public List<ValidationMessage> validate(ReadableConfiguration readableConfiguration) {
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        for (FileSetDefinition fileSetDefinition : ((Configuration)readableConfiguration).getTarget().getFileSets()) {
            FileSetInstance fileSetInstance;
            String string;
            if (!(this.fForPackaging ^ !fileSetDefinition.getKey().startsWith("fileset.package")) || fileSetDefinition.isExcludedFromChecksum() || (string = BasicValidator.getErrorMessage((Configuration)readableConfiguration, fileSetInstance = ((Configuration)readableConfiguration).getFileSet(fileSetDefinition.getKey()))) == null) continue;
            arrayList.add(new ValidationMessage(Severity.ERROR, string));
        }
        return arrayList;
    }

    private static String getErrorMessage(Configuration configuration, FileSetInstance fileSetInstance) {
        FileSetDefinition fileSetDefinition = fileSetInstance.getDefinition();
        if (fileSetDefinition.getMinCount() == 1 && fileSetDefinition.getMaxCount() == 1 && fileSetInstance.getCurrentCount() == 0) {
            return MessageFormat.format(BuiltInResources.getString("validation.fileset.single.missing"), fileSetDefinition.getName());
        }
        if (fileSetDefinition.getMinCount() > 0 && fileSetInstance.getCurrentCount() == 0) {
            return MessageFormat.format(BuiltInResources.getString("validation.fileset.empty"), fileSetDefinition.getName());
        }
        if (fileSetInstance.getCurrentCount() > fileSetDefinition.getMaxCount()) {
            return MessageFormat.format(BuiltInResources.getString("validation.fileset.toomany"), fileSetDefinition.getName());
        }
        HashSet<File> hashSet = new HashSet<File>();
        if (fileSetInstance.getDefinition().getKey().startsWith("fileset.package")) {
            try {
                Set<DynamicFileReference> set = configuration.getTarget().getBuildDeliverables().evaluate(configuration, configuration.getVariableGraph(), XmlApi.getInstance().read(configuration.getXML()));
                Iterator object = set.iterator();
                while (object.hasNext()) {
                    DynamicFileReference dynamicFileReference = (DynamicFileReference)object.next();
                    if (!dynamicFileReference.isOptional()) continue;
                    hashSet.add(dynamicFileReference.getFile());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (File file : fileSetInstance.getFiles()) {
            if (hashSet.contains(file) || file.exists()) continue;
            if (fileSetDefinition.getMaxCount() == 1) {
                return MessageFormat.format(BuiltInResources.getString("validation.fileset.nonexistent"), fileSetDefinition.getName(), file.getName());
            }
            return MessageFormat.format(BuiltInResources.getString("validation.fileset.nonexistent.inset"), file.getName(), fileSetDefinition.getName());
        }
        return null;
    }
}

