/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.project.api.WritableEntityInstance;
import com.mathworks.project.impl.model.EntityDefinition;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public final class EntityInstance
implements WritableEntityInstance {
    private String fName;
    private final boolean fMutable;
    private final EntityInstance fOriginal;
    private final EntityDefinition fDefinition;
    private final PropertyChangeSupport fPropertySupport;
    public static final String NAME_PROPERTY = "name";

    public EntityInstance(EntityInstance entityInstance) {
        this.fName = entityInstance.getName();
        this.fOriginal = entityInstance;
        this.fMutable = false;
        this.fPropertySupport = new PropertyChangeSupport(this);
        this.fDefinition = entityInstance.getDefinition();
    }

    public EntityInstance(EntityDefinition entityDefinition) {
        this.fName = "";
        this.fMutable = true;
        this.fOriginal = this;
        this.fDefinition = entityDefinition;
        this.fPropertySupport = new PropertyChangeSupport(this);
    }

    public EntityDefinition getDefinition() {
        return this.fDefinition;
    }

    public String getName() {
        return this.fOriginal == this ? this.fName : this.fOriginal.getName();
    }

    public void setName(String string) {
        if (this.fOriginal == this) {
            String string2 = this.fName;
            this.fName = string;
            this.fPropertySupport.firePropertyChange(NAME_PROPERTY, string2, string);
        } else {
            this.fOriginal.setName(string);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        assert (this.fMutable);
        this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public int hashCode() {
        return this.fOriginal == this ? super.hashCode() : this.fOriginal.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof EntityInstance)) {
            return false;
        }
        EntityInstance entityInstance = (EntityInstance)object;
        if (entityInstance.fOriginal == entityInstance && this.fOriginal == this) {
            return entityInstance == this;
        }
        return this.fOriginal.equals(entityInstance.fOriginal);
    }

    public String toString() {
        return this.getName();
    }
}

