/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.util.FileUtils;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Locale;

public enum FileReferenceMode {
    DIRECT{

        @Override
        public File generateReference(File file, File file2) {
            return file;
        }

        @Override
        public String getReferenceFileName(File file) {
            return file.getName();
        }
    }
    ,
    SYMBOLIC(!PlatformInfo.isWindows()){

        @Override
        public String getReferenceFileName(File file) {
            return file.getName();
        }

        @Override
        public File generateReference(File file, File file2) throws IOException {
            File file3 = NativeJava.createShortcutOrLink((String)file.getAbsolutePath(), (String)file2.getAbsolutePath());
            if (file3 == null) {
                throw new IOException("Failed to create symbolic link in " + file2.getAbsolutePath());
            }
            return file3;
        }

        @Override
        protected FileReferenceMode[] getRelatedModes() {
            return new FileReferenceMode[]{SHORTCUT, SHELL_INVOKER, BATCH_INVOKER};
        }
    }
    ,
    SHORTCUT(PlatformInfo.isWindows()){

        @Override
        public boolean isLocationPortable(File file) {
            return FileReferenceMode.isNetworkFile(file);
        }

        @Override
        protected FileReferenceMode[] getRelatedModes() {
            return new FileReferenceMode[]{SYMBOLIC, BATCH_INVOKER, SHELL_INVOKER};
        }

        @Override
        public String getReferenceFileName(File file) {
            return FileReferenceMode.replaceExtension(file, ".lnk");
        }

        @Override
        public File generateReference(File file, File file2) throws IOException {
            File file3 = NativeJava.createShortcutOrLink((String)file.getAbsolutePath(), (String)file2.getAbsolutePath());
            if (file3 == null) {
                throw new IOException("Failed to create shortcut in " + file2.getAbsolutePath());
            }
            return file3;
        }
    }
    ,
    BATCH_INVOKER(PlatformInfo.isWindows()){

        @Override
        public boolean isLocationPortable(File file) {
            return FileReferenceMode.isNetworkFile(file);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public File generateReference(File file, File file2) throws IOException {
            File file3 = new File(file2, this.getReferenceFileName(file));
            File file4 = NativeJava.resolveMappedDriveToUnc((String)NativeJava.getNormalizedWindowsPath((File)file));
            try (PrintWriter printWriter = null;){
                printWriter = new PrintWriter(new FileWriter(file3));
                printWriter.println("@echo off");
                printWriter.println("\"" + file4.getAbsolutePath() + "\"");
                printWriter.println("if %ErrorLevel% GEQ 1. Pause");
            }
            return file3;
        }

        @Override
        public String getReferenceFileName(File file) {
            return FileReferenceMode.replaceExtension(file, ".cmd");
        }

        @Override
        protected FileReferenceMode[] getRelatedModes() {
            return new FileReferenceMode[]{SHELL_INVOKER, SHORTCUT, SYMBOLIC};
        }
    }
    ,
    SHELL_INVOKER(!PlatformInfo.isWindows()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public File generateReference(File file, File file2) throws IOException {
            File file3 = new File(file2, this.getReferenceFileName(file));
            try (PrintWriter printWriter = null;){
                printWriter = new PrintWriter(new FileWriter(file3));
                printWriter.println("#!/bin/sh");
                printWriter.println("\"" + file.getAbsolutePath() + "\"");
            }
            NativeJava.makeExecutable((String)file3.getAbsolutePath());
            return file3;
        }

        @Override
        public String getReferenceFileName(File file) {
            return FileReferenceMode.replaceExtension(file, ".sh");
        }

        @Override
        protected FileReferenceMode[] getRelatedModes() {
            return new FileReferenceMode[]{BATCH_INVOKER, SHORTCUT, SYMBOLIC};
        }
    };

    private final String fOptionResourceKey;
    private final String fFileLabelResourceKey;
    private final String fShortLabelResourceKey;
    private final boolean fSupportedOnCurrentPlatform;

    private FileReferenceMode() {
        this(true);
    }

    private FileReferenceMode(boolean bl) {
        String string2 = this.toString().toLowerCase(Locale.ENGLISH).replace('_', '.');
        this.fOptionResourceKey = "option.referencemode." + string2;
        this.fFileLabelResourceKey = "file.referencemode." + string2;
        this.fShortLabelResourceKey = "label.referencemode." + string2;
        this.fSupportedOnCurrentPlatform = bl;
    }

    public String getShortLabel() {
        return BuiltInResources.getString(this.fShortLabelResourceKey);
    }

    public String getFileLabel(File file) {
        return MessageFormat.format(BuiltInResources.getString(this.fFileLabelResourceKey), this.getReferenceFileName(file), file.getName());
    }

    public String getOptionText(String string, File file) {
        return MessageFormat.format(BuiltInResources.getString(this.fOptionResourceKey), string, FileUtils.truncatePathname((String)file.getAbsolutePath()));
    }

    public boolean isSupportedOnCurrentPlatform() {
        return this.fSupportedOnCurrentPlatform;
    }

    protected FileReferenceMode[] getRelatedModes() {
        return new FileReferenceMode[]{DIRECT};
    }

    public FileReferenceMode getNearestPlatformCounterpart(Collection<FileReferenceMode> collection) {
        if (this.isSupportedOnCurrentPlatform() && collection.contains((Object)this)) {
            return this;
        }
        for (FileReferenceMode fileReferenceMode : this.getRelatedModes()) {
            if (!fileReferenceMode.isSupportedOnCurrentPlatform() || !collection.contains((Object)fileReferenceMode)) continue;
            return fileReferenceMode;
        }
        return DIRECT;
    }

    public boolean isLocationPortable(File file) {
        return true;
    }

    public abstract String getReferenceFileName(File var1);

    public abstract File generateReference(File var1, File var2) throws IOException;

    private static boolean isNetworkFile(File file) {
        return !PlatformInfo.isWindows() || file.getAbsolutePath().startsWith("\\\\") || NativeJava.resolveMappedDriveToUnc((String)NativeJava.getNormalizedWindowsPath((File)file)).getAbsolutePath().startsWith("\\\\");
    }

    private static String replaceExtension(File file, String string) {
        String string2;
        int n;
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        return (n = (string2 = file.getName()).lastIndexOf(46)) <= 0 ? string2 + string : string2.substring(0, n) + string;
    }
}

