/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.project.impl.model.LazyVariableGraph;
import com.mathworks.project.impl.model.Profile;
import com.mathworks.project.impl.model.VariableGraph;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class LazyVariableGraphNode {
    private final LazyVariableGraph fGraph;
    private final String fName;
    private final List<LazyVariableGraphNode> fInputs;
    private final List<LazyVariableGraphNode> fOutputs;
    private final Map<String, ProfileState> fProfileStates;
    private VariableGraph.Generator fDefaultGenerator;
    private VariableGraph.XmlSerializer fSerializer;
    private ProfileState fCurrentProfileState;

    LazyVariableGraphNode(LazyVariableGraph lazyVariableGraph, String string, Set<String> set) {
        this.fGraph = lazyVariableGraph;
        this.fName = string;
        this.fProfileStates = new HashMap<String, ProfileState>();
        this.fInputs = new LinkedList<LazyVariableGraphNode>();
        this.fOutputs = new LinkedList<LazyVariableGraphNode>();
        if (set == null || set.isEmpty()) {
            this.fProfileStates.put(null, new ProfileState());
        } else {
            for (String string2 : set) {
                this.fProfileStates.put(string2, new ProfileState());
            }
        }
        this.fCurrentProfileState = this.fProfileStates.values().iterator().next();
    }

    VariableGraph.Generator getDefaultGenerator() {
        return this.fDefaultGenerator;
    }

    void setDefaultGenerator(VariableGraph.Generator generator) {
        this.fGraph.checkFrozen();
        this.fDefaultGenerator = generator;
    }

    void setSerializer(VariableGraph.XmlSerializer xmlSerializer) {
        this.fGraph.checkFrozen();
        this.fSerializer = xmlSerializer;
    }

    void setProfile(Profile profile) {
        Object object;
        Object object2;
        ProfileState profileState = this.fCurrentProfileState;
        this.fCurrentProfileState = this.fProfileStates.get(profile.getKey());
        if (this.fCurrentProfileState == null) {
            this.fCurrentProfileState = this.fProfileStates.values().iterator().next();
        }
        if (!(this.fCurrentProfileState == profileState || profileState.isDormant() && this.fCurrentProfileState.isDormant() || LazyVariableGraphNode.matches(object2 = profileState.getValue(), object = this.fCurrentProfileState.getValue()))) {
            this.fGraph.firePropertyChange(this.fName, object2, object);
        }
    }

    void updateDefault(boolean bl, boolean bl2) {
        this.fCurrentProfileState.updateDefault(bl, bl2);
    }

    boolean isDormant() {
        return this.fCurrentProfileState.isDormant();
    }

    void lock(Object object) {
        this.fCurrentProfileState.lock(object);
    }

    void reset() {
        this.fCurrentProfileState.reset();
    }

    String getName() {
        return this.fName;
    }

    public String toString() {
        return this.fName;
    }

    VariableGraph getView() {
        return new LazyVariableGraph(this.fGraph, this);
    }

    void addInput(LazyVariableGraphNode lazyVariableGraphNode) {
        this.fGraph.checkFrozen();
        this.fInputs.add(lazyVariableGraphNode);
    }

    public List<LazyVariableGraphNode> getInputs() {
        return new LinkedList<LazyVariableGraphNode>(this.fInputs);
    }

    public List<LazyVariableGraphNode> getOutputs() {
        return new LinkedList<LazyVariableGraphNode>(this.fOutputs);
    }

    public boolean hasInput(LazyVariableGraphNode lazyVariableGraphNode) {
        return this.fInputs.contains(lazyVariableGraphNode);
    }

    void addOutput(LazyVariableGraphNode lazyVariableGraphNode) {
        this.fGraph.checkFrozen();
        this.fOutputs.add(lazyVariableGraphNode);
    }

    boolean isExcludedFromProfile(String string) {
        return (this.fProfileStates.size() != 1 || this.fProfileStates.keySet().iterator().next() != null) && !this.fProfileStates.containsKey(string);
    }

    boolean hasProfileValue(String string) {
        return this.fProfileStates.get(string).isExplicitlySet();
    }

    Object getProfileValue(String string) {
        return this.fProfileStates.get(string).getExplicitValue();
    }

    void restoreProfileValue(String string, Object object) {
        this.fProfileStates.get(string).restoreValue(object);
    }

    Object getValue() {
        return this.fCurrentProfileState.getValue();
    }

    Object getExplicitValue() {
        return this.fCurrentProfileState.getExplicitValue();
    }

    void setExplicitValue(Object object) {
        this.fCurrentProfileState.setExplicitValue(object);
    }

    boolean isExplicitlySet() {
        return this.fCurrentProfileState.isExplicitlySet();
    }

    Object getDefaultValue() {
        return this.fCurrentProfileState.getDefaultValue();
    }

    Object getDefaultValueIfLoaded() {
        return this.fCurrentProfileState.getDefaultValueIfLoaded();
    }

    void setDefaultValue(Object object) {
        this.fCurrentProfileState.setDefaultValue(object);
    }

    String getXml() {
        return this.fCurrentProfileState.getXml();
    }

    private static boolean matches(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    private class ProfileState {
        private State fState = State.DORMANT;
        private Object fDefaultValue;
        private Object fExplicitValue;
        private String fXml;
        private State fUnlockedState;
        private Thread fDefaultUpdateThread;

        ProfileState() {
        }

        void restoreValue(Object object) {
            this.fExplicitValue = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setDefaultValue(final Object object) {
            Runnable runnable;
            Object object2 = LazyVariableGraphNode.this.fGraph.getLock();
            synchronized (object2) {
                if (LazyVariableGraphNode.matches(object, this.fDefaultValue)) {
                    return;
                }
                runnable = this.applyChange(true, new Runnable(){

                    @Override
                    public void run() {
                        ProfileState.this.fDefaultValue = object;
                    }
                });
            }
            runnable.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void lock(Object object) {
            Object object2 = LazyVariableGraphNode.this.fGraph.getLock();
            synchronized (object2) {
                if (this.fState != State.LOCKED) {
                    this.fUnlockedState = this.fState;
                    this.fState = State.LOCKED;
                }
            }
            this.setExplicitValue(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reset() {
            Object object = LazyVariableGraphNode.this.fGraph.getLock();
            synchronized (object) {
                if (this.fState != State.LOCKED) {
                    return;
                }
                this.fState = this.fUnlockedState;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setExplicitValue(final Object object) {
            Runnable runnable;
            Object object2 = LazyVariableGraphNode.this.fGraph.getLock();
            synchronized (object2) {
                if (LazyVariableGraphNode.matches(object, this.fExplicitValue)) {
                    return;
                }
                runnable = this.applyChange(true, new Runnable(){

                    @Override
                    public void run() {
                        ProfileState.this.fExplicitValue = object;
                    }
                });
            }
            runnable.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Runnable applyChange(final boolean bl, Runnable runnable) {
            Object object = LazyVariableGraphNode.this.fGraph.getLock();
            synchronized (object) {
                final Object object2 = this.getValue();
                runnable.run();
                final Object object3 = this.getValue();
                if (!LazyVariableGraphNode.matches(object2, object3)) {
                    this.fXml = null;
                    return new Runnable(){

                        @Override
                        public void run() {
                            LazyVariableGraphNode.this.fGraph.firePropertyChange(LazyVariableGraphNode.this.fName, object2, object3);
                            if (!ProfileState.this.isDormant() && bl) {
                                for (LazyVariableGraphNode lazyVariableGraphNode : LazyVariableGraphNode.this.fOutputs) {
                                    lazyVariableGraphNode.updateDefault(false, true);
                                }
                            }
                        }
                    };
                }
                return new Runnable(){

                    @Override
                    public void run() {
                    }
                };
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isDormant() {
            Object object = LazyVariableGraphNode.this.fGraph.getLock();
            synchronized (object) {
                return this.fState == State.DORMANT;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateDefault(boolean bl, boolean bl2) {
            Object object3;
            Object object2;
            LazyVariableGraphNode.this.fGraph.freeze();
            if (this.fDefaultUpdateThread == Thread.currentThread()) {
                return;
            }
            if (!bl) {
                object2 = LazyVariableGraphNode.this.fGraph.getLock();
                synchronized (object2) {
                    if (this.isDormant()) {
                        return;
                    }
                }
            }
            for (Object object3 : LazyVariableGraphNode.this.fInputs) {
                ((LazyVariableGraphNode)object3).updateDefault(true, false);
            }
            this.fDefaultUpdateThread = Thread.currentThread();
            object2 = LazyVariableGraphNode.this.fDefaultGenerator.generateValue(LazyVariableGraphNode.this.fName, LazyVariableGraphNode.this.getView());
            this.fDefaultUpdateThread = null;
            Object object4 = LazyVariableGraphNode.this.fGraph.getLock();
            synchronized (object4) {
                if (this.isDormant()) {
                    this.fState = State.READY;
                }
                object3 = this.applyChange(bl2, new Runnable(){

                    @Override
                    public void run() {
                        ProfileState.this.fDefaultValue = object2;
                    }
                });
            }
            object3.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object getValue() {
            Object object = this.getExplicitValue();
            if (object != null) {
                return object;
            }
            if (this.isDormant()) {
                this.updateDefault(true, true);
            }
            Object object2 = LazyVariableGraphNode.this.fGraph.getLock();
            synchronized (object2) {
                return this.fDefaultValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object getExplicitValue() {
            Object object = LazyVariableGraphNode.this.fGraph.getLock();
            synchronized (object) {
                return this.fExplicitValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isExplicitlySet() {
            Object object = LazyVariableGraphNode.this.fGraph.getLock();
            synchronized (object) {
                return this.fExplicitValue != null;
            }
        }

        Object getDefaultValue() {
            if (this.isDormant()) {
                this.updateDefault(true, true);
            }
            return this.getDefaultValueIfLoaded();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object getDefaultValueIfLoaded() {
            Object object = LazyVariableGraphNode.this.fGraph.getLock();
            synchronized (object) {
                return this.fDefaultValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getXml() {
            if (LazyVariableGraphNode.this.fSerializer == null) {
                return null;
            }
            Object object = LazyVariableGraphNode.this.fGraph.getLock();
            synchronized (object) {
                if (this.fXml != null) {
                    return this.fXml;
                }
            }
            object = LazyVariableGraphNode.this.fSerializer.serialize(this.getValue());
            Object object2 = LazyVariableGraphNode.this.fGraph.getLock();
            synchronized (object2) {
                this.fXml = object;
            }
            return object;
        }
    }

    public static enum State {
        DORMANT,
        LOCKED,
        READY;

    }
}

