/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.ProjectPrefs;
import com.mathworks.project.impl.desktop.AbstractProjectClient;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.util.FileUtils;
import com.mathworks.util.RequestFilter;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.swing.Icon;

public final class Project {
    private Configuration fConfiguration;
    private XmlReader fXslInput;
    private final PropertyChangeSupport fPropertySupport;
    private final List<MatlabChangeCallback> fMatlabChangeCallbacks;
    private final Object fXslInputLock;
    private PropertyChangeListener fListener;
    private int fXslInputStateId;
    private RequestFilter fMatlabChangeRequestFilter;
    private final String fUuid;
    public static final String FILE_PROPERTY = "@file";
    public static final String FILE_EXTENSION = ".prj";

    Project(Configuration configuration) {
        this.fConfiguration = configuration;
        this.fUuid = UUID.randomUUID().toString();
        this.fMatlabChangeCallbacks = new LinkedList<MatlabChangeCallback>();
        this.fXslInputLock = new Object();
        this.fPropertySupport = new PropertyChangeSupport(this);
    }

    public File getFile() {
        return this.fConfiguration.getFile();
    }

    public void setFile(File file) {
        this.fConfiguration.setFile(file);
    }

    public Icon getIcon() {
        return this.fConfiguration.getIcon();
    }

    public boolean setFileWithUIOverwriteCheck(File file) {
        int n;
        assert (ProjectGUI.getInstance().getCurrentClient() != null);
        File file2 = this.fConfiguration.getFile();
        if (file == null || FileUtils.areFilesTheSame((File)file, (File)file2)) {
            return true;
        }
        if (file.exists() && (n = MJOptionPane.showConfirmDialog((Component)ProjectGUI.getInstance().getCurrentClient().getComponent(), (Object)BuiltInResources.getString("appname.project.exists"), (String)BuiltInResources.getString("appname.project.rename"), (int)0)) == 1) {
            return false;
        }
        this.fConfiguration.setFile(file);
        ((AbstractProjectClient)ProjectGUI.getInstance().getCurrentClient()).updateTitle();
        ProjectPrefs.LAST_OPEN_FILE.set(file.getAbsolutePath());
        return true;
    }

    public String getUuid() {
        return this.fUuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlReader getXslInput() {
        int n;
        Object object = this.fXslInputLock;
        synchronized (object) {
            if (this.fXslInput == null) {
                if (this.fListener == null) {
                    this.fListener = new PropertyChangeListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            Object object = Project.this.fXslInputLock;
                            synchronized (object) {
                                Project.this.fXslInput = null;
                            }
                        }
                    };
                    this.fConfiguration.addPropertyChangeListener(this.fListener);
                }
            } else {
                return this.fXslInput;
            }
            n = ++this.fXslInputStateId;
        }
        object = ProjectManager.configurationToXslInput(this);
        Object object2 = this.fXslInputLock;
        synchronized (object2) {
            if (n == this.fXslInputStateId) {
                this.fXslInput = object;
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlReader getXslInputIfCached() {
        Object object = this.fXslInputLock;
        synchronized (object) {
            return this.fXslInput;
        }
    }

    public Configuration getConfiguration() {
        return this.fConfiguration;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
        this.fConfiguration.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
        this.fConfiguration.removePropertyChangeListener(propertyChangeListener);
    }

    public void addMatlabChangeCallback(String string, Object ... objectArray) {
        this.fMatlabChangeCallbacks.add(new MatlabChangeCallback(string, objectArray));
        if (this.fMatlabChangeRequestFilter == null) {
            this.fMatlabChangeRequestFilter = new RequestFilter(new Runnable(){

                @Override
                public void run() {
                    for (MatlabChangeCallback matlabChangeCallback : new ArrayList(Project.this.fMatlabChangeCallbacks)) {
                        new Matlab().fevalConsoleOutput(matlabChangeCallback.getFunction(), matlabChangeCallback.getArguments());
                    }
                }
            }, 400);
            this.fConfiguration.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Project.this.fMatlabChangeRequestFilter.request();
                }
            });
        }
    }

    private static class MatlabChangeCallback {
        private final String fFunction;
        private final Object[] fArguments;

        MatlabChangeCallback(String string, Object[] objectArray) {
            this.fFunction = string;
            this.fArguments = (Object[])objectArray.clone();
        }

        public String getFunction() {
            return this.fFunction;
        }

        public Object[] getArguments() {
            return (Object[])this.fArguments.clone();
        }
    }
}

