/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.project.api.ParamType;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.ReadableFileSet;
import com.mathworks.project.api.WarningState;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.VariableGraph;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public final class XslInput {
    private final ReadableConfiguration fData;
    private final String fText;
    private Document fDocument;

    public XslInput(XmlReader xmlReader) {
        this(null, xmlReader);
    }

    public XslInput(ReadableConfiguration readableConfiguration, String string) {
        this.fData = readableConfiguration;
        this.fText = string;
    }

    public XslInput(ReadableConfiguration readableConfiguration, XmlReader xmlReader) {
        this.fData = readableConfiguration;
        this.fText = xmlReader.getXML();
    }

    public XslInput(Configuration configuration, VariableGraph variableGraph, XmlReader xmlReader) {
        this.fData = new ReadableConfigurationAdapter(configuration, variableGraph);
        this.fText = xmlReader.getXML();
    }

    public XslInput(Configuration configuration, VariableGraph variableGraph, String string) {
        this.fText = string;
        this.fData = new ReadableConfigurationAdapter(configuration, variableGraph);
    }

    public ReadableConfiguration getData() {
        return this.fData;
    }

    public String getText() {
        return this.fText;
    }

    public synchronized Document getDocument() {
        if (this.fDocument == null) {
            try {
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                this.fDocument = documentBuilder.parse(new InputSource(new StringReader(this.fText)));
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
        return this.fDocument;
    }

    private static class ReadableConfigurationAdapter
    implements ReadableConfiguration {
        private final Configuration fConfiguration;
        private final VariableGraph fData;

        ReadableConfigurationAdapter(Configuration configuration, VariableGraph variableGraph) {
            this.fConfiguration = configuration;
            this.fData = variableGraph;
        }

        public File getFile() {
            return this.fConfiguration.getFile();
        }

        public String getName() {
            return this.fConfiguration.getName();
        }

        public String getResourceString(String string) {
            return this.fConfiguration.getResourceString(string);
        }

        public String getTargetKey() {
            return this.fConfiguration.getTargetKey();
        }

        public String getTargetName() {
            return this.fConfiguration.getTargetName();
        }

        public ReadableFileSet getFileSet(String string) {
            return (ReadableFileSet)this.fData.getValue(string);
        }

        public Set<String> getParamKeys() {
            return this.fConfiguration.getParamKeys();
        }

        public Set<String> getFileSetKeys() {
            return this.fConfiguration.getFileSetKeys();
        }

        public ParamType getParamType(String string) {
            return this.fConfiguration.getParamType(string);
        }

        public boolean isParamEnabled(String string) {
            return this.fConfiguration.isParamEnabled(string);
        }

        public boolean isParamVisible(String string) {
            return this.fConfiguration.isParamVisible(string);
        }

        public boolean isParamExplicitlySet(String string) {
            return this.fData.isExplicitlySet(string);
        }

        public boolean shouldSaveImplicitValues(String string) {
            return this.fConfiguration.shouldSaveImplicitValues(string);
        }

        public String getParamAttribute(String string, String string2) {
            return this.fConfiguration.getParamAttribute(string, string2);
        }

        public String getParamAsString(String string) {
            Object object = this.fData.getValue(string);
            return object == null ? null : object.toString();
        }

        public List<String> getParamAsStringList(String string) {
            return (List)this.fData.getValue(string);
        }

        public int getParamAsInt(String string) {
            return (Integer)this.fData.getValue(string);
        }

        public BigDecimal getParamAsDecimal(String string) {
            return (BigDecimal)this.fData.getValue(string);
        }

        public boolean getParamAsBoolean(String string) {
            return (Boolean)this.fData.getValue(string);
        }

        public File getParamAsFile(String string) {
            return (File)this.fData.getValue(string);
        }

        public List<File> getParamAsFileList(String string) {
            return (List)this.fData.getValue(string);
        }

        public XmlReader getParamReader(String string) throws IOException {
            Object object = this.fData.getValue(string);
            if (object instanceof XmlReader) {
                return (XmlReader)object;
            }
            return XmlApi.getInstance().read(object.toString());
        }

        public Map<String, WarningState> getParamAsWarnings(String string) {
            return (Map)this.fData.getValue(string);
        }

        public String getXML() {
            throw new UnsupportedOperationException();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            throw new UnsupportedOperationException();
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            throw new UnsupportedOperationException();
        }
    }
}

