/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.plaf;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.plaf.LAFUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicButtonUI;

public abstract class ButtonUI
extends BasicButtonUI {
    public static final String BUTTON_SELECTED_BY_KEY = "BUTTON_SELECTED_BY_KEY";

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Rectangle rectangle = LAFUtil.getWorkArea(abstractButton);
        Shape shape = graphics2D.getClip();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean bl = false;
        Object object = jComponent.getClientProperty(BUTTON_SELECTED_BY_KEY);
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        }
        if (this.isPressed(abstractButton)) {
            this.paintPressed(graphics2D, abstractButton, rectangle);
        } else if (buttonModel.isArmed() || abstractButton.isFocusPainted() && abstractButton.hasFocus() || bl) {
            this.paintArmed(graphics2D, abstractButton, rectangle);
        }
        if (shape != null) {
            graphics2D.setClip(shape);
        }
        this.paintContent(graphics2D, abstractButton, rectangle);
        graphics2D.dispose();
    }

    private boolean isPressed(AbstractButton abstractButton) {
        return abstractButton.getModel().isPressed();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.installListeners(jComponent);
        this.installDefaults(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners(jComponent);
    }

    private void installDefaults(JComponent jComponent) {
        jComponent.setOpaque(false);
        jComponent.setBorder(null);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    private void installListeners(JComponent jComponent) {
        AppsButtonListener appsButtonListener = this.newAppsButtonListener((AbstractButton)jComponent);
        jComponent.addMouseListener(appsButtonListener);
        jComponent.addMouseMotionListener(appsButtonListener);
        jComponent.addFocusListener(appsButtonListener);
        jComponent.addPropertyChangeListener(appsButtonListener);
        jComponent.addKeyListener(appsButtonListener);
        ((AbstractButton)jComponent).addChangeListener(appsButtonListener);
    }

    private void uninstallListeners(JComponent jComponent) {
        AppsButtonListener appsButtonListener = this.getButtonListener((AbstractButton)jComponent);
        jComponent.removeMouseListener(appsButtonListener);
        jComponent.removeMouseMotionListener(appsButtonListener);
        jComponent.removeFocusListener(appsButtonListener);
        jComponent.removePropertyChangeListener(appsButtonListener);
        jComponent.removeKeyListener(appsButtonListener);
        ((AbstractButton)jComponent).removeChangeListener(appsButtonListener);
    }

    private AppsButtonListener newAppsButtonListener(AbstractButton abstractButton) {
        return new AppsButtonListener(abstractButton);
    }

    private AppsButtonListener getButtonListener(AbstractButton abstractButton) {
        MouseListener[] mouseListenerArray = abstractButton.getMouseListeners();
        if (mouseListenerArray != null) {
            for (MouseListener mouseListener : mouseListenerArray) {
                if (!(mouseListener instanceof AppsButtonListener)) continue;
                return (AppsButtonListener)mouseListener;
            }
        }
        return null;
    }

    private void paintPressed(Graphics2D graphics2D, AbstractButton abstractButton, Rectangle rectangle) {
        RectangularShape rectangularShape = LAFUtil.getButtonRect(rectangle);
        LAFUtil.drawRoundButtonPressedRect(graphics2D, rectangularShape);
    }

    private void paintArmed(Graphics2D graphics2D, AbstractButton abstractButton, Rectangle rectangle) {
        LAFUtil.drawButtonArmedRect(graphics2D, rectangle);
    }

    protected abstract void paintContent(Graphics2D var1, AbstractButton var2, Rectangle var3);

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        assert (jComponent instanceof AbstractButton);
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Icon icon = abstractButton.getIcon();
        int n = this.getSpacer() * 2 + icon.getIconWidth();
        int n2 = this.getSpacer() * 2 + icon.getIconHeight();
        return new Dimension(n, n2);
    }

    protected abstract int getSpacer();

    private class AppsButtonListener
    implements MouseListener,
    MouseMotionListener,
    FocusListener,
    PropertyChangeListener,
    ChangeListener,
    KeyListener {
        private final AbstractButton fButton;

        public AppsButtonListener(AbstractButton abstractButton) {
            this.fButton = abstractButton;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.fButton.revalidate();
            this.fButton.repaint();
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.fButton.revalidate();
            this.fButton.repaint();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.fButton.getModel().setArmed(true);
            this.fButton.repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.fButton.getModel().setArmed(false);
            this.fButton.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ButtonModel buttonModel;
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.fButton.contains(mouseEvent.getX(), mouseEvent.getY()) && (buttonModel = this.fButton.getModel()).isEnabled()) {
                buttonModel.setArmed(true);
                buttonModel.setPressed(true);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.fButton.getModel().setPressed(false);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (this.fButton.getParent() instanceof MJPanel && this.fButton.getParent().getName() != null && this.fButton.getParent().getName().equals("sally.icon.panel")) {
                this.fButton.requestFocus();
            }
            this.fButton.getModel().setArmed(true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.fButton.hasFocus()) {
                this.fButton.getModel().setArmed(false);
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                this.fButton.doClick();
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

