/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.settingsui.SettingComponentDefinition;
import com.mathworks.project.impl.settingsui.SettingsPanelBuilder;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public final class DependencyShiftingSettingsPanelBuilder
implements SettingsPanelBuilder {
    private final Configuration fConfiguration;
    private final SettingsPanelBuilder fBuilder;
    private final List<Param> fParamsInCategory;

    public DependencyShiftingSettingsPanelBuilder(Configuration configuration, SettingsPanelBuilder settingsPanelBuilder) {
        this.fConfiguration = configuration;
        this.fBuilder = settingsPanelBuilder;
        this.fParamsInCategory = new ArrayList<Param>();
    }

    @Override
    public void startCategory(String string) {
        this.fBuilder.startCategory(string);
        this.fParamsInCategory.clear();
    }

    @Override
    public String getCurrentCategoryName() {
        return this.fBuilder.getCurrentCategoryName();
    }

    @Override
    public void endCategory() {
        this.fBuilder.endCategory();
        this.fParamsInCategory.clear();
    }

    @Override
    public void addComponent(SettingComponentDefinition settingComponentDefinition) {
        if (this.hasDependencyOnPriorComponent(settingComponentDefinition.getParam())) {
            this.addComponent((Component)((Object)new ShiftedComponent(settingComponentDefinition)), false);
        } else {
            this.fBuilder.addComponent(settingComponentDefinition);
        }
        this.fParamsInCategory.add(settingComponentDefinition.getParam());
    }

    @Override
    public void addComponent(Component component, boolean bl) {
        this.fBuilder.addComponent(component, bl);
    }

    @Override
    public void addPadding() {
        this.fBuilder.addPadding();
    }

    @Override
    public JComponent getComponent() {
        return this.fBuilder.getComponent();
    }

    private boolean hasDependencyOnPriorComponent(Param param) {
        for (Param param2 : this.fParamsInCategory) {
            if (!this.fConfiguration.hasEnabledOrVisibleDependency(param, param2)) continue;
            return true;
        }
        return false;
    }

    private static class ShiftedComponent
    extends MJPanel {
        ShiftedComponent(SettingComponentDefinition settingComponentDefinition) {
            this.setLayout((LayoutManager)new FormLayout("14dlu, fill:d, 3dlu, fill:d:grow", "fill:d"));
            this.setOpaque(false);
            CellConstraints cellConstraints = new CellConstraints();
            this.add((Component)new MJLabel(settingComponentDefinition.getLabel()), cellConstraints.xy(2, 1));
            this.add(settingComponentDefinition.getComponent(), cellConstraints.xy(4, 1));
        }
    }
}

