/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.mwswing.ComponentUtils;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.DetailedToolTipProvider;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.settingsui.DetailedToolTipData;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.ReturnRunnable;
import com.mathworks.widgets.HyperlinkTextLabel;
import com.mathworks.widgets.LightButton;
import com.mathworks.widgets.LightScrollPane;
import com.mathworks.widgets.tooltip.BalloonToolTip;
import com.mathworks.widgets.tooltip.ToolTipAndComponentAWTListener;
import com.mathworks.widgets.tooltip.TooltipUtils;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public final class DetailedToolTip {
    private BalloonToolTip fBalloon;
    private HyperlinkTextLabel fDetailsContainer;
    private static DetailedToolTip sShowingTip;
    private final Rectangle fTargetBounds;
    private final DetailedToolTipData fData;
    private final Point fPoint;
    private final List<BalloonToolTip.ArrowDirection> fPossiblePositions;
    private static final int WINDOW_MOUSE_MOVE_BUFFER = 12;
    private static final List<BalloonToolTip.ArrowDirection> sParamDirections;
    private static final Map<Component, Listener> sListeners;

    public static void install(Component component, Configuration configuration, Param param) {
        if (param != null) {
            if (configuration.getTarget().getDetailedToolTipProviderClassName() != null) {
                DetailedToolTip.install(component, new ToolTipRetriever(configuration, param), sParamDirections);
            } else {
                String string = param.getDetailedDescriptionHtml();
                if (string != null) {
                    DetailedToolTip.install(component, new DetailedToolTipData(param.getDescription(), string), sParamDirections);
                } else if (param.getDescription() != null && component instanceof JComponent) {
                    ((JComponent)component).setToolTipText(param.getDescription());
                }
            }
        }
    }

    public static void install(Component component, final DetailedToolTipData detailedToolTipData, List<BalloonToolTip.ArrowDirection> list) {
        if (!sListeners.containsKey(component)) {
            ReturnRunnable<DetailedToolTipData> returnRunnable = new ReturnRunnable<DetailedToolTipData>(){

                public DetailedToolTipData run() {
                    return detailedToolTipData;
                }
            };
            sListeners.put(component, new Listener(component, returnRunnable, list));
        }
    }

    public static void install(Component component, ReturnRunnable<DetailedToolTipData> returnRunnable, List<BalloonToolTip.ArrowDirection> list) {
        if (!sListeners.containsKey(component)) {
            sListeners.put(component, new Listener(component, returnRunnable, list));
        }
    }

    public static void uninstall(Component component) {
        ToolTipAndComponentAWTListener toolTipAndComponentAWTListener = sListeners.remove(component);
        if (toolTipAndComponentAWTListener != null) {
            toolTipAndComponentAWTListener.uninstall();
        }
    }

    public static DetailedToolTip show(DetailedToolTipData detailedToolTipData, Rectangle rectangle, List<BalloonToolTip.ArrowDirection> list, Point point) {
        DetailedToolTip detailedToolTip = new DetailedToolTip(detailedToolTipData, rectangle, list, point);
        detailedToolTip.show();
        return detailedToolTip;
    }

    public void cleanup() {
        if (this.fBalloon != null) {
            this.fBalloon.cleanup();
        }
    }

    private DetailedToolTip(DetailedToolTipData detailedToolTipData, Rectangle rectangle, List<BalloonToolTip.ArrowDirection> list, Point point) {
        this.fData = detailedToolTipData;
        this.fTargetBounds = rectangle;
        this.fPossiblePositions = new ArrayList<BalloonToolTip.ArrowDirection>(list);
        this.fPoint = point;
    }

    private void show() {
        if (sShowingTip != null && sShowingTip != this) {
            sShowingTip.cleanup();
        }
        sShowingTip = this;
        if (this.fData.getSummaryText() != null) {
            JComponent jComponent = this.createContent(false);
            this.fBalloon = new BalloonToolTip((Frame)null, (Component)jComponent, this.fPossiblePositions, jComponent.getPreferredSize(), this.fTargetBounds, this.fPoint);
            this.fBalloon.getDialog().setName("settings.tooltip");
            this.fBalloon.show();
        }
    }

    private JComponent createContent(final boolean bl) {
        Font font;
        MJPanel mJPanel = new MJPanel(new BorderLayout(3, 3)){

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (bl) {
                    graphics.setColor(Color.LIGHT_GRAY);
                    graphics.fillRect(0, this.getHeight() - 1, this.getWidth(), 1);
                }
            }
        };
        mJPanel.setBackground(TooltipUtils.getTooltipBackground());
        mJPanel.setBorder(BorderFactory.createEmptyBorder(2, 3, 2, 4));
        final MJLabel mJLabel = new MJLabel(this.fData.getSummaryText());
        if (PlatformInfo.isMacintosh()) {
            font = mJLabel.getFont();
            mJLabel.setFont(font.deriveFont((float)font.getSize() - 2.0f));
        }
        font = new LightButton(BuiltInResources.getString("button.tooltip.details"));
        font.setIcon(bl ? MiscellaneousIcon.OPEN_ARROW.getIcon() : MiscellaneousIcon.CLOSE_ARROW.getIcon());
        font.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DetailedToolTip.this.fBalloon.setNewContent((Component)DetailedToolTip.this.createContent(!bl), true);
            }
        });
        mJPanel.add((Component)mJLabel, (Object)"Center");
        if (this.fData.getDetailedHtml() == null) {
            return mJPanel;
        }
        mJPanel.add((Component)((Object)font), (Object)"West");
        MJPanel mJPanel2 = new MJPanel(new BorderLayout(), (LightButton)font){
            final /* synthetic */ LightButton val$detailsButton;
            {
                this.val$detailsButton = lightButton;
                super(layoutManager);
            }

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (bl) {
                    dimension.height = 200;
                    dimension.width = (int)Math.max(350.0, mJLabel.getPreferredSize().getWidth() + this.val$detailsButton.getPreferredSize().getWidth() + 16.0);
                }
                return dimension;
            }
        };
        mJPanel2.setOpaque(true);
        mJPanel2.setBackground(TooltipUtils.getTooltipBackground());
        mJPanel2.add((Component)mJPanel, (Object)"North");
        if (bl) {
            this.fDetailsContainer = new HyperlinkTextLabel(this.fData.getDetailedHtml()){

                protected JScrollPane makeScrollPane(JComponent jComponent) {
                    return new LightScrollPane((Component)jComponent);
                }
            };
            this.fDetailsContainer.scrollToTop();
            this.fDetailsContainer.setFont(TooltipUtils.getTooltipHtmlFont());
            this.fDetailsContainer.setFontColor(TooltipUtils.getTooltipFontColor());
            mJPanel2.add((Component)this.fDetailsContainer.getComponent(), (Object)"Center");
        }
        return mJPanel2;
    }

    public JDialog getDialog() {
        return this.fBalloon == null ? null : this.fBalloon.getDialog();
    }

    public HyperlinkTextLabel getDetailsContainer() {
        return this.fDetailsContainer;
    }

    public boolean containsScreenPoint(Point point) {
        if (this.fBalloon != null) {
            Rectangle rectangle = this.fBalloon.getBounds();
            rectangle.x -= 12;
            rectangle.y -= 12;
            rectangle.height += 24;
            rectangle.width += 24;
            return rectangle.contains(point);
        }
        return false;
    }

    static {
        sListeners = new HashMap<Component, Listener>();
        sParamDirections = new ArrayList<BalloonToolTip.ArrowDirection>();
        sParamDirections.add(BalloonToolTip.ArrowDirection.SOUTH);
    }

    private static class Listener
    extends ToolTipAndComponentAWTListener {
        private final Component fTargetComponent;
        private final ReturnRunnable<DetailedToolTipData> fRetriever;
        private final List<BalloonToolTip.ArrowDirection> fPossibleDirections;
        private DetailedToolTip fToolTip;

        Listener(Component component, ReturnRunnable<DetailedToolTipData> returnRunnable, List<BalloonToolTip.ArrowDirection> list) {
            super(component, ToolTipManager.sharedInstance().getInitialDelay());
            this.setPersistentInsideSource(true);
            this.fTargetComponent = component;
            this.fRetriever = returnRunnable;
            this.fPossibleDirections = new ArrayList<BalloonToolTip.ArrowDirection>(list);
        }

        protected void hideTip() {
            if (this.fToolTip != null) {
                this.fToolTip.cleanup();
                this.fToolTip = null;
            }
        }

        protected void movedInsideSource(MouseEvent mouseEvent) {
            if (this.fToolTip == null) {
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                this.fToolTip = DetailedToolTip.show((DetailedToolTipData)this.fRetriever.run(), this.getTargetRect(), this.fPossibleDirections, point);
            } else {
                this.stopHideTimer();
            }
        }

        private Rectangle getTargetRect() {
            Rectangle rectangle = this.fTargetComponent.getBounds();
            Point point = rectangle.getLocation();
            SwingUtilities.convertPointToScreen(point, this.fTargetComponent.getParent());
            return new Rectangle(point, rectangle.getSize());
        }

        protected boolean isTipShowing() {
            return this.fToolTip != null;
        }

        protected boolean shouldStartHideTimer() {
            return this.fToolTip != null;
        }

        protected boolean doesTipContainScreenCoordinates(Point point) {
            return this.fToolTip != null && this.fToolTip.containsScreenPoint(point);
        }

        protected void mouseWheeledInsideTip(MouseWheelEvent mouseWheelEvent) {
            try {
                for (MouseWheelListener mouseWheelListener : this.fToolTip.getDetailsContainer().getComponent().getMouseWheelListeners()) {
                    mouseWheelListener.mouseWheelMoved(mouseWheelEvent);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected void mouseClickedInsideTip(MouseEvent mouseEvent) {
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            Point point = mouseEvent.getPoint();
            if (mouseEvent.getSource() instanceof Component) {
                SwingUtilities.convertPointToScreen(point, (Component)aWTEvent.getSource());
                SwingUtilities.convertPointFromScreen(point, this.fTargetComponent);
                if (this.fTargetComponent.contains(point) && (ComponentUtils.isChild((Component)this.fTargetComponent, (Component)((Component)mouseEvent.getSource())) || ComponentUtils.isChild((Component)((Component)mouseEvent.getSource()), (Component)this.fTargetComponent))) {
                    if (mouseEvent instanceof MouseWheelEvent) {
                        super.eventDispatched((AWTEvent)new MouseWheelEvent(this.fTargetComponent, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), (int)point.getX(), (int)point.getY(), mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), ((MouseWheelEvent)mouseEvent).getScrollType(), ((MouseWheelEvent)mouseEvent).getScrollAmount(), ((MouseWheelEvent)mouseEvent).getWheelRotation()));
                    } else {
                        super.eventDispatched((AWTEvent)new MouseEvent(this.fTargetComponent, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), (int)point.getX(), (int)point.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
                    }
                    return;
                }
            }
            super.eventDispatched((AWTEvent)mouseEvent);
        }
    }

    private static class ToolTipRetriever
    implements ReturnRunnable<DetailedToolTipData> {
        private final Configuration fConfiguration;
        private final Param fParam;
        private DetailedToolTipProvider fProvider;

        ToolTipRetriever(Configuration configuration, Param param) {
            this.fConfiguration = configuration;
            this.fParam = param;
        }

        public DetailedToolTipData run() {
            if (this.fProvider == null) {
                try {
                    this.fProvider = (DetailedToolTipProvider)Class.forName(this.fConfiguration.getTarget().getDetailedToolTipProviderClassName()).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalStateException(classNotFoundException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalStateException(illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    throw new IllegalStateException(instantiationException);
                }
            }
            return new DetailedToolTipData(this.fParam.getDescription(), this.fProvider.getContent(this.fConfiguration, this.fParam));
        }
    }
}

